/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.async;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.core.ResponseBytes;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.internal.async.ByteArrayAsyncResponseTransformer;
import software.amazon.awssdk.core.internal.async.FileAsyncResponseTransformer;

@SdkPublicApi
public interface AsyncResponseTransformer<ResponseT, ResultT> {
    public CompletableFuture<ResultT> prepare();

    public void onResponse(ResponseT var1);

    public void onStream(SdkPublisher<ByteBuffer> var1);

    public void exceptionOccurred(Throwable var1);

    public static <ResponseT> AsyncResponseTransformer<ResponseT, ResponseT> toFile(Path path) {
        return new FileAsyncResponseTransformer(path);
    }

    public static <ResponseT> AsyncResponseTransformer<ResponseT, ResponseT> toFile(File file) {
        return AsyncResponseTransformer.toFile(file.toPath());
    }

    public static <ResponseT> AsyncResponseTransformer<ResponseT, ResponseBytes<ResponseT>> toBytes() {
        return new ByteArrayAsyncResponseTransformer();
    }
}

