/*
 * Decompiled with CFR 0.152.
 */
package macromedia.resource.jdbcsqlserver.spi;

import java.io.PrintWriter;
import java.sql.SQLException;
import javax.resource.ResourceException;
import javax.resource.spi.EISSystemException;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.LocalTransactionException;
import javax.resource.spi.ResourceAdapterInternalException;
import macromedia.resource.jdbcsqlserver.spi.JCAMessages;
import macromedia.sqlserverutil.ddq;

public class JCAExceptions {
    private static String footprint = "$Revision: #1 $";
    public static final int EXCEPT_TYPE_GENERIC = 0;
    public static final int EXCEPT_TYPE_SYSTEM = 1;
    public static final int EXCEPT_TYPE_INTERNAL = 2;
    public static final int EXCEPT_TYPE_ILLEGAL_STATE = 3;
    public static final int EXCEPT_TYPE_LOCAL_TRANSACT = 4;
    protected JCAMessages messages;
    protected PrintWriter logWriter;

    public JCAExceptions(String string) {
        this.messages = new JCAMessages(string);
        this.logWriter = null;
    }

    public void setLogWriter(PrintWriter printWriter) {
        this.logWriter = printWriter;
    }

    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public ResourceException getException(int n2) {
        JCAExceptions jCAExceptions = this;
        ResourceException resourceException = jCAExceptions.createException(jCAExceptions.messages.getMessage(n2, null), 2);
        return resourceException;
    }

    public ResourceException getException(int n2, int n3) {
        JCAExceptions jCAExceptions = this;
        ResourceException resourceException = jCAExceptions.createException(jCAExceptions.messages.getMessage(n2, null), n3);
        return resourceException;
    }

    public ResourceException getException(int n2, String[] stringArray, int n3) {
        JCAExceptions jCAExceptions = this;
        ResourceException resourceException = jCAExceptions.createException(jCAExceptions.messages.getMessage(n2, stringArray), n3);
        return resourceException;
    }

    public ResourceException getException(Exception exception, int n2) {
        ResourceException resourceException = this.createException(exception.getMessage(), n2);
        return resourceException;
    }

    public ResourceException getException(Exception exception, int n2, int n3) {
        JCAExceptions jCAExceptions = this;
        ResourceException resourceException = jCAExceptions.createException(jCAExceptions.messages.getMessage(n2, null), n3);
        resourceException = this.linkException(exception, resourceException);
        return resourceException;
    }

    public ResourceException getException(Exception exception, int n2, String[] stringArray, int n3) {
        JCAExceptions jCAExceptions = this;
        ResourceException resourceException = jCAExceptions.createException(jCAExceptions.messages.getMessage(n2, stringArray), n3);
        resourceException = this.linkException(exception, resourceException);
        return resourceException;
    }

    public static SQLException getSQLExceptionFromResourceException(ResourceException resourceException) {
        Exception exception = resourceException.getLinkedException();
        String string = resourceException.getMessage();
        if (exception != null) {
            string = string + "\nLinked Exception: " + exception.getMessage();
        }
        return new SQLException(string);
    }

    private final ResourceException createException(String string, int n2) {
        ResourceException resourceException;
        switch (n2) {
            case 0: {
                resourceException = new ResourceException(string);
                break;
            }
            case 2: {
                resourceException = new ResourceAdapterInternalException(string);
                break;
            }
            case 1: {
                resourceException = new EISSystemException(string);
                break;
            }
            case 3: {
                resourceException = new IllegalStateException(string);
                break;
            }
            case 4: {
                resourceException = new LocalTransactionException(string);
                break;
            }
            default: {
                ddq.a((String)"Invalid ResourceException type specified", (boolean)false);
                resourceException = new ResourceException(string);
            }
        }
        if (this.logWriter != null) {
            this.logWriter.println("");
            this.logWriter.println("Generated ResourceException: ");
            this.logWriter.println((Object)resourceException);
            resourceException.printStackTrace(this.logWriter);
        }
        return resourceException;
    }

    private final ResourceException linkException(Exception exception, ResourceException resourceException) {
        resourceException.setLinkedException(exception);
        return resourceException;
    }
}

