/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.slf4j_1_7_5.helpers;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import macromedia.externals.org.slf4j_1_7_5.Marker;

public class BasicMarker
implements Marker {
    private static final long serialVersionUID = 1803952589649545191L;
    private final String name;
    private List refereceList;
    private static String OPEN = "[ ";
    private static String CLOSE = " ]";
    private static String SEP = ", ";

    BasicMarker(String string) {
        if (string == null) {
            throw new IllegalArgumentException("A marker name cannot be null");
        }
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public synchronized void add(Marker marker) {
        if (marker == null) {
            throw new IllegalArgumentException("A null value cannot be added to a Marker as reference.");
        }
        if (this.contains(marker)) {
            return;
        }
        if (marker.contains((Marker)this)) {
            return;
        }
        if (this.refereceList == null) {
            this.refereceList = new Vector();
        }
        this.refereceList.add(marker);
    }

    public synchronized boolean hasReferences() {
        return this.refereceList != null && this.refereceList.size() > 0;
    }

    public boolean hasChildren() {
        return this.hasReferences();
    }

    public synchronized Iterator iterator() {
        if (this.refereceList != null) {
            return this.refereceList.iterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public synchronized boolean remove(Marker marker) {
        if (this.refereceList == null) {
            return false;
        }
        int n2 = this.refereceList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Marker marker2 = (Marker)this.refereceList.get(i2);
            if (!marker.equals(marker2)) continue;
            this.refereceList.remove(i2);
            return true;
        }
        return false;
    }

    public boolean contains(Marker marker) {
        if (marker == null) {
            throw new IllegalArgumentException("Other cannot be null");
        }
        if (this.equals((Object)marker)) {
            return true;
        }
        if (this.hasReferences()) {
            for (int i2 = 0; i2 < this.refereceList.size(); ++i2) {
                Marker marker2 = (Marker)this.refereceList.get(i2);
                if (!marker2.contains(marker)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean contains(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Other cannot be null");
        }
        if (this.name.equals(string)) {
            return true;
        }
        if (this.hasReferences()) {
            for (int i2 = 0; i2 < this.refereceList.size(); ++i2) {
                Marker marker = (Marker)this.refereceList.get(i2);
                if (!marker.contains(string)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof Marker)) {
            return false;
        }
        Marker marker = (Marker)object;
        return this.name.equals(marker.getName());
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        if (!this.hasReferences()) {
            return this.getName();
        }
        Iterator iterator = this.iterator();
        StringBuffer stringBuffer = new StringBuffer(this.getName());
        stringBuffer.append(' ').append(OPEN);
        while (iterator.hasNext()) {
            Marker marker = (Marker)iterator.next();
            stringBuffer.append(marker.getName());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(SEP);
        }
        stringBuffer.append(CLOSE);
        return stringBuffer.toString();
    }
}

