/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.x509;

import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Encodable;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1EncodableVector;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1GeneralizedTime;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1InputStream;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Integer;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1ObjectIdentifier;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Sequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERBitString;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERSequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.AlgorithmIdentifier;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.CertificateList;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.Extensions;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.TBSCertList;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.Time;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.V2TBSCertListGenerator;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.X509Extensions;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.X509ExtensionsGenerator;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.X509Name;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.util.BCJcaJceHelper;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.util.JcaJceHelper;
import macromedia.externals.org.bouncycastle_1_60_0_0.jce.X509Principal;
import macromedia.externals.org.bouncycastle_1_60_0_0.jce.provider.X509CRLObject;
import macromedia.externals.org.bouncycastle_1_60_0_0.x509.X509Util;
import macromedia.externals.org.bouncycastle_1_60_0_0.x509.X509V2CRLGenerator;

public class X509V2CRLGenerator {
    private final JcaJceHelper bcHelper = new BCJcaJceHelper();
    private V2TBSCertListGenerator tbsGen = new V2TBSCertListGenerator();
    private ASN1ObjectIdentifier sigOID;
    private AlgorithmIdentifier sigAlgId;
    private String signatureAlgorithm;
    private X509ExtensionsGenerator extGenerator = new X509ExtensionsGenerator();

    public void reset() {
        this.tbsGen = new V2TBSCertListGenerator();
        this.extGenerator.reset();
    }

    public void setIssuerDN(X500Principal x500Principal) {
        try {
            this.tbsGen.setIssuer((X509Name)new X509Principal(x500Principal.getEncoded()));
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("can't process principal: " + iOException);
        }
    }

    public void setIssuerDN(X509Name x509Name) {
        this.tbsGen.setIssuer(x509Name);
    }

    public void setThisUpdate(Date date) {
        this.tbsGen.setThisUpdate(new Time(date));
    }

    public void setNextUpdate(Date date) {
        this.tbsGen.setNextUpdate(new Time(date));
    }

    public void addCRLEntry(BigInteger bigInteger, Date date, int n2) {
        this.tbsGen.addCRLEntry(new ASN1Integer(bigInteger), new Time(date), n2);
    }

    public void addCRLEntry(BigInteger bigInteger, Date date, int n2, Date date2) {
        this.tbsGen.addCRLEntry(new ASN1Integer(bigInteger), new Time(date), n2, new ASN1GeneralizedTime(date2));
    }

    public void addCRLEntry(BigInteger bigInteger, Date date, X509Extensions x509Extensions) {
        this.tbsGen.addCRLEntry(new ASN1Integer(bigInteger), new Time(date), Extensions.getInstance((Object)x509Extensions));
    }

    public void addCRL(X509CRL x509CRL) throws CRLException {
        Set<? extends X509CRLEntry> set = x509CRL.getRevokedCertificates();
        if (set != null) {
            for (X509CRLEntry x509CRLEntry : set) {
                ASN1InputStream aSN1InputStream = new ASN1InputStream(x509CRLEntry.getEncoded());
                try {
                    this.tbsGen.addCRLEntry(ASN1Sequence.getInstance((Object)aSN1InputStream.readObject()));
                }
                catch (IOException iOException) {
                    throw new CRLException("exception processing encoding of CRL: " + iOException.toString());
                }
            }
        }
    }

    public void setSignatureAlgorithm(String string) {
        this.signatureAlgorithm = string;
        try {
            this.sigOID = X509Util.getAlgorithmOID((String)string);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Unknown signature type requested");
        }
        this.sigAlgId = X509Util.getSigAlgID((ASN1ObjectIdentifier)this.sigOID, (String)string);
        this.tbsGen.setSignature(this.sigAlgId);
    }

    public void addExtension(String string, boolean bl2, ASN1Encodable aSN1Encodable) {
        this.addExtension(new ASN1ObjectIdentifier(string), bl2, aSN1Encodable);
    }

    public void addExtension(ASN1ObjectIdentifier aSN1ObjectIdentifier, boolean bl2, ASN1Encodable aSN1Encodable) {
        this.extGenerator.addExtension(new ASN1ObjectIdentifier(aSN1ObjectIdentifier.getId()), bl2, aSN1Encodable);
    }

    public void addExtension(String string, boolean bl2, byte[] byArray) {
        this.addExtension(new ASN1ObjectIdentifier(string), bl2, byArray);
    }

    public void addExtension(ASN1ObjectIdentifier aSN1ObjectIdentifier, boolean bl2, byte[] byArray) {
        this.extGenerator.addExtension(new ASN1ObjectIdentifier(aSN1ObjectIdentifier.getId()), bl2, byArray);
    }

    public X509CRL generateX509CRL(PrivateKey privateKey) throws SecurityException, SignatureException, InvalidKeyException {
        try {
            return this.generateX509CRL(privateKey, "BC", null);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new SecurityException("BC provider not installed!");
        }
    }

    public X509CRL generateX509CRL(PrivateKey privateKey, SecureRandom secureRandom) throws SecurityException, SignatureException, InvalidKeyException {
        try {
            return this.generateX509CRL(privateKey, "BC", secureRandom);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new SecurityException("BC provider not installed!");
        }
    }

    public X509CRL generateX509CRL(PrivateKey privateKey, String string) throws NoSuchProviderException, SecurityException, SignatureException, InvalidKeyException {
        return this.generateX509CRL(privateKey, string, null);
    }

    public X509CRL generateX509CRL(PrivateKey privateKey, String string, SecureRandom secureRandom) throws NoSuchProviderException, SecurityException, SignatureException, InvalidKeyException {
        try {
            return this.generate(privateKey, string, secureRandom);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw noSuchProviderException;
        }
        catch (SignatureException signatureException) {
            throw signatureException;
        }
        catch (InvalidKeyException invalidKeyException) {
            throw invalidKeyException;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SecurityException("exception: " + generalSecurityException);
        }
    }

    public X509CRL generate(PrivateKey privateKey) throws CRLException, IllegalStateException, NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        return this.generate(privateKey, (SecureRandom)null);
    }

    public X509CRL generate(PrivateKey privateKey, SecureRandom secureRandom) throws CRLException, IllegalStateException, NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        byte[] byArray;
        TBSCertList tBSCertList = this.generateCertList();
        try {
            byArray = X509Util.calculateSignature((ASN1ObjectIdentifier)this.sigOID, (String)this.signatureAlgorithm, (PrivateKey)privateKey, (SecureRandom)secureRandom, (ASN1Encodable)tBSCertList);
        }
        catch (IOException iOException) {
            throw new ExtCRLException("cannot generate CRL encoding", (Throwable)iOException);
        }
        return this.generateJcaObject(tBSCertList, byArray);
    }

    public X509CRL generate(PrivateKey privateKey, String string) throws CRLException, IllegalStateException, NoSuchProviderException, NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        return this.generate(privateKey, string, null);
    }

    public X509CRL generate(PrivateKey privateKey, String string, SecureRandom secureRandom) throws CRLException, IllegalStateException, NoSuchProviderException, NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        byte[] byArray;
        TBSCertList tBSCertList = this.generateCertList();
        try {
            byArray = X509Util.calculateSignature((ASN1ObjectIdentifier)this.sigOID, (String)this.signatureAlgorithm, (String)string, (PrivateKey)privateKey, (SecureRandom)secureRandom, (ASN1Encodable)tBSCertList);
        }
        catch (IOException iOException) {
            throw new ExtCRLException("cannot generate CRL encoding", (Throwable)iOException);
        }
        return this.generateJcaObject(tBSCertList, byArray);
    }

    private TBSCertList generateCertList() {
        if (!this.extGenerator.isEmpty()) {
            this.tbsGen.setExtensions(this.extGenerator.generate());
        }
        return this.tbsGen.generateTBSCertList();
    }

    private X509CRL generateJcaObject(TBSCertList tBSCertList, byte[] byArray) throws CRLException {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((ASN1Encodable)tBSCertList);
        aSN1EncodableVector.add((ASN1Encodable)this.sigAlgId);
        aSN1EncodableVector.add((ASN1Encodable)new DERBitString(byArray));
        return new X509CRLObject(new CertificateList((ASN1Sequence)new DERSequence(aSN1EncodableVector)));
    }

    public Iterator getSignatureAlgNames() {
        return X509Util.getAlgNames();
    }
}

