/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.x509;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXParameters;
import java.security.cert.PolicyNode;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Encodable;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Enumerated;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1InputStream;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Integer;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1ObjectIdentifier;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1OctetString;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Primitive;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Sequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1TaggedObject;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERIA5String;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DEROctetString;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.AccessDescription;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.AlgorithmIdentifier;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.AuthorityInformationAccess;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.AuthorityKeyIdentifier;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.BasicConstraints;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.CRLDistPoint;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.DistributionPoint;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.DistributionPointName;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.Extension;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.GeneralName;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.GeneralNames;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.GeneralSubtree;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.IssuingDistributionPoint;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.NameConstraints;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.PolicyInformation;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.qualified.Iso4217CurrencyCode;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.qualified.MonetaryValue;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.qualified.QCStatement;
import macromedia.externals.org.bouncycastle_1_60_0_0.i18n.ErrorBundle;
import macromedia.externals.org.bouncycastle_1_60_0_0.i18n.LocaleString;
import macromedia.externals.org.bouncycastle_1_60_0_0.i18n.filter.TrustedInput;
import macromedia.externals.org.bouncycastle_1_60_0_0.i18n.filter.UntrustedInput;
import macromedia.externals.org.bouncycastle_1_60_0_0.i18n.filter.UntrustedUrlInput;
import macromedia.externals.org.bouncycastle_1_60_0_0.jce.provider.AnnotatedException;
import macromedia.externals.org.bouncycastle_1_60_0_0.jce.provider.PKIXNameConstraintValidator;
import macromedia.externals.org.bouncycastle_1_60_0_0.jce.provider.PKIXNameConstraintValidatorException;
import macromedia.externals.org.bouncycastle_1_60_0_0.jce.provider.PKIXPolicyNode;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Integers;
import macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerException;
import macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathValidatorUtilities;
import macromedia.externals.org.bouncycastle_1_60_0_0.x509.X509CRLStoreSelector;

/*
 * Exception performing whole class analysis ignored.
 */
public class PKIXCertPathReviewer
extends CertPathValidatorUtilities {
    private static final String QC_STATEMENT = Extension.qCStatements.getId();
    private static final String CRL_DIST_POINTS = Extension.cRLDistributionPoints.getId();
    private static final String AUTH_INFO_ACCESS = Extension.authorityInfoAccess.getId();
    private static final String RESOURCE_NAME = "macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages";
    protected CertPath certPath;
    protected PKIXParameters pkixParams;
    protected Date validDate;
    protected List certs;
    protected int n;
    protected List[] notifications;
    protected List[] errors;
    protected TrustAnchor trustAnchor;
    protected PublicKey subjectPublicKey;
    protected PolicyNode policyTree;
    private boolean initialized;

    public void init(CertPath certPath, PKIXParameters pKIXParameters) throws CertPathReviewerException {
        if (this.initialized) {
            throw new IllegalStateException("object is already initialized!");
        }
        this.initialized = true;
        if (certPath == null) {
            throw new NullPointerException("certPath was null");
        }
        this.certPath = certPath;
        this.certs = certPath.getCertificates();
        this.n = this.certs.size();
        if (this.certs.isEmpty()) {
            throw new CertPathReviewerException(new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.emptyCertPath"));
        }
        this.pkixParams = (PKIXParameters)pKIXParameters.clone();
        this.validDate = PKIXCertPathReviewer.getValidDate((PKIXParameters)this.pkixParams);
        this.notifications = null;
        this.errors = null;
        this.trustAnchor = null;
        this.subjectPublicKey = null;
        this.policyTree = null;
    }

    public PKIXCertPathReviewer(CertPath certPath, PKIXParameters pKIXParameters) throws CertPathReviewerException {
        this.init(certPath, pKIXParameters);
    }

    public PKIXCertPathReviewer() {
    }

    public CertPath getCertPath() {
        return this.certPath;
    }

    public int getCertPathSize() {
        return this.n;
    }

    public List[] getErrors() {
        this.doChecks();
        return this.errors;
    }

    public List getErrors(int n2) {
        this.doChecks();
        return this.errors[n2 + 1];
    }

    public List[] getNotifications() {
        this.doChecks();
        return this.notifications;
    }

    public List getNotifications(int n2) {
        this.doChecks();
        return this.notifications[n2 + 1];
    }

    public PolicyNode getPolicyTree() {
        this.doChecks();
        return this.policyTree;
    }

    public PublicKey getSubjectPublicKey() {
        this.doChecks();
        return this.subjectPublicKey;
    }

    public TrustAnchor getTrustAnchor() {
        this.doChecks();
        return this.trustAnchor;
    }

    public boolean isValidCertPath() {
        this.doChecks();
        boolean bl2 = true;
        for (int i2 = 0; i2 < this.errors.length; ++i2) {
            if (this.errors[i2].isEmpty()) continue;
            bl2 = false;
            break;
        }
        return bl2;
    }

    protected void addNotification(ErrorBundle errorBundle) {
        this.notifications[0].add(errorBundle);
    }

    protected void addNotification(ErrorBundle errorBundle, int n2) {
        if (n2 < -1 || n2 >= this.n) {
            throw new IndexOutOfBoundsException();
        }
        this.notifications[n2 + 1].add(errorBundle);
    }

    protected void addError(ErrorBundle errorBundle) {
        this.errors[0].add(errorBundle);
    }

    protected void addError(ErrorBundle errorBundle, int n2) {
        if (n2 < -1 || n2 >= this.n) {
            throw new IndexOutOfBoundsException();
        }
        this.errors[n2 + 1].add(errorBundle);
    }

    protected void doChecks() {
        if (!this.initialized) {
            throw new IllegalStateException("Object not initialized. Call init() first.");
        }
        if (this.notifications == null) {
            this.notifications = new List[this.n + 1];
            this.errors = new List[this.n + 1];
            for (int i2 = 0; i2 < this.notifications.length; ++i2) {
                this.notifications[i2] = new ArrayList();
                this.errors[i2] = new ArrayList();
            }
            this.checkSignatures();
            this.checkNameConstraints();
            this.checkPathLength();
            this.checkPolicy();
            this.checkCriticalExtensions();
        }
    }

    private void checkNameConstraints() {
        X509Certificate x509Certificate = null;
        PKIXNameConstraintValidator pKIXNameConstraintValidator = new PKIXNameConstraintValidator();
        try {
            for (int i2 = this.certs.size() - 1; i2 > 0; --i2) {
                int n2;
                ASN1Sequence aSN1Sequence;
                ASN1Sequence aSN1Sequence2;
                ASN1InputStream aSN1InputStream;
                X500Principal x500Principal;
                int n3 = this.n - i2;
                x509Certificate = (X509Certificate)this.certs.get(i2);
                if (!PKIXCertPathReviewer.isSelfIssued((X509Certificate)x509Certificate)) {
                    ErrorBundle errorBundle;
                    x500Principal = PKIXCertPathReviewer.getSubjectPrincipal((X509Certificate)x509Certificate);
                    aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(x500Principal.getEncoded()));
                    try {
                        aSN1Sequence2 = (ASN1Sequence)aSN1InputStream.readObject();
                    }
                    catch (IOException iOException) {
                        ErrorBundle errorBundle2 = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.ncSubjectNameError", new Object[]{new UntrustedInput((Object)x500Principal)});
                        throw new CertPathReviewerException(errorBundle2, (Throwable)iOException, this.certPath, i2);
                    }
                    try {
                        pKIXNameConstraintValidator.checkPermittedDN(aSN1Sequence2);
                    }
                    catch (PKIXNameConstraintValidatorException pKIXNameConstraintValidatorException) {
                        ErrorBundle errorBundle3 = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.notPermittedDN", new Object[]{new UntrustedInput((Object)x500Principal.getName())});
                        throw new CertPathReviewerException(errorBundle3, (Throwable)pKIXNameConstraintValidatorException, this.certPath, i2);
                    }
                    try {
                        pKIXNameConstraintValidator.checkExcludedDN(aSN1Sequence2);
                    }
                    catch (PKIXNameConstraintValidatorException pKIXNameConstraintValidatorException) {
                        ErrorBundle errorBundle4 = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.excludedDN", new Object[]{new UntrustedInput((Object)x500Principal.getName())});
                        throw new CertPathReviewerException(errorBundle4, (Throwable)pKIXNameConstraintValidatorException, this.certPath, i2);
                    }
                    try {
                        aSN1Sequence = (ASN1Sequence)PKIXCertPathReviewer.getExtensionValue((X509Extension)x509Certificate, (String)SUBJECT_ALTERNATIVE_NAME);
                    }
                    catch (AnnotatedException annotatedException) {
                        errorBundle = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.subjAltNameExtError");
                        throw new CertPathReviewerException(errorBundle, (Throwable)annotatedException, this.certPath, i2);
                    }
                    if (aSN1Sequence != null) {
                        for (n2 = 0; n2 < aSN1Sequence.size(); ++n2) {
                            errorBundle = GeneralName.getInstance((Object)aSN1Sequence.getObjectAt(n2));
                            try {
                                pKIXNameConstraintValidator.checkPermitted((GeneralName)errorBundle);
                                pKIXNameConstraintValidator.checkExcluded((GeneralName)errorBundle);
                                continue;
                            }
                            catch (PKIXNameConstraintValidatorException pKIXNameConstraintValidatorException) {
                                ErrorBundle errorBundle5 = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.notPermittedEmail", new Object[]{new UntrustedInput((Object)errorBundle)});
                                throw new CertPathReviewerException(errorBundle5, (Throwable)pKIXNameConstraintValidatorException, this.certPath, i2);
                            }
                        }
                    }
                }
                try {
                    x500Principal = (ASN1Sequence)PKIXCertPathReviewer.getExtensionValue((X509Extension)x509Certificate, (String)NAME_CONSTRAINTS);
                }
                catch (AnnotatedException annotatedException) {
                    aSN1Sequence2 = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.ncExtError");
                    throw new CertPathReviewerException((ErrorBundle)aSN1Sequence2, (Throwable)annotatedException, this.certPath, i2);
                }
                if (x500Principal == null) continue;
                aSN1InputStream = NameConstraints.getInstance((Object)x500Principal);
                aSN1Sequence2 = aSN1InputStream.getPermittedSubtrees();
                if (aSN1Sequence2 != null) {
                    pKIXNameConstraintValidator.intersectPermittedSubtree((GeneralSubtree[])aSN1Sequence2);
                }
                if ((aSN1Sequence = aSN1InputStream.getExcludedSubtrees()) == null) continue;
                for (n2 = 0; n2 != ((GeneralSubtree[])aSN1Sequence).length; ++n2) {
                    pKIXNameConstraintValidator.addExcludedSubtree(aSN1Sequence[n2]);
                }
            }
        }
        catch (CertPathReviewerException certPathReviewerException) {
            this.addError(certPathReviewerException.getErrorMessage(), certPathReviewerException.getIndex());
        }
    }

    private void checkPathLength() {
        int n2 = this.n;
        int n3 = 0;
        X509Certificate x509Certificate = null;
        for (int i2 = this.certs.size() - 1; i2 > 0; --i2) {
            int n4;
            BigInteger bigInteger;
            BasicConstraints basicConstraints;
            int n5 = this.n - i2;
            x509Certificate = (X509Certificate)this.certs.get(i2);
            if (!PKIXCertPathReviewer.isSelfIssued((X509Certificate)x509Certificate)) {
                if (n2 <= 0) {
                    basicConstraints = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.pathLengthExtended");
                    this.addError((ErrorBundle)basicConstraints);
                }
                --n2;
                ++n3;
            }
            try {
                basicConstraints = BasicConstraints.getInstance((Object)PKIXCertPathReviewer.getExtensionValue((X509Extension)x509Certificate, (String)BASIC_CONSTRAINTS));
            }
            catch (AnnotatedException annotatedException) {
                ErrorBundle errorBundle = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.processLengthConstError");
                this.addError(errorBundle, i2);
                basicConstraints = null;
            }
            if (basicConstraints == null || (bigInteger = basicConstraints.getPathLenConstraint()) == null || (n4 = bigInteger.intValue()) >= n2) continue;
            n2 = n4;
        }
        ErrorBundle errorBundle = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.totalPathLength", new Object[]{Integers.valueOf((int)n3)});
        this.addNotification(errorBundle);
    }

    private void checkSignatures() {
        ASN1ObjectIdentifier aSN1ObjectIdentifier;
        Serializable serializable;
        Object object;
        TrustAnchor trustAnchor = null;
        Object object2 = null;
        Object object3 = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.certPathValidDate", new Object[]{new TrustedInput((Object)this.validDate), new TrustedInput((Object)new Date())});
        this.addNotification((ErrorBundle)object3);
        try {
            object3 = (X509Certificate)this.certs.get(this.certs.size() - 1);
            object = this.getTrustAnchors((X509Certificate)object3, this.pkixParams.getTrustAnchors());
            if (object.size() > 1) {
                serializable = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.conflictingTrustAnchors", new Object[]{Integers.valueOf((int)object.size()), new UntrustedInput((Object)((X509Certificate)object3).getIssuerX500Principal())});
                this.addError((ErrorBundle)serializable);
            } else if (object.isEmpty()) {
                serializable = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.noTrustAnchorFound", new Object[]{new UntrustedInput((Object)((X509Certificate)object3).getIssuerX500Principal()), Integers.valueOf((int)this.pkixParams.getTrustAnchors().size())});
                this.addError((ErrorBundle)serializable);
            } else {
                trustAnchor = (TrustAnchor)object.iterator().next();
                serializable = trustAnchor.getTrustedCert() != null ? trustAnchor.getTrustedCert().getPublicKey() : trustAnchor.getCAPublicKey();
                try {
                    CertPathValidatorUtilities.verifyX509Certificate((X509Certificate)object3, (PublicKey)serializable, (String)this.pkixParams.getSigProvider());
                }
                catch (SignatureException signatureException) {
                    aSN1ObjectIdentifier = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.trustButInvalidCert");
                    this.addError((ErrorBundle)aSN1ObjectIdentifier);
                }
                catch (Exception exception) {}
            }
        }
        catch (CertPathReviewerException certPathReviewerException) {
            this.addError(certPathReviewerException.getErrorMessage());
        }
        catch (Throwable throwable) {
            object = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.unknown", new Object[]{new UntrustedInput((Object)throwable.getMessage()), new UntrustedInput((Object)throwable)});
            this.addError((ErrorBundle)object);
        }
        if (trustAnchor != null) {
            object3 = trustAnchor.getTrustedCert();
            try {
                object2 = object3 != null ? PKIXCertPathReviewer.getSubjectPrincipal((X509Certificate)object3) : new X500Principal(trustAnchor.getCAName());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                serializable = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.trustDNInvalid", new Object[]{new UntrustedInput((Object)trustAnchor.getCAName())});
                this.addError((ErrorBundle)serializable);
            }
            if (object3 != null && (object = (Object)((X509Certificate)object3).getKeyUsage()) != null && object[5] == false) {
                serializable = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.trustKeyUsage");
                this.addNotification((ErrorBundle)serializable);
            }
        }
        object3 = null;
        object = object2;
        serializable = null;
        AlgorithmIdentifier algorithmIdentifier = null;
        aSN1ObjectIdentifier = null;
        ASN1Encodable aSN1Encodable = null;
        if (trustAnchor != null) {
            serializable = trustAnchor.getTrustedCert();
            object3 = serializable != null ? serializable.getPublicKey() : trustAnchor.getCAPublicKey();
            try {
                algorithmIdentifier = PKIXCertPathReviewer.getAlgorithmIdentifier((PublicKey)object3);
                aSN1ObjectIdentifier = algorithmIdentifier.getAlgorithm();
                aSN1Encodable = algorithmIdentifier.getParameters();
            }
            catch (CertPathValidatorException certPathValidatorException) {
                ErrorBundle errorBundle = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.trustPubKeyError");
                this.addError(errorBundle);
                algorithmIdentifier = null;
            }
        }
        X509Certificate x509Certificate = null;
        for (int i2 = this.certs.size() - 1; i2 >= 0; --i2) {
            BigInteger bigInteger;
            Object object4;
            Object object5;
            Object object6;
            ErrorBundle errorBundle;
            Object object7;
            int n2 = this.n - i2;
            x509Certificate = (X509Certificate)this.certs.get(i2);
            if (object3 != null) {
                try {
                    CertPathValidatorUtilities.verifyX509Certificate((X509Certificate)x509Certificate, (PublicKey)object3, (String)this.pkixParams.getSigProvider());
                }
                catch (GeneralSecurityException generalSecurityException) {
                    object7 = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.signatureNotVerified", new Object[]{generalSecurityException.getMessage(), generalSecurityException, generalSecurityException.getClass().getName()});
                    this.addError((ErrorBundle)object7, i2);
                }
            } else if (PKIXCertPathReviewer.isSelfIssued((X509Certificate)x509Certificate)) {
                try {
                    CertPathValidatorUtilities.verifyX509Certificate((X509Certificate)x509Certificate, (PublicKey)x509Certificate.getPublicKey(), (String)this.pkixParams.getSigProvider());
                    errorBundle = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.rootKeyIsValidButNotATrustAnchor");
                    this.addError(errorBundle, i2);
                }
                catch (GeneralSecurityException generalSecurityException) {
                    object7 = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.signatureNotVerified", new Object[]{generalSecurityException.getMessage(), generalSecurityException, generalSecurityException.getClass().getName()});
                    this.addError((ErrorBundle)object7, i2);
                }
            } else {
                errorBundle = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.NoIssuerPublicKey");
                object7 = x509Certificate.getExtensionValue(Extension.authorityKeyIdentifier.getId());
                if (object7 != null && (object6 = (object5 = AuthorityKeyIdentifier.getInstance((Object)DEROctetString.getInstance((Object)object7).getOctets())).getAuthorityCertIssuer()) != null) {
                    object4 = object6.getNames()[0];
                    bigInteger = object5.getAuthorityCertSerialNumber();
                    if (bigInteger != null) {
                        Object[] objectArray = new Object[]{new LocaleString("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "missingIssuer"), " \"", object4, "\" ", new LocaleString("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "missingSerial"), " ", bigInteger};
                        errorBundle.setExtraArguments(objectArray);
                    }
                }
                this.addError(errorBundle, i2);
            }
            try {
                x509Certificate.checkValidity(this.validDate);
            }
            catch (CertificateNotYetValidException certificateNotYetValidException) {
                object7 = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.certificateNotYetValid", new Object[]{new TrustedInput((Object)x509Certificate.getNotBefore())});
                this.addError((ErrorBundle)object7, i2);
            }
            catch (CertificateExpiredException certificateExpiredException) {
                object7 = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.certificateExpired", new Object[]{new TrustedInput((Object)x509Certificate.getNotAfter())});
                this.addError((ErrorBundle)object7, i2);
            }
            if (this.pkixParams.isRevocationEnabled()) {
                errorBundle = null;
                try {
                    object7 = PKIXCertPathReviewer.getExtensionValue((X509Extension)x509Certificate, (String)CRL_DIST_POINTS);
                    if (object7 != null) {
                        errorBundle = CRLDistPoint.getInstance((Object)object7);
                    }
                }
                catch (AnnotatedException annotatedException) {
                    object5 = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.crlDistPtExtError");
                    this.addError((ErrorBundle)object5, i2);
                }
                object7 = null;
                try {
                    object5 = PKIXCertPathReviewer.getExtensionValue((X509Extension)x509Certificate, (String)AUTH_INFO_ACCESS);
                    if (object5 != null) {
                        object7 = AuthorityInformationAccess.getInstance((Object)object5);
                    }
                }
                catch (AnnotatedException annotatedException) {
                    object6 = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.crlAuthInfoAccError");
                    this.addError((ErrorBundle)object6, i2);
                }
                object5 = this.getCRLDistUrls((CRLDistPoint)errorBundle);
                object6 = this.getOCSPUrls((AuthorityInformationAccess)object7);
                object4 = ((Vector)object5).iterator();
                while (object4.hasNext()) {
                    bigInteger = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.crlDistPoint", new Object[]{new UntrustedUrlInput(object4.next())});
                    this.addNotification((ErrorBundle)bigInteger, i2);
                }
                object4 = ((Vector)object6).iterator();
                while (object4.hasNext()) {
                    bigInteger = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.ocspLocation", new Object[]{new UntrustedUrlInput(object4.next())});
                    this.addNotification((ErrorBundle)bigInteger, i2);
                }
                try {
                    this.checkRevocation(this.pkixParams, x509Certificate, this.validDate, serializable, (PublicKey)object3, (Vector)object5, (Vector)object6, i2);
                }
                catch (CertPathReviewerException certPathReviewerException) {
                    this.addError(certPathReviewerException.getErrorMessage(), i2);
                }
            }
            if (object != null && !x509Certificate.getIssuerX500Principal().equals(object)) {
                errorBundle = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.certWrongIssuer", new Object[]{((X500Principal)object).getName(), x509Certificate.getIssuerX500Principal().getName()});
                this.addError(errorBundle, i2);
            }
            if (n2 != this.n) {
                if (x509Certificate != null && x509Certificate.getVersion() == 1) {
                    errorBundle = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.noCACert");
                    this.addError(errorBundle, i2);
                }
                try {
                    errorBundle = BasicConstraints.getInstance((Object)PKIXCertPathReviewer.getExtensionValue((X509Extension)x509Certificate, (String)BASIC_CONSTRAINTS));
                    if (errorBundle != null) {
                        if (!errorBundle.isCA()) {
                            object7 = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.noCACert");
                            this.addError((ErrorBundle)object7, i2);
                        }
                    } else {
                        object7 = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.noBasicConstraints");
                        this.addError((ErrorBundle)object7, i2);
                    }
                }
                catch (AnnotatedException annotatedException) {
                    object5 = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.errorProcesingBC");
                    this.addError((ErrorBundle)object5, i2);
                }
                object7 = x509Certificate.getKeyUsage();
                if (object7 != null && object7[5] == 0) {
                    object5 = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.noCertSign");
                    this.addError((ErrorBundle)object5, i2);
                }
            }
            serializable = x509Certificate;
            object = x509Certificate.getSubjectX500Principal();
            try {
                object3 = PKIXCertPathReviewer.getNextWorkingKey((List)this.certs, (int)i2);
                algorithmIdentifier = PKIXCertPathReviewer.getAlgorithmIdentifier((PublicKey)object3);
                aSN1ObjectIdentifier = algorithmIdentifier.getAlgorithm();
                aSN1Encodable = algorithmIdentifier.getParameters();
                continue;
            }
            catch (CertPathValidatorException certPathValidatorException) {
                object7 = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.pubKeyError");
                this.addError((ErrorBundle)object7, i2);
                algorithmIdentifier = null;
                aSN1ObjectIdentifier = null;
                aSN1Encodable = null;
            }
        }
        this.trustAnchor = trustAnchor;
        this.subjectPublicKey = object3;
    }

    /*
     * WARNING - void declaration
     */
    private void checkPolicy() {
        Set<String> set = this.pkixParams.getInitialPolicies();
        List[] listArray = new ArrayList[this.n + 1];
        for (int i2 = 0; i2 < listArray.length; ++i2) {
            listArray[i2] = new ArrayList();
        }
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("2.5.29.32.0");
        PKIXPolicyNode pKIXPolicyNode = new PKIXPolicyNode(new ArrayList(), 0, hashSet, null, new HashSet(), "2.5.29.32.0", false);
        listArray[0].add(pKIXPolicyNode);
        int n2 = this.pkixParams.isExplicitPolicyRequired() ? 0 : this.n + 1;
        int n3 = this.pkixParams.isAnyPolicyInhibited() ? 0 : this.n + 1;
        int n4 = this.pkixParams.isPolicyMappingInhibited() ? 0 : this.n + 1;
        Set set2 = null;
        X509Certificate x509Certificate = null;
        try {
            Object certPathValidatorException;
            Object object2;
            Object object3;
            ASN1Sequence aSN1Sequence;
            int n5;
            for (n5 = this.certs.size() - 1; n5 >= 0; --n5) {
                int n6 = this.n - n5;
                x509Certificate = (X509Certificate)this.certs.get(n5);
                try {
                    aSN1Sequence = (ASN1Sequence)PKIXCertPathReviewer.getExtensionValue((X509Extension)x509Certificate, (String)CERTIFICATE_POLICIES);
                }
                catch (AnnotatedException annotatedException) {
                    object3 = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.policyExtError");
                    throw new CertPathReviewerException((ErrorBundle)object3, (Throwable)annotatedException, this.certPath, n5);
                }
                if (aSN1Sequence != null && pKIXPolicyNode != null) {
                    boolean n7;
                    Object object4;
                    Object object5;
                    Object object6;
                    object2 = aSN1Sequence.getObjects();
                    object3 = new HashSet();
                    while (object2.hasMoreElements()) {
                        object6 = PolicyInformation.getInstance(object2.nextElement());
                        object5 = object6.getPolicyIdentifier();
                        object3.add(object5.getId());
                        if ("2.5.29.32.0".equals(object5.getId())) continue;
                        try {
                            object4 = PKIXCertPathReviewer.getQualifierSet((ASN1Sequence)object6.getPolicyQualifiers());
                        }
                        catch (CertPathValidatorException certPathValidatorException2) {
                            certPathValidatorException = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.policyQualifierError");
                            throw new CertPathReviewerException((ErrorBundle)certPathValidatorException, (Throwable)certPathValidatorException2, this.certPath, n5);
                        }
                        n7 = PKIXCertPathReviewer.processCertD1i((int)n6, (List[])listArray, (ASN1ObjectIdentifier)object5, object4);
                        if (n7) continue;
                        PKIXCertPathReviewer.processCertD1ii((int)n6, (List[])listArray, (ASN1ObjectIdentifier)object5, object4);
                    }
                    if (set2 == null || set2.contains("2.5.29.32.0")) {
                        set2 = object3;
                    } else {
                        object6 = set2.iterator();
                        object5 = new HashSet();
                        while (object6.hasNext()) {
                            object4 = object6.next();
                            if (!object3.contains(object4)) continue;
                            object5.add(object4);
                        }
                        set2 = object5;
                    }
                    if (n3 > 0 || n6 < this.n && PKIXCertPathReviewer.isSelfIssued((X509Certificate)x509Certificate)) {
                        object2 = aSN1Sequence.getObjects();
                        while (object2.hasMoreElements()) {
                            void pKIXPolicyNode3;
                            object6 = PolicyInformation.getInstance(object2.nextElement());
                            if (!"2.5.29.32.0".equals(object6.getPolicyIdentifier().getId())) continue;
                            try {
                                object5 = PKIXCertPathReviewer.getQualifierSet((ASN1Sequence)object6.getPolicyQualifiers());
                            }
                            catch (CertPathValidatorException certPathValidatorException3) {
                                ErrorBundle errorBundle = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.policyQualifierError");
                                throw new CertPathReviewerException(errorBundle, (Throwable)certPathValidatorException3, this.certPath, n5);
                            }
                            object4 = listArray[n6 - 1];
                            n7 = false;
                            while (pKIXPolicyNode3 < object4.size()) {
                                certPathValidatorException = (PKIXPolicyNode)object4.get((int)pKIXPolicyNode3);
                                for (Set<Object> set3 : certPathValidatorException.getExpectedPolicies()) {
                                    Object object;
                                    String string;
                                    if (set3 instanceof String) {
                                        string = (String)((Object)set3);
                                    } else {
                                        if (!(set3 instanceof ASN1ObjectIdentifier)) continue;
                                        string = ((ASN1ObjectIdentifier)set3).getId();
                                    }
                                    boolean bl2 = false;
                                    Iterator iterator = certPathValidatorException.getChildren();
                                    while (iterator.hasNext()) {
                                        object = (PKIXPolicyNode)iterator.next();
                                        if (!string.equals(object.getValidPolicy())) continue;
                                        bl2 = true;
                                    }
                                    if (bl2) continue;
                                    object = new HashSet();
                                    object.add(string);
                                    PKIXPolicyNode pKIXPolicyNode2 = new PKIXPolicyNode(new ArrayList(), n6, (Set)object, (PolicyNode)certPathValidatorException, (Set)object5, string, false);
                                    certPathValidatorException.addChild(pKIXPolicyNode2);
                                    listArray[n6].add(pKIXPolicyNode2);
                                }
                                ++pKIXPolicyNode3;
                            }
                            break block30;
                        }
                    }
                    for (int i3 = n6 - 1; i3 >= 0; --i3) {
                        PKIXPolicyNode i5;
                        object5 = listArray[i3];
                        for (int i4 = 0; i4 < object5.size() && ((i5 = (PKIXPolicyNode)object5.get(i4)).hasChildren() || (pKIXPolicyNode = PKIXCertPathReviewer.removePolicyNode((PKIXPolicyNode)pKIXPolicyNode, (List[])listArray, (PKIXPolicyNode)i5)) != null); ++i4) {
                        }
                    }
                    Set<String> set4 = x509Certificate.getCriticalExtensionOIDs();
                    if (set4 != null) {
                        void aSN1Sequence3;
                        boolean bl3 = set4.contains(CERTIFICATE_POLICIES);
                        List list = listArray[n6];
                        boolean aSN1ObjectIdentifier2 = false;
                        while (aSN1Sequence3 < list.size()) {
                            certPathValidatorException = (PKIXPolicyNode)list.get((int)aSN1Sequence3);
                            certPathValidatorException.setCritical(bl3);
                            ++aSN1Sequence3;
                        }
                    }
                }
                if (aSN1Sequence == null) {
                    pKIXPolicyNode = null;
                }
                if (n2 <= 0 && pKIXPolicyNode == null) {
                    object2 = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.noValidPolicyTree");
                    throw new CertPathReviewerException((ErrorBundle)object2);
                }
                if (n6 == this.n) continue;
                try {
                    object2 = PKIXCertPathReviewer.getExtensionValue((X509Extension)x509Certificate, (String)POLICY_MAPPINGS);
                }
                catch (AnnotatedException annotatedException) {
                    ErrorBundle errorBundle = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.policyMapExtError");
                    throw new CertPathReviewerException(errorBundle, (Throwable)annotatedException, this.certPath, n5);
                }
                if (object2 != null) {
                    object3 = (ASN1Sequence)object2;
                    for (int i6 = 0; i6 < object3.size(); ++i6) {
                        ASN1Sequence aSN1Sequence2 = (ASN1Sequence)object3.getObjectAt(i6);
                        ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)aSN1Sequence2.getObjectAt(0);
                        ASN1ObjectIdentifier string = (ASN1ObjectIdentifier)aSN1Sequence2.getObjectAt(1);
                        if ("2.5.29.32.0".equals(aSN1ObjectIdentifier.getId())) {
                            certPathValidatorException = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.invalidPolicyMapping");
                            throw new CertPathReviewerException((ErrorBundle)certPathValidatorException, this.certPath, n5);
                        }
                        if (!"2.5.29.32.0".equals(string.getId())) continue;
                        certPathValidatorException = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.invalidPolicyMapping");
                        throw new CertPathReviewerException((ErrorBundle)certPathValidatorException, this.certPath, n5);
                    }
                }
                if (object2 != null) {
                    Object object;
                    object3 = (ASN1Sequence)object2;
                    HashMap hashMap = new HashMap();
                    HashSet<PKIXPolicyNode> hashSet2 = new HashSet<PKIXPolicyNode>();
                    for (int i7 = 0; i7 < object3.size(); ++i7) {
                        Set<Object> set3;
                        ASN1Sequence iterator = (ASN1Sequence)object3.getObjectAt(i7);
                        certPathValidatorException = ((ASN1ObjectIdentifier)iterator.getObjectAt(0)).getId();
                        object = ((ASN1ObjectIdentifier)iterator.getObjectAt(1)).getId();
                        if (!hashMap.containsKey(certPathValidatorException)) {
                            set3 = new HashSet<Object>();
                            set3.add(object);
                            hashMap.put((PKIXPolicyNode)certPathValidatorException, set3);
                            hashSet2.add((PKIXPolicyNode)certPathValidatorException);
                            continue;
                        }
                        set3 = (Set)hashMap.get(certPathValidatorException);
                        set3.add(object);
                    }
                    for (String pKIXPolicyNode6 : hashSet2) {
                        if (n4 > 0) {
                            try {
                                PKIXCertPathReviewer.prepareNextCertB1((int)n6, (List[])listArray, (String)pKIXPolicyNode6, hashMap, (X509Certificate)x509Certificate);
                                continue;
                            }
                            catch (AnnotatedException annotatedException) {
                                object = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.policyExtError");
                                throw new CertPathReviewerException((ErrorBundle)object, (Throwable)annotatedException, this.certPath, n5);
                            }
                            catch (CertPathValidatorException certPathValidatorException4) {
                                object = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.policyQualifierError");
                                throw new CertPathReviewerException((ErrorBundle)object, (Throwable)certPathValidatorException4, this.certPath, n5);
                            }
                        }
                        if (n4 > 0) continue;
                        pKIXPolicyNode = PKIXCertPathReviewer.prepareNextCertB2((int)n6, (List[])listArray, (String)pKIXPolicyNode6, (PKIXPolicyNode)pKIXPolicyNode);
                    }
                }
                if (!PKIXCertPathReviewer.isSelfIssued((X509Certificate)x509Certificate)) {
                    if (n2 != 0) {
                        --n2;
                    }
                    if (n4 != 0) {
                        --n4;
                    }
                    if (n3 != 0) {
                        --n3;
                    }
                }
                try {
                    object3 = (ASN1Sequence)PKIXCertPathReviewer.getExtensionValue((X509Extension)x509Certificate, (String)POLICY_CONSTRAINTS);
                    if (object3 != null) {
                        Enumeration enumeration = object3.getObjects();
                        while (enumeration.hasMoreElements()) {
                            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)enumeration.nextElement();
                            switch (aSN1TaggedObject.getTagNo()) {
                                case 0: {
                                    int n8 = ASN1Integer.getInstance((ASN1TaggedObject)aSN1TaggedObject, (boolean)false).getValue().intValue();
                                    if (n8 >= n2) break;
                                    n2 = n8;
                                    break;
                                }
                                case 1: {
                                    int n8 = ASN1Integer.getInstance((ASN1TaggedObject)aSN1TaggedObject, (boolean)false).getValue().intValue();
                                    if (n8 >= n4) break;
                                    n4 = n8;
                                }
                            }
                        }
                    }
                }
                catch (AnnotatedException annotatedException) {
                    ErrorBundle errorBundle = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.policyConstExtError");
                    throw new CertPathReviewerException(errorBundle, this.certPath, n5);
                }
                try {
                    int n9;
                    object3 = (ASN1Integer)PKIXCertPathReviewer.getExtensionValue((X509Extension)x509Certificate, (String)INHIBIT_ANY_POLICY);
                    if (object3 == null || (n9 = object3.getValue().intValue()) >= n3) continue;
                    n3 = n9;
                    continue;
                }
                catch (AnnotatedException annotatedException) {
                    ErrorBundle errorBundle = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.policyInhibitExtError");
                    throw new CertPathReviewerException(errorBundle, this.certPath, n5);
                }
            }
            if (!PKIXCertPathReviewer.isSelfIssued(x509Certificate) && n2 > 0) {
                --n2;
            }
            try {
                aSN1Sequence = (ASN1Sequence)PKIXCertPathReviewer.getExtensionValue(x509Certificate, (String)POLICY_CONSTRAINTS);
                if (aSN1Sequence != null) {
                    object2 = aSN1Sequence.getObjects();
                    while (object2.hasMoreElements()) {
                        object3 = (ASN1TaggedObject)object2.nextElement();
                        switch (object3.getTagNo()) {
                            case 0: {
                                int n10 = ASN1Integer.getInstance((ASN1TaggedObject)object3, (boolean)false).getValue().intValue();
                                if (n10 != 0) break;
                                n2 = 0;
                            }
                        }
                    }
                }
            }
            catch (AnnotatedException annotatedException) {
                object2 = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.policyConstExtError");
                throw new CertPathReviewerException((ErrorBundle)object2, this.certPath, n5);
            }
            if (pKIXPolicyNode == null) {
                if (this.pkixParams.isExplicitPolicyRequired()) {
                    object2 = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.explicitPolicy");
                    throw new CertPathReviewerException((ErrorBundle)object2, this.certPath, n5);
                }
                aSN1Sequence = null;
            } else if (PKIXCertPathReviewer.isAnyPolicy(set)) {
                if (this.pkixParams.isExplicitPolicyRequired()) {
                    if (set2.isEmpty()) {
                        object2 = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.explicitPolicy");
                        throw new CertPathReviewerException((ErrorBundle)object2, this.certPath, n5);
                    }
                    object2 = new HashSet();
                    for (int i8 = 0; i8 < listArray.length; ++i8) {
                        ArrayList arrayList = listArray[i8];
                        for (int i9 = 0; i9 < arrayList.size(); ++i9) {
                            PKIXPolicyNode pKIXPolicyNode4 = (PKIXPolicyNode)arrayList.get(i9);
                            if (!"2.5.29.32.0".equals(pKIXPolicyNode4.getValidPolicy())) continue;
                            Iterator iterator = pKIXPolicyNode4.getChildren();
                            while (iterator.hasNext()) {
                                object2.add(iterator.next());
                            }
                        }
                    }
                    Iterator iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        PKIXPolicyNode pKIXPolicyNode5 = (PKIXPolicyNode)iterator.next();
                        String string = pKIXPolicyNode5.getValidPolicy();
                        if (set2.contains(string)) continue;
                    }
                    if (pKIXPolicyNode != null) {
                        for (int i10 = this.n - 1; i10 >= 0; --i10) {
                            List list = listArray[i10];
                            for (int i11 = 0; i11 < list.size(); ++i11) {
                                PKIXPolicyNode pKIXPolicyNode9 = (PKIXPolicyNode)list.get(i11);
                                if (pKIXPolicyNode9.hasChildren()) continue;
                                pKIXPolicyNode = PKIXCertPathReviewer.removePolicyNode((PKIXPolicyNode)pKIXPolicyNode, (List[])listArray, (PKIXPolicyNode)pKIXPolicyNode9);
                            }
                        }
                    }
                }
                aSN1Sequence = pKIXPolicyNode;
            } else {
                object2 = new HashSet();
                for (int i12 = 0; i12 < listArray.length; ++i12) {
                    ArrayList arrayList = listArray[i12];
                    for (int i13 = 0; i13 < arrayList.size(); ++i13) {
                        PKIXPolicyNode pKIXPolicyNode7 = (PKIXPolicyNode)arrayList.get(i13);
                        if (!"2.5.29.32.0".equals(pKIXPolicyNode7.getValidPolicy())) continue;
                        Iterator iterator = pKIXPolicyNode7.getChildren();
                        while (iterator.hasNext()) {
                            certPathValidatorException = (PKIXPolicyNode)iterator.next();
                            if ("2.5.29.32.0".equals(certPathValidatorException.getValidPolicy())) continue;
                            object2.add(certPathValidatorException);
                        }
                    }
                }
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    PKIXPolicyNode pKIXPolicyNode8 = (PKIXPolicyNode)iterator.next();
                    String string = pKIXPolicyNode8.getValidPolicy();
                    if (set.contains(string)) continue;
                    pKIXPolicyNode = PKIXCertPathReviewer.removePolicyNode((PKIXPolicyNode)pKIXPolicyNode, (List[])listArray, (PKIXPolicyNode)pKIXPolicyNode8);
                }
                if (pKIXPolicyNode != null) {
                    for (int i14 = this.n - 1; i14 >= 0; --i14) {
                        ArrayList arrayList = listArray[i14];
                        for (int i15 = 0; i15 < arrayList.size(); ++i15) {
                            PKIXPolicyNode pKIXPolicyNode3 = (PKIXPolicyNode)arrayList.get(i15);
                            if (pKIXPolicyNode3.hasChildren()) continue;
                            pKIXPolicyNode = PKIXCertPathReviewer.removePolicyNode((PKIXPolicyNode)pKIXPolicyNode, (List[])listArray, (PKIXPolicyNode)pKIXPolicyNode3);
                        }
                    }
                }
                aSN1Sequence = pKIXPolicyNode;
            }
            if (n2 <= 0 && aSN1Sequence == null) {
                object2 = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.invalidPolicy");
                throw new CertPathReviewerException((ErrorBundle)object2);
            }
            pKIXPolicyNode = aSN1Sequence;
        }
        catch (CertPathReviewerException certPathReviewerException) {
            this.addError(certPathReviewerException.getErrorMessage(), certPathReviewerException.getIndex());
            pKIXPolicyNode = null;
        }
    }

    private void checkCriticalExtensions() {
        List<PKIXCertPathChecker> list = this.pkixParams.getCertPathCheckers();
        Iterator<PKIXCertPathChecker> iterator = list.iterator();
        try {
            try {
                while (iterator.hasNext()) {
                    iterator.next().init(false);
                }
            }
            catch (CertPathValidatorException certPathValidatorException) {
                ErrorBundle errorBundle = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.certPathCheckerError", new Object[]{certPathValidatorException.getMessage(), certPathValidatorException, certPathValidatorException.getClass().getName()});
                throw new CertPathReviewerException(errorBundle, (Throwable)certPathValidatorException);
            }
            X509Certificate x509Certificate = null;
            for (int i2 = this.certs.size() - 1; i2 >= 0; --i2) {
                ErrorBundle errorBundle;
                x509Certificate = (X509Certificate)this.certs.get(i2);
                Set<String> set = x509Certificate.getCriticalExtensionOIDs();
                if (set == null || set.isEmpty()) continue;
                set.remove(KEY_USAGE);
                set.remove(CERTIFICATE_POLICIES);
                set.remove(POLICY_MAPPINGS);
                set.remove(INHIBIT_ANY_POLICY);
                set.remove(ISSUING_DISTRIBUTION_POINT);
                set.remove(DELTA_CRL_INDICATOR);
                set.remove(POLICY_CONSTRAINTS);
                set.remove(BASIC_CONSTRAINTS);
                set.remove(SUBJECT_ALTERNATIVE_NAME);
                set.remove(NAME_CONSTRAINTS);
                if (set.contains(QC_STATEMENT) && this.processQcStatements(x509Certificate, i2)) {
                    set.remove(QC_STATEMENT);
                }
                Iterator<PKIXCertPathChecker> iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    try {
                        iterator2.next().check(x509Certificate, set);
                    }
                    catch (CertPathValidatorException certPathValidatorException) {
                        errorBundle = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.criticalExtensionError", new Object[]{certPathValidatorException.getMessage(), certPathValidatorException, certPathValidatorException.getClass().getName()});
                        throw new CertPathReviewerException(errorBundle, certPathValidatorException.getCause(), this.certPath, i2);
                    }
                }
                if (set.isEmpty()) continue;
                errorBundle = set.iterator();
                while (errorBundle.hasNext()) {
                    ErrorBundle errorBundle2 = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.unknownCriticalExt", new Object[]{new ASN1ObjectIdentifier(errorBundle.next())});
                    this.addError(errorBundle2, i2);
                }
            }
        }
        catch (CertPathReviewerException certPathReviewerException) {
            this.addError(certPathReviewerException.getErrorMessage(), certPathReviewerException.getIndex());
        }
    }

    private boolean processQcStatements(X509Certificate x509Certificate, int n2) {
        try {
            boolean bl2 = false;
            ASN1Sequence aSN1Sequence = (ASN1Sequence)PKIXCertPathReviewer.getExtensionValue((X509Extension)x509Certificate, (String)QC_STATEMENT);
            for (int i2 = 0; i2 < aSN1Sequence.size(); ++i2) {
                ErrorBundle errorBundle;
                QCStatement qCStatement = QCStatement.getInstance((Object)aSN1Sequence.getObjectAt(i2));
                if (QCStatement.id_etsi_qcs_QcCompliance.equals((Object)qCStatement.getStatementId())) {
                    errorBundle = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.QcEuCompliance");
                    this.addNotification(errorBundle, n2);
                    continue;
                }
                if (QCStatement.id_qcs_pkixQCSyntax_v1.equals((Object)qCStatement.getStatementId())) continue;
                if (QCStatement.id_etsi_qcs_QcSSCD.equals((Object)qCStatement.getStatementId())) {
                    errorBundle = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.QcSSCD");
                    this.addNotification(errorBundle, n2);
                    continue;
                }
                if (QCStatement.id_etsi_qcs_LimiteValue.equals((Object)qCStatement.getStatementId())) {
                    errorBundle = MonetaryValue.getInstance((Object)qCStatement.getStatementInfo());
                    Iso4217CurrencyCode iso4217CurrencyCode = errorBundle.getCurrency();
                    double d2 = errorBundle.getAmount().doubleValue() * Math.pow(10.0, errorBundle.getExponent().doubleValue());
                    ErrorBundle errorBundle2 = errorBundle.getCurrency().isAlphabetic() ? new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.QcLimitValueAlpha", new Object[]{errorBundle.getCurrency().getAlphabetic(), new TrustedInput((Object)new Double(d2)), errorBundle}) : new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.QcLimitValueNum", new Object[]{Integers.valueOf((int)errorBundle.getCurrency().getNumeric()), new TrustedInput((Object)new Double(d2)), errorBundle});
                    this.addNotification(errorBundle2, n2);
                    continue;
                }
                errorBundle = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.QcUnknownStatement", new Object[]{qCStatement.getStatementId(), new UntrustedInput((Object)qCStatement)});
                this.addNotification(errorBundle, n2);
                bl2 = true;
            }
            return !bl2;
        }
        catch (AnnotatedException annotatedException) {
            ErrorBundle errorBundle = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.QcStatementExtError");
            this.addError(errorBundle, n2);
            return false;
        }
    }

    private String IPtoString(byte[] byArray) {
        String string;
        try {
            string = InetAddress.getByAddress(byArray).getHostAddress();
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i2 = 0; i2 != byArray.length; ++i2) {
                stringBuffer.append(Integer.toHexString(byArray[i2] & 0xFF));
                stringBuffer.append(' ');
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    protected void checkRevocation(PKIXParameters pKIXParameters, X509Certificate x509Certificate, Date date, X509Certificate x509Certificate2, PublicKey publicKey, Vector vector, Vector vector2, int n2) throws CertPathReviewerException {
        this.checkCRLs(pKIXParameters, x509Certificate, date, x509Certificate2, publicKey, vector, n2);
    }

    protected void checkCRLs(PKIXParameters pKIXParameters, X509Certificate x509Certificate, Date date, X509Certificate x509Certificate2, PublicKey publicKey, Vector vector, int n2) throws CertPathReviewerException {
        ErrorBundle errorBundle;
        String string;
        Object object;
        Object object2;
        Iterator iterator;
        X509CRLStoreSelector x509CRLStoreSelector = new X509CRLStoreSelector();
        try {
            x509CRLStoreSelector.addIssuerName(PKIXCertPathReviewer.getEncodedIssuerPrincipal((Object)x509Certificate).getEncoded());
        }
        catch (IOException iOException) {
            ErrorBundle errorBundle2 = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.crlIssuerException");
            throw new CertPathReviewerException(errorBundle2, (Throwable)iOException);
        }
        x509CRLStoreSelector.setCertificateChecking(x509Certificate);
        try {
            Set set = CRL_UTIL.findCRLs(x509CRLStoreSelector, pKIXParameters);
            iterator = set.iterator();
            if (set.isEmpty()) {
                set = CRL_UTIL.findCRLs(new X509CRLStoreSelector(), pKIXParameters);
                object2 = set.iterator();
                object = new ArrayList<X500Principal>();
                while (object2.hasNext()) {
                    object.add(((X509CRL)object2.next()).getIssuerX500Principal());
                }
                int n3 = object.size();
                string = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.noCrlInCertstore", new Object[]{new UntrustedInput((Object)x509CRLStoreSelector.getIssuerNames()), new UntrustedInput(object), Integers.valueOf((int)n3)});
                this.addNotification((ErrorBundle)string, n2);
            }
        }
        catch (AnnotatedException annotatedException) {
            object2 = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.crlExtractionError", new Object[]{annotatedException.getCause().getMessage(), annotatedException.getCause(), annotatedException.getCause().getClass().getName()});
            this.addError((ErrorBundle)object2, n2);
            iterator = new ArrayList().iterator();
        }
        boolean bl2 = false;
        object2 = null;
        while (iterator.hasNext()) {
            object2 = (X509CRL)iterator.next();
            if (((X509CRL)object2).getNextUpdate() == null || pKIXParameters.getDate().before(((X509CRL)object2).getNextUpdate())) {
                bl2 = true;
                object = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.localValidCRL", new Object[]{new TrustedInput((Object)((X509CRL)object2).getThisUpdate()), new TrustedInput((Object)((X509CRL)object2).getNextUpdate())});
                this.addNotification((ErrorBundle)object, n2);
                break;
            }
            object = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.localInvalidCRL", new Object[]{new TrustedInput((Object)((X509CRL)object2).getThisUpdate()), new TrustedInput((Object)((X509CRL)object2).getNextUpdate())});
            this.addNotification((ErrorBundle)object, n2);
        }
        if (!bl2) {
            object = null;
            Iterator iterator2 = vector.iterator();
            while (iterator2.hasNext()) {
                try {
                    string = (String)iterator2.next();
                    object = this.getCRL(string);
                    if (object == null) continue;
                    if (!x509Certificate.getIssuerX500Principal().equals(((X509CRL)object).getIssuerX500Principal())) {
                        errorBundle = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.onlineCRLWrongCA", new Object[]{new UntrustedInput((Object)((X509CRL)object).getIssuerX500Principal().getName()), new UntrustedInput((Object)x509Certificate.getIssuerX500Principal().getName()), new UntrustedUrlInput((Object)string)});
                        this.addNotification(errorBundle, n2);
                        continue;
                    }
                    if (((X509CRL)object).getNextUpdate() == null || this.pkixParams.getDate().before(((X509CRL)object).getNextUpdate())) {
                        bl2 = true;
                        errorBundle = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.onlineValidCRL", new Object[]{new TrustedInput((Object)((X509CRL)object).getThisUpdate()), new TrustedInput((Object)((X509CRL)object).getNextUpdate()), new UntrustedUrlInput((Object)string)});
                        this.addNotification(errorBundle, n2);
                        object2 = object;
                        break;
                    }
                    errorBundle = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.onlineInvalidCRL", new Object[]{new TrustedInput((Object)((X509CRL)object).getThisUpdate()), new TrustedInput((Object)((X509CRL)object).getNextUpdate()), new UntrustedUrlInput((Object)string)});
                    this.addNotification(errorBundle, n2);
                }
                catch (CertPathReviewerException certPathReviewerException) {
                    this.addNotification(certPathReviewerException.getErrorMessage(), n2);
                }
            }
        }
        if (object2 != null) {
            Object object3;
            Object object4;
            Object object5;
            boolean[] blArray;
            if (!(x509Certificate2 == null || (blArray = x509Certificate2.getKeyUsage()) == null || blArray.length >= 7 && blArray[6])) {
                string = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.noCrlSigningPermited");
                throw new CertPathReviewerException((ErrorBundle)string);
            }
            if (publicKey != null) {
                try {
                    ((X509CRL)object2).verify(publicKey, "BC");
                }
                catch (Exception exception) {
                    string = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.crlVerifyFailed");
                    throw new CertPathReviewerException((ErrorBundle)string, (Throwable)exception);
                }
            } else {
                ErrorBundle errorBundle3 = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.crlNoIssuerPublicKey");
                throw new CertPathReviewerException(errorBundle3);
            }
            object = ((X509CRL)object2).getRevokedCertificate(x509Certificate.getSerialNumber());
            if (object != null) {
                object5 = null;
                if (((X509CRLEntry)object).hasExtensions()) {
                    try {
                        string = ASN1Enumerated.getInstance((Object)PKIXCertPathReviewer.getExtensionValue((X509Extension)object, (String)Extension.reasonCode.getId()));
                    }
                    catch (AnnotatedException annotatedException) {
                        ErrorBundle errorBundle4 = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.crlReasonExtError");
                        throw new CertPathReviewerException(errorBundle4, (Throwable)annotatedException);
                    }
                    if (string != null) {
                        object5 = crlReasons[string.getValue().intValue()];
                    }
                }
                if (object5 == null) {
                    object5 = crlReasons[7];
                }
                string = new LocaleString("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", (String)object5);
                if (!date.before(((X509CRLEntry)object).getRevocationDate())) {
                    errorBundle = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.certRevoked", new Object[]{new TrustedInput((Object)((X509CRLEntry)object).getRevocationDate()), string});
                    throw new CertPathReviewerException(errorBundle);
                }
                errorBundle = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.revokedAfterValidation", new Object[]{new TrustedInput((Object)((X509CRLEntry)object).getRevocationDate()), string});
                this.addNotification(errorBundle, n2);
            } else {
                object5 = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.notRevoked");
                this.addNotification(object5, n2);
            }
            if (((X509CRL)object2).getNextUpdate() != null && ((X509CRL)object2).getNextUpdate().before(this.pkixParams.getDate())) {
                object5 = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.crlUpdateAvailable", new Object[]{new TrustedInput((Object)((X509CRL)object2).getNextUpdate())});
                this.addNotification(object5, n2);
            }
            try {
                object5 = PKIXCertPathReviewer.getExtensionValue((X509Extension)object2, (String)ISSUING_DISTRIBUTION_POINT);
            }
            catch (AnnotatedException annotatedException) {
                errorBundle = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.distrPtExtError");
                throw new CertPathReviewerException(errorBundle);
            }
            try {
                string = PKIXCertPathReviewer.getExtensionValue((X509Extension)object2, (String)DELTA_CRL_INDICATOR);
            }
            catch (AnnotatedException annotatedException) {
                ErrorBundle errorBundle5 = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.deltaCrlExtError");
                throw new CertPathReviewerException(errorBundle5);
            }
            if (string != null) {
                errorBundle = new X509CRLStoreSelector();
                try {
                    errorBundle.addIssuerName(PKIXCertPathReviewer.getIssuerPrincipal((X509CRL)object2).getEncoded());
                }
                catch (IOException iOException) {
                    ErrorBundle errorBundle6 = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.crlIssuerException");
                    throw new CertPathReviewerException(errorBundle6, (Throwable)iOException);
                }
                errorBundle.setMinCRLNumber(((ASN1Integer)string).getPositiveValue());
                try {
                    errorBundle.setMaxCRLNumber(((ASN1Integer)PKIXCertPathReviewer.getExtensionValue((X509Extension)object2, (String)CRL_NUMBER)).getPositiveValue().subtract(BigInteger.valueOf(1L)));
                }
                catch (AnnotatedException annotatedException) {
                    ErrorBundle errorBundle7 = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.crlNbrExtError");
                    throw new CertPathReviewerException(errorBundle7, (Throwable)annotatedException);
                }
                boolean bl3 = false;
                try {
                    object4 = CRL_UTIL.findCRLs((X509CRLStoreSelector)errorBundle, pKIXParameters).iterator();
                }
                catch (AnnotatedException annotatedException) {
                    ErrorBundle errorBundle8 = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.crlExtractionError");
                    throw new CertPathReviewerException(errorBundle8, (Throwable)annotatedException);
                }
                while (object4.hasNext()) {
                    ASN1Primitive aSN1Primitive;
                    object3 = (X509CRL)object4.next();
                    try {
                        aSN1Primitive = PKIXCertPathReviewer.getExtensionValue((X509Extension)object3, (String)ISSUING_DISTRIBUTION_POINT);
                    }
                    catch (AnnotatedException annotatedException) {
                        ErrorBundle errorBundle9 = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.distrPtExtError");
                        throw new CertPathReviewerException(errorBundle9, (Throwable)annotatedException);
                    }
                    if (object5 == null) {
                        if (aSN1Primitive != null) continue;
                        bl3 = true;
                        break;
                    }
                    if (!object5.equals((Object)aSN1Primitive)) continue;
                    bl3 = true;
                    break;
                }
                if (!bl3) {
                    object3 = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.noBaseCRL");
                    throw new CertPathReviewerException(object3);
                }
            }
            if (object5 != null) {
                errorBundle = IssuingDistributionPoint.getInstance((Object)object5);
                BasicConstraints basicConstraints = null;
                try {
                    basicConstraints = BasicConstraints.getInstance((Object)PKIXCertPathReviewer.getExtensionValue((X509Extension)x509Certificate, (String)BASIC_CONSTRAINTS));
                }
                catch (AnnotatedException annotatedException) {
                    object3 = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.crlBCExtError");
                    throw new CertPathReviewerException(object3, (Throwable)annotatedException);
                }
                if (errorBundle.onlyContainsUserCerts() && basicConstraints != null && basicConstraints.isCA()) {
                    object4 = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.crlOnlyUserCert");
                    throw new CertPathReviewerException((ErrorBundle)object4);
                }
                if (errorBundle.onlyContainsCACerts() && (basicConstraints == null || !basicConstraints.isCA())) {
                    object4 = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.crlOnlyCaCert");
                    throw new CertPathReviewerException((ErrorBundle)object4);
                }
                if (errorBundle.onlyContainsAttributeCerts()) {
                    object4 = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.crlOnlyAttrCert");
                    throw new CertPathReviewerException((ErrorBundle)object4);
                }
            }
        }
        if (!bl2) {
            ErrorBundle errorBundle10 = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.noValidCrlFound");
            throw new CertPathReviewerException(errorBundle10);
        }
    }

    protected Vector getCRLDistUrls(CRLDistPoint cRLDistPoint) {
        Vector<String> vector = new Vector<String>();
        if (cRLDistPoint != null) {
            DistributionPoint[] distributionPointArray = cRLDistPoint.getDistributionPoints();
            for (int i2 = 0; i2 < distributionPointArray.length; ++i2) {
                DistributionPointName distributionPointName = distributionPointArray[i2].getDistributionPoint();
                if (distributionPointName.getType() != 0) continue;
                GeneralName[] generalNameArray = GeneralNames.getInstance((Object)distributionPointName.getName()).getNames();
                for (int i3 = 0; i3 < generalNameArray.length; ++i3) {
                    if (generalNameArray[i3].getTagNo() != 6) continue;
                    String string = ((DERIA5String)generalNameArray[i3].getName()).getString();
                    vector.add(string);
                }
            }
        }
        return vector;
    }

    protected Vector getOCSPUrls(AuthorityInformationAccess authorityInformationAccess) {
        Vector<String> vector = new Vector<String>();
        if (authorityInformationAccess != null) {
            AccessDescription[] accessDescriptionArray = authorityInformationAccess.getAccessDescriptions();
            for (int i2 = 0; i2 < accessDescriptionArray.length; ++i2) {
                GeneralName generalName;
                if (!accessDescriptionArray[i2].getAccessMethod().equals((Object)AccessDescription.id_ad_ocsp) || (generalName = accessDescriptionArray[i2].getAccessLocation()).getTagNo() != 6) continue;
                String string = ((DERIA5String)generalName.getName()).getString();
                vector.add(string);
            }
        }
        return vector;
    }

    private X509CRL getCRL(String string) throws CertPathReviewerException {
        X509CRL x509CRL;
        block3: {
            x509CRL = null;
            try {
                URL uRL = new URL(string);
                if (!uRL.getProtocol().equals("http") && !uRL.getProtocol().equals("https")) break block3;
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                httpURLConnection.setUseCaches(false);
                httpURLConnection.setDoInput(true);
                httpURLConnection.connect();
                if (httpURLConnection.getResponseCode() == 200) {
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "BC");
                    x509CRL = (X509CRL)certificateFactory.generateCRL(httpURLConnection.getInputStream());
                    break block3;
                }
                throw new Exception(httpURLConnection.getResponseMessage());
            }
            catch (Exception exception) {
                ErrorBundle errorBundle = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.loadCrlDistPointError", new Object[]{new UntrustedInput((Object)string), exception.getMessage(), exception, exception.getClass().getName()});
                throw new CertPathReviewerException(errorBundle);
            }
        }
        return x509CRL;
    }

    protected Collection getTrustAnchors(X509Certificate x509Certificate, Set set) throws CertPathReviewerException {
        Object object;
        Object object2;
        Object object3;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = set.iterator();
        X509CertSelector x509CertSelector = new X509CertSelector();
        try {
            x509CertSelector.setSubject(PKIXCertPathReviewer.getEncodedIssuerPrincipal((Object)x509Certificate).getEncoded());
            object3 = x509Certificate.getExtensionValue(Extension.authorityKeyIdentifier.getId());
            if (object3 != null) {
                object2 = (ASN1OctetString)ASN1Primitive.fromByteArray((byte[])object3);
                object = AuthorityKeyIdentifier.getInstance((Object)ASN1Primitive.fromByteArray((byte[])object2.getOctets()));
                x509CertSelector.setSerialNumber(object.getAuthorityCertSerialNumber());
                byte[] byArray = object.getKeyIdentifier();
                if (byArray != null) {
                    x509CertSelector.setSubjectKeyIdentifier(new DEROctetString(byArray).getEncoded());
                }
            }
        }
        catch (IOException iOException) {
            ErrorBundle errorBundle = new ErrorBundle("macromedia.externals.org.bouncycastle_1_60_0_0.x509.CertPathReviewerMessages", "CertPathReviewer.trustAnchorIssuerError");
            throw new CertPathReviewerException(errorBundle);
        }
        while (iterator.hasNext()) {
            object3 = (TrustAnchor)iterator.next();
            if (((TrustAnchor)object3).getTrustedCert() != null) {
                if (!x509CertSelector.match(((TrustAnchor)object3).getTrustedCert())) continue;
                arrayList.add(object3);
                continue;
            }
            if (((TrustAnchor)object3).getCAName() == null || ((TrustAnchor)object3).getCAPublicKey() == null || !((X500Principal)(object2 = PKIXCertPathReviewer.getEncodedIssuerPrincipal((Object)x509Certificate))).equals(object = new X500Principal(((TrustAnchor)object3).getCAName()))) continue;
            arrayList.add(object3);
        }
        return arrayList;
    }
}

