/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.pqc.jcajce.provider.xmss;

import java.io.IOException;
import java.security.PrivateKey;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Encodable;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1ObjectIdentifier;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.pkcs.PrivateKeyInfo;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.AlgorithmIdentifier;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.CipherParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.asn1.PQCObjectIdentifiers;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.asn1.XMSSKeyParams;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.asn1.XMSSPrivateKey;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.BDS;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.XMSSParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.XMSSPrivateKeyParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.XMSSUtil;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.jcajce.interfaces.XMSSKey;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.jcajce.provider.xmss.DigestUtil;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Arrays;

public class BCXMSSPrivateKey
implements XMSSKey,
PrivateKey {
    private final XMSSPrivateKeyParameters keyParams;
    private final ASN1ObjectIdentifier treeDigest;

    public BCXMSSPrivateKey(ASN1ObjectIdentifier aSN1ObjectIdentifier, XMSSPrivateKeyParameters xMSSPrivateKeyParameters) {
        this.treeDigest = aSN1ObjectIdentifier;
        this.keyParams = xMSSPrivateKeyParameters;
    }

    public BCXMSSPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        XMSSKeyParams xMSSKeyParams = XMSSKeyParams.getInstance((Object)privateKeyInfo.getPrivateKeyAlgorithm().getParameters());
        this.treeDigest = xMSSKeyParams.getTreeDigest().getAlgorithm();
        XMSSPrivateKey xMSSPrivateKey = XMSSPrivateKey.getInstance((Object)privateKeyInfo.parsePrivateKey());
        try {
            XMSSPrivateKeyParameters.Builder builder = new XMSSPrivateKeyParameters.Builder(new XMSSParameters(xMSSKeyParams.getHeight(), DigestUtil.getDigest((ASN1ObjectIdentifier)this.treeDigest))).withIndex(xMSSPrivateKey.getIndex()).withSecretKeySeed(xMSSPrivateKey.getSecretKeySeed()).withSecretKeyPRF(xMSSPrivateKey.getSecretKeyPRF()).withPublicSeed(xMSSPrivateKey.getPublicSeed()).withRoot(xMSSPrivateKey.getRoot());
            if (xMSSPrivateKey.getBdsState() != null) {
                builder.withBDSState((BDS)XMSSUtil.deserialize((byte[])xMSSPrivateKey.getBdsState(), BDS.class));
            }
            this.keyParams = builder.build();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException("ClassNotFoundException processing BDS state: " + classNotFoundException.getMessage());
        }
    }

    @Override
    public String getAlgorithm() {
        return "XMSS";
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    @Override
    public byte[] getEncoded() {
        try {
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.xmss, (ASN1Encodable)new XMSSKeyParams(this.keyParams.getParameters().getHeight(), new AlgorithmIdentifier(this.treeDigest)));
            PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(algorithmIdentifier, (ASN1Encodable)this.createKeyStructure());
            return privateKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCXMSSPrivateKey) {
            BCXMSSPrivateKey bCXMSSPrivateKey = (BCXMSSPrivateKey)object;
            return this.treeDigest.equals((Object)bCXMSSPrivateKey.treeDigest) && Arrays.areEqual((byte[])this.keyParams.toByteArray(), (byte[])bCXMSSPrivateKey.keyParams.toByteArray());
        }
        return false;
    }

    public int hashCode() {
        return this.treeDigest.hashCode() + 37 * Arrays.hashCode((byte[])this.keyParams.toByteArray());
    }

    CipherParameters getKeyParams() {
        return this.keyParams;
    }

    private XMSSPrivateKey createKeyStructure() {
        byte[] byArray = this.keyParams.toByteArray();
        int n2 = this.keyParams.getParameters().getDigestSize();
        int n3 = this.keyParams.getParameters().getHeight();
        int n4 = 4;
        int n5 = n2;
        int n6 = n2;
        int n7 = n2;
        int n8 = n2;
        int n9 = 0;
        int n10 = (int)XMSSUtil.bytesToXBigEndian((byte[])byArray, (int)n9, (int)n4);
        if (!XMSSUtil.isIndexValid((int)n3, (long)n10)) {
            throw new IllegalArgumentException("index out of bounds");
        }
        byte[] byArray2 = XMSSUtil.extractBytesAtOffset((byte[])byArray, (int)(n9 += n4), (int)n5);
        byte[] byArray3 = XMSSUtil.extractBytesAtOffset((byte[])byArray, (int)(n9 += n5), (int)n6);
        byte[] byArray4 = XMSSUtil.extractBytesAtOffset((byte[])byArray, (int)(n9 += n6), (int)n7);
        byte[] byArray5 = XMSSUtil.extractBytesAtOffset((byte[])byArray, (int)(n9 += n7), (int)n8);
        byte[] byArray6 = XMSSUtil.extractBytesAtOffset((byte[])byArray, (int)(n9 += n8), (int)(byArray.length - n9));
        return new XMSSPrivateKey(n10, byArray2, byArray3, byArray4, byArray5, byArray6);
    }

    ASN1ObjectIdentifier getTreeDigestOID() {
        return this.treeDigest;
    }

    public int getHeight() {
        return this.keyParams.getParameters().getHeight();
    }

    public String getTreeDigest() {
        return DigestUtil.getXMSSDigestName((ASN1ObjectIdentifier)this.treeDigest);
    }
}

