/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.pqc.jcajce.provider.xmss;

import java.io.IOException;
import java.security.PrivateKey;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Encodable;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1ObjectIdentifier;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.pkcs.PrivateKeyInfo;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.AlgorithmIdentifier;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.CipherParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.asn1.PQCObjectIdentifiers;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.asn1.XMSSMTKeyParams;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.asn1.XMSSMTPrivateKey;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.asn1.XMSSPrivateKey;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.BDSStateMap;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.XMSSMTParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.XMSSMTPrivateKeyParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.XMSSUtil;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.jcajce.interfaces.XMSSMTKey;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.jcajce.provider.xmss.DigestUtil;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Arrays;

public class BCXMSSMTPrivateKey
implements XMSSMTKey,
PrivateKey {
    private final ASN1ObjectIdentifier treeDigest;
    private final XMSSMTPrivateKeyParameters keyParams;

    public BCXMSSMTPrivateKey(ASN1ObjectIdentifier aSN1ObjectIdentifier, XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters) {
        this.treeDigest = aSN1ObjectIdentifier;
        this.keyParams = xMSSMTPrivateKeyParameters;
    }

    public BCXMSSMTPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        XMSSMTKeyParams xMSSMTKeyParams = XMSSMTKeyParams.getInstance((Object)privateKeyInfo.getPrivateKeyAlgorithm().getParameters());
        this.treeDigest = xMSSMTKeyParams.getTreeDigest().getAlgorithm();
        XMSSPrivateKey xMSSPrivateKey = XMSSPrivateKey.getInstance((Object)privateKeyInfo.parsePrivateKey());
        try {
            XMSSMTPrivateKeyParameters.Builder builder = new XMSSMTPrivateKeyParameters.Builder(new XMSSMTParameters(xMSSMTKeyParams.getHeight(), xMSSMTKeyParams.getLayers(), DigestUtil.getDigest((ASN1ObjectIdentifier)this.treeDigest))).withIndex((long)xMSSPrivateKey.getIndex()).withSecretKeySeed(xMSSPrivateKey.getSecretKeySeed()).withSecretKeyPRF(xMSSPrivateKey.getSecretKeyPRF()).withPublicSeed(xMSSPrivateKey.getPublicSeed()).withRoot(xMSSPrivateKey.getRoot());
            if (xMSSPrivateKey.getBdsState() != null) {
                builder.withBDSState((BDSStateMap)XMSSUtil.deserialize((byte[])xMSSPrivateKey.getBdsState(), BDSStateMap.class));
            }
            this.keyParams = builder.build();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException("ClassNotFoundException processing BDS state: " + classNotFoundException.getMessage());
        }
    }

    @Override
    public String getAlgorithm() {
        return "XMSSMT";
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    @Override
    public byte[] getEncoded() {
        try {
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.xmss_mt, (ASN1Encodable)new XMSSMTKeyParams(this.keyParams.getParameters().getHeight(), this.keyParams.getParameters().getLayers(), new AlgorithmIdentifier(this.treeDigest)));
            PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(algorithmIdentifier, (ASN1Encodable)this.createKeyStructure());
            return privateKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    CipherParameters getKeyParams() {
        return this.keyParams;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCXMSSMTPrivateKey) {
            BCXMSSMTPrivateKey bCXMSSMTPrivateKey = (BCXMSSMTPrivateKey)object;
            return this.treeDigest.equals((Object)bCXMSSMTPrivateKey.treeDigest) && Arrays.areEqual((byte[])this.keyParams.toByteArray(), (byte[])bCXMSSMTPrivateKey.keyParams.toByteArray());
        }
        return false;
    }

    public int hashCode() {
        return this.treeDigest.hashCode() + 37 * Arrays.hashCode((byte[])this.keyParams.toByteArray());
    }

    private XMSSMTPrivateKey createKeyStructure() {
        byte[] byArray = this.keyParams.toByteArray();
        int n2 = this.keyParams.getParameters().getDigestSize();
        int n3 = this.keyParams.getParameters().getHeight();
        int n4 = (n3 + 7) / 8;
        int n5 = n2;
        int n6 = n2;
        int n7 = n2;
        int n8 = n2;
        int n9 = 0;
        int n10 = (int)XMSSUtil.bytesToXBigEndian((byte[])byArray, (int)n9, (int)n4);
        if (!XMSSUtil.isIndexValid((int)n3, (long)n10)) {
            throw new IllegalArgumentException("index out of bounds");
        }
        byte[] byArray2 = XMSSUtil.extractBytesAtOffset((byte[])byArray, (int)(n9 += n4), (int)n5);
        byte[] byArray3 = XMSSUtil.extractBytesAtOffset((byte[])byArray, (int)(n9 += n5), (int)n6);
        byte[] byArray4 = XMSSUtil.extractBytesAtOffset((byte[])byArray, (int)(n9 += n6), (int)n7);
        byte[] byArray5 = XMSSUtil.extractBytesAtOffset((byte[])byArray, (int)(n9 += n7), (int)n8);
        byte[] byArray6 = XMSSUtil.extractBytesAtOffset((byte[])byArray, (int)(n9 += n8), (int)(byArray.length - n9));
        return new XMSSMTPrivateKey(n10, byArray2, byArray3, byArray4, byArray5, byArray6);
    }

    ASN1ObjectIdentifier getTreeDigestOID() {
        return this.treeDigest;
    }

    public int getHeight() {
        return this.keyParams.getParameters().getHeight();
    }

    public int getLayers() {
        return this.keyParams.getParameters().getLayers();
    }

    public String getTreeDigest() {
        return DigestUtil.getXMSSDigestName((ASN1ObjectIdentifier)this.treeDigest);
    }
}

