/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.pqc.jcajce.provider.rainbow;

import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.CipherParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.Digest;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.AsymmetricKeyParameter;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ParametersWithRandom;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.rainbow.RainbowSigner;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.jcajce.provider.rainbow.RainbowKeysToParams;

public class SignatureSpi
extends java.security.SignatureSpi {
    private Digest digest;
    private RainbowSigner signer;
    private SecureRandom random;

    protected SignatureSpi(Digest digest, RainbowSigner rainbowSigner) {
        this.digest = digest;
        this.signer = rainbowSigner;
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        AsymmetricKeyParameter asymmetricKeyParameter = RainbowKeysToParams.generatePublicKeyParameter((PublicKey)publicKey);
        this.digest.reset();
        this.signer.init(false, (CipherParameters)asymmetricKeyParameter);
    }

    protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        this.random = secureRandom;
        this.engineInitSign(privateKey);
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        AsymmetricKeyParameter asymmetricKeyParameter = RainbowKeysToParams.generatePrivateKeyParameter((PrivateKey)privateKey);
        if (this.random != null) {
            asymmetricKeyParameter = new ParametersWithRandom((CipherParameters)asymmetricKeyParameter, this.random);
        }
        this.digest.reset();
        this.signer.init(true, (CipherParameters)asymmetricKeyParameter);
    }

    protected void engineUpdate(byte by2) throws SignatureException {
        this.digest.update(by2);
    }

    protected void engineUpdate(byte[] byArray, int n2, int n3) throws SignatureException {
        this.digest.update(byArray, n2, n3);
    }

    protected byte[] engineSign() throws SignatureException {
        byte[] byArray = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(byArray, 0);
        try {
            byte[] byArray2 = this.signer.generateSignature(byArray);
            return byArray2;
        }
        catch (Exception exception) {
            throw new SignatureException(exception.toString());
        }
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        byte[] byArray2 = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(byArray2, 0);
        return this.signer.verifySignature(byArray2, byArray);
    }

    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    protected void engineSetParameter(String string, Object object) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    protected Object engineGetParameter(String string) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }
}

