/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.pqc.jcajce.provider.mceliece;

import java.io.ByteArrayOutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.pkcs.PKCSObjectIdentifiers;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.X509ObjectIdentifiers;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.CipherParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.Digest;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.InvalidCipherTextException;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.AsymmetricKeyParameter;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ParametersWithRandom;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.mceliece.McElieceCCA2KeyParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.mceliece.McElieceKobaraImaiCipher;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.jcajce.provider.mceliece.McElieceCCA2KeysToParams;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.jcajce.provider.util.AsymmetricHybridCipher;

public class McElieceKobaraImaiCipherSpi
extends AsymmetricHybridCipher
implements PKCSObjectIdentifiers,
X509ObjectIdentifiers {
    private Digest digest;
    private McElieceKobaraImaiCipher cipher;
    private ByteArrayOutputStream buf = new ByteArrayOutputStream();

    public McElieceKobaraImaiCipherSpi() {
        this.buf = new ByteArrayOutputStream();
    }

    protected McElieceKobaraImaiCipherSpi(Digest digest, McElieceKobaraImaiCipher mcElieceKobaraImaiCipher) {
        this.digest = digest;
        this.cipher = mcElieceKobaraImaiCipher;
        this.buf = new ByteArrayOutputStream();
    }

    public byte[] update(byte[] byArray, int n2, int n3) {
        this.buf.write(byArray, n2, n3);
        return new byte[0];
    }

    public byte[] doFinal(byte[] byArray, int n2, int n3) throws BadPaddingException {
        this.update(byArray, n2, n3);
        if (this.opMode == 1) {
            return this.cipher.messageEncrypt(this.pad());
        }
        if (this.opMode == 2) {
            try {
                byte[] byArray2 = this.buf.toByteArray();
                this.buf.reset();
                return this.unpad(this.cipher.messageDecrypt(byArray2));
            }
            catch (InvalidCipherTextException invalidCipherTextException) {
                throw new BadPaddingException(invalidCipherTextException.getMessage());
            }
        }
        throw new IllegalStateException("unknown mode in doFinal");
    }

    protected int encryptOutputSize(int n2) {
        return 0;
    }

    protected int decryptOutputSize(int n2) {
        return 0;
    }

    protected void initCipherEncrypt(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.buf.reset();
        AsymmetricKeyParameter asymmetricKeyParameter = McElieceCCA2KeysToParams.generatePublicKeyParameter((PublicKey)((PublicKey)key));
        asymmetricKeyParameter = new ParametersWithRandom((CipherParameters)asymmetricKeyParameter, secureRandom);
        this.digest.reset();
        this.cipher.init(true, (CipherParameters)asymmetricKeyParameter);
    }

    protected void initCipherDecrypt(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.buf.reset();
        AsymmetricKeyParameter asymmetricKeyParameter = McElieceCCA2KeysToParams.generatePrivateKeyParameter((PrivateKey)((PrivateKey)key));
        this.digest.reset();
        this.cipher.init(false, (CipherParameters)asymmetricKeyParameter);
    }

    public String getName() {
        return "McElieceKobaraImaiCipher";
    }

    public int getKeySize(Key key) throws InvalidKeyException {
        if (key instanceof PublicKey) {
            McElieceCCA2KeyParameters mcElieceCCA2KeyParameters = (McElieceCCA2KeyParameters)McElieceCCA2KeysToParams.generatePublicKeyParameter((PublicKey)((PublicKey)key));
            return this.cipher.getKeySize(mcElieceCCA2KeyParameters);
        }
        if (key instanceof PrivateKey) {
            McElieceCCA2KeyParameters mcElieceCCA2KeyParameters = (McElieceCCA2KeyParameters)McElieceCCA2KeysToParams.generatePrivateKeyParameter((PrivateKey)((PrivateKey)key));
            return this.cipher.getKeySize(mcElieceCCA2KeyParameters);
        }
        throw new InvalidKeyException();
    }

    private byte[] pad() {
        this.buf.write(1);
        byte[] byArray = this.buf.toByteArray();
        this.buf.reset();
        return byArray;
    }

    private byte[] unpad(byte[] byArray) throws BadPaddingException {
        int n2;
        for (n2 = byArray.length - 1; n2 >= 0 && byArray[n2] == 0; --n2) {
        }
        if (byArray[n2] != 1) {
            throw new BadPaddingException("invalid ciphertext");
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        return byArray2;
    }
}

