/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.pqc.jcajce.provider.gmss;

import java.security.PublicKey;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Encodable;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.AlgorithmIdentifier;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.CipherParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.asn1.GMSSPublicKey;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.asn1.PQCObjectIdentifiers;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.asn1.ParSet;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.gmss.GMSSParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.gmss.GMSSPublicKeyParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.jcajce.provider.util.KeyUtil;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.encoders.Hex;

public class BCGMSSPublicKey
implements CipherParameters,
PublicKey {
    private static final long serialVersionUID = 1L;
    private byte[] publicKeyBytes;
    private GMSSParameters gmssParameterSet;
    private GMSSParameters gmssParams;

    public BCGMSSPublicKey(byte[] byArray, GMSSParameters gMSSParameters) {
        this.gmssParameterSet = gMSSParameters;
        this.publicKeyBytes = byArray;
    }

    public BCGMSSPublicKey(GMSSPublicKeyParameters gMSSPublicKeyParameters) {
        this(gMSSPublicKeyParameters.getPublicKey(), gMSSPublicKeyParameters.getParameters());
    }

    @Override
    public String getAlgorithm() {
        return "GMSS";
    }

    public byte[] getPublicKeyBytes() {
        return this.publicKeyBytes;
    }

    public GMSSParameters getParameterSet() {
        return this.gmssParameterSet;
    }

    public String toString() {
        String string = "GMSS public key : " + new String(Hex.encode((byte[])this.publicKeyBytes)) + "\nHeight of Trees: \n";
        for (int i2 = 0; i2 < this.gmssParameterSet.getHeightOfTrees().length; ++i2) {
            string = string + "Layer " + i2 + " : " + this.gmssParameterSet.getHeightOfTrees()[i2] + " WinternitzParameter: " + this.gmssParameterSet.getWinternitzParameter()[i2] + " K: " + this.gmssParameterSet.getK()[i2] + "\n";
        }
        return string;
    }

    @Override
    public byte[] getEncoded() {
        return KeyUtil.getEncodedSubjectPublicKeyInfo((AlgorithmIdentifier)new AlgorithmIdentifier(PQCObjectIdentifiers.gmss, (ASN1Encodable)new ParSet(this.gmssParameterSet.getNumOfLayers(), this.gmssParameterSet.getHeightOfTrees(), this.gmssParameterSet.getWinternitzParameter(), this.gmssParameterSet.getK()).toASN1Primitive()), (ASN1Encodable)new GMSSPublicKey(this.publicKeyBytes));
    }

    @Override
    public String getFormat() {
        return "X.509";
    }
}

