/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss;

import java.security.SecureRandom;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.AsymmetricCipherKeyPair;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.KeyGenerationParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.AsymmetricKeyParameter;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.BDS;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.BDSStateMap;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.OTSHashAddress;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.XMSSMTKeyGenerationParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.XMSSMTParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.XMSSMTPrivateKeyParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.XMSSMTPublicKeyParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.XMSSNode;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.xmss.XMSSParameters;

public final class XMSSMTKeyPairGenerator {
    private XMSSMTParameters params;
    private XMSSParameters xmssParams;
    private SecureRandom prng;

    public void init(KeyGenerationParameters keyGenerationParameters) {
        XMSSMTKeyGenerationParameters xMSSMTKeyGenerationParameters = (XMSSMTKeyGenerationParameters)keyGenerationParameters;
        this.prng = xMSSMTKeyGenerationParameters.getRandom();
        this.params = xMSSMTKeyGenerationParameters.getParameters();
        this.xmssParams = this.params.getXMSSParameters();
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters = this.generatePrivateKey(new XMSSMTPrivateKeyParameters.Builder(this.params).build().getBDSState());
        this.xmssParams.getWOTSPlus().importKeys(new byte[this.params.getDigestSize()], xMSSMTPrivateKeyParameters.getPublicSeed());
        int n2 = this.params.getLayers() - 1;
        OTSHashAddress oTSHashAddress = (OTSHashAddress)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withLayerAddress(n2)).build();
        BDS bDS = new BDS(this.xmssParams, xMSSMTPrivateKeyParameters.getPublicSeed(), xMSSMTPrivateKeyParameters.getSecretKeySeed(), oTSHashAddress);
        XMSSNode xMSSNode = bDS.getRoot();
        xMSSMTPrivateKeyParameters.getBDSState().put(n2, bDS);
        xMSSMTPrivateKeyParameters = new XMSSMTPrivateKeyParameters.Builder(this.params).withSecretKeySeed(xMSSMTPrivateKeyParameters.getSecretKeySeed()).withSecretKeyPRF(xMSSMTPrivateKeyParameters.getSecretKeyPRF()).withPublicSeed(xMSSMTPrivateKeyParameters.getPublicSeed()).withRoot(xMSSNode.getValue()).withBDSState(xMSSMTPrivateKeyParameters.getBDSState()).build();
        XMSSMTPublicKeyParameters xMSSMTPublicKeyParameters = new XMSSMTPublicKeyParameters.Builder(this.params).withRoot(xMSSNode.getValue()).withPublicSeed(xMSSMTPrivateKeyParameters.getPublicSeed()).build();
        return new AsymmetricCipherKeyPair((AsymmetricKeyParameter)xMSSMTPublicKeyParameters, (AsymmetricKeyParameter)xMSSMTPrivateKeyParameters);
    }

    private XMSSMTPrivateKeyParameters generatePrivateKey(BDSStateMap bDSStateMap) {
        int n2 = this.params.getDigestSize();
        byte[] byArray = new byte[n2];
        this.prng.nextBytes(byArray);
        byte[] byArray2 = new byte[n2];
        this.prng.nextBytes(byArray2);
        byte[] byArray3 = new byte[n2];
        this.prng.nextBytes(byArray3);
        XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters = null;
        xMSSMTPrivateKeyParameters = new XMSSMTPrivateKeyParameters.Builder(this.params).withSecretKeySeed(byArray).withSecretKeyPRF(byArray2).withPublicSeed(byArray3).withBDSState(bDSStateMap).build();
        return xMSSMTPrivateKeyParameters;
    }
}

