/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.ntru;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.AsymmetricCipherKeyPair;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.AsymmetricCipherKeyPairGenerator;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.CryptoServicesRegistrar;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.KeyGenerationParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.AsymmetricKeyParameter;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.ntru.NTRUSigningKeyGenerationParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.ntru.NTRUSigningKeyPairGenerator;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.ntru.NTRUSigningPrivateKeyParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.crypto.ntru.NTRUSigningPublicKeyParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.math.ntru.euclid.BigIntEuclidean;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.math.ntru.polynomial.BigIntPolynomial;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.math.ntru.polynomial.DenseTernaryPolynomial;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.math.ntru.polynomial.IntegerPolynomial;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.math.ntru.polynomial.Polynomial;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.math.ntru.polynomial.ProductFormPolynomial;
import macromedia.externals.org.bouncycastle_1_60_0_0.pqc.math.ntru.polynomial.Resultant;

public class NTRUSigningKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private NTRUSigningKeyGenerationParameters params;

    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.params = (NTRUSigningKeyGenerationParameters)keyGenerationParameters;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        Future future;
        NTRUSigningPublicKeyParameters nTRUSigningPublicKeyParameters = null;
        ExecutorService executorService = Executors.newCachedThreadPool();
        ArrayList arrayList = new ArrayList();
        for (int i2 = this.params.B; i2 >= 0; --i2) {
            arrayList.add(executorService.submit(new BasisGenerationTask(this, null)));
        }
        executorService.shutdown();
        ArrayList arrayList2 = new ArrayList();
        for (int i3 = this.params.B; i3 >= 0; --i3) {
            future = (Future)arrayList.get(i3);
            try {
                arrayList2.add(future.get());
                if (i3 != this.params.B) continue;
                nTRUSigningPublicKeyParameters = new NTRUSigningPublicKeyParameters(((NTRUSigningPrivateKeyParameters.Basis)future.get()).h, this.params.getSigningParameters());
                continue;
            }
            catch (Exception exception) {
                throw new IllegalStateException(exception);
            }
        }
        NTRUSigningPrivateKeyParameters nTRUSigningPrivateKeyParameters = new NTRUSigningPrivateKeyParameters(arrayList2, nTRUSigningPublicKeyParameters);
        future = new AsymmetricCipherKeyPair(nTRUSigningPublicKeyParameters, (AsymmetricKeyParameter)nTRUSigningPrivateKeyParameters);
        return future;
    }

    public AsymmetricCipherKeyPair generateKeyPairSingleThread() {
        ArrayList<NTRUSigningPrivateKeyParameters.Basis> arrayList = new ArrayList<NTRUSigningPrivateKeyParameters.Basis>();
        NTRUSigningPublicKeyParameters nTRUSigningPublicKeyParameters = null;
        for (int i2 = this.params.B; i2 >= 0; --i2) {
            NTRUSigningPrivateKeyParameters.Basis basis = this.generateBoundedBasis();
            arrayList.add(basis);
            if (i2 != 0) continue;
            nTRUSigningPublicKeyParameters = new NTRUSigningPublicKeyParameters(basis.h, this.params.getSigningParameters());
        }
        NTRUSigningPrivateKeyParameters nTRUSigningPrivateKeyParameters = new NTRUSigningPrivateKeyParameters(arrayList, nTRUSigningPublicKeyParameters);
        return new AsymmetricCipherKeyPair(nTRUSigningPublicKeyParameters, (AsymmetricKeyParameter)nTRUSigningPrivateKeyParameters);
    }

    private void minimizeFG(IntegerPolynomial integerPolynomial, IntegerPolynomial integerPolynomial2, IntegerPolynomial integerPolynomial3, IntegerPolynomial integerPolynomial4, int n2) {
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            n3 += 2 * n2 * (integerPolynomial.coeffs[i2] * integerPolynomial.coeffs[i2] + integerPolynomial2.coeffs[i2] * integerPolynomial2.coeffs[i2]);
        }
        n3 -= 4;
        IntegerPolynomial integerPolynomial5 = (IntegerPolynomial)integerPolynomial.clone();
        IntegerPolynomial integerPolynomial6 = (IntegerPolynomial)integerPolynomial2.clone();
        int n4 = 0;
        int n5 = n2;
        for (int i3 = 0; n4 < n5 && i3 < n2; ++i3) {
            int n6;
            int n7 = 0;
            for (int i4 = 0; i4 < n2; ++i4) {
                n6 = integerPolynomial3.coeffs[i4] * integerPolynomial.coeffs[i4];
                int n8 = integerPolynomial4.coeffs[i4] * integerPolynomial2.coeffs[i4];
                int n9 = 4 * n2 * (n6 + n8);
                n7 += n9;
            }
            n6 = 4 * (integerPolynomial3.sumCoeffs() + integerPolynomial4.sumCoeffs());
            if ((n7 -= n6) > n3) {
                integerPolynomial3.sub(integerPolynomial5);
                integerPolynomial4.sub(integerPolynomial6);
                ++n4;
                i3 = 0;
            } else if (n7 < -n3) {
                integerPolynomial3.add(integerPolynomial5);
                integerPolynomial4.add(integerPolynomial6);
                ++n4;
                i3 = 0;
            }
            integerPolynomial5.rotate1();
            integerPolynomial6.rotate1();
        }
    }

    private FGBasis generateBasis() {
        BigIntPolynomial bigIntPolynomial;
        Resultant resultant;
        IntegerPolynomial integerPolynomial;
        IntegerPolynomial integerPolynomial2;
        IntegerPolynomial integerPolynomial3;
        Object object;
        Object object2;
        BigIntEuclidean bigIntEuclidean;
        Resultant resultant2;
        IntegerPolynomial integerPolynomial4;
        DenseTernaryPolynomial denseTernaryPolynomial;
        DenseTernaryPolynomial denseTernaryPolynomial2;
        IntegerPolynomial integerPolynomial5;
        IntegerPolynomial integerPolynomial6;
        int n2 = this.params.N;
        int n3 = this.params.q;
        int n4 = this.params.d;
        int n5 = this.params.d1;
        int n6 = this.params.d2;
        int n7 = this.params.d3;
        int n8 = this.params.basisType;
        int n9 = 2 * n2 + 1;
        boolean bl2 = this.params.primeCheck;
        do {
            denseTernaryPolynomial2 = this.params.polyType == 0 ? DenseTernaryPolynomial.generateRandom((int)n2, (int)(n4 + 1), (int)n4, (SecureRandom)CryptoServicesRegistrar.getSecureRandom()) : ProductFormPolynomial.generateRandom((int)n2, (int)n5, (int)n6, (int)(n7 + 1), (int)n7, (SecureRandom)CryptoServicesRegistrar.getSecureRandom());
            integerPolynomial6 = denseTernaryPolynomial2.toIntegerPolynomial();
        } while (bl2 && integerPolynomial6.resultant((int)n9).res.equals(BigInteger.ZERO) || (integerPolynomial5 = integerPolynomial6.invertFq(n3)) == null);
        Resultant resultant3 = integerPolynomial6.resultant();
        while (true) {
            denseTernaryPolynomial = this.params.polyType == 0 ? DenseTernaryPolynomial.generateRandom((int)n2, (int)(n4 + 1), (int)n4, (SecureRandom)CryptoServicesRegistrar.getSecureRandom()) : ProductFormPolynomial.generateRandom((int)n2, (int)n5, (int)n6, (int)(n7 + 1), (int)n7, (SecureRandom)CryptoServicesRegistrar.getSecureRandom());
            integerPolynomial4 = denseTernaryPolynomial.toIntegerPolynomial();
            if (bl2 && integerPolynomial4.resultant((int)n9).res.equals(BigInteger.ZERO) || integerPolynomial4.invertFq(n3) == null) continue;
            resultant2 = integerPolynomial4.resultant();
            bigIntEuclidean = BigIntEuclidean.calculate((BigInteger)resultant3.res, (BigInteger)resultant2.res);
            if (bigIntEuclidean.gcd.equals(BigInteger.ONE)) break;
        }
        BigIntPolynomial bigIntPolynomial2 = (BigIntPolynomial)resultant3.rho.clone();
        bigIntPolynomial2.mult(bigIntEuclidean.x.multiply(BigInteger.valueOf(n3)));
        BigIntPolynomial bigIntPolynomial3 = (BigIntPolynomial)resultant2.rho.clone();
        bigIntPolynomial3.mult(bigIntEuclidean.y.multiply(BigInteger.valueOf(-n3)));
        if (this.params.keyGenAlg == 0) {
            object2 = new int[n2];
            object = new int[n2];
            object2[0] = integerPolynomial6.coeffs[0];
            object[0] = integerPolynomial4.coeffs[0];
            for (int i2 = 1; i2 < n2; ++i2) {
                object2[i2] = integerPolynomial6.coeffs[n2 - i2];
                object[i2] = integerPolynomial4.coeffs[n2 - i2];
            }
            integerPolynomial3 = new IntegerPolynomial(object2);
            integerPolynomial2 = new IntegerPolynomial(object);
            integerPolynomial = denseTernaryPolynomial2.mult(integerPolynomial3);
            integerPolynomial.add(denseTernaryPolynomial.mult(integerPolynomial2));
            resultant = integerPolynomial.resultant();
            bigIntPolynomial = integerPolynomial3.mult(bigIntPolynomial3);
            bigIntPolynomial.add(integerPolynomial2.mult(bigIntPolynomial2));
            bigIntPolynomial = bigIntPolynomial.mult(resultant.rho);
            bigIntPolynomial.div(resultant.res);
        } else {
            int n10 = 0;
            for (int i3 = 1; i3 < n2; i3 *= 10) {
                ++n10;
            }
            object = resultant3.rho.div(new BigDecimal(resultant3.res), bigIntPolynomial3.getMaxCoeffLength() + 1 + n10);
            integerPolynomial3 = resultant2.rho.div(new BigDecimal(resultant2.res), bigIntPolynomial2.getMaxCoeffLength() + 1 + n10);
            integerPolynomial2 = object.mult(bigIntPolynomial3);
            integerPolynomial2.add(integerPolynomial3.mult(bigIntPolynomial2));
            integerPolynomial2.halve();
            bigIntPolynomial = integerPolynomial2.round();
        }
        object2 = (BigIntPolynomial)bigIntPolynomial3.clone();
        object2.sub(denseTernaryPolynomial2.mult(bigIntPolynomial));
        object = (BigIntPolynomial)bigIntPolynomial2.clone();
        object.sub(denseTernaryPolynomial.mult(bigIntPolynomial));
        integerPolynomial3 = new IntegerPolynomial((BigIntPolynomial)object2);
        integerPolynomial2 = new IntegerPolynomial((BigIntPolynomial)object);
        this.minimizeFG(integerPolynomial6, integerPolynomial4, integerPolynomial3, integerPolynomial2, n2);
        if (n8 == 0) {
            integerPolynomial = integerPolynomial3;
            resultant = denseTernaryPolynomial.mult(integerPolynomial5, n3);
        } else {
            integerPolynomial = denseTernaryPolynomial;
            resultant = integerPolynomial3.mult(integerPolynomial5, n3);
        }
        resultant.modPositive(n3);
        return new FGBasis(this, (Polynomial)denseTernaryPolynomial2, (Polynomial)integerPolynomial, (IntegerPolynomial)resultant, integerPolynomial3, integerPolynomial2, this.params);
    }

    public NTRUSigningPrivateKeyParameters.Basis generateBoundedBasis() {
        FGBasis fGBasis;
        while (!(fGBasis = this.generateBasis()).isNormOk()) {
        }
        return fGBasis;
    }
}

