/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.pqc.asn1;

import java.math.BigInteger;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Encodable;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1EncodableVector;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Integer;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Object;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Primitive;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Sequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1TaggedObject;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DEROctetString;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERSequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERTaggedObject;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Arrays;

public class XMSSMTPrivateKey
extends ASN1Object {
    private final int index;
    private final byte[] secretKeySeed;
    private final byte[] secretKeyPRF;
    private final byte[] publicSeed;
    private final byte[] root;
    private final byte[] bdsState;

    public XMSSMTPrivateKey(int n2, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5) {
        this.index = n2;
        this.secretKeySeed = Arrays.clone((byte[])byArray);
        this.secretKeyPRF = Arrays.clone((byte[])byArray2);
        this.publicSeed = Arrays.clone((byte[])byArray3);
        this.root = Arrays.clone((byte[])byArray4);
        this.bdsState = Arrays.clone((byte[])byArray5);
    }

    private XMSSMTPrivateKey(ASN1Sequence aSN1Sequence) {
        if (!ASN1Integer.getInstance((Object)aSN1Sequence.getObjectAt(0)).getValue().equals(BigInteger.valueOf(0L))) {
            throw new IllegalArgumentException("unknown version of sequence");
        }
        if (aSN1Sequence.size() != 2 && aSN1Sequence.size() != 3) {
            throw new IllegalArgumentException("key sequence wrong size");
        }
        ASN1Sequence aSN1Sequence2 = ASN1Sequence.getInstance((Object)aSN1Sequence.getObjectAt(1));
        this.index = ASN1Integer.getInstance((Object)aSN1Sequence2.getObjectAt(0)).getValue().intValue();
        this.secretKeySeed = Arrays.clone((byte[])DEROctetString.getInstance((Object)aSN1Sequence2.getObjectAt(1)).getOctets());
        this.secretKeyPRF = Arrays.clone((byte[])DEROctetString.getInstance((Object)aSN1Sequence2.getObjectAt(2)).getOctets());
        this.publicSeed = Arrays.clone((byte[])DEROctetString.getInstance((Object)aSN1Sequence2.getObjectAt(3)).getOctets());
        this.root = Arrays.clone((byte[])DEROctetString.getInstance((Object)aSN1Sequence2.getObjectAt(4)).getOctets());
        this.bdsState = (byte[])(aSN1Sequence.size() == 3 ? Arrays.clone((byte[])DEROctetString.getInstance((ASN1TaggedObject)ASN1TaggedObject.getInstance((Object)aSN1Sequence.getObjectAt(2)), (boolean)true).getOctets()) : null);
    }

    public static XMSSMTPrivateKey getInstance(Object object) {
        if (object instanceof XMSSMTPrivateKey) {
            return (XMSSMTPrivateKey)object;
        }
        if (object != null) {
            return new XMSSMTPrivateKey(ASN1Sequence.getInstance((Object)object));
        }
        return null;
    }

    public int getIndex() {
        return this.index;
    }

    public byte[] getSecretKeySeed() {
        return Arrays.clone((byte[])this.secretKeySeed);
    }

    public byte[] getSecretKeyPRF() {
        return Arrays.clone((byte[])this.secretKeyPRF);
    }

    public byte[] getPublicSeed() {
        return Arrays.clone((byte[])this.publicSeed);
    }

    public byte[] getRoot() {
        return Arrays.clone((byte[])this.root);
    }

    public byte[] getBdsState() {
        return Arrays.clone((byte[])this.bdsState);
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((ASN1Encodable)new ASN1Integer(0L));
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        aSN1EncodableVector2.add((ASN1Encodable)new ASN1Integer((long)this.index));
        aSN1EncodableVector2.add((ASN1Encodable)new DEROctetString(this.secretKeySeed));
        aSN1EncodableVector2.add((ASN1Encodable)new DEROctetString(this.secretKeyPRF));
        aSN1EncodableVector2.add((ASN1Encodable)new DEROctetString(this.publicSeed));
        aSN1EncodableVector2.add((ASN1Encodable)new DEROctetString(this.root));
        aSN1EncodableVector.add((ASN1Encodable)new DERSequence(aSN1EncodableVector2));
        aSN1EncodableVector.add((ASN1Encodable)new DERTaggedObject(true, 0, (ASN1Encodable)new DEROctetString(this.bdsState)));
        return new DERSequence(aSN1EncodableVector);
    }
}

