/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.pqc.asn1;

import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Encodable;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1EncodableVector;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Integer;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Object;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Primitive;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Sequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERSequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.AlgorithmIdentifier;

public class XMSSMTKeyParams
extends ASN1Object {
    private final ASN1Integer version;
    private final int height;
    private final int layers;
    private final AlgorithmIdentifier treeDigest;

    public XMSSMTKeyParams(int n2, int n3, AlgorithmIdentifier algorithmIdentifier) {
        this.version = new ASN1Integer(0L);
        this.height = n2;
        this.layers = n3;
        this.treeDigest = algorithmIdentifier;
    }

    private XMSSMTKeyParams(ASN1Sequence aSN1Sequence) {
        this.version = ASN1Integer.getInstance((Object)aSN1Sequence.getObjectAt(0));
        this.height = ASN1Integer.getInstance((Object)aSN1Sequence.getObjectAt(1)).getValue().intValue();
        this.layers = ASN1Integer.getInstance((Object)aSN1Sequence.getObjectAt(2)).getValue().intValue();
        this.treeDigest = AlgorithmIdentifier.getInstance((Object)aSN1Sequence.getObjectAt(3));
    }

    public static XMSSMTKeyParams getInstance(Object object) {
        if (object instanceof XMSSMTKeyParams) {
            return (XMSSMTKeyParams)object;
        }
        if (object != null) {
            return new XMSSMTKeyParams(ASN1Sequence.getInstance((Object)object));
        }
        return null;
    }

    public int getHeight() {
        return this.height;
    }

    public int getLayers() {
        return this.layers;
    }

    public AlgorithmIdentifier getTreeDigest() {
        return this.treeDigest;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((ASN1Encodable)this.version);
        aSN1EncodableVector.add((ASN1Encodable)new ASN1Integer((long)this.height));
        aSN1EncodableVector.add((ASN1Encodable)new ASN1Integer((long)this.layers));
        aSN1EncodableVector.add((ASN1Encodable)this.treeDigest);
        return new DERSequence(aSN1EncodableVector);
    }
}

