/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.rfc8032;

import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.digests.SHAKEDigest;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.rfc7748.X448Field;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.rfc8032.Ed448;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.raw.Nat;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Arrays;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Strings;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class Ed448 {
    private static final long M26L = 0x3FFFFFFL;
    private static final long M28L = 0xFFFFFFFL;
    private static final long M32L = 0xFFFFFFFFL;
    private static final int POINT_BYTES = 57;
    private static final int SCALAR_INTS = 14;
    private static final int SCALAR_BYTES = 57;
    public static final int PUBLIC_KEY_SIZE = 57;
    public static final int SECRET_KEY_SIZE = 57;
    public static final int SIGNATURE_SIZE = 114;
    private static final byte[] DOM4_PREFIX = Strings.toByteArray((String)"SigEd448");
    private static final int[] P = new int[]{-1, -1, -1, -1, -1, -1, -1, -2, -1, -1, -1, -1, -1, -1};
    private static final int[] L = new int[]{-1420278541, 595116690, -1916432555, 560775794, -1361693040, -1001465015, 2093622249, -1, -1, -1, -1, -1, -1, 0x3FFFFFFF};
    private static final int L_0 = 78101261;
    private static final int L_1 = 141809365;
    private static final int L_2 = 175155932;
    private static final int L_3 = 64542499;
    private static final int L_4 = 158326419;
    private static final int L_5 = 191173276;
    private static final int L_6 = 104575268;
    private static final int L_7 = 137584065;
    private static final int L4_0 = 43969588;
    private static final int L4_1 = 30366549;
    private static final int L4_2 = 163752818;
    private static final int L4_3 = 258169998;
    private static final int L4_4 = 96434764;
    private static final int L4_5 = 227822194;
    private static final int L4_6 = 149865618;
    private static final int L4_7 = 550336261;
    private static final int[] B_x = new int[]{118276190, 40534716, 9670182, 135141552, 85017403, 259173222, 68333082, 171784774, 174973732, 15824510, 73756743, 57518561, 94773951, 248652241, 107736333, 82941708};
    private static final int[] B_y = new int[]{36764180, 8885695, 130592152, 20104429, 163904957, 30304195, 121295871, 5901357, 125344798, 171541512, 175338348, 209069246, 3626697, 38307682, 24032956, 110359655};
    private static final int C_d = -39081;
    private static final int WNAF_WIDTH_BASE = 7;
    private static final int PRECOMP_BLOCKS = 5;
    private static final int PRECOMP_TEETH = 5;
    private static final int PRECOMP_SPACING = 18;
    private static final int PRECOMP_POINTS = 16;
    private static final int PRECOMP_MASK = 15;
    private static PointExt[] precompBaseTable = null;
    private static int[] precompBase = null;

    private static byte[] calculateS(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int[] nArray = new int[28];
        Ed448.decodeScalar((byte[])byArray, (int)0, (int[])nArray);
        int[] nArray2 = new int[14];
        Ed448.decodeScalar((byte[])byArray2, (int)0, (int[])nArray2);
        int[] nArray3 = new int[14];
        Ed448.decodeScalar((byte[])byArray3, (int)0, (int[])nArray3);
        Nat.mulAddTo((int)14, (int[])nArray2, (int[])nArray3, (int[])nArray);
        byte[] byArray4 = new byte[114];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            Ed448.encode32((int)nArray[i2], (byte[])byArray4, (int)(i2 * 4));
        }
        return Ed448.reduceScalar((byte[])byArray4);
    }

    private static boolean checkContextVar(byte[] byArray) {
        return byArray != null && byArray.length < 256;
    }

    private static boolean checkPointVar(byte[] byArray) {
        if ((byArray[56] & 0x7F) != 0) {
            return false;
        }
        int[] nArray = new int[14];
        Ed448.decode32((byte[])byArray, (int)0, (int[])nArray, (int)0, (int)14);
        return !Nat.gte((int)14, (int[])nArray, (int[])P);
    }

    private static boolean checkScalarVar(byte[] byArray) {
        if (byArray[56] != 0) {
            return false;
        }
        int[] nArray = new int[14];
        Ed448.decodeScalar((byte[])byArray, (int)0, (int[])nArray);
        return !Nat.gte((int)14, (int[])nArray, (int[])L);
    }

    private static int decode16(byte[] byArray, int n2) {
        int n3 = byArray[n2] & 0xFF;
        return n3 |= (byArray[++n2] & 0xFF) << 8;
    }

    private static int decode24(byte[] byArray, int n2) {
        int n3 = byArray[n2] & 0xFF;
        n3 |= (byArray[++n2] & 0xFF) << 8;
        return n3 |= (byArray[++n2] & 0xFF) << 16;
    }

    private static int decode32(byte[] byArray, int n2) {
        int n3 = byArray[n2] & 0xFF;
        n3 |= (byArray[++n2] & 0xFF) << 8;
        n3 |= (byArray[++n2] & 0xFF) << 16;
        return n3 |= byArray[++n2] << 24;
    }

    private static void decode32(byte[] byArray, int n2, int[] nArray, int n3, int n4) {
        for (int i2 = 0; i2 < n4; ++i2) {
            nArray[n3 + i2] = Ed448.decode32((byte[])byArray, (int)(n2 + i2 * 4));
        }
    }

    private static boolean decodePointVar(byte[] byArray, int n2, boolean bl2, PointExt pointExt) {
        byte[] byArray2 = Arrays.copyOfRange((byte[])byArray, (int)n2, (int)(n2 + 57));
        if (!Ed448.checkPointVar((byte[])byArray2)) {
            return false;
        }
        int n3 = (byArray2[56] & 0x80) >>> 7;
        byArray2[56] = (byte)(byArray2[56] & 0x7F);
        X448Field.decode((byte[])byArray2, (int)0, (int[])pointExt.y);
        int[] nArray = X448Field.create();
        int[] nArray2 = X448Field.create();
        X448Field.sqr((int[])pointExt.y, (int[])nArray);
        X448Field.mul((int[])nArray, (int)39081, (int[])nArray2);
        X448Field.negate((int[])nArray, (int[])nArray);
        X448Field.addOne((int[])nArray);
        X448Field.addOne((int[])nArray2);
        if (!X448Field.sqrtRatioVar((int[])nArray, (int[])nArray2, (int[])pointExt.x)) {
            return false;
        }
        X448Field.normalize((int[])pointExt.x);
        if (n3 == 1 && X448Field.isZeroVar((int[])pointExt.x)) {
            return false;
        }
        if (bl2 ^ n3 != (pointExt.x[0] & 1)) {
            X448Field.negate((int[])pointExt.x, (int[])pointExt.x);
        }
        Ed448.pointExtendXY((PointExt)pointExt);
        return true;
    }

    private static void decodeScalar(byte[] byArray, int n2, int[] nArray) {
        Ed448.decode32((byte[])byArray, (int)n2, (int[])nArray, (int)0, (int)14);
    }

    private static void dom4(SHAKEDigest sHAKEDigest, byte by2, byte[] byArray) {
        sHAKEDigest.update(DOM4_PREFIX, 0, DOM4_PREFIX.length);
        sHAKEDigest.update(by2);
        sHAKEDigest.update((byte)byArray.length);
        sHAKEDigest.update(byArray, 0, byArray.length);
    }

    private static void encode24(int n2, byte[] byArray, int n3) {
        byArray[n3] = (byte)n2;
        byArray[++n3] = (byte)(n2 >>> 8);
        byArray[++n3] = (byte)(n2 >>> 16);
    }

    private static void encode32(int n2, byte[] byArray, int n3) {
        byArray[n3] = (byte)n2;
        byArray[++n3] = (byte)(n2 >>> 8);
        byArray[++n3] = (byte)(n2 >>> 16);
        byArray[++n3] = (byte)(n2 >>> 24);
    }

    private static void encode56(long l2, byte[] byArray, int n2) {
        Ed448.encode32((int)((int)l2), (byte[])byArray, (int)n2);
        Ed448.encode24((int)((int)(l2 >>> 32)), (byte[])byArray, (int)(n2 + 4));
    }

    private static void encodePoint(PointExt pointExt, byte[] byArray, int n2) {
        int[] nArray = X448Field.create();
        int[] nArray2 = X448Field.create();
        X448Field.inv((int[])pointExt.z, (int[])nArray2);
        X448Field.mul((int[])pointExt.x, (int[])nArray2, (int[])nArray);
        X448Field.mul((int[])pointExt.y, (int[])nArray2, (int[])nArray2);
        X448Field.normalize((int[])nArray);
        X448Field.normalize((int[])nArray2);
        X448Field.encode((int[])nArray2, (byte[])byArray, (int)n2);
        byArray[n2 + 57 - 1] = (byte)((nArray[0] & 1) << 7);
    }

    public static void generatePublicKey(byte[] byArray, int n2, byte[] byArray2, int n3) {
        SHAKEDigest sHAKEDigest = new SHAKEDigest(256);
        byte[] byArray3 = new byte[114];
        sHAKEDigest.update(byArray, n2, 57);
        sHAKEDigest.doFinal(byArray3, 0, byArray3.length);
        byte[] byArray4 = new byte[57];
        Ed448.pruneScalar((byte[])byArray3, (int)0, (byte[])byArray4);
        Ed448.scalarMultBaseEncodedVar((byte[])byArray4, (byte[])byArray2, (int)n3);
    }

    private static byte[] getWNAF(int[] nArray, int n2) {
        int n3;
        int[] nArray2 = new int[28];
        int n4 = nArray2.length;
        int n5 = 0;
        int n6 = 14;
        while (--n6 >= 0) {
            n3 = nArray[n6];
            nArray2[--n4] = n3 >>> 16 | n5 << 16;
            nArray2[--n4] = n5 = n3;
        }
        byte[] byArray = new byte[448];
        n5 = 1 << n2;
        n6 = n5 - 1;
        n3 = n5 >>> 1;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        while (n9 < nArray2.length) {
            int n10 = nArray2[n9];
            while (n7 < 16) {
                int n11 = n10 >>> n7;
                int n12 = n11 & 1;
                if (n12 == n8) {
                    ++n7;
                    continue;
                }
                int n13 = (n11 & n6) + n8;
                n8 = n13 & n3;
                n13 -= n8 << 1;
                n8 >>>= n2 - 1;
                byArray[(n9 << 4) + n7] = (byte)n13;
                n7 += n2;
            }
            ++n9;
            n7 -= 16;
        }
        return byArray;
    }

    private static void implSignVar(SHAKEDigest sHAKEDigest, byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, byte[] byArray4, byte[] byArray5, int n3, int n4, byte[] byArray6, int n5) {
        byte by2 = 0;
        Ed448.dom4((SHAKEDigest)sHAKEDigest, (byte)by2, (byte[])byArray4);
        sHAKEDigest.update(byArray, 57, 57);
        sHAKEDigest.update(byArray5, n3, n4);
        sHAKEDigest.doFinal(byArray, 0, byArray.length);
        byte[] byArray7 = Ed448.reduceScalar((byte[])byArray);
        byte[] byArray8 = new byte[57];
        Ed448.scalarMultBaseEncodedVar((byte[])byArray7, (byte[])byArray8, (int)0);
        Ed448.dom4((SHAKEDigest)sHAKEDigest, (byte)by2, (byte[])byArray4);
        sHAKEDigest.update(byArray8, 0, 57);
        sHAKEDigest.update(byArray3, n2, 57);
        sHAKEDigest.update(byArray5, n3, n4);
        sHAKEDigest.doFinal(byArray, 0, byArray.length);
        byte[] byArray9 = Ed448.reduceScalar((byte[])byArray);
        byte[] byArray10 = Ed448.calculateS((byte[])byArray7, (byte[])byArray9, (byte[])byArray2);
        System.arraycopy(byArray8, 0, byArray6, n5, 57);
        System.arraycopy(byArray10, 0, byArray6, n5 + 57, 57);
    }

    private static void pointAddVar(boolean bl2, PointExt pointExt, PointExt pointExt2) {
        int[] nArray;
        int[] nArray2;
        int[] nArray3;
        int[] nArray4;
        int[] nArray5 = X448Field.create();
        int[] nArray6 = X448Field.create();
        int[] nArray7 = X448Field.create();
        int[] nArray8 = X448Field.create();
        int[] nArray9 = X448Field.create();
        int[] nArray10 = X448Field.create();
        int[] nArray11 = X448Field.create();
        int[] nArray12 = X448Field.create();
        if (bl2) {
            nArray4 = nArray9;
            nArray3 = nArray6;
            nArray2 = nArray11;
            nArray = nArray10;
            X448Field.sub((int[])pointExt.y, (int[])pointExt.x, (int[])nArray12);
        } else {
            nArray4 = nArray6;
            nArray3 = nArray9;
            nArray2 = nArray10;
            nArray = nArray11;
            X448Field.add((int[])pointExt.y, (int[])pointExt.x, (int[])nArray12);
        }
        X448Field.mul((int[])pointExt.z, (int[])pointExt2.z, (int[])nArray5);
        X448Field.sqr((int[])nArray5, (int[])nArray6);
        X448Field.mul((int[])pointExt.x, (int[])pointExt2.x, (int[])nArray7);
        X448Field.mul((int[])pointExt.y, (int[])pointExt2.y, (int[])nArray8);
        X448Field.mul((int[])nArray7, (int[])nArray8, (int[])nArray9);
        X448Field.mul((int[])nArray9, (int)39081, (int[])nArray9);
        X448Field.add((int[])nArray6, (int[])nArray9, (int[])nArray2);
        X448Field.sub((int[])nArray6, (int[])nArray9, (int[])nArray);
        X448Field.add((int[])pointExt2.x, (int[])pointExt2.y, (int[])nArray9);
        X448Field.mul((int[])nArray12, (int[])nArray9, (int[])nArray12);
        X448Field.add((int[])nArray8, (int[])nArray7, (int[])nArray4);
        X448Field.sub((int[])nArray8, (int[])nArray7, (int[])nArray3);
        X448Field.carry((int[])nArray4);
        X448Field.sub((int[])nArray12, (int[])nArray6, (int[])nArray12);
        X448Field.mul((int[])nArray12, (int[])nArray5, (int[])nArray12);
        X448Field.mul((int[])nArray9, (int[])nArray5, (int[])nArray9);
        X448Field.mul((int[])nArray10, (int[])nArray12, (int[])pointExt2.x);
        X448Field.mul((int[])nArray9, (int[])nArray11, (int[])pointExt2.y);
        X448Field.mul((int[])nArray10, (int[])nArray11, (int[])pointExt2.z);
    }

    private static void pointAddPrecomp(PointPrecomp pointPrecomp, PointExt pointExt) {
        int[] nArray = X448Field.create();
        int[] nArray2 = X448Field.create();
        int[] nArray3 = X448Field.create();
        int[] nArray4 = X448Field.create();
        int[] nArray5 = X448Field.create();
        int[] nArray6 = X448Field.create();
        int[] nArray7 = X448Field.create();
        X448Field.sqr((int[])pointExt.z, (int[])nArray);
        X448Field.mul((int[])pointPrecomp.x, (int[])pointExt.x, (int[])nArray2);
        X448Field.mul((int[])pointPrecomp.y, (int[])pointExt.y, (int[])nArray3);
        X448Field.mul((int[])nArray2, (int[])nArray3, (int[])nArray4);
        X448Field.mul((int[])nArray4, (int)39081, (int[])nArray4);
        X448Field.add((int[])nArray, (int[])nArray4, (int[])nArray5);
        X448Field.sub((int[])nArray, (int[])nArray4, (int[])nArray6);
        X448Field.add((int[])pointPrecomp.x, (int[])pointPrecomp.y, (int[])nArray);
        X448Field.add((int[])pointExt.x, (int[])pointExt.y, (int[])nArray4);
        X448Field.mul((int[])nArray, (int[])nArray4, (int[])nArray7);
        X448Field.add((int[])nArray3, (int[])nArray2, (int[])nArray);
        X448Field.sub((int[])nArray3, (int[])nArray2, (int[])nArray4);
        X448Field.carry((int[])nArray);
        X448Field.sub((int[])nArray7, (int[])nArray, (int[])nArray7);
        X448Field.mul((int[])nArray7, (int[])pointExt.z, (int[])nArray7);
        X448Field.mul((int[])nArray4, (int[])pointExt.z, (int[])nArray4);
        X448Field.mul((int[])nArray5, (int[])nArray7, (int[])pointExt.x);
        X448Field.mul((int[])nArray4, (int[])nArray6, (int[])pointExt.y);
        X448Field.mul((int[])nArray5, (int[])nArray6, (int[])pointExt.z);
    }

    private static PointExt pointCopy(PointExt pointExt) {
        PointExt pointExt2 = new PointExt(null);
        X448Field.copy((int[])pointExt.x, (int)0, (int[])pointExt2.x, (int)0);
        X448Field.copy((int[])pointExt.y, (int)0, (int[])pointExt2.y, (int)0);
        X448Field.copy((int[])pointExt.z, (int)0, (int[])pointExt2.z, (int)0);
        return pointExt2;
    }

    private static void pointDouble(PointExt pointExt) {
        int[] nArray = X448Field.create();
        int[] nArray2 = X448Field.create();
        int[] nArray3 = X448Field.create();
        int[] nArray4 = X448Field.create();
        int[] nArray5 = X448Field.create();
        int[] nArray6 = X448Field.create();
        X448Field.add((int[])pointExt.x, (int[])pointExt.y, (int[])nArray);
        X448Field.sqr((int[])nArray, (int[])nArray);
        X448Field.sqr((int[])pointExt.x, (int[])nArray2);
        X448Field.sqr((int[])pointExt.y, (int[])nArray3);
        X448Field.add((int[])nArray2, (int[])nArray3, (int[])nArray4);
        X448Field.carry((int[])nArray4);
        X448Field.sqr((int[])pointExt.z, (int[])nArray5);
        X448Field.add((int[])nArray5, (int[])nArray5, (int[])nArray5);
        X448Field.carry((int[])nArray5);
        X448Field.sub((int[])nArray4, (int[])nArray5, (int[])nArray6);
        X448Field.sub((int[])nArray, (int[])nArray4, (int[])nArray);
        X448Field.sub((int[])nArray2, (int[])nArray3, (int[])nArray2);
        X448Field.mul((int[])nArray, (int[])nArray6, (int[])pointExt.x);
        X448Field.mul((int[])nArray4, (int[])nArray2, (int[])pointExt.y);
        X448Field.mul((int[])nArray4, (int[])nArray6, (int[])pointExt.z);
    }

    private static void pointExtendXY(PointExt pointExt) {
        X448Field.one((int[])pointExt.z);
    }

    private static void pointLookup(int n2, int n3, PointPrecomp pointPrecomp) {
        int n4 = n2 * 16 * 2 * 16;
        for (int i2 = 0; i2 < 16; ++i2) {
            int n5 = (i2 ^ n3) - 1 >> 31;
            Nat.cmov((int)16, (int)n5, (int[])precompBase, (int)n4, (int[])pointPrecomp.x, (int)0);
            Nat.cmov((int)16, (int)n5, (int[])precompBase, (int)(n4 += 16), (int[])pointPrecomp.y, (int)0);
            n4 += 16;
        }
    }

    private static PointExt[] pointPrecompVar(PointExt pointExt, int n2) {
        PointExt pointExt2 = Ed448.pointCopy((PointExt)pointExt);
        Ed448.pointDouble((PointExt)pointExt2);
        PointExt[] pointExtArray = new PointExt[n2];
        pointExtArray[0] = Ed448.pointCopy((PointExt)pointExt);
        for (int i2 = 1; i2 < n2; ++i2) {
            pointExtArray[i2] = Ed448.pointCopy((PointExt)pointExtArray[i2 - 1]);
            Ed448.pointAddVar((boolean)false, (PointExt)pointExt2, (PointExt)pointExtArray[i2]);
        }
        return pointExtArray;
    }

    private static void pointSetNeutral(PointExt pointExt) {
        X448Field.zero((int[])pointExt.x);
        X448Field.one((int[])pointExt.y);
        X448Field.one((int[])pointExt.z);
    }

    public static synchronized void precompute() {
        if (precompBase != null) {
            return;
        }
        PointExt pointExt = new PointExt(null);
        X448Field.copy((int[])B_x, (int)0, (int[])pointExt.x, (int)0);
        X448Field.copy((int[])B_y, (int)0, (int[])pointExt.y, (int)0);
        Ed448.pointExtendXY((PointExt)pointExt);
        precompBaseTable = Ed448.pointPrecompVar((PointExt)pointExt, (int)32);
        precompBase = new int[2560];
        int n2 = 0;
        for (int i2 = 0; i2 < 5; ++i2) {
            int n3;
            int n4;
            PointExt[] pointExtArray = new PointExt[5];
            PointExt pointExt2 = new PointExt(null);
            Ed448.pointSetNeutral((PointExt)pointExt2);
            for (int i3 = 0; i3 < 5; ++i3) {
                Ed448.pointAddVar((boolean)true, (PointExt)pointExt, (PointExt)pointExt2);
                Ed448.pointDouble((PointExt)pointExt);
                pointExtArray[i3] = Ed448.pointCopy((PointExt)pointExt);
                for (n4 = 1; n4 < 18; ++n4) {
                    Ed448.pointDouble((PointExt)pointExt);
                }
            }
            PointExt[] pointExtArray2 = new PointExt[16];
            n4 = 0;
            pointExtArray2[n4++] = pointExt2;
            for (n3 = 0; n3 < 4; ++n3) {
                int n5 = 1 << n3;
                for (int i4 = 0; i4 < n5; ++i4) {
                    pointExtArray2[n4] = Ed448.pointCopy((PointExt)pointExtArray2[n4 - n5]);
                    Ed448.pointAddVar((boolean)false, (PointExt)pointExtArray[n3], (PointExt)pointExtArray2[n4++]);
                }
            }
            for (n3 = 0; n3 < 16; ++n3) {
                PointExt pointExt3 = pointExtArray2[n3];
                X448Field.inv((int[])pointExt3.z, (int[])pointExt3.z);
                X448Field.mul((int[])pointExt3.x, (int[])pointExt3.z, (int[])pointExt3.x);
                X448Field.mul((int[])pointExt3.y, (int[])pointExt3.z, (int[])pointExt3.y);
                X448Field.copy((int[])pointExt3.x, (int)0, (int[])precompBase, (int)n2);
                X448Field.copy((int[])pointExt3.y, (int)0, (int[])precompBase, (int)(n2 += 16));
                n2 += 16;
            }
        }
    }

    private static void pruneScalar(byte[] byArray, int n2, byte[] byArray2) {
        System.arraycopy(byArray, n2, byArray2, 0, 57);
        byArray2[0] = (byte)(byArray2[0] & 0xFC);
        byArray2[55] = (byte)(byArray2[55] | 0x80);
        byArray2[56] = (byte)(byArray2[56] & 0);
    }

    private static byte[] reduceScalar(byte[] byArray) {
        long l2 = (long)Ed448.decode32((byte[])byArray, (int)0) & 0xFFFFFFFFL;
        long l3 = (long)(Ed448.decode24((byte[])byArray, (int)4) << 4) & 0xFFFFFFFFL;
        long l4 = (long)Ed448.decode32((byte[])byArray, (int)7) & 0xFFFFFFFFL;
        long l5 = (long)(Ed448.decode24((byte[])byArray, (int)11) << 4) & 0xFFFFFFFFL;
        long l6 = (long)Ed448.decode32((byte[])byArray, (int)14) & 0xFFFFFFFFL;
        long l7 = (long)(Ed448.decode24((byte[])byArray, (int)18) << 4) & 0xFFFFFFFFL;
        long l8 = (long)Ed448.decode32((byte[])byArray, (int)21) & 0xFFFFFFFFL;
        long l9 = (long)(Ed448.decode24((byte[])byArray, (int)25) << 4) & 0xFFFFFFFFL;
        long l10 = (long)Ed448.decode32((byte[])byArray, (int)28) & 0xFFFFFFFFL;
        long l11 = (long)(Ed448.decode24((byte[])byArray, (int)32) << 4) & 0xFFFFFFFFL;
        long l12 = (long)Ed448.decode32((byte[])byArray, (int)35) & 0xFFFFFFFFL;
        long l13 = (long)(Ed448.decode24((byte[])byArray, (int)39) << 4) & 0xFFFFFFFFL;
        long l14 = (long)Ed448.decode32((byte[])byArray, (int)42) & 0xFFFFFFFFL;
        long l15 = (long)(Ed448.decode24((byte[])byArray, (int)46) << 4) & 0xFFFFFFFFL;
        long l16 = (long)Ed448.decode32((byte[])byArray, (int)49) & 0xFFFFFFFFL;
        long l17 = (long)(Ed448.decode24((byte[])byArray, (int)53) << 4) & 0xFFFFFFFFL;
        long l18 = (long)Ed448.decode32((byte[])byArray, (int)56) & 0xFFFFFFFFL;
        long l19 = (long)(Ed448.decode24((byte[])byArray, (int)60) << 4) & 0xFFFFFFFFL;
        long l20 = (long)Ed448.decode32((byte[])byArray, (int)63) & 0xFFFFFFFFL;
        long l21 = (long)(Ed448.decode24((byte[])byArray, (int)67) << 4) & 0xFFFFFFFFL;
        long l22 = (long)Ed448.decode32((byte[])byArray, (int)70) & 0xFFFFFFFFL;
        long l23 = (long)(Ed448.decode24((byte[])byArray, (int)74) << 4) & 0xFFFFFFFFL;
        long l24 = (long)Ed448.decode32((byte[])byArray, (int)77) & 0xFFFFFFFFL;
        long l25 = (long)(Ed448.decode24((byte[])byArray, (int)81) << 4) & 0xFFFFFFFFL;
        long l26 = (long)Ed448.decode32((byte[])byArray, (int)84) & 0xFFFFFFFFL;
        long l27 = (long)(Ed448.decode24((byte[])byArray, (int)88) << 4) & 0xFFFFFFFFL;
        long l28 = (long)Ed448.decode32((byte[])byArray, (int)91) & 0xFFFFFFFFL;
        long l29 = (long)(Ed448.decode24((byte[])byArray, (int)95) << 4) & 0xFFFFFFFFL;
        long l30 = (long)Ed448.decode32((byte[])byArray, (int)98) & 0xFFFFFFFFL;
        long l31 = (long)(Ed448.decode24((byte[])byArray, (int)102) << 4) & 0xFFFFFFFFL;
        long l32 = (long)Ed448.decode32((byte[])byArray, (int)105) & 0xFFFFFFFFL;
        long l33 = (long)(Ed448.decode24((byte[])byArray, (int)109) << 4) & 0xFFFFFFFFL;
        long l34 = (long)Ed448.decode16((byte[])byArray, (int)112) & 0xFFFFFFFFL;
        l18 += l34 * 43969588L;
        l19 += l34 * 30366549L;
        l20 += l34 * 163752818L;
        l21 += l34 * 258169998L;
        l22 += l34 * 96434764L;
        l23 += l34 * 227822194L;
        l24 += l34 * 149865618L;
        l25 += l34 * 550336261L;
        l33 += l32 >>> 28;
        l32 &= 0xFFFFFFFL;
        l17 += l33 * 43969588L;
        l18 += l33 * 30366549L;
        l19 += l33 * 163752818L;
        l20 += l33 * 258169998L;
        l21 += l33 * 96434764L;
        l22 += l33 * 227822194L;
        l23 += l33 * 149865618L;
        l24 += l33 * 550336261L;
        l16 += l32 * 43969588L;
        l17 += l32 * 30366549L;
        l18 += l32 * 163752818L;
        l19 += l32 * 258169998L;
        l20 += l32 * 96434764L;
        l21 += l32 * 227822194L;
        l22 += l32 * 149865618L;
        l23 += l32 * 550336261L;
        l31 += l30 >>> 28;
        l30 &= 0xFFFFFFFL;
        l15 += l31 * 43969588L;
        l16 += l31 * 30366549L;
        l17 += l31 * 163752818L;
        l18 += l31 * 258169998L;
        l19 += l31 * 96434764L;
        l20 += l31 * 227822194L;
        l21 += l31 * 149865618L;
        l22 += l31 * 550336261L;
        l14 += l30 * 43969588L;
        l15 += l30 * 30366549L;
        l16 += l30 * 163752818L;
        l17 += l30 * 258169998L;
        l18 += l30 * 96434764L;
        l19 += l30 * 227822194L;
        l20 += l30 * 149865618L;
        l21 += l30 * 550336261L;
        l29 += l28 >>> 28;
        l28 &= 0xFFFFFFFL;
        l13 += l29 * 43969588L;
        l14 += l29 * 30366549L;
        l15 += l29 * 163752818L;
        l16 += l29 * 258169998L;
        l17 += l29 * 96434764L;
        l18 += l29 * 227822194L;
        l19 += l29 * 149865618L;
        l20 += l29 * 550336261L;
        l12 += l28 * 43969588L;
        l13 += l28 * 30366549L;
        l14 += l28 * 163752818L;
        l15 += l28 * 258169998L;
        l16 += l28 * 96434764L;
        l17 += l28 * 227822194L;
        l18 += l28 * 149865618L;
        l19 += l28 * 550336261L;
        l27 += l26 >>> 28;
        l26 &= 0xFFFFFFFL;
        l11 += l27 * 43969588L;
        l12 += l27 * 30366549L;
        l13 += l27 * 163752818L;
        l14 += l27 * 258169998L;
        l15 += l27 * 96434764L;
        l16 += l27 * 227822194L;
        l17 += l27 * 149865618L;
        l18 += l27 * 550336261L;
        l23 += l22 >>> 28;
        l22 &= 0xFFFFFFFL;
        l24 += l23 >>> 28;
        l23 &= 0xFFFFFFFL;
        l25 += l24 >>> 28;
        l24 &= 0xFFFFFFFL;
        l26 += l25 >>> 28;
        l25 &= 0xFFFFFFFL;
        l10 += l26 * 43969588L;
        l11 += l26 * 30366549L;
        l12 += l26 * 163752818L;
        l13 += l26 * 258169998L;
        l14 += l26 * 96434764L;
        l15 += l26 * 227822194L;
        l16 += l26 * 149865618L;
        l17 += l26 * 550336261L;
        l9 += l25 * 43969588L;
        l10 += l25 * 30366549L;
        l11 += l25 * 163752818L;
        l12 += l25 * 258169998L;
        l13 += l25 * 96434764L;
        l14 += l25 * 227822194L;
        l15 += l25 * 149865618L;
        l16 += l25 * 550336261L;
        l8 += l24 * 43969588L;
        l9 += l24 * 30366549L;
        l10 += l24 * 163752818L;
        l11 += l24 * 258169998L;
        l12 += l24 * 96434764L;
        l13 += l24 * 227822194L;
        l14 += l24 * 149865618L;
        l15 += l24 * 550336261L;
        l20 += l19 >>> 28;
        l19 &= 0xFFFFFFFL;
        l21 += l20 >>> 28;
        l20 &= 0xFFFFFFFL;
        l22 += l21 >>> 28;
        l21 &= 0xFFFFFFFL;
        l23 += l22 >>> 28;
        l22 &= 0xFFFFFFFL;
        l7 += l23 * 43969588L;
        l8 += l23 * 30366549L;
        l9 += l23 * 163752818L;
        l10 += l23 * 258169998L;
        l11 += l23 * 96434764L;
        l12 += l23 * 227822194L;
        l13 += l23 * 149865618L;
        l14 += l23 * 550336261L;
        l6 += l22 * 43969588L;
        l7 += l22 * 30366549L;
        l8 += l22 * 163752818L;
        l9 += l22 * 258169998L;
        l10 += l22 * 96434764L;
        l11 += l22 * 227822194L;
        l12 += l22 * 149865618L;
        l13 += l22 * 550336261L;
        l5 += l21 * 43969588L;
        l6 += l21 * 30366549L;
        l7 += l21 * 163752818L;
        l8 += l21 * 258169998L;
        l9 += l21 * 96434764L;
        l10 += l21 * 227822194L;
        l11 += l21 * 149865618L;
        l12 += l21 * 550336261L;
        l17 += l16 >>> 28;
        l16 &= 0xFFFFFFFL;
        l18 += l17 >>> 28;
        l17 &= 0xFFFFFFFL;
        l19 += l18 >>> 28;
        l18 &= 0xFFFFFFFL;
        l20 += l19 >>> 28;
        l19 &= 0xFFFFFFFL;
        l4 += l20 * 43969588L;
        l5 += l20 * 30366549L;
        l6 += l20 * 163752818L;
        l7 += l20 * 258169998L;
        l8 += l20 * 96434764L;
        l9 += l20 * 227822194L;
        l10 += l20 * 149865618L;
        l11 += l20 * 550336261L;
        l3 += l19 * 43969588L;
        l4 += l19 * 30366549L;
        l5 += l19 * 163752818L;
        l6 += l19 * 258169998L;
        l7 += l19 * 96434764L;
        l8 += l19 * 227822194L;
        l9 += l19 * 149865618L;
        l10 += l19 * 550336261L;
        l18 *= 4L;
        l18 += l17 >>> 26;
        l17 &= 0x3FFFFFFL;
        l2 += ++l18 * 78101261L;
        l3 += l18 * 141809365L;
        l4 += l18 * 175155932L;
        l5 += l18 * 64542499L;
        l6 += l18 * 158326419L;
        l7 += l18 * 191173276L;
        l8 += l18 * 104575268L;
        l9 += l18 * 137584065L;
        l3 += l2 >>> 28;
        l2 &= 0xFFFFFFFL;
        l4 += l3 >>> 28;
        l3 &= 0xFFFFFFFL;
        l5 += l4 >>> 28;
        l4 &= 0xFFFFFFFL;
        l6 += l5 >>> 28;
        l5 &= 0xFFFFFFFL;
        l7 += l6 >>> 28;
        l6 &= 0xFFFFFFFL;
        l8 += l7 >>> 28;
        l7 &= 0xFFFFFFFL;
        l9 += l8 >>> 28;
        l8 &= 0xFFFFFFFL;
        l10 += l9 >>> 28;
        l9 &= 0xFFFFFFFL;
        l11 += l10 >>> 28;
        l10 &= 0xFFFFFFFL;
        l12 += l11 >>> 28;
        l11 &= 0xFFFFFFFL;
        l13 += l12 >>> 28;
        l12 &= 0xFFFFFFFL;
        l14 += l13 >>> 28;
        l13 &= 0xFFFFFFFL;
        l15 += l14 >>> 28;
        l14 &= 0xFFFFFFFL;
        l16 += l15 >>> 28;
        l15 &= 0xFFFFFFFL;
        l17 += l16 >>> 28;
        l16 &= 0xFFFFFFFL;
        l18 = l17 >>> 26;
        l17 &= 0x3FFFFFFL;
        l2 -= --l18 & 0x4A7BB0DL;
        l3 -= l18 & 0x873D6D5L;
        l4 -= l18 & 0xA70AADCL;
        l5 -= l18 & 0x3D8D723L;
        l6 -= l18 & 0x96FDE93L;
        l7 -= l18 & 0xB65129CL;
        l8 -= l18 & 0x63BB124L;
        l9 -= l18 & 0x8335DC1L;
        l3 += l2 >> 28;
        l2 &= 0xFFFFFFFL;
        l4 += l3 >> 28;
        l3 &= 0xFFFFFFFL;
        l5 += l4 >> 28;
        l4 &= 0xFFFFFFFL;
        l6 += l5 >> 28;
        l5 &= 0xFFFFFFFL;
        l7 += l6 >> 28;
        l6 &= 0xFFFFFFFL;
        l8 += l7 >> 28;
        l7 &= 0xFFFFFFFL;
        l9 += l8 >> 28;
        l8 &= 0xFFFFFFFL;
        l10 += l9 >> 28;
        l9 &= 0xFFFFFFFL;
        l11 += l10 >> 28;
        l10 &= 0xFFFFFFFL;
        l12 += l11 >> 28;
        l11 &= 0xFFFFFFFL;
        l13 += l12 >> 28;
        l12 &= 0xFFFFFFFL;
        l14 += l13 >> 28;
        l13 &= 0xFFFFFFFL;
        l15 += l14 >> 28;
        l14 &= 0xFFFFFFFL;
        l16 += l15 >> 28;
        l15 &= 0xFFFFFFFL;
        l17 += l16 >> 28;
        l16 &= 0xFFFFFFFL;
        byte[] byArray2 = new byte[57];
        Ed448.encode56((long)(l2 | l3 << 28), (byte[])byArray2, (int)0);
        Ed448.encode56((long)(l4 | l5 << 28), (byte[])byArray2, (int)7);
        Ed448.encode56((long)(l6 | l7 << 28), (byte[])byArray2, (int)14);
        Ed448.encode56((long)(l8 | l9 << 28), (byte[])byArray2, (int)21);
        Ed448.encode56((long)(l10 | l11 << 28), (byte[])byArray2, (int)28);
        Ed448.encode56((long)(l12 | l13 << 28), (byte[])byArray2, (int)35);
        Ed448.encode56((long)(l14 | l15 << 28), (byte[])byArray2, (int)42);
        Ed448.encode56((long)(l16 | l17 << 28), (byte[])byArray2, (int)49);
        return byArray2;
    }

    private static void scalarMultBase(byte[] byArray, PointExt pointExt) {
        Ed448.precompute();
        Ed448.pointSetNeutral((PointExt)pointExt);
        int[] nArray = new int[15];
        Ed448.decodeScalar((byte[])byArray, (int)0, (int[])nArray);
        nArray[14] = 4 + Nat.cadd((int)14, (int)(~nArray[0] & 1), (int[])nArray, (int[])L, (int[])nArray);
        Nat.shiftDownBit((int)nArray.length, (int[])nArray, (int)0);
        PointPrecomp pointPrecomp = new PointPrecomp(null);
        int n2 = 17;
        while (true) {
            int n3 = n2;
            for (int i2 = 0; i2 < 5; ++i2) {
                int n4;
                int n5;
                int n6 = 0;
                for (n5 = 0; n5 < 5; ++n5) {
                    n4 = nArray[n3 >>> 5] >>> (n3 & 0x1F) & 1;
                    n6 |= n4 << n5;
                    n3 += 18;
                }
                n5 = n6 >>> 4 & 1;
                n4 = (n6 ^ -n5) & 0xF;
                Ed448.pointLookup((int)i2, (int)n4, (PointPrecomp)pointPrecomp);
                X448Field.cnegate((int)n5, (int[])pointPrecomp.x);
                Ed448.pointAddPrecomp((PointPrecomp)pointPrecomp, (PointExt)pointExt);
            }
            if (--n2 < 0) break;
            Ed448.pointDouble((PointExt)pointExt);
        }
    }

    private static void scalarMultBaseEncodedVar(byte[] byArray, byte[] byArray2, int n2) {
        PointExt pointExt = new PointExt(null);
        Ed448.scalarMultBase((byte[])byArray, (PointExt)pointExt);
        Ed448.encodePoint((PointExt)pointExt, (byte[])byArray2, (int)n2);
    }

    private static void scalarMultStraussVar(int[] nArray, int[] nArray2, PointExt pointExt, PointExt pointExt2) {
        int n2;
        Ed448.precompute();
        int n3 = 5;
        byte[] byArray = Ed448.getWNAF((int[])nArray, (int)7);
        byte[] byArray2 = Ed448.getWNAF((int[])nArray2, (int)5);
        PointExt[] pointExtArray = Ed448.pointPrecompVar((PointExt)pointExt, (int)8);
        Ed448.pointSetNeutral((PointExt)pointExt2);
        for (n2 = 447; n2 > 0 && (byArray[n2] | byArray2[n2]) == 0; --n2) {
        }
        while (true) {
            int n4;
            int n5;
            byte by2;
            if ((by2 = byArray[n2]) != 0) {
                n5 = by2 >> 31;
                n4 = (by2 ^ n5) >>> 1;
                Ed448.pointAddVar((n5 != 0 ? 1 : 0) != 0, (PointExt)precompBaseTable[n4], (PointExt)pointExt2);
            }
            if ((n5 = byArray2[n2]) != 0) {
                n4 = n5 >> 31;
                int n6 = (n5 ^ n4) >>> 1;
                Ed448.pointAddVar((n4 != 0 ? 1 : 0) != 0, (PointExt)pointExtArray[n6], (PointExt)pointExt2);
            }
            if (--n2 < 0) break;
            Ed448.pointDouble((PointExt)pointExt2);
        }
    }

    public static void sign(byte[] byArray, int n2, byte[] byArray2, byte[] byArray3, int n3, int n4, byte[] byArray4, int n5) {
        if (!Ed448.checkContextVar((byte[])byArray2)) {
            throw new IllegalArgumentException("ctx");
        }
        SHAKEDigest sHAKEDigest = new SHAKEDigest(256);
        byte[] byArray5 = new byte[114];
        sHAKEDigest.update(byArray, n2, 57);
        sHAKEDigest.doFinal(byArray5, 0, byArray5.length);
        byte[] byArray6 = new byte[57];
        Ed448.pruneScalar((byte[])byArray5, (int)0, (byte[])byArray6);
        byte[] byArray7 = new byte[57];
        Ed448.scalarMultBaseEncodedVar((byte[])byArray6, (byte[])byArray7, (int)0);
        Ed448.implSignVar((SHAKEDigest)sHAKEDigest, (byte[])byArray5, (byte[])byArray6, (byte[])byArray7, (int)0, (byte[])byArray2, (byte[])byArray3, (int)n3, (int)n4, (byte[])byArray4, (int)n5);
    }

    public static void sign(byte[] byArray, int n2, byte[] byArray2, int n3, byte[] byArray3, byte[] byArray4, int n4, int n5, byte[] byArray5, int n6) {
        if (!Ed448.checkContextVar((byte[])byArray3)) {
            throw new IllegalArgumentException("ctx");
        }
        SHAKEDigest sHAKEDigest = new SHAKEDigest(256);
        byte[] byArray6 = new byte[114];
        sHAKEDigest.update(byArray, n2, 57);
        sHAKEDigest.doFinal(byArray6, 0, byArray6.length);
        byte[] byArray7 = new byte[57];
        Ed448.pruneScalar((byte[])byArray6, (int)0, (byte[])byArray7);
        Ed448.implSignVar((SHAKEDigest)sHAKEDigest, (byte[])byArray6, (byte[])byArray7, (byte[])byArray2, (int)n3, (byte[])byArray3, (byte[])byArray4, (int)n4, (int)n5, (byte[])byArray5, (int)n6);
    }

    public static boolean verify(byte[] byArray, int n2, byte[] byArray2, int n3, byte[] byArray3, byte[] byArray4, int n4, int n5) {
        if (!Ed448.checkContextVar((byte[])byArray3)) {
            throw new IllegalArgumentException("ctx");
        }
        byte[] byArray5 = Arrays.copyOfRange((byte[])byArray, (int)n2, (int)(n2 + 57));
        byte[] byArray6 = Arrays.copyOfRange((byte[])byArray, (int)(n2 + 57), (int)(n2 + 114));
        if (!Ed448.checkPointVar((byte[])byArray5)) {
            return false;
        }
        if (!Ed448.checkScalarVar((byte[])byArray6)) {
            return false;
        }
        PointExt pointExt = new PointExt(null);
        if (!Ed448.decodePointVar((byte[])byArray2, (int)n3, (boolean)true, (PointExt)pointExt)) {
            return false;
        }
        byte by2 = 0;
        SHAKEDigest sHAKEDigest = new SHAKEDigest(256);
        byte[] byArray7 = new byte[114];
        Ed448.dom4((SHAKEDigest)sHAKEDigest, (byte)by2, (byte[])byArray3);
        sHAKEDigest.update(byArray5, 0, 57);
        sHAKEDigest.update(byArray2, n3, 57);
        sHAKEDigest.update(byArray4, n4, n5);
        sHAKEDigest.doFinal(byArray7, 0, byArray7.length);
        byte[] byArray8 = Ed448.reduceScalar((byte[])byArray7);
        int[] nArray = new int[14];
        Ed448.decodeScalar((byte[])byArray6, (int)0, (int[])nArray);
        int[] nArray2 = new int[14];
        Ed448.decodeScalar((byte[])byArray8, (int)0, (int[])nArray2);
        PointExt pointExt2 = new PointExt(null);
        Ed448.scalarMultStraussVar((int[])nArray, (int[])nArray2, (PointExt)pointExt, (PointExt)pointExt2);
        byte[] byArray9 = new byte[57];
        Ed448.encodePoint((PointExt)pointExt2, (byte[])byArray9, (int)0);
        return Arrays.areEqual((byte[])byArray9, (byte[])byArray5);
    }
}

