/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.custom.sec;

import java.math.BigInteger;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECCurve;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECFieldElement;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECLookupTable;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECPoint;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.custom.sec.SecT571FieldElement;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.custom.sec.SecT571R1Point;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.raw.Nat576;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.encoders.Hex;

public class SecT571R1Curve
extends ECCurve.AbstractF2m {
    private static final int SecT571R1_DEFAULT_COORDS = 6;
    protected SecT571R1Point infinity = new SecT571R1Point((ECCurve)this, null, null);
    static final SecT571FieldElement SecT571R1_B = new SecT571FieldElement(new BigInteger(1, Hex.decode((String)"02F40E7E2221F295DE297117B7F3D62F5C6A97FFCB8CEFF1CD6BA8CE4A9A18AD84FFABBD8EFA59332BE7AD6756A66E294AFD185A78FF12AA520E4DE739BACA0C7FFEFF7F2955727A")));
    static final SecT571FieldElement SecT571R1_B_SQRT = (SecT571FieldElement)SecT571R1_B.sqrt();

    public SecT571R1Curve() {
        super(571, 2, 5, 10);
        this.a = this.fromBigInteger(BigInteger.valueOf(1L));
        this.b = SecT571R1_B;
        this.order = new BigInteger(1, Hex.decode((String)"03FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE661CE18FF55987308059B186823851EC7DD9CA1161DE93D5174D66E8382E9BB2FE84E47"));
        this.cofactor = BigInteger.valueOf(2L);
        this.coord = 6;
    }

    protected ECCurve cloneCurve() {
        return new SecT571R1Curve();
    }

    public boolean supportsCoordinateSystem(int n2) {
        switch (n2) {
            case 6: {
                return true;
            }
        }
        return false;
    }

    public int getFieldSize() {
        return 571;
    }

    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SecT571FieldElement(bigInteger);
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, boolean bl2) {
        return new SecT571R1Point((ECCurve)this, eCFieldElement, eCFieldElement2, bl2);
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray, boolean bl2) {
        return new SecT571R1Point((ECCurve)this, eCFieldElement, eCFieldElement2, eCFieldElementArray, bl2);
    }

    public ECPoint getInfinity() {
        return this.infinity;
    }

    public boolean isKoblitz() {
        return false;
    }

    public int getM() {
        return 571;
    }

    public boolean isTrinomial() {
        return false;
    }

    public int getK1() {
        return 2;
    }

    public int getK2() {
        return 5;
    }

    public int getK3() {
        return 10;
    }

    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n2, int n3) {
        int n4 = 9;
        long[] lArray = new long[n3 * 9 * 2];
        int n5 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            ECPoint eCPoint = eCPointArray[n2 + i2];
            Nat576.copy64((long[])((SecT571FieldElement)eCPoint.getRawXCoord()).x, (int)0, (long[])lArray, (int)n5);
            Nat576.copy64((long[])((SecT571FieldElement)eCPoint.getRawYCoord()).x, (int)0, (long[])lArray, (int)(n5 += 9));
            n5 += 9;
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }
}

