/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.custom.sec;

import java.math.BigInteger;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECCurve;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECFieldElement;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECLookupTable;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECPoint;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.custom.sec.SecT283FieldElement;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.custom.sec.SecT283R1Point;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.raw.Nat320;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.encoders.Hex;

public class SecT283R1Curve
extends ECCurve.AbstractF2m {
    private static final int SecT283R1_DEFAULT_COORDS = 6;
    protected SecT283R1Point infinity = new SecT283R1Point((ECCurve)this, null, null);

    public SecT283R1Curve() {
        super(283, 5, 7, 12);
        this.a = this.fromBigInteger(BigInteger.valueOf(1L));
        this.b = this.fromBigInteger(new BigInteger(1, Hex.decode((String)"027B680AC8B8596DA5A4AF8A19A0303FCA97FD7645309FA2A581485AF6263E313B79A2F5")));
        this.order = new BigInteger(1, Hex.decode((String)"03FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEF90399660FC938A90165B042A7CEFADB307"));
        this.cofactor = BigInteger.valueOf(2L);
        this.coord = 6;
    }

    protected ECCurve cloneCurve() {
        return new SecT283R1Curve();
    }

    public boolean supportsCoordinateSystem(int n2) {
        switch (n2) {
            case 6: {
                return true;
            }
        }
        return false;
    }

    public int getFieldSize() {
        return 283;
    }

    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SecT283FieldElement(bigInteger);
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, boolean bl2) {
        return new SecT283R1Point((ECCurve)this, eCFieldElement, eCFieldElement2, bl2);
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray, boolean bl2) {
        return new SecT283R1Point((ECCurve)this, eCFieldElement, eCFieldElement2, eCFieldElementArray, bl2);
    }

    public ECPoint getInfinity() {
        return this.infinity;
    }

    public boolean isKoblitz() {
        return false;
    }

    public int getM() {
        return 283;
    }

    public boolean isTrinomial() {
        return false;
    }

    public int getK1() {
        return 5;
    }

    public int getK2() {
        return 7;
    }

    public int getK3() {
        return 12;
    }

    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n2, int n3) {
        int n4 = 5;
        long[] lArray = new long[n3 * 5 * 2];
        int n5 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            ECPoint eCPoint = eCPointArray[n2 + i2];
            Nat320.copy64((long[])((SecT283FieldElement)eCPoint.getRawXCoord()).x, (int)0, (long[])lArray, (int)n5);
            Nat320.copy64((long[])((SecT283FieldElement)eCPoint.getRawYCoord()).x, (int)0, (long[])lArray, (int)(n5 += 5));
            n5 += 5;
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }
}

