/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.custom.sec;

import java.math.BigInteger;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECFieldElement;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.custom.sec.SecP256K1Curve;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.custom.sec.SecP256K1Field;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.raw.Mod;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.raw.Nat256;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Arrays;

public class SecP256K1FieldElement
extends ECFieldElement.AbstractFp {
    public static final BigInteger Q = SecP256K1Curve.q;
    protected int[] x;

    public SecP256K1FieldElement(BigInteger bigInteger) {
        if (bigInteger == null || bigInteger.signum() < 0 || bigInteger.compareTo(Q) >= 0) {
            throw new IllegalArgumentException("x value invalid for SecP256K1FieldElement");
        }
        this.x = SecP256K1Field.fromBigInteger((BigInteger)bigInteger);
    }

    public SecP256K1FieldElement() {
        this.x = Nat256.create();
    }

    protected SecP256K1FieldElement(int[] nArray) {
        this.x = nArray;
    }

    public boolean isZero() {
        return Nat256.isZero((int[])this.x);
    }

    public boolean isOne() {
        return Nat256.isOne((int[])this.x);
    }

    public boolean testBitZero() {
        return Nat256.getBit((int[])this.x, (int)0) == 1;
    }

    public BigInteger toBigInteger() {
        return Nat256.toBigInteger((int[])this.x);
    }

    public String getFieldName() {
        return "SecP256K1Field";
    }

    public int getFieldSize() {
        return Q.bitLength();
    }

    public ECFieldElement add(ECFieldElement eCFieldElement) {
        int[] nArray = Nat256.create();
        SecP256K1Field.add((int[])this.x, (int[])((SecP256K1FieldElement)eCFieldElement).x, (int[])nArray);
        return new SecP256K1FieldElement(nArray);
    }

    public ECFieldElement addOne() {
        int[] nArray = Nat256.create();
        SecP256K1Field.addOne((int[])this.x, (int[])nArray);
        return new SecP256K1FieldElement(nArray);
    }

    public ECFieldElement subtract(ECFieldElement eCFieldElement) {
        int[] nArray = Nat256.create();
        SecP256K1Field.subtract((int[])this.x, (int[])((SecP256K1FieldElement)eCFieldElement).x, (int[])nArray);
        return new SecP256K1FieldElement(nArray);
    }

    public ECFieldElement multiply(ECFieldElement eCFieldElement) {
        int[] nArray = Nat256.create();
        SecP256K1Field.multiply((int[])this.x, (int[])((SecP256K1FieldElement)eCFieldElement).x, (int[])nArray);
        return new SecP256K1FieldElement(nArray);
    }

    public ECFieldElement divide(ECFieldElement eCFieldElement) {
        int[] nArray = Nat256.create();
        Mod.invert((int[])SecP256K1Field.P, (int[])((SecP256K1FieldElement)eCFieldElement).x, (int[])nArray);
        SecP256K1Field.multiply((int[])nArray, (int[])this.x, (int[])nArray);
        return new SecP256K1FieldElement(nArray);
    }

    public ECFieldElement negate() {
        int[] nArray = Nat256.create();
        SecP256K1Field.negate((int[])this.x, (int[])nArray);
        return new SecP256K1FieldElement(nArray);
    }

    public ECFieldElement square() {
        int[] nArray = Nat256.create();
        SecP256K1Field.square((int[])this.x, (int[])nArray);
        return new SecP256K1FieldElement(nArray);
    }

    public ECFieldElement invert() {
        int[] nArray = Nat256.create();
        Mod.invert((int[])SecP256K1Field.P, (int[])this.x, (int[])nArray);
        return new SecP256K1FieldElement(nArray);
    }

    public ECFieldElement sqrt() {
        int[] nArray = this.x;
        if (Nat256.isZero((int[])nArray) || Nat256.isOne((int[])nArray)) {
            return this;
        }
        int[] nArray2 = Nat256.create();
        SecP256K1Field.square((int[])nArray, (int[])nArray2);
        SecP256K1Field.multiply((int[])nArray2, (int[])nArray, (int[])nArray2);
        int[] nArray3 = Nat256.create();
        SecP256K1Field.square((int[])nArray2, (int[])nArray3);
        SecP256K1Field.multiply((int[])nArray3, (int[])nArray, (int[])nArray3);
        int[] nArray4 = Nat256.create();
        SecP256K1Field.squareN((int[])nArray3, (int)3, (int[])nArray4);
        SecP256K1Field.multiply((int[])nArray4, (int[])nArray3, (int[])nArray4);
        int[] nArray5 = nArray4;
        SecP256K1Field.squareN((int[])nArray4, (int)3, (int[])nArray5);
        SecP256K1Field.multiply((int[])nArray5, (int[])nArray3, (int[])nArray5);
        int[] nArray6 = nArray5;
        SecP256K1Field.squareN((int[])nArray5, (int)2, (int[])nArray6);
        SecP256K1Field.multiply((int[])nArray6, (int[])nArray2, (int[])nArray6);
        int[] nArray7 = Nat256.create();
        SecP256K1Field.squareN((int[])nArray6, (int)11, (int[])nArray7);
        SecP256K1Field.multiply((int[])nArray7, (int[])nArray6, (int[])nArray7);
        int[] nArray8 = nArray6;
        SecP256K1Field.squareN((int[])nArray7, (int)22, (int[])nArray8);
        SecP256K1Field.multiply((int[])nArray8, (int[])nArray7, (int[])nArray8);
        int[] nArray9 = Nat256.create();
        SecP256K1Field.squareN((int[])nArray8, (int)44, (int[])nArray9);
        SecP256K1Field.multiply((int[])nArray9, (int[])nArray8, (int[])nArray9);
        int[] nArray10 = Nat256.create();
        SecP256K1Field.squareN((int[])nArray9, (int)88, (int[])nArray10);
        SecP256K1Field.multiply((int[])nArray10, (int[])nArray9, (int[])nArray10);
        int[] nArray11 = nArray9;
        SecP256K1Field.squareN((int[])nArray10, (int)44, (int[])nArray11);
        SecP256K1Field.multiply((int[])nArray11, (int[])nArray8, (int[])nArray11);
        int[] nArray12 = nArray8;
        SecP256K1Field.squareN((int[])nArray11, (int)3, (int[])nArray12);
        SecP256K1Field.multiply((int[])nArray12, (int[])nArray3, (int[])nArray12);
        int[] nArray13 = nArray12;
        SecP256K1Field.squareN((int[])nArray13, (int)23, (int[])nArray13);
        SecP256K1Field.multiply((int[])nArray13, (int[])nArray7, (int[])nArray13);
        SecP256K1Field.squareN((int[])nArray13, (int)6, (int[])nArray13);
        SecP256K1Field.multiply((int[])nArray13, (int[])nArray2, (int[])nArray13);
        SecP256K1Field.squareN((int[])nArray13, (int)2, (int[])nArray13);
        int[] nArray14 = nArray2;
        SecP256K1Field.square((int[])nArray13, (int[])nArray14);
        return Nat256.eq((int[])nArray, (int[])nArray14) ? new SecP256K1FieldElement(nArray13) : null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SecP256K1FieldElement)) {
            return false;
        }
        SecP256K1FieldElement secP256K1FieldElement = (SecP256K1FieldElement)object;
        return Nat256.eq((int[])this.x, (int[])secP256K1FieldElement.x);
    }

    public int hashCode() {
        return Q.hashCode() ^ Arrays.hashCode((int[])this.x, (int)0, (int)8);
    }
}

