/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.custom.djb;

import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECCurve;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECFieldElement;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECPoint;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.custom.djb.Curve25519Field;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.custom.djb.Curve25519FieldElement;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.raw.Nat256;

public class Curve25519Point
extends ECPoint.AbstractFp {
    public Curve25519Point(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        this(eCCurve, eCFieldElement, eCFieldElement2, false);
    }

    public Curve25519Point(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, boolean bl2) {
        super(eCCurve, eCFieldElement, eCFieldElement2);
        if (eCFieldElement == null != (eCFieldElement2 == null)) {
            throw new IllegalArgumentException("Exactly one of the field elements is null");
        }
        this.withCompression = bl2;
    }

    Curve25519Point(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray, boolean bl2) {
        super(eCCurve, eCFieldElement, eCFieldElement2, eCFieldElementArray);
        this.withCompression = bl2;
    }

    protected ECPoint detach() {
        return new Curve25519Point(null, this.getAffineXCoord(), this.getAffineYCoord());
    }

    public ECFieldElement getZCoord(int n2) {
        if (n2 == 1) {
            return this.getJacobianModifiedW();
        }
        return super.getZCoord(n2);
    }

    public ECPoint add(ECPoint eCPoint) {
        int[] nArray;
        int[] nArray2;
        int[] nArray3;
        int[] nArray4;
        if (this.isInfinity()) {
            return eCPoint;
        }
        if (eCPoint.isInfinity()) {
            return this;
        }
        if (this == eCPoint) {
            return this.twice();
        }
        ECCurve eCCurve = this.getCurve();
        Curve25519FieldElement curve25519FieldElement = (Curve25519FieldElement)this.x;
        Curve25519FieldElement curve25519FieldElement2 = (Curve25519FieldElement)this.y;
        Curve25519FieldElement curve25519FieldElement3 = (Curve25519FieldElement)this.zs[0];
        Curve25519FieldElement curve25519FieldElement4 = (Curve25519FieldElement)eCPoint.getXCoord();
        Curve25519FieldElement curve25519FieldElement5 = (Curve25519FieldElement)eCPoint.getYCoord();
        Curve25519FieldElement curve25519FieldElement6 = (Curve25519FieldElement)eCPoint.getZCoord(0);
        int[] nArray5 = Nat256.createExt();
        int[] nArray6 = Nat256.create();
        int[] nArray7 = Nat256.create();
        int[] nArray8 = Nat256.create();
        boolean bl2 = curve25519FieldElement3.isOne();
        if (bl2) {
            nArray4 = curve25519FieldElement4.x;
            nArray3 = curve25519FieldElement5.x;
        } else {
            nArray3 = nArray7;
            Curve25519Field.square((int[])curve25519FieldElement3.x, (int[])nArray3);
            nArray4 = nArray6;
            Curve25519Field.multiply((int[])nArray3, (int[])curve25519FieldElement4.x, (int[])nArray4);
            Curve25519Field.multiply((int[])nArray3, (int[])curve25519FieldElement3.x, (int[])nArray3);
            Curve25519Field.multiply((int[])nArray3, (int[])curve25519FieldElement5.x, (int[])nArray3);
        }
        boolean bl3 = curve25519FieldElement6.isOne();
        if (bl3) {
            nArray2 = curve25519FieldElement.x;
            nArray = curve25519FieldElement2.x;
        } else {
            nArray = nArray8;
            Curve25519Field.square((int[])curve25519FieldElement6.x, (int[])nArray);
            nArray2 = nArray5;
            Curve25519Field.multiply((int[])nArray, (int[])curve25519FieldElement.x, (int[])nArray2);
            Curve25519Field.multiply((int[])nArray, (int[])curve25519FieldElement6.x, (int[])nArray);
            Curve25519Field.multiply((int[])nArray, (int[])curve25519FieldElement2.x, (int[])nArray);
        }
        int[] nArray9 = Nat256.create();
        Curve25519Field.subtract((int[])nArray2, (int[])nArray4, (int[])nArray9);
        int[] nArray10 = nArray6;
        Curve25519Field.subtract((int[])nArray, (int[])nArray3, (int[])nArray10);
        if (Nat256.isZero((int[])nArray9)) {
            if (Nat256.isZero((int[])nArray10)) {
                return this.twice();
            }
            return eCCurve.getInfinity();
        }
        int[] nArray11 = Nat256.create();
        Curve25519Field.square((int[])nArray9, (int[])nArray11);
        int[] nArray12 = Nat256.create();
        Curve25519Field.multiply((int[])nArray11, (int[])nArray9, (int[])nArray12);
        int[] nArray13 = nArray7;
        Curve25519Field.multiply((int[])nArray11, (int[])nArray2, (int[])nArray13);
        Curve25519Field.negate((int[])nArray12, (int[])nArray12);
        Nat256.mul((int[])nArray, (int[])nArray12, (int[])nArray5);
        int n2 = Nat256.addBothTo((int[])nArray13, (int[])nArray13, (int[])nArray12);
        Curve25519Field.reduce27((int)n2, (int[])nArray12);
        Curve25519FieldElement curve25519FieldElement7 = new Curve25519FieldElement(nArray8);
        Curve25519Field.square((int[])nArray10, (int[])curve25519FieldElement7.x);
        Curve25519Field.subtract((int[])curve25519FieldElement7.x, (int[])nArray12, (int[])curve25519FieldElement7.x);
        Curve25519FieldElement curve25519FieldElement8 = new Curve25519FieldElement(nArray12);
        Curve25519Field.subtract((int[])nArray13, (int[])curve25519FieldElement7.x, (int[])curve25519FieldElement8.x);
        Curve25519Field.multiplyAddToExt((int[])curve25519FieldElement8.x, (int[])nArray10, (int[])nArray5);
        Curve25519Field.reduce((int[])nArray5, (int[])curve25519FieldElement8.x);
        Curve25519FieldElement curve25519FieldElement9 = new Curve25519FieldElement(nArray9);
        if (!bl2) {
            Curve25519Field.multiply((int[])curve25519FieldElement9.x, (int[])curve25519FieldElement3.x, (int[])curve25519FieldElement9.x);
        }
        if (!bl3) {
            Curve25519Field.multiply((int[])curve25519FieldElement9.x, (int[])curve25519FieldElement6.x, (int[])curve25519FieldElement9.x);
        }
        int[] nArray14 = bl2 && bl3 ? nArray11 : null;
        Curve25519FieldElement curve25519FieldElement10 = this.calculateJacobianModifiedW(curve25519FieldElement9, nArray14);
        ECFieldElement[] eCFieldElementArray = new ECFieldElement[]{curve25519FieldElement9, curve25519FieldElement10};
        return new Curve25519Point(eCCurve, (ECFieldElement)curve25519FieldElement7, (ECFieldElement)curve25519FieldElement8, eCFieldElementArray, this.withCompression);
    }

    public ECPoint twice() {
        if (this.isInfinity()) {
            return this;
        }
        ECCurve eCCurve = this.getCurve();
        ECFieldElement eCFieldElement = this.y;
        if (eCFieldElement.isZero()) {
            return eCCurve.getInfinity();
        }
        return this.twiceJacobianModified(true);
    }

    public ECPoint twicePlus(ECPoint eCPoint) {
        if (this == eCPoint) {
            return this.threeTimes();
        }
        if (this.isInfinity()) {
            return eCPoint;
        }
        if (eCPoint.isInfinity()) {
            return this.twice();
        }
        ECFieldElement eCFieldElement = this.y;
        if (eCFieldElement.isZero()) {
            return eCPoint;
        }
        return this.twiceJacobianModified(false).add(eCPoint);
    }

    public ECPoint threeTimes() {
        if (this.isInfinity()) {
            return this;
        }
        ECFieldElement eCFieldElement = this.y;
        if (eCFieldElement.isZero()) {
            return this;
        }
        return this.twiceJacobianModified(false).add((ECPoint)this);
    }

    public ECPoint negate() {
        if (this.isInfinity()) {
            return this;
        }
        return new Curve25519Point(this.getCurve(), this.x, this.y.negate(), this.zs, this.withCompression);
    }

    protected Curve25519FieldElement calculateJacobianModifiedW(Curve25519FieldElement curve25519FieldElement, int[] nArray) {
        Curve25519FieldElement curve25519FieldElement2 = (Curve25519FieldElement)this.getCurve().getA();
        if (curve25519FieldElement.isOne()) {
            return curve25519FieldElement2;
        }
        Curve25519FieldElement curve25519FieldElement3 = new Curve25519FieldElement();
        if (nArray == null) {
            nArray = curve25519FieldElement3.x;
            Curve25519Field.square((int[])curve25519FieldElement.x, (int[])nArray);
        }
        Curve25519Field.square((int[])nArray, (int[])curve25519FieldElement3.x);
        Curve25519Field.multiply((int[])curve25519FieldElement3.x, (int[])curve25519FieldElement2.x, (int[])curve25519FieldElement3.x);
        return curve25519FieldElement3;
    }

    protected Curve25519FieldElement getJacobianModifiedW() {
        Curve25519FieldElement curve25519FieldElement = (Curve25519FieldElement)this.zs[1];
        if (curve25519FieldElement == null) {
            curve25519FieldElement = this.calculateJacobianModifiedW((Curve25519FieldElement)this.zs[0], null);
            this.zs[1] = curve25519FieldElement;
        }
        return curve25519FieldElement;
    }

    protected Curve25519Point twiceJacobianModified(boolean bl2) {
        Curve25519FieldElement curve25519FieldElement = (Curve25519FieldElement)this.x;
        Curve25519FieldElement curve25519FieldElement2 = (Curve25519FieldElement)this.y;
        Curve25519FieldElement curve25519FieldElement3 = (Curve25519FieldElement)this.zs[0];
        Curve25519FieldElement curve25519FieldElement4 = this.getJacobianModifiedW();
        int[] nArray = Nat256.create();
        Curve25519Field.square((int[])curve25519FieldElement.x, (int[])nArray);
        int n2 = Nat256.addBothTo((int[])nArray, (int[])nArray, (int[])nArray);
        Curve25519Field.reduce27((int)(n2 += Nat256.addTo((int[])curve25519FieldElement4.x, (int[])nArray)), (int[])nArray);
        int[] nArray2 = Nat256.create();
        Curve25519Field.twice((int[])curve25519FieldElement2.x, (int[])nArray2);
        int[] nArray3 = Nat256.create();
        Curve25519Field.multiply((int[])nArray2, (int[])curve25519FieldElement2.x, (int[])nArray3);
        int[] nArray4 = Nat256.create();
        Curve25519Field.multiply((int[])nArray3, (int[])curve25519FieldElement.x, (int[])nArray4);
        Curve25519Field.twice((int[])nArray4, (int[])nArray4);
        int[] nArray5 = Nat256.create();
        Curve25519Field.square((int[])nArray3, (int[])nArray5);
        Curve25519Field.twice((int[])nArray5, (int[])nArray5);
        Curve25519FieldElement curve25519FieldElement5 = new Curve25519FieldElement(nArray3);
        Curve25519Field.square((int[])nArray, (int[])curve25519FieldElement5.x);
        Curve25519Field.subtract((int[])curve25519FieldElement5.x, (int[])nArray4, (int[])curve25519FieldElement5.x);
        Curve25519Field.subtract((int[])curve25519FieldElement5.x, (int[])nArray4, (int[])curve25519FieldElement5.x);
        Curve25519FieldElement curve25519FieldElement6 = new Curve25519FieldElement(nArray4);
        Curve25519Field.subtract((int[])nArray4, (int[])curve25519FieldElement5.x, (int[])curve25519FieldElement6.x);
        Curve25519Field.multiply((int[])curve25519FieldElement6.x, (int[])nArray, (int[])curve25519FieldElement6.x);
        Curve25519Field.subtract((int[])curve25519FieldElement6.x, (int[])nArray5, (int[])curve25519FieldElement6.x);
        Curve25519FieldElement curve25519FieldElement7 = new Curve25519FieldElement(nArray2);
        if (!Nat256.isOne((int[])curve25519FieldElement3.x)) {
            Curve25519Field.multiply((int[])curve25519FieldElement7.x, (int[])curve25519FieldElement3.x, (int[])curve25519FieldElement7.x);
        }
        Curve25519FieldElement curve25519FieldElement8 = null;
        if (bl2) {
            curve25519FieldElement8 = new Curve25519FieldElement(nArray5);
            Curve25519Field.multiply((int[])curve25519FieldElement8.x, (int[])curve25519FieldElement4.x, (int[])curve25519FieldElement8.x);
            Curve25519Field.twice((int[])curve25519FieldElement8.x, (int[])curve25519FieldElement8.x);
        }
        return new Curve25519Point(this.getCurve(), (ECFieldElement)curve25519FieldElement5, (ECFieldElement)curve25519FieldElement6, new ECFieldElement[]{curve25519FieldElement7, curve25519FieldElement8}, this.withCompression);
    }
}

