/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.math.ec;

import java.math.BigInteger;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.AbstractECMultiplier;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECCurve;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECLookupTable;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECPoint;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.FixedPointPreCompInfo;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.FixedPointUtil;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.raw.Nat;

public class FixedPointCombMultiplier
extends AbstractECMultiplier {
    protected ECPoint multiplyPositive(ECPoint eCPoint, BigInteger bigInteger) {
        ECCurve eCCurve = eCPoint.getCurve();
        int n2 = FixedPointUtil.getCombSize((ECCurve)eCCurve);
        if (bigInteger.bitLength() > n2) {
            throw new IllegalStateException("fixed-point comb doesn't support scalars larger than the curve order");
        }
        FixedPointPreCompInfo fixedPointPreCompInfo = FixedPointUtil.precompute((ECPoint)eCPoint);
        ECLookupTable eCLookupTable = fixedPointPreCompInfo.getLookupTable();
        int n3 = fixedPointPreCompInfo.getWidth();
        int n4 = (n2 + n3 - 1) / n3;
        ECPoint eCPoint2 = eCCurve.getInfinity();
        int n5 = n4 * n3;
        int[] nArray = Nat.fromBigInteger((int)n5, (BigInteger)bigInteger);
        int n6 = n5 - 1;
        for (int i2 = 0; i2 < n4; ++i2) {
            int n7 = 0;
            for (int i3 = n6 - i2; i3 >= 0; i3 -= n4) {
                n7 <<= 1;
                n7 |= Nat.getBit((int[])nArray, (int)i3);
            }
            ECPoint eCPoint3 = eCLookupTable.lookup(n7);
            eCPoint2 = eCPoint2.twicePlus(eCPoint3);
        }
        return eCPoint2.add(fixedPointPreCompInfo.getOffset());
    }
}

