/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.jce.provider;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateParsingException;
import java.util.ArrayList;
import java.util.Collection;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1InputStream;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Sequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.CertificatePair;
import macromedia.externals.org.bouncycastle_1_60_0_0.x509.X509CertificatePair;
import macromedia.externals.org.bouncycastle_1_60_0_0.x509.X509StreamParserSpi;
import macromedia.externals.org.bouncycastle_1_60_0_0.x509.util.StreamParsingException;

public class X509CertPairParser
extends X509StreamParserSpi {
    private InputStream currentStream = null;

    private X509CertificatePair readDERCrossCertificatePair(InputStream inputStream) throws IOException, CertificateParsingException {
        ASN1InputStream aSN1InputStream = new ASN1InputStream(inputStream);
        ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
        CertificatePair certificatePair = CertificatePair.getInstance((Object)aSN1Sequence);
        return new X509CertificatePair(certificatePair);
    }

    public void engineInit(InputStream inputStream) {
        this.currentStream = inputStream;
        if (!this.currentStream.markSupported()) {
            this.currentStream = new BufferedInputStream(this.currentStream);
        }
    }

    public Object engineRead() throws StreamParsingException {
        try {
            this.currentStream.mark(10);
            int n2 = this.currentStream.read();
            if (n2 == -1) {
                return null;
            }
            this.currentStream.reset();
            return this.readDERCrossCertificatePair(this.currentStream);
        }
        catch (Exception exception) {
            throw new StreamParsingException(exception.toString(), (Throwable)exception);
        }
    }

    public Collection engineReadAll() throws StreamParsingException {
        X509CertificatePair x509CertificatePair;
        ArrayList<X509CertificatePair> arrayList = new ArrayList<X509CertificatePair>();
        while ((x509CertificatePair = (X509CertificatePair)this.engineRead()) != null) {
            arrayList.add(x509CertificatePair);
        }
        return arrayList;
    }
}

