/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.jce.provider;

import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.PKIXCRLStoreSelector;
import macromedia.externals.org.bouncycastle_1_60_0_0.jce.provider.AnnotatedException;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Selector;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Store;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.StoreException;

class PKIXCRLUtil {
    PKIXCRLUtil() {
    }

    public Set findCRLs(PKIXCRLStoreSelector pKIXCRLStoreSelector, Date date, List list, List list2) throws AnnotatedException {
        HashSet hashSet = new HashSet();
        try {
            hashSet.addAll(this.findCRLs(pKIXCRLStoreSelector, list2));
            hashSet.addAll(this.findCRLs(pKIXCRLStoreSelector, list));
        }
        catch (AnnotatedException annotatedException) {
            throw new AnnotatedException("Exception obtaining complete CRLs.", (Throwable)annotatedException);
        }
        HashSet<X509CRL> hashSet2 = new HashSet<X509CRL>();
        for (X509CRL x509CRL : hashSet) {
            if (!x509CRL.getNextUpdate().after(date)) continue;
            X509Certificate x509Certificate = pKIXCRLStoreSelector.getCertificateChecking();
            if (x509Certificate != null) {
                if (!x509CRL.getThisUpdate().before(x509Certificate.getNotAfter())) continue;
                hashSet2.add(x509CRL);
                continue;
            }
            hashSet2.add(x509CRL);
        }
        return hashSet2;
    }

    private final Collection findCRLs(PKIXCRLStoreSelector pKIXCRLStoreSelector, List list) throws AnnotatedException {
        HashSet hashSet = new HashSet();
        Iterator iterator = list.iterator();
        AnnotatedException annotatedException = null;
        boolean bl2 = false;
        while (iterator.hasNext()) {
            Object object;
            Object e2 = iterator.next();
            if (e2 instanceof Store) {
                object = (Store)e2;
                try {
                    hashSet.addAll(object.getMatches((Selector)pKIXCRLStoreSelector));
                    bl2 = true;
                }
                catch (StoreException storeException) {
                    annotatedException = new AnnotatedException("Exception searching in X.509 CRL store.", (Throwable)storeException);
                }
                continue;
            }
            object = (CertStore)e2;
            try {
                hashSet.addAll(PKIXCRLStoreSelector.getCRLs((PKIXCRLStoreSelector)pKIXCRLStoreSelector, (CertStore)object));
                bl2 = true;
            }
            catch (CertStoreException certStoreException) {
                annotatedException = new AnnotatedException("Exception searching in X.509 CRL store.", (Throwable)certStoreException);
            }
        }
        if (!bl2 && annotatedException != null) {
            throw annotatedException;
        }
        return hashSet;
    }
}

