/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.jce;

import java.io.IOException;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Primitive;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.TBSCertList;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.TBSCertificateStructure;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.X509Name;
import macromedia.externals.org.bouncycastle_1_60_0_0.jce.X509Principal;

public class PrincipalUtil {
    public static X509Principal getIssuerX509Principal(X509Certificate x509Certificate) throws CertificateEncodingException {
        try {
            TBSCertificateStructure tBSCertificateStructure = TBSCertificateStructure.getInstance((Object)ASN1Primitive.fromByteArray((byte[])x509Certificate.getTBSCertificate()));
            return new X509Principal(X509Name.getInstance((Object)tBSCertificateStructure.getIssuer()));
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException(iOException.toString());
        }
    }

    public static X509Principal getSubjectX509Principal(X509Certificate x509Certificate) throws CertificateEncodingException {
        try {
            TBSCertificateStructure tBSCertificateStructure = TBSCertificateStructure.getInstance((Object)ASN1Primitive.fromByteArray((byte[])x509Certificate.getTBSCertificate()));
            return new X509Principal(X509Name.getInstance((Object)tBSCertificateStructure.getSubject()));
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException(iOException.toString());
        }
    }

    public static X509Principal getIssuerX509Principal(X509CRL x509CRL) throws CRLException {
        try {
            TBSCertList tBSCertList = TBSCertList.getInstance((Object)ASN1Primitive.fromByteArray((byte[])x509CRL.getTBSCertList()));
            return new X509Principal(X509Name.getInstance((Object)tBSCertList.getIssuer()));
        }
        catch (IOException iOException) {
            throw new CRLException(iOException.toString());
        }
    }
}

