/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.symmetric.util;

import java.lang.reflect.Method;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Hashtable;
import java.util.Map;
import javax.crypto.MacSpi;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.CipherParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.Mac;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.macs.HMac;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.AEADParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.KeyParameter;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ParametersWithIV;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.RC2Parameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.SkeinParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.PKCS12Key;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.symmetric.util.BCPBEKey;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.symmetric.util.ClassUtil;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.symmetric.util.PBE;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.spec.AEADParameterSpec;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.spec.SkeinParameterSpec;

/*
 * Exception performing whole class analysis ignored.
 */
public class BaseMac
extends MacSpi
implements PBE {
    private static final Class gcmSpecClass = ClassUtil.loadClass(BaseMac.class, (String)"javax.crypto.spec.GCMParameterSpec");
    private Mac macEngine;
    private int scheme = 2;
    private int pbeHash = 1;
    private int keySize = 160;

    protected BaseMac(Mac mac) {
        this.macEngine = mac;
    }

    protected BaseMac(Mac mac, int n2, int n3, int n4) {
        this.macEngine = mac;
        this.scheme = n2;
        this.pbeHash = n3;
        this.keySize = n4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        CipherParameters cipherParameters;
        Object object;
        SecretKey secretKey;
        if (key == null) {
            throw new InvalidKeyException("key is null");
        }
        if (key instanceof PKCS12Key) {
            try {
                secretKey = (SecretKey)key;
            }
            catch (Exception exception) {
                throw new InvalidKeyException("PKCS12 requires a SecretKey/PBEKey");
            }
            try {
                object = (PBEParameterSpec)algorithmParameterSpec;
            }
            catch (Exception exception) {
                throw new InvalidAlgorithmParameterException("PKCS12 requires a PBEParameterSpec");
            }
            if (secretKey instanceof PBEKey && object == null) {
                object = new PBEParameterSpec(((PBEKey)secretKey).getSalt(), ((PBEKey)secretKey).getIterationCount());
            }
            int n2 = 1;
            int n3 = 160;
            if (this.macEngine.getAlgorithmName().startsWith("GOST")) {
                n2 = 6;
                n3 = 256;
            } else if (this.macEngine instanceof HMac && !this.macEngine.getAlgorithmName().startsWith("SHA-1")) {
                if (this.macEngine.getAlgorithmName().startsWith("SHA-224")) {
                    n2 = 7;
                    n3 = 224;
                } else if (this.macEngine.getAlgorithmName().startsWith("SHA-256")) {
                    n2 = 4;
                    n3 = 256;
                } else if (this.macEngine.getAlgorithmName().startsWith("SHA-384")) {
                    n2 = 8;
                    n3 = 384;
                } else if (this.macEngine.getAlgorithmName().startsWith("SHA-512")) {
                    n2 = 9;
                    n3 = 512;
                } else {
                    if (!this.macEngine.getAlgorithmName().startsWith("RIPEMD160")) throw new InvalidAlgorithmParameterException("no PKCS12 mapping for HMAC: " + this.macEngine.getAlgorithmName());
                    n2 = 2;
                    n3 = 160;
                }
            }
            cipherParameters = PBE.Util.makePBEMacParameters((SecretKey)secretKey, (int)2, (int)n2, (int)n3, (PBEParameterSpec)object);
        } else if (key instanceof BCPBEKey) {
            secretKey = (BCPBEKey)key;
            if (secretKey.getParam() != null) {
                cipherParameters = secretKey.getParam();
            } else {
                if (!(algorithmParameterSpec instanceof PBEParameterSpec)) throw new InvalidAlgorithmParameterException("PBE requires PBE parameters to be set.");
                cipherParameters = PBE.Util.makePBEMacParameters((BCPBEKey)secretKey, (AlgorithmParameterSpec)algorithmParameterSpec);
            }
        } else {
            if (algorithmParameterSpec instanceof PBEParameterSpec) {
                throw new InvalidAlgorithmParameterException("inappropriate parameter type: " + algorithmParameterSpec.getClass().getName());
            }
            cipherParameters = new KeyParameter(key.getEncoded());
        }
        secretKey = cipherParameters instanceof ParametersWithIV ? (KeyParameter)((ParametersWithIV)cipherParameters).getParameters() : (KeyParameter)cipherParameters;
        if (algorithmParameterSpec instanceof AEADParameterSpec) {
            object = (AEADParameterSpec)algorithmParameterSpec;
            cipherParameters = new AEADParameters((KeyParameter)secretKey, object.getMacSizeInBits(), object.getNonce(), object.getAssociatedData());
        } else if (algorithmParameterSpec instanceof IvParameterSpec) {
            cipherParameters = new ParametersWithIV((CipherParameters)secretKey, ((IvParameterSpec)algorithmParameterSpec).getIV());
        } else if (algorithmParameterSpec instanceof RC2ParameterSpec) {
            cipherParameters = new ParametersWithIV((CipherParameters)new RC2Parameters(secretKey.getKey(), ((RC2ParameterSpec)algorithmParameterSpec).getEffectiveKeyBits()), ((RC2ParameterSpec)algorithmParameterSpec).getIV());
        } else if (algorithmParameterSpec instanceof SkeinParameterSpec) {
            cipherParameters = new SkeinParameters.Builder(BaseMac.copyMap((Map)((SkeinParameterSpec)algorithmParameterSpec).getParameters())).setKey(secretKey.getKey()).build();
        } else if (algorithmParameterSpec == null) {
            cipherParameters = new KeyParameter(key.getEncoded());
        } else if (gcmSpecClass != null && gcmSpecClass.isAssignableFrom(algorithmParameterSpec.getClass())) {
            try {
                object = gcmSpecClass.getDeclaredMethod("getTLen", new Class[0]);
                Method method = gcmSpecClass.getDeclaredMethod("getIV", new Class[0]);
                cipherParameters = new AEADParameters((KeyParameter)secretKey, ((Integer)((Method)object).invoke((Object)algorithmParameterSpec, new Object[0])).intValue(), (byte[])method.invoke((Object)algorithmParameterSpec, new Object[0]));
            }
            catch (Exception exception) {
                throw new InvalidAlgorithmParameterException("Cannot process GCMParameterSpec.");
            }
        } else if (!(algorithmParameterSpec instanceof PBEParameterSpec)) {
            throw new InvalidAlgorithmParameterException("unknown parameter type: " + algorithmParameterSpec.getClass().getName());
        }
        try {
            this.macEngine.init(cipherParameters);
            return;
        }
        catch (Exception exception) {
            throw new InvalidAlgorithmParameterException("cannot initialize MAC: " + exception.getMessage());
        }
    }

    protected int engineGetMacLength() {
        return this.macEngine.getMacSize();
    }

    protected void engineReset() {
        this.macEngine.reset();
    }

    protected void engineUpdate(byte by2) {
        this.macEngine.update(by2);
    }

    protected void engineUpdate(byte[] byArray, int n2, int n3) {
        this.macEngine.update(byArray, n2, n3);
    }

    protected byte[] engineDoFinal() {
        byte[] byArray = new byte[this.engineGetMacLength()];
        this.macEngine.doFinal(byArray, 0);
        return byArray;
    }

    private static Hashtable copyMap(Map map) {
        Hashtable hashtable = new Hashtable();
        for (Object k2 : map.keySet()) {
            hashtable.put(k2, map.get(k2));
        }
        return hashtable;
    }
}

