/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.symmetric.util;

import java.security.spec.KeySpec;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.PBEKeySpec;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1ObjectIdentifier;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.CipherParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.PBEParametersGenerator;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.KeyParameter;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ParametersWithIV;

public class BCPBEKey
implements PBEKey {
    String algorithm;
    ASN1ObjectIdentifier oid;
    int type;
    int digest;
    int keySize;
    int ivSize;
    CipherParameters param;
    PBEKeySpec pbeKeySpec;
    boolean tryWrong = false;

    public BCPBEKey(String string, ASN1ObjectIdentifier aSN1ObjectIdentifier, int n2, int n3, int n4, int n5, PBEKeySpec pBEKeySpec, CipherParameters cipherParameters) {
        this.algorithm = string;
        this.oid = aSN1ObjectIdentifier;
        this.type = n2;
        this.digest = n3;
        this.keySize = n4;
        this.ivSize = n5;
        this.pbeKeySpec = pBEKeySpec;
        this.param = cipherParameters;
    }

    public BCPBEKey(String string, KeySpec keySpec, CipherParameters cipherParameters) {
        this.algorithm = string;
        this.param = cipherParameters;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public String getFormat() {
        return "RAW";
    }

    @Override
    public byte[] getEncoded() {
        if (this.param != null) {
            KeyParameter keyParameter = this.param instanceof ParametersWithIV ? (KeyParameter)((ParametersWithIV)this.param).getParameters() : (KeyParameter)this.param;
            return keyParameter.getKey();
        }
        if (this.type == 2) {
            return PBEParametersGenerator.PKCS12PasswordToBytes((char[])this.pbeKeySpec.getPassword());
        }
        if (this.type == 5) {
            return PBEParametersGenerator.PKCS5PasswordToUTF8Bytes((char[])this.pbeKeySpec.getPassword());
        }
        return PBEParametersGenerator.PKCS5PasswordToBytes((char[])this.pbeKeySpec.getPassword());
    }

    int getType() {
        return this.type;
    }

    int getDigest() {
        return this.digest;
    }

    int getKeySize() {
        return this.keySize;
    }

    public int getIvSize() {
        return this.ivSize;
    }

    public CipherParameters getParam() {
        return this.param;
    }

    @Override
    public char[] getPassword() {
        return this.pbeKeySpec.getPassword();
    }

    @Override
    public byte[] getSalt() {
        return this.pbeKeySpec.getSalt();
    }

    @Override
    public int getIterationCount() {
        return this.pbeKeySpec.getIterationCount();
    }

    public ASN1ObjectIdentifier getOID() {
        return this.oid;
    }

    public void setTryWrongPKCS12Zero(boolean bl2) {
        this.tryWrong = bl2;
    }

    boolean shouldTryWrongPKCS12() {
        return this.tryWrong;
    }
}

