/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.keystore.pkcs12;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Encodable;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1EncodableVector;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1InputStream;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1ObjectIdentifier;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1OctetString;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Primitive;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Sequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Set;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.BEROctetString;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.BEROutputStream;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERBMPString;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERNull;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DEROctetString;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DEROutputStream;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERSequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERSet;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.cryptopro.GOST28147Parameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.oiw.OIWObjectIdentifiers;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.pkcs.AuthenticatedSafe;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.pkcs.CertBag;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.pkcs.ContentInfo;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.pkcs.EncryptedData;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.pkcs.EncryptedPrivateKeyInfo;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.pkcs.MacData;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.pkcs.PBES2Parameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.pkcs.PBKDF2Params;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.pkcs.PKCS12PBEParams;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.pkcs.PKCSObjectIdentifiers;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.pkcs.Pfx;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.pkcs.PrivateKeyInfo;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.pkcs.SafeBag;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.util.ASN1Dump;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.AlgorithmIdentifier;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.AuthorityKeyIdentifier;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.DigestInfo;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.Extension;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.SubjectKeyIdentifier;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.SubjectPublicKeyInfo;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.X509ObjectIdentifiers;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.CryptoServicesRegistrar;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.Digest;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.util.DigestFactory;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.PKCS12Key;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.PKCS12StoreParameter;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.keystore.pkcs12.PKCS12KeyStoreSpi;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.spec.GOST28147ParameterSpec;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.spec.PBKDF2KeySpec;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.util.BCJcaJceHelper;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.util.JcaJceHelper;
import macromedia.externals.org.bouncycastle_1_60_0_0.jce.interfaces.BCKeyStore;
import macromedia.externals.org.bouncycastle_1_60_0_0.jce.interfaces.PKCS12BagAttributeCarrier;
import macromedia.externals.org.bouncycastle_1_60_0_0.jce.provider.BouncyCastleProvider;
import macromedia.externals.org.bouncycastle_1_60_0_0.jce.provider.JDKPKCS12StoreParameter;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Arrays;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Properties;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.encoders.Hex;

/*
 * Exception performing whole class analysis ignored.
 */
public class PKCS12KeyStoreSpi
extends KeyStoreSpi
implements PKCSObjectIdentifiers,
X509ObjectIdentifiers,
BCKeyStore {
    static final String PKCS12_MAX_IT_COUNT_PROPERTY = "macromedia.externals.org.bouncycastle_1_60_0_0.pkcs12.max_it_count";
    private final JcaJceHelper helper = new BCJcaJceHelper();
    private static final int SALT_SIZE = 20;
    private static final int MIN_ITERATIONS = 51200;
    private static final DefaultSecretKeyProvider keySizeProvider = new DefaultSecretKeyProvider();
    private IgnoresCaseHashtable keys = new IgnoresCaseHashtable(null);
    private Hashtable localIds = new Hashtable();
    private IgnoresCaseHashtable certs = new IgnoresCaseHashtable(null);
    private Hashtable chainCerts = new Hashtable();
    private Hashtable keyCerts = new Hashtable();
    static final int NULL = 0;
    static final int CERTIFICATE = 1;
    static final int KEY = 2;
    static final int SECRET = 3;
    static final int SEALED = 4;
    static final int KEY_PRIVATE = 0;
    static final int KEY_PUBLIC = 1;
    static final int KEY_SECRET = 2;
    protected SecureRandom random = CryptoServicesRegistrar.getSecureRandom();
    private CertificateFactory certFact;
    private ASN1ObjectIdentifier keyAlgorithm;
    private ASN1ObjectIdentifier certAlgorithm;
    private AlgorithmIdentifier macAlgorithm = new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1, (ASN1Encodable)DERNull.INSTANCE);
    private int itCount = 102400;
    private int saltLength = 20;
    private static Provider provider = null;

    public PKCS12KeyStoreSpi(Provider provider, ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1ObjectIdentifier aSN1ObjectIdentifier2) {
        this.keyAlgorithm = aSN1ObjectIdentifier;
        this.certAlgorithm = aSN1ObjectIdentifier2;
        try {
            this.certFact = provider != null ? CertificateFactory.getInstance("X.509", provider) : CertificateFactory.getInstance("X.509");
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("can't create cert factory - " + exception.toString());
        }
    }

    private SubjectKeyIdentifier createSubjectKeyId(PublicKey publicKey) {
        try {
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded());
            return new SubjectKeyIdentifier(PKCS12KeyStoreSpi.getDigest((SubjectPublicKeyInfo)subjectPublicKeyInfo));
        }
        catch (Exception exception) {
            throw new RuntimeException("error creating key");
        }
    }

    private static byte[] getDigest(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        Digest digest = DigestFactory.createSHA1();
        byte[] byArray = new byte[digest.getDigestSize()];
        byte[] byArray2 = subjectPublicKeyInfo.getPublicKeyData().getBytes();
        digest.update(byArray2, 0, byArray2.length);
        digest.doFinal(byArray, 0);
        return byArray;
    }

    public void setRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
    }

    public Enumeration engineAliases() {
        Hashtable<Object, String> hashtable = new Hashtable<Object, String>();
        Enumeration enumeration = this.certs.keys();
        while (enumeration.hasMoreElements()) {
            hashtable.put(enumeration.nextElement(), "cert");
        }
        enumeration = this.keys.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (hashtable.get(string) != null) continue;
            hashtable.put(string, "key");
        }
        return hashtable.keys();
    }

    @Override
    public boolean engineContainsAlias(String string) {
        return this.certs.get(string) != null || this.keys.get(string) != null;
    }

    @Override
    public void engineDeleteEntry(String string) throws KeyStoreException {
        Key key = (Key)this.keys.remove(string);
        Certificate certificate = (Certificate)this.certs.remove(string);
        if (certificate != null) {
            this.chainCerts.remove(new CertId(this, certificate.getPublicKey()));
        }
        if (key != null) {
            String string2 = (String)this.localIds.remove(string);
            if (string2 != null) {
                certificate = (Certificate)this.keyCerts.remove(string2);
            }
            if (certificate != null) {
                this.chainCerts.remove(new CertId(this, certificate.getPublicKey()));
            }
        }
    }

    @Override
    public Certificate engineGetCertificate(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null alias passed to getCertificate.");
        }
        Certificate certificate = (Certificate)this.certs.get(string);
        if (certificate == null) {
            String string2 = (String)this.localIds.get(string);
            certificate = string2 != null ? (Certificate)this.keyCerts.get(string2) : (Certificate)this.keyCerts.get(string);
        }
        return certificate;
    }

    @Override
    public String engineGetCertificateAlias(Certificate certificate) {
        String string;
        Certificate certificate2;
        Enumeration enumeration = this.certs.elements();
        Enumeration enumeration2 = this.certs.keys();
        while (enumeration.hasMoreElements()) {
            certificate2 = (Certificate)enumeration.nextElement();
            string = (String)enumeration2.nextElement();
            if (!certificate2.equals(certificate)) continue;
            return string;
        }
        enumeration = this.keyCerts.elements();
        enumeration2 = this.keyCerts.keys();
        while (enumeration.hasMoreElements()) {
            certificate2 = (Certificate)enumeration.nextElement();
            string = (String)enumeration2.nextElement();
            if (!certificate2.equals(certificate)) continue;
            return string;
        }
        return null;
    }

    @Override
    public Certificate[] engineGetCertificateChain(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null alias passed to getCertificateChain.");
        }
        if (!this.engineIsKeyEntry(string)) {
            return null;
        }
        Certificate certificate = this.engineGetCertificate(string);
        if (certificate != null) {
            Certificate[] certificateArray;
            Vector<Certificate> vector = new Vector<Certificate>();
            while (certificate != null) {
                AuthorityKeyIdentifier authorityKeyIdentifier;
                Object object;
                Principal principal;
                certificateArray = (Certificate[])certificate;
                Certificate certificate2 = null;
                byte[] byArray = certificateArray.getExtensionValue(Extension.authorityKeyIdentifier.getId());
                if (byArray != null) {
                    try {
                        principal = new ASN1InputStream(byArray);
                        object = ((ASN1OctetString)principal.readObject()).getOctets();
                        principal = new ASN1InputStream((byte[])object);
                        authorityKeyIdentifier = AuthorityKeyIdentifier.getInstance((Object)principal.readObject());
                        if (authorityKeyIdentifier.getKeyIdentifier() != null) {
                            certificate2 = (Certificate)this.chainCerts.get(new CertId(this, authorityKeyIdentifier.getKeyIdentifier()));
                        }
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(iOException.toString());
                    }
                }
                if (certificate2 == null && !(principal = certificateArray.getIssuerDN()).equals(object = certificateArray.getSubjectDN())) {
                    authorityKeyIdentifier = this.chainCerts.keys();
                    while (authorityKeyIdentifier.hasMoreElements()) {
                        X509Certificate x509Certificate = (X509Certificate)this.chainCerts.get(authorityKeyIdentifier.nextElement());
                        Principal principal2 = x509Certificate.getSubjectDN();
                        if (!principal2.equals(principal)) continue;
                        try {
                            certificateArray.verify(x509Certificate.getPublicKey());
                            certificate2 = x509Certificate;
                            break;
                        }
                        catch (Exception exception) {
                        }
                    }
                }
                if (vector.contains(certificate)) {
                    certificate = null;
                    continue;
                }
                vector.addElement(certificate);
                if (certificate2 != certificate) {
                    certificate = certificate2;
                    continue;
                }
                certificate = null;
            }
            certificateArray = new Certificate[vector.size()];
            for (int i2 = 0; i2 != certificateArray.length; ++i2) {
                certificateArray[i2] = (Certificate)vector.elementAt(i2);
            }
            return certificateArray;
        }
        return null;
    }

    @Override
    public Date engineGetCreationDate(String string) {
        if (string == null) {
            throw new NullPointerException("alias == null");
        }
        if (this.keys.get(string) == null && this.certs.get(string) == null) {
            return null;
        }
        return new Date();
    }

    @Override
    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        if (string == null) {
            throw new IllegalArgumentException("null alias passed to getKey.");
        }
        return (Key)this.keys.get(string);
    }

    @Override
    public boolean engineIsCertificateEntry(String string) {
        return this.certs.get(string) != null && this.keys.get(string) == null;
    }

    @Override
    public boolean engineIsKeyEntry(String string) {
        return this.keys.get(string) != null;
    }

    @Override
    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        if (this.keys.get(string) != null) {
            throw new KeyStoreException("There is a key entry with the name " + string + ".");
        }
        this.certs.put(string, (Object)certificate);
        this.chainCerts.put(new CertId(this, certificate.getPublicKey()), certificate);
    }

    @Override
    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        throw new RuntimeException("operation not supported");
    }

    @Override
    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        if (!(key instanceof PrivateKey)) {
            throw new KeyStoreException("PKCS12 does not support non-PrivateKeys");
        }
        if (key instanceof PrivateKey && certificateArray == null) {
            throw new KeyStoreException("no certificate chain for private key");
        }
        if (this.keys.get(string) != null) {
            this.engineDeleteEntry(string);
        }
        this.keys.put(string, (Object)key);
        if (certificateArray != null) {
            this.certs.put(string, (Object)certificateArray[0]);
            for (int i2 = 0; i2 != certificateArray.length; ++i2) {
                this.chainCerts.put(new CertId(this, certificateArray[i2].getPublicKey()), certificateArray[i2]);
            }
        }
    }

    @Override
    public int engineSize() {
        Hashtable<Object, String> hashtable = new Hashtable<Object, String>();
        Enumeration enumeration = this.certs.keys();
        while (enumeration.hasMoreElements()) {
            hashtable.put(enumeration.nextElement(), "cert");
        }
        enumeration = this.keys.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (hashtable.get(string) != null) continue;
            hashtable.put(string, "key");
        }
        return hashtable.size();
    }

    protected PrivateKey unwrapKey(AlgorithmIdentifier algorithmIdentifier, byte[] byArray, char[] cArray, boolean bl2) throws IOException {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = algorithmIdentifier.getAlgorithm();
        try {
            if (aSN1ObjectIdentifier.on(PKCSObjectIdentifiers.pkcs_12PbeIds)) {
                PKCS12PBEParams pKCS12PBEParams = PKCS12PBEParams.getInstance((Object)algorithmIdentifier.getParameters());
                PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(pKCS12PBEParams.getIV(), this.validateIterationCount(pKCS12PBEParams.getIterations()));
                Cipher cipher = this.helper.createCipher(aSN1ObjectIdentifier.getId());
                PKCS12Key pKCS12Key = new PKCS12Key(cArray, bl2);
                cipher.init(4, (Key)pKCS12Key, pBEParameterSpec);
                return (PrivateKey)cipher.unwrap(byArray, "", 2);
            }
            if (aSN1ObjectIdentifier.equals((Object)PKCSObjectIdentifiers.id_PBES2)) {
                Cipher cipher = this.createCipher(4, cArray, algorithmIdentifier);
                return (PrivateKey)cipher.unwrap(byArray, "", 2);
            }
        }
        catch (Exception exception) {
            throw new IOException("exception unwrapping private key - " + exception.toString());
        }
        throw new IOException("exception unwrapping private key - cannot recognise: " + aSN1ObjectIdentifier);
    }

    protected byte[] wrapKey(String string, Key key, PKCS12PBEParams pKCS12PBEParams, char[] cArray) throws IOException {
        byte[] byArray;
        PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
        try {
            SecretKeyFactory secretKeyFactory = this.helper.createSecretKeyFactory(string);
            PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(pKCS12PBEParams.getIV(), pKCS12PBEParams.getIterations().intValue());
            Cipher cipher = this.helper.createCipher(string);
            cipher.init(3, (Key)secretKeyFactory.generateSecret(pBEKeySpec), pBEParameterSpec);
            byArray = cipher.wrap(key);
        }
        catch (Exception exception) {
            throw new IOException("exception encrypting data - " + exception.toString());
        }
        return byArray;
    }

    protected byte[] cryptData(boolean bl2, AlgorithmIdentifier algorithmIdentifier, char[] cArray, boolean bl3, byte[] byArray) throws IOException {
        int n2;
        ASN1ObjectIdentifier aSN1ObjectIdentifier = algorithmIdentifier.getAlgorithm();
        int n3 = n2 = bl2 ? 1 : 2;
        if (aSN1ObjectIdentifier.on(PKCSObjectIdentifiers.pkcs_12PbeIds)) {
            PKCS12PBEParams pKCS12PBEParams = PKCS12PBEParams.getInstance((Object)algorithmIdentifier.getParameters());
            try {
                PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(pKCS12PBEParams.getIV(), pKCS12PBEParams.getIterations().intValue());
                PKCS12Key pKCS12Key = new PKCS12Key(cArray, bl3);
                Cipher cipher = this.helper.createCipher(aSN1ObjectIdentifier.getId());
                cipher.init(n2, (Key)pKCS12Key, pBEParameterSpec);
                return cipher.doFinal(byArray);
            }
            catch (Exception exception) {
                throw new IOException("exception decrypting data - " + exception.toString());
            }
        }
        if (aSN1ObjectIdentifier.equals((Object)PKCSObjectIdentifiers.id_PBES2)) {
            try {
                Cipher cipher = this.createCipher(n2, cArray, algorithmIdentifier);
                return cipher.doFinal(byArray);
            }
            catch (Exception exception) {
                throw new IOException("exception decrypting data - " + exception.toString());
            }
        }
        throw new IOException("unknown PBE algorithm: " + aSN1ObjectIdentifier);
    }

    private Cipher createCipher(int n2, char[] cArray, AlgorithmIdentifier algorithmIdentifier) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, NoSuchProviderException {
        PBES2Parameters pBES2Parameters = PBES2Parameters.getInstance((Object)algorithmIdentifier.getParameters());
        PBKDF2Params pBKDF2Params = PBKDF2Params.getInstance((Object)pBES2Parameters.getKeyDerivationFunc().getParameters());
        AlgorithmIdentifier algorithmIdentifier2 = AlgorithmIdentifier.getInstance((Object)pBES2Parameters.getEncryptionScheme());
        SecretKeyFactory secretKeyFactory = this.helper.createSecretKeyFactory(pBES2Parameters.getKeyDerivationFunc().getAlgorithm().getId());
        SecretKey secretKey = pBKDF2Params.isDefaultPrf() ? secretKeyFactory.generateSecret(new PBEKeySpec(cArray, pBKDF2Params.getSalt(), this.validateIterationCount(pBKDF2Params.getIterationCount()), keySizeProvider.getKeySize(algorithmIdentifier2))) : secretKeyFactory.generateSecret((KeySpec)new PBKDF2KeySpec(cArray, pBKDF2Params.getSalt(), this.validateIterationCount(pBKDF2Params.getIterationCount()), keySizeProvider.getKeySize(algorithmIdentifier2), pBKDF2Params.getPrf()));
        Cipher cipher = Cipher.getInstance(pBES2Parameters.getEncryptionScheme().getAlgorithm().getId());
        ASN1Encodable aSN1Encodable = pBES2Parameters.getEncryptionScheme().getParameters();
        if (aSN1Encodable instanceof ASN1OctetString) {
            cipher.init(n2, (Key)secretKey, new IvParameterSpec(ASN1OctetString.getInstance((Object)aSN1Encodable).getOctets()));
        } else {
            GOST28147Parameters gOST28147Parameters = GOST28147Parameters.getInstance((Object)aSN1Encodable);
            cipher.init(n2, (Key)secretKey, (AlgorithmParameterSpec)new GOST28147ParameterSpec(gOST28147Parameters.getEncryptionParamSet(), gOST28147Parameters.getIV()));
        }
        return cipher;
    }

    @Override
    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException {
        ASN1Sequence aSN1Sequence;
        Object object;
        ASN1Primitive aSN1Primitive;
        Object object2;
        PrivateKey privateKey;
        EncryptedPrivateKeyInfo encryptedPrivateKeyInfo;
        Object object3;
        Object object4;
        Object object5;
        SafeBag safeBag;
        MacData macData;
        Pfx pfx;
        if (inputStream == null) {
            return;
        }
        if (cArray == null) {
            throw new NullPointerException("No password supplied for PKCS#12 KeyStore.");
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        bufferedInputStream.mark(10);
        int n2 = bufferedInputStream.read();
        if (n2 != 48) {
            throw new IOException("stream does not represent a PKCS12 key store");
        }
        bufferedInputStream.reset();
        ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)bufferedInputStream);
        try {
            pfx = Pfx.getInstance((Object)aSN1InputStream.readObject());
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
        ContentInfo contentInfo = pfx.getAuthSafe();
        Vector<Object> vector = new Vector<Object>();
        boolean bl2 = false;
        boolean bl3 = false;
        if (pfx.getMacData() != null) {
            macData = pfx.getMacData();
            safeBag = macData.getMac();
            this.macAlgorithm = safeBag.getAlgorithmId();
            byte[] byArray = macData.getSalt();
            this.itCount = this.validateIterationCount(macData.getIterationCount());
            this.saltLength = byArray.length;
            object5 = ((ASN1OctetString)contentInfo.getContent()).getOctets();
            try {
                object4 = this.calculatePbeMac(this.macAlgorithm.getAlgorithm(), byArray, this.itCount, cArray, false, (byte[])object5);
                object3 = safeBag.getDigest();
                if (!Arrays.constantTimeAreEqual((byte[])object4, (byte[])object3)) {
                    if (cArray.length > 0) {
                        throw new IOException("PKCS12 key store mac invalid - wrong password or corrupted file.");
                    }
                    object4 = this.calculatePbeMac(this.macAlgorithm.getAlgorithm(), byArray, this.itCount, cArray, true, (byte[])object5);
                    if (!Arrays.constantTimeAreEqual((byte[])object4, (byte[])object3)) {
                        throw new IOException("PKCS12 key store mac invalid - wrong password or corrupted file.");
                    }
                    bl3 = true;
                }
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                throw new IOException("error constructing MAC: " + exception.toString());
            }
        }
        this.keys = new IgnoresCaseHashtable(null);
        this.localIds = new Hashtable();
        if (contentInfo.getContentType().equals((Object)data)) {
            aSN1InputStream = new ASN1InputStream(((ASN1OctetString)contentInfo.getContent()).getOctets());
            macData = AuthenticatedSafe.getInstance((Object)aSN1InputStream.readObject());
            safeBag = macData.getContentInfo();
            for (int i2 = 0; i2 != ((ContentInfo[])safeBag).length; ++i2) {
                ASN1Encodable aSN1Encodable;
                PKCS12BagAttributeCarrier pKCS12BagAttributeCarrier;
                ASN1Primitive aSN1Primitive2;
                Object object6;
                Object object7;
                if (safeBag[i2].getContentType().equals((Object)data)) {
                    object5 = new ASN1InputStream(((ASN1OctetString)safeBag[i2].getContent()).getOctets());
                    object4 = (ASN1Sequence)object5.readObject();
                    for (int i3 = 0; i3 != object4.size(); ++i3) {
                        SafeBag safeBag2 = SafeBag.getInstance((Object)object4.getObjectAt(i3));
                        if (safeBag2.getBagId().equals((Object)pkcs8ShroudedKeyBag)) {
                            encryptedPrivateKeyInfo = EncryptedPrivateKeyInfo.getInstance((Object)safeBag2.getBagValue());
                            privateKey = this.unwrapKey(encryptedPrivateKeyInfo.getEncryptionAlgorithm(), encryptedPrivateKeyInfo.getEncryptedData(), cArray, bl3);
                            object2 = null;
                            aSN1Primitive = null;
                            if (safeBag2.getBagAttributes() != null) {
                                object = safeBag2.getBagAttributes().getObjects();
                                while (object.hasMoreElements()) {
                                    aSN1Sequence = (ASN1Sequence)object.nextElement();
                                    object7 = (ASN1ObjectIdentifier)aSN1Sequence.getObjectAt(0);
                                    object6 = (ASN1Set)aSN1Sequence.getObjectAt(1);
                                    aSN1Primitive2 = null;
                                    if (object6.size() > 0) {
                                        aSN1Primitive2 = (ASN1Primitive)object6.getObjectAt(0);
                                        if (privateKey instanceof PKCS12BagAttributeCarrier) {
                                            pKCS12BagAttributeCarrier = (PKCS12BagAttributeCarrier)privateKey;
                                            aSN1Encodable = pKCS12BagAttributeCarrier.getBagAttribute((ASN1ObjectIdentifier)object7);
                                            if (aSN1Encodable != null) {
                                                if (!aSN1Encodable.toASN1Primitive().equals((Object)aSN1Primitive2)) {
                                                    throw new IOException("attempt to add existing attribute with different value");
                                                }
                                            } else {
                                                pKCS12BagAttributeCarrier.setBagAttribute((ASN1ObjectIdentifier)object7, (ASN1Encodable)aSN1Primitive2);
                                            }
                                        }
                                    }
                                    if (object7.equals((Object)pkcs_9_at_friendlyName)) {
                                        object2 = ((DERBMPString)aSN1Primitive2).getString();
                                        this.keys.put((String)object2, (Object)privateKey);
                                        continue;
                                    }
                                    if (!object7.equals((Object)pkcs_9_at_localKeyId)) continue;
                                    aSN1Primitive = (ASN1OctetString)aSN1Primitive2;
                                }
                            }
                            if (aSN1Primitive != null) {
                                object = new String(Hex.encode((byte[])aSN1Primitive.getOctets()));
                                if (object2 == null) {
                                    this.keys.put((String)object, (Object)privateKey);
                                    continue;
                                }
                                this.localIds.put(object2, object);
                                continue;
                            }
                            bl2 = true;
                            this.keys.put("unmarked", (Object)privateKey);
                            continue;
                        }
                        if (safeBag2.getBagId().equals((Object)certBag)) {
                            vector.addElement(safeBag2);
                            continue;
                        }
                        System.out.println("extra in data " + safeBag2.getBagId());
                        System.out.println(ASN1Dump.dumpAsString((Object)safeBag2));
                    }
                    continue;
                }
                if (safeBag[i2].getContentType().equals((Object)encryptedData)) {
                    object5 = EncryptedData.getInstance((Object)safeBag[i2].getContent());
                    object4 = this.cryptData(false, object5.getEncryptionAlgorithm(), cArray, bl3, object5.getContent().getOctets());
                    object3 = (ASN1Sequence)ASN1Primitive.fromByteArray((byte[])object4);
                    for (int i4 = 0; i4 != object3.size(); ++i4) {
                        ASN1Encodable aSN1Encodable2;
                        encryptedPrivateKeyInfo = SafeBag.getInstance((Object)object3.getObjectAt(i4));
                        if (encryptedPrivateKeyInfo.getBagId().equals((Object)certBag)) {
                            vector.addElement(encryptedPrivateKeyInfo);
                            continue;
                        }
                        if (encryptedPrivateKeyInfo.getBagId().equals((Object)pkcs8ShroudedKeyBag)) {
                            privateKey = EncryptedPrivateKeyInfo.getInstance((Object)encryptedPrivateKeyInfo.getBagValue());
                            object2 = this.unwrapKey(privateKey.getEncryptionAlgorithm(), privateKey.getEncryptedData(), cArray, bl3);
                            aSN1Primitive = (PKCS12BagAttributeCarrier)object2;
                            object = null;
                            aSN1Sequence = null;
                            object7 = encryptedPrivateKeyInfo.getBagAttributes().getObjects();
                            while (object7.hasMoreElements()) {
                                object6 = (ASN1Sequence)object7.nextElement();
                                aSN1Primitive2 = (ASN1ObjectIdentifier)object6.getObjectAt(0);
                                pKCS12BagAttributeCarrier = (ASN1Set)object6.getObjectAt(1);
                                aSN1Encodable = null;
                                if (pKCS12BagAttributeCarrier.size() > 0) {
                                    aSN1Encodable = (ASN1Primitive)pKCS12BagAttributeCarrier.getObjectAt(0);
                                    aSN1Encodable2 = aSN1Primitive.getBagAttribute((ASN1ObjectIdentifier)aSN1Primitive2);
                                    if (aSN1Encodable2 != null) {
                                        if (!aSN1Encodable2.toASN1Primitive().equals((Object)aSN1Encodable)) {
                                            throw new IOException("attempt to add existing attribute with different value");
                                        }
                                    } else {
                                        aSN1Primitive.setBagAttribute((ASN1ObjectIdentifier)aSN1Primitive2, aSN1Encodable);
                                    }
                                }
                                if (aSN1Primitive2.equals((Object)pkcs_9_at_friendlyName)) {
                                    object = ((DERBMPString)aSN1Encodable).getString();
                                    this.keys.put((String)object, object2);
                                    continue;
                                }
                                if (!aSN1Primitive2.equals((Object)pkcs_9_at_localKeyId)) continue;
                                aSN1Sequence = (ASN1OctetString)aSN1Encodable;
                            }
                            object6 = new String(Hex.encode((byte[])aSN1Sequence.getOctets()));
                            if (object == null) {
                                this.keys.put((String)object6, object2);
                                continue;
                            }
                            this.localIds.put(object, object6);
                            continue;
                        }
                        if (encryptedPrivateKeyInfo.getBagId().equals((Object)keyBag)) {
                            privateKey = PrivateKeyInfo.getInstance((Object)encryptedPrivateKeyInfo.getBagValue());
                            object2 = BouncyCastleProvider.getPrivateKey((PrivateKeyInfo)privateKey);
                            aSN1Primitive = (PKCS12BagAttributeCarrier)object2;
                            object = null;
                            aSN1Sequence = null;
                            object7 = encryptedPrivateKeyInfo.getBagAttributes().getObjects();
                            while (object7.hasMoreElements()) {
                                object6 = ASN1Sequence.getInstance(object7.nextElement());
                                aSN1Primitive2 = ASN1ObjectIdentifier.getInstance((Object)object6.getObjectAt(0));
                                pKCS12BagAttributeCarrier = ASN1Set.getInstance((Object)object6.getObjectAt(1));
                                aSN1Encodable = null;
                                if (pKCS12BagAttributeCarrier.size() <= 0) continue;
                                aSN1Encodable = (ASN1Primitive)pKCS12BagAttributeCarrier.getObjectAt(0);
                                aSN1Encodable2 = aSN1Primitive.getBagAttribute((ASN1ObjectIdentifier)aSN1Primitive2);
                                if (aSN1Encodable2 != null) {
                                    if (!aSN1Encodable2.toASN1Primitive().equals((Object)aSN1Encodable)) {
                                        throw new IOException("attempt to add existing attribute with different value");
                                    }
                                } else {
                                    aSN1Primitive.setBagAttribute((ASN1ObjectIdentifier)aSN1Primitive2, aSN1Encodable);
                                }
                                if (aSN1Primitive2.equals((Object)pkcs_9_at_friendlyName)) {
                                    object = ((DERBMPString)aSN1Encodable).getString();
                                    this.keys.put((String)object, object2);
                                    continue;
                                }
                                if (!aSN1Primitive2.equals((Object)pkcs_9_at_localKeyId)) continue;
                                aSN1Sequence = (ASN1OctetString)aSN1Encodable;
                            }
                            object6 = new String(Hex.encode((byte[])aSN1Sequence.getOctets()));
                            if (object == null) {
                                this.keys.put((String)object6, object2);
                                continue;
                            }
                            this.localIds.put(object, object6);
                            continue;
                        }
                        System.out.println("extra in encryptedData " + encryptedPrivateKeyInfo.getBagId());
                        System.out.println(ASN1Dump.dumpAsString((Object)encryptedPrivateKeyInfo));
                    }
                    continue;
                }
                System.out.println("extra " + safeBag[i2].getContentType().getId());
                System.out.println("extra " + ASN1Dump.dumpAsString((Object)safeBag[i2].getContent()));
            }
        }
        this.certs = new IgnoresCaseHashtable(null);
        this.chainCerts = new Hashtable();
        this.keyCerts = new Hashtable();
        for (int i5 = 0; i5 != vector.size(); ++i5) {
            Object object8;
            safeBag = (SafeBag)vector.elementAt(i5);
            CertBag certBag = CertBag.getInstance((Object)safeBag.getBagValue());
            if (!certBag.getCertId().equals((Object)x509Certificate)) {
                throw new RuntimeException("Unsupported certificate type: " + certBag.getCertId());
            }
            try {
                object4 = new ByteArrayInputStream(((ASN1OctetString)certBag.getCertValue()).getOctets());
                object5 = this.certFact.generateCertificate((InputStream)object4);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.toString());
            }
            object4 = null;
            object3 = null;
            if (safeBag.getBagAttributes() != null) {
                object8 = safeBag.getBagAttributes().getObjects();
                while (object8.hasMoreElements()) {
                    encryptedPrivateKeyInfo = ASN1Sequence.getInstance(object8.nextElement());
                    privateKey = ASN1ObjectIdentifier.getInstance((Object)encryptedPrivateKeyInfo.getObjectAt(0));
                    object2 = ASN1Set.getInstance((Object)encryptedPrivateKeyInfo.getObjectAt(1));
                    if (object2.size() <= 0) continue;
                    aSN1Primitive = (ASN1Primitive)object2.getObjectAt(0);
                    object = null;
                    if (object5 instanceof PKCS12BagAttributeCarrier) {
                        object = (PKCS12BagAttributeCarrier)object5;
                        aSN1Sequence = object.getBagAttribute((ASN1ObjectIdentifier)privateKey);
                        if (aSN1Sequence != null) {
                            if (!aSN1Sequence.toASN1Primitive().equals((Object)aSN1Primitive)) {
                                throw new IOException("attempt to add existing attribute with different value");
                            }
                        } else {
                            object.setBagAttribute((ASN1ObjectIdentifier)privateKey, (ASN1Encodable)aSN1Primitive);
                        }
                    }
                    if (privateKey.equals(pkcs_9_at_friendlyName)) {
                        object3 = ((DERBMPString)aSN1Primitive).getString();
                        continue;
                    }
                    if (!privateKey.equals(pkcs_9_at_localKeyId)) continue;
                    object4 = (ASN1OctetString)aSN1Primitive;
                }
            }
            this.chainCerts.put(new CertId(this, ((Certificate)object5).getPublicKey()), object5);
            if (bl2) {
                if (!this.keyCerts.isEmpty()) continue;
                object8 = new String(Hex.encode((byte[])this.createSubjectKeyId(((Certificate)object5).getPublicKey()).getKeyIdentifier()));
                this.keyCerts.put(object8, object5);
                this.keys.put((String)object8, this.keys.remove("unmarked"));
                continue;
            }
            if (object4 != null) {
                object8 = new String(Hex.encode((byte[])object4.getOctets()));
                this.keyCerts.put(object8, object5);
            }
            if (object3 == null) continue;
            this.certs.put((String)object3, object5);
        }
    }

    private int validateIterationCount(BigInteger bigInteger) {
        int n2 = bigInteger.intValue();
        if (n2 < 0) {
            throw new IllegalStateException("negative iteration count found");
        }
        BigInteger bigInteger2 = Properties.asBigInteger((String)"macromedia.externals.org.bouncycastle_1_60_0_0.pkcs12.max_it_count");
        if (bigInteger2 != null && bigInteger2.intValue() < n2) {
            throw new IllegalStateException("iteration count " + n2 + " greater than " + bigInteger2.intValue());
        }
        return n2;
    }

    @Override
    public void engineStore(KeyStore.LoadStoreParameter loadStoreParameter) throws IOException, NoSuchAlgorithmException, CertificateException {
        char[] cArray;
        if (loadStoreParameter == null) {
            throw new IllegalArgumentException("'param' arg cannot be null");
        }
        if (!(loadStoreParameter instanceof PKCS12StoreParameter) && !(loadStoreParameter instanceof JDKPKCS12StoreParameter)) {
            throw new IllegalArgumentException("No support for 'param' of type " + loadStoreParameter.getClass().getName());
        }
        PKCS12StoreParameter pKCS12StoreParameter = loadStoreParameter instanceof PKCS12StoreParameter ? (PKCS12StoreParameter)loadStoreParameter : new PKCS12StoreParameter(((JDKPKCS12StoreParameter)loadStoreParameter).getOutputStream(), loadStoreParameter.getProtectionParameter(), ((JDKPKCS12StoreParameter)loadStoreParameter).isUseDEREncoding());
        KeyStore.ProtectionParameter protectionParameter = loadStoreParameter.getProtectionParameter();
        if (protectionParameter == null) {
            cArray = null;
        } else if (protectionParameter instanceof KeyStore.PasswordProtection) {
            cArray = ((KeyStore.PasswordProtection)protectionParameter).getPassword();
        } else {
            throw new IllegalArgumentException("No support for protection parameter of type " + protectionParameter.getClass().getName());
        }
        this.doStore(pKCS12StoreParameter.getOutputStream(), cArray, pKCS12StoreParameter.isForDEREncoding());
    }

    @Override
    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException {
        this.doStore(outputStream, cArray, false);
    }

    private void doStore(OutputStream outputStream, char[] cArray, boolean bl2) throws IOException {
        MacData macData;
        Object object;
        ASN1EncodableVector aSN1EncodableVector;
        Object object2;
        Enumeration enumeration;
        Object object3;
        PKCS12BagAttributeCarrier pKCS12BagAttributeCarrier;
        ContentInfo[] contentInfoArray;
        Object object4;
        Object object5;
        Object object6;
        EncryptedPrivateKeyInfo encryptedPrivateKeyInfo;
        AlgorithmIdentifier algorithmIdentifier;
        Object object7;
        PKCS12PBEParams pKCS12PBEParams;
        Object object8;
        String string;
        byte[] byArray;
        if (cArray == null) {
            throw new NullPointerException("No password supplied for PKCS#12 KeyStore.");
        }
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        Enumeration enumeration2 = this.keys.keys();
        while (enumeration2.hasMoreElements()) {
            Object object9;
            byArray = new byte[20];
            this.random.nextBytes(byArray);
            string = (String)enumeration2.nextElement();
            object8 = (PrivateKey)this.keys.get(string);
            pKCS12PBEParams = new PKCS12PBEParams(byArray, 51200);
            object7 = this.wrapKey(this.keyAlgorithm.getId(), (Key)object8, pKCS12PBEParams, cArray);
            algorithmIdentifier = new AlgorithmIdentifier(this.keyAlgorithm, (ASN1Encodable)pKCS12PBEParams.toASN1Primitive());
            encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(algorithmIdentifier, (byte[])object7);
            boolean bl3 = false;
            object6 = new ASN1EncodableVector();
            if (object8 instanceof PKCS12BagAttributeCarrier) {
                object5 = (PKCS12BagAttributeCarrier)object8;
                object9 = (DERBMPString)object5.getBagAttribute(pkcs_9_at_friendlyName);
                if (object9 == null || !object9.getString().equals(string)) {
                    object5.setBagAttribute(pkcs_9_at_friendlyName, (ASN1Encodable)new DERBMPString(string));
                }
                if (object5.getBagAttribute(pkcs_9_at_localKeyId) == null) {
                    object4 = this.engineGetCertificate(string);
                    object5.setBagAttribute(pkcs_9_at_localKeyId, (ASN1Encodable)this.createSubjectKeyId(((Certificate)object4).getPublicKey()));
                }
                object4 = object5.getBagAttributeKeys();
                while (object4.hasMoreElements()) {
                    contentInfoArray = (ASN1ObjectIdentifier)object4.nextElement();
                    pKCS12BagAttributeCarrier = new ASN1EncodableVector();
                    pKCS12BagAttributeCarrier.add((ASN1Encodable)contentInfoArray);
                    pKCS12BagAttributeCarrier.add((ASN1Encodable)new DERSet(object5.getBagAttribute((ASN1ObjectIdentifier)contentInfoArray)));
                    bl3 = true;
                    object6.add((ASN1Encodable)new DERSequence((ASN1EncodableVector)pKCS12BagAttributeCarrier));
                }
            }
            if (!bl3) {
                object5 = new ASN1EncodableVector();
                object9 = this.engineGetCertificate(string);
                object5.add((ASN1Encodable)pkcs_9_at_localKeyId);
                object5.add((ASN1Encodable)new DERSet((ASN1Encodable)this.createSubjectKeyId(((Certificate)object9).getPublicKey())));
                object6.add((ASN1Encodable)new DERSequence((ASN1EncodableVector)object5));
                object5 = new ASN1EncodableVector();
                object5.add((ASN1Encodable)pkcs_9_at_friendlyName);
                object5.add((ASN1Encodable)new DERSet((ASN1Encodable)new DERBMPString(string)));
                object6.add((ASN1Encodable)new DERSequence((ASN1EncodableVector)object5));
            }
            object5 = new SafeBag(pkcs8ShroudedKeyBag, (ASN1Encodable)encryptedPrivateKeyInfo.toASN1Primitive(), (ASN1Set)new DERSet((ASN1EncodableVector)object6));
            aSN1EncodableVector2.add((ASN1Encodable)object5);
        }
        byArray = new DERSequence(aSN1EncodableVector2).getEncoded("DER");
        string = new BEROctetString(byArray);
        object8 = new byte[20];
        this.random.nextBytes((byte[])object8);
        pKCS12PBEParams = new ASN1EncodableVector();
        object7 = new PKCS12PBEParams(object8, 51200);
        algorithmIdentifier = new AlgorithmIdentifier(this.certAlgorithm, (ASN1Encodable)object7.toASN1Primitive());
        encryptedPrivateKeyInfo = new Hashtable();
        Enumeration enumeration3 = this.keys.keys();
        while (enumeration3.hasMoreElements()) {
            try {
                object6 = (String)enumeration3.nextElement();
                object5 = this.engineGetCertificate((String)object6);
                boolean bl4 = false;
                object4 = new CertBag(x509Certificate, (ASN1Encodable)new DEROctetString(((Certificate)object5).getEncoded()));
                contentInfoArray = new ASN1EncodableVector();
                if (object5 instanceof PKCS12BagAttributeCarrier) {
                    pKCS12BagAttributeCarrier = (PKCS12BagAttributeCarrier)object5;
                    object3 = (DERBMPString)pKCS12BagAttributeCarrier.getBagAttribute(pkcs_9_at_friendlyName);
                    if (object3 == null || !object3.getString().equals(object6)) {
                        pKCS12BagAttributeCarrier.setBagAttribute(pkcs_9_at_friendlyName, (ASN1Encodable)new DERBMPString((String)object6));
                    }
                    if (pKCS12BagAttributeCarrier.getBagAttribute(pkcs_9_at_localKeyId) == null) {
                        pKCS12BagAttributeCarrier.setBagAttribute(pkcs_9_at_localKeyId, (ASN1Encodable)this.createSubjectKeyId(((Certificate)object5).getPublicKey()));
                    }
                    enumeration = pKCS12BagAttributeCarrier.getBagAttributeKeys();
                    while (enumeration.hasMoreElements()) {
                        object2 = (ASN1ObjectIdentifier)enumeration.nextElement();
                        aSN1EncodableVector = new ASN1EncodableVector();
                        aSN1EncodableVector.add((ASN1Encodable)object2);
                        aSN1EncodableVector.add((ASN1Encodable)new DERSet(pKCS12BagAttributeCarrier.getBagAttribute(object2)));
                        contentInfoArray.add((ASN1Encodable)new DERSequence(aSN1EncodableVector));
                        bl4 = true;
                    }
                }
                if (!bl4) {
                    pKCS12BagAttributeCarrier = new ASN1EncodableVector();
                    pKCS12BagAttributeCarrier.add((ASN1Encodable)pkcs_9_at_localKeyId);
                    pKCS12BagAttributeCarrier.add((ASN1Encodable)new DERSet((ASN1Encodable)this.createSubjectKeyId(((Certificate)object5).getPublicKey())));
                    contentInfoArray.add((ASN1Encodable)new DERSequence((ASN1EncodableVector)pKCS12BagAttributeCarrier));
                    pKCS12BagAttributeCarrier = new ASN1EncodableVector();
                    pKCS12BagAttributeCarrier.add((ASN1Encodable)pkcs_9_at_friendlyName);
                    pKCS12BagAttributeCarrier.add((ASN1Encodable)new DERSet((ASN1Encodable)new DERBMPString((String)object6)));
                    contentInfoArray.add((ASN1Encodable)new DERSequence((ASN1EncodableVector)pKCS12BagAttributeCarrier));
                }
                pKCS12BagAttributeCarrier = new SafeBag(certBag, (ASN1Encodable)object4.toASN1Primitive(), (ASN1Set)new DERSet((ASN1EncodableVector)contentInfoArray));
                pKCS12PBEParams.add((ASN1Encodable)pKCS12BagAttributeCarrier);
                encryptedPrivateKeyInfo.put(object5, object5);
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new IOException("Error encoding certificate: " + certificateEncodingException.toString());
            }
        }
        enumeration3 = this.certs.keys();
        while (enumeration3.hasMoreElements()) {
            try {
                object6 = (String)enumeration3.nextElement();
                object5 = (Certificate)this.certs.get((String)object6);
                boolean bl5 = false;
                if (this.keys.get((String)object6) != null) continue;
                object4 = new CertBag(x509Certificate, (ASN1Encodable)new DEROctetString(((Certificate)object5).getEncoded()));
                contentInfoArray = new ASN1EncodableVector();
                if (object5 instanceof PKCS12BagAttributeCarrier) {
                    pKCS12BagAttributeCarrier = (PKCS12BagAttributeCarrier)object5;
                    object3 = (DERBMPString)pKCS12BagAttributeCarrier.getBagAttribute(pkcs_9_at_friendlyName);
                    if (object3 == null || !object3.getString().equals(object6)) {
                        pKCS12BagAttributeCarrier.setBagAttribute(pkcs_9_at_friendlyName, (ASN1Encodable)new DERBMPString((String)object6));
                    }
                    enumeration = pKCS12BagAttributeCarrier.getBagAttributeKeys();
                    while (enumeration.hasMoreElements()) {
                        object2 = (ASN1ObjectIdentifier)enumeration.nextElement();
                        if (object2.equals((Object)PKCSObjectIdentifiers.pkcs_9_at_localKeyId)) continue;
                        aSN1EncodableVector = new ASN1EncodableVector();
                        aSN1EncodableVector.add((ASN1Encodable)object2);
                        aSN1EncodableVector.add((ASN1Encodable)new DERSet(pKCS12BagAttributeCarrier.getBagAttribute(object2)));
                        contentInfoArray.add((ASN1Encodable)new DERSequence(aSN1EncodableVector));
                        bl5 = true;
                    }
                }
                if (!bl5) {
                    pKCS12BagAttributeCarrier = new ASN1EncodableVector();
                    pKCS12BagAttributeCarrier.add((ASN1Encodable)pkcs_9_at_friendlyName);
                    pKCS12BagAttributeCarrier.add((ASN1Encodable)new DERSet((ASN1Encodable)new DERBMPString((String)object6)));
                    contentInfoArray.add((ASN1Encodable)new DERSequence((ASN1EncodableVector)pKCS12BagAttributeCarrier));
                }
                pKCS12BagAttributeCarrier = new SafeBag(certBag, (ASN1Encodable)object4.toASN1Primitive(), (ASN1Set)new DERSet((ASN1EncodableVector)contentInfoArray));
                pKCS12PBEParams.add((ASN1Encodable)pKCS12BagAttributeCarrier);
                encryptedPrivateKeyInfo.put(object5, object5);
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new IOException("Error encoding certificate: " + certificateEncodingException.toString());
            }
        }
        object6 = this.getUsedCertificateSet();
        enumeration3 = this.chainCerts.keys();
        while (enumeration3.hasMoreElements()) {
            try {
                object5 = (CertId)enumeration3.nextElement();
                Certificate certificate = (Certificate)this.chainCerts.get(object5);
                if (!object6.contains(certificate) || encryptedPrivateKeyInfo.get(certificate) != null) continue;
                object4 = new CertBag(x509Certificate, (ASN1Encodable)new DEROctetString(certificate.getEncoded()));
                contentInfoArray = new ASN1EncodableVector();
                if (certificate instanceof PKCS12BagAttributeCarrier) {
                    pKCS12BagAttributeCarrier = (PKCS12BagAttributeCarrier)certificate;
                    object3 = pKCS12BagAttributeCarrier.getBagAttributeKeys();
                    while (object3.hasMoreElements()) {
                        enumeration = (ASN1ObjectIdentifier)object3.nextElement();
                        if (enumeration.equals(PKCSObjectIdentifiers.pkcs_9_at_localKeyId)) continue;
                        object2 = new ASN1EncodableVector();
                        object2.add((ASN1Encodable)enumeration);
                        object2.add((ASN1Encodable)new DERSet(pKCS12BagAttributeCarrier.getBagAttribute((ASN1ObjectIdentifier)enumeration)));
                        contentInfoArray.add((ASN1Encodable)new DERSequence((ASN1EncodableVector)object2));
                    }
                }
                pKCS12BagAttributeCarrier = new SafeBag(certBag, (ASN1Encodable)object4.toASN1Primitive(), (ASN1Set)new DERSet((ASN1EncodableVector)contentInfoArray));
                pKCS12PBEParams.add((ASN1Encodable)pKCS12BagAttributeCarrier);
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new IOException("Error encoding certificate: " + certificateEncodingException.toString());
            }
        }
        object5 = new DERSequence((ASN1EncodableVector)pKCS12PBEParams).getEncoded("DER");
        byte[] byArray2 = this.cryptData(true, algorithmIdentifier, cArray, false, (byte[])object5);
        object4 = new EncryptedData(data, algorithmIdentifier, (ASN1Encodable)new BEROctetString(byArray2));
        contentInfoArray = new ContentInfo[]{new ContentInfo(data, (ASN1Encodable)string), new ContentInfo(encryptedData, (ASN1Encodable)object4.toASN1Primitive())};
        pKCS12BagAttributeCarrier = new AuthenticatedSafe(contentInfoArray);
        object3 = new ByteArrayOutputStream();
        enumeration = bl2 ? new DEROutputStream((OutputStream)object3) : new BEROutputStream((OutputStream)object3);
        enumeration.writeObject((ASN1Encodable)pKCS12BagAttributeCarrier);
        object2 = ((ByteArrayOutputStream)object3).toByteArray();
        aSN1EncodableVector = new ContentInfo(data, (ASN1Encodable)new BEROctetString((byte[])object2));
        byte[] byArray3 = new byte[this.saltLength];
        this.random.nextBytes(byArray3);
        byte[] byArray4 = ((ASN1OctetString)aSN1EncodableVector.getContent()).getOctets();
        try {
            object = this.calculatePbeMac(this.macAlgorithm.getAlgorithm(), byArray3, this.itCount, cArray, false, byArray4);
            DigestInfo digestInfo = new DigestInfo(this.macAlgorithm, object);
            macData = new MacData(digestInfo, byArray3, this.itCount);
        }
        catch (Exception exception) {
            throw new IOException("error constructing MAC: " + exception.toString());
        }
        object = new Pfx((ContentInfo)aSN1EncodableVector, macData);
        enumeration = bl2 ? new DEROutputStream(outputStream) : new BEROutputStream(outputStream);
        enumeration.writeObject((ASN1Encodable)object);
    }

    private Set getUsedCertificateSet() {
        Object object;
        String string;
        HashSet<Object> hashSet = new HashSet<Object>();
        Enumeration enumeration = this.keys.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            object = this.engineGetCertificateChain(string);
            for (int i2 = 0; i2 != ((Certificate[])object).length; ++i2) {
                hashSet.add(object[i2]);
            }
        }
        enumeration = this.certs.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            object = this.engineGetCertificate(string);
            hashSet.add(object);
        }
        return hashSet;
    }

    private byte[] calculatePbeMac(ASN1ObjectIdentifier aSN1ObjectIdentifier, byte[] byArray, int n2, char[] cArray, boolean bl2, byte[] byArray2) throws Exception {
        PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(byArray, n2);
        Mac mac = this.helper.createMac(aSN1ObjectIdentifier.getId());
        mac.init((Key)new PKCS12Key(cArray, bl2), pBEParameterSpec);
        mac.update(byArray2);
        return mac.doFinal();
    }

    private static synchronized Provider getBouncyCastleProvider() {
        if (Security.getProvider("BC") != null) {
            return Security.getProvider("BC");
        }
        if (provider == null) {
            provider = new BouncyCastleProvider();
        }
        return provider;
    }

    static /* synthetic */ SubjectKeyIdentifier access$100(PKCS12KeyStoreSpi pKCS12KeyStoreSpi, PublicKey publicKey) {
        return pKCS12KeyStoreSpi.createSubjectKeyId(publicKey);
    }

    static /* synthetic */ Provider access$200() {
        return PKCS12KeyStoreSpi.getBouncyCastleProvider();
    }
}

