/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.asymmetric.x509;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.security.NoSuchProviderException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.security.auth.x500.X500Principal;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Encodable;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1EncodableVector;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1InputStream;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Integer;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Primitive;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Sequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Set;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERSequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERSet;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.pkcs.ContentInfo;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.pkcs.PKCSObjectIdentifiers;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.pkcs.SignedData;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.util.BCJcaJceHelper;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.util.JcaJceHelper;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.io.pem.PemObject;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.io.pem.PemObjectGenerator;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.io.pem.PemWriter;

public class PKIXCertPath
extends CertPath {
    private final JcaJceHelper helper;
    static final List certPathEncodings;
    private List certificates;

    private List sortCerts(List list) {
        int n2;
        Serializable serializable;
        if (list.size() < 2) {
            return list;
        }
        X500Principal x500Principal = ((X509Certificate)list.get(0)).getIssuerX500Principal();
        boolean bl2 = true;
        for (int i2 = 1; i2 != list.size(); ++i2) {
            serializable = (X509Certificate)list.get(i2);
            if (!x500Principal.equals(serializable.getSubjectX500Principal())) {
                bl2 = false;
                break;
            }
            x500Principal = ((X509Certificate)list.get(i2)).getIssuerX500Principal();
        }
        if (bl2) {
            return list;
        }
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>(list.size());
        serializable = new ArrayList(list);
        for (n2 = 0; n2 < list.size(); ++n2) {
            X509Certificate x509Certificate = (X509Certificate)list.get(n2);
            boolean bl3 = false;
            X500Principal x500Principal2 = x509Certificate.getSubjectX500Principal();
            for (int i3 = 0; i3 != list.size(); ++i3) {
                X509Certificate x509Certificate2 = (X509Certificate)list.get(i3);
                if (!x509Certificate2.getIssuerX500Principal().equals(x500Principal2)) continue;
                bl3 = true;
                break;
            }
            if (bl3) continue;
            arrayList.add(x509Certificate);
            list.remove(n2);
        }
        if (arrayList.size() > 1) {
            return serializable;
        }
        block3: for (n2 = 0; n2 != arrayList.size(); ++n2) {
            x500Principal = ((X509Certificate)arrayList.get(n2)).getIssuerX500Principal();
            for (int i4 = 0; i4 < list.size(); ++i4) {
                X509Certificate x509Certificate = (X509Certificate)list.get(i4);
                if (!x500Principal.equals(x509Certificate.getSubjectX500Principal())) continue;
                arrayList.add(x509Certificate);
                list.remove(i4);
                continue block3;
            }
        }
        if (list.size() > 0) {
            return serializable;
        }
        return arrayList;
    }

    PKIXCertPath(List list) {
        super("X.509");
        this.helper = new BCJcaJceHelper();
        this.certificates = this.sortCerts(new ArrayList(list));
    }

    PKIXCertPath(InputStream inputStream, String string) throws CertificateException {
        block8: {
            super("X.509");
            this.helper = new BCJcaJceHelper();
            try {
                if (string.equalsIgnoreCase("PkiPath")) {
                    ASN1InputStream aSN1InputStream = new ASN1InputStream(inputStream);
                    ASN1Primitive aSN1Primitive = aSN1InputStream.readObject();
                    if (!(aSN1Primitive instanceof ASN1Sequence)) {
                        throw new CertificateException("input stream does not contain a ASN1 SEQUENCE while reading PkiPath encoded data to load CertPath");
                    }
                    Enumeration enumeration = ((ASN1Sequence)aSN1Primitive).getObjects();
                    this.certificates = new ArrayList();
                    CertificateFactory certificateFactory = this.helper.createCertificateFactory("X.509");
                    while (enumeration.hasMoreElements()) {
                        ASN1Encodable aSN1Encodable = (ASN1Encodable)enumeration.nextElement();
                        byte[] byArray = aSN1Encodable.toASN1Primitive().getEncoded("DER");
                        this.certificates.add(0, certificateFactory.generateCertificate(new ByteArrayInputStream(byArray)));
                    }
                    break block8;
                }
                if (string.equalsIgnoreCase("PKCS7") || string.equalsIgnoreCase("PEM")) {
                    Certificate certificate;
                    inputStream = new BufferedInputStream(inputStream);
                    this.certificates = new ArrayList();
                    CertificateFactory certificateFactory = this.helper.createCertificateFactory("X.509");
                    while ((certificate = certificateFactory.generateCertificate(inputStream)) != null) {
                        this.certificates.add(certificate);
                    }
                    break block8;
                }
                throw new CertificateException("unsupported encoding: " + string);
            }
            catch (IOException iOException) {
                throw new CertificateException("IOException throw while decoding CertPath:\n" + iOException.toString());
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new CertificateException("BouncyCastle provider not found while trying to get a CertificateFactory:\n" + noSuchProviderException.toString());
            }
        }
        this.certificates = this.sortCerts(this.certificates);
    }

    public Iterator getEncodings() {
        return certPathEncodings.iterator();
    }

    @Override
    public byte[] getEncoded() throws CertificateEncodingException {
        Object e2;
        Iterator iterator = this.getEncodings();
        if (iterator.hasNext() && (e2 = iterator.next()) instanceof String) {
            return this.getEncoded((String)e2);
        }
        return null;
    }

    @Override
    public byte[] getEncoded(String string) throws CertificateEncodingException {
        if (string.equalsIgnoreCase("PkiPath")) {
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            ListIterator listIterator = this.certificates.listIterator(this.certificates.size());
            while (listIterator.hasPrevious()) {
                aSN1EncodableVector.add((ASN1Encodable)this.toASN1Object((X509Certificate)listIterator.previous()));
            }
            return this.toDEREncoded((ASN1Encodable)new DERSequence(aSN1EncodableVector));
        }
        if (string.equalsIgnoreCase("PKCS7")) {
            ContentInfo contentInfo = new ContentInfo(PKCSObjectIdentifiers.data, null);
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            for (int i2 = 0; i2 != this.certificates.size(); ++i2) {
                aSN1EncodableVector.add((ASN1Encodable)this.toASN1Object((X509Certificate)this.certificates.get(i2)));
            }
            SignedData signedData = new SignedData(new ASN1Integer(1L), (ASN1Set)new DERSet(), contentInfo, (ASN1Set)new DERSet(aSN1EncodableVector), null, (ASN1Set)new DERSet());
            return this.toDEREncoded((ASN1Encodable)new ContentInfo(PKCSObjectIdentifiers.signedData, (ASN1Encodable)signedData));
        }
        if (string.equalsIgnoreCase("PEM")) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PemWriter pemWriter = new PemWriter((Writer)new OutputStreamWriter(byteArrayOutputStream));
            try {
                for (int i3 = 0; i3 != this.certificates.size(); ++i3) {
                    pemWriter.writeObject((PemObjectGenerator)new PemObject("CERTIFICATE", ((X509Certificate)this.certificates.get(i3)).getEncoded()));
                }
                pemWriter.close();
            }
            catch (Exception exception) {
                throw new CertificateEncodingException("can't encode certificate for PEM encoded path");
            }
            return byteArrayOutputStream.toByteArray();
        }
        throw new CertificateEncodingException("unsupported encoding: " + string);
    }

    public List getCertificates() {
        return Collections.unmodifiableList(new ArrayList(this.certificates));
    }

    private ASN1Primitive toASN1Object(X509Certificate x509Certificate) throws CertificateEncodingException {
        try {
            return new ASN1InputStream(x509Certificate.getEncoded()).readObject();
        }
        catch (Exception exception) {
            throw new CertificateEncodingException("Exception while encoding certificate: " + exception.toString());
        }
    }

    private byte[] toDEREncoded(ASN1Encodable aSN1Encodable) throws CertificateEncodingException {
        try {
            return aSN1Encodable.toASN1Primitive().getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException("Exception thrown: " + iOException);
        }
    }

    static {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("PkiPath");
        arrayList.add("PEM");
        arrayList.add("PKCS7");
        certPathEncodings = Collections.unmodifiableList(arrayList);
    }
}

