/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.asymmetric.ec;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.spec.AlgorithmParameterSpec;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.CipherParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.CryptoException;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.AsymmetricKeyParameter;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ParametersWithID;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ParametersWithRandom;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.signers.SM2Signer;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.asymmetric.ec.ECUtils;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.asymmetric.util.ECUtil;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.spec.SM2ParameterSpec;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.util.BCJcaJceHelper;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.util.JcaJceHelper;

public class GMSignatureSpi
extends SignatureSpi {
    private final JcaJceHelper helper = new BCJcaJceHelper();
    private AlgorithmParameters engineParams;
    private SM2ParameterSpec paramSpec;
    private final SM2Signer signer;

    GMSignatureSpi(SM2Signer sM2Signer) {
        this.signer = sM2Signer;
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        AsymmetricKeyParameter asymmetricKeyParameter = ECUtils.generatePublicKeyParameter((PublicKey)publicKey);
        if (this.paramSpec != null) {
            asymmetricKeyParameter = new ParametersWithID((CipherParameters)asymmetricKeyParameter, this.paramSpec.getID());
        }
        this.signer.init(false, (CipherParameters)asymmetricKeyParameter);
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        AsymmetricKeyParameter asymmetricKeyParameter = ECUtil.generatePrivateKeyParameter((PrivateKey)privateKey);
        if (this.appRandom != null) {
            asymmetricKeyParameter = new ParametersWithRandom((CipherParameters)asymmetricKeyParameter, this.appRandom);
        }
        if (this.paramSpec != null) {
            this.signer.init(true, (CipherParameters)new ParametersWithID((CipherParameters)asymmetricKeyParameter, this.paramSpec.getID()));
        } else {
            this.signer.init(true, (CipherParameters)asymmetricKeyParameter);
        }
    }

    protected void engineUpdate(byte by2) throws SignatureException {
        this.signer.update(by2);
    }

    protected void engineUpdate(byte[] byArray, int n2, int n3) throws SignatureException {
        this.signer.update(byArray, n2, n3);
    }

    protected byte[] engineSign() throws SignatureException {
        try {
            return this.signer.generateSignature();
        }
        catch (CryptoException cryptoException) {
            throw new SignatureException("unable to create signature: " + cryptoException.getMessage());
        }
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        return this.signer.verifySignature(byArray);
    }

    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof SM2ParameterSpec)) {
            throw new InvalidAlgorithmParameterException("only SM2ParameterSpec supported");
        }
        this.paramSpec = (SM2ParameterSpec)algorithmParameterSpec;
    }

    protected AlgorithmParameters engineGetParameters() {
        if (this.engineParams == null && this.paramSpec != null) {
            try {
                this.engineParams = this.helper.createAlgorithmParameters("PSS");
                this.engineParams.init((AlgorithmParameterSpec)this.paramSpec);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.toString());
            }
        }
        return this.engineParams;
    }

    protected void engineSetParameter(String string, Object object) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    protected Object engineGetParameter(String string) {
        throw new UnsupportedOperationException("engineGetParameter unsupported");
    }
}

