/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.asymmetric.dstu;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Encodable;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1ObjectIdentifier;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1OctetString;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Primitive;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Sequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERBitString;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DEROctetString;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ua.DSTU4145BinaryField;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ua.DSTU4145NamedCurves;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ua.DSTU4145Params;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ua.DSTU4145PointEncoder;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ua.UAObjectIdentifiers;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.AlgorithmIdentifier;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.SubjectPublicKeyInfo;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x9.X962Parameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x9.X9ECParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ECDomainParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ECPublicKeyParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.asymmetric.util.EC5Util;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.asymmetric.util.ECUtil;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.asymmetric.util.KeyUtil;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.config.ProviderConfiguration;
import macromedia.externals.org.bouncycastle_1_60_0_0.jce.interfaces.ECPointEncoder;
import macromedia.externals.org.bouncycastle_1_60_0_0.jce.provider.BouncyCastleProvider;
import macromedia.externals.org.bouncycastle_1_60_0_0.jce.spec.ECNamedCurveParameterSpec;
import macromedia.externals.org.bouncycastle_1_60_0_0.jce.spec.ECNamedCurveSpec;
import macromedia.externals.org.bouncycastle_1_60_0_0.jce.spec.ECPublicKeySpec;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECCurve;

public class BCDSTU4145PublicKey
implements ECPointEncoder,
macromedia.externals.org.bouncycastle_1_60_0_0.jce.interfaces.ECPublicKey,
ECPublicKey {
    static final long serialVersionUID = 7026240464295649314L;
    private String algorithm = "DSTU4145";
    private boolean withCompression;
    private transient ECPublicKeyParameters ecPublicKey;
    private transient ECParameterSpec ecSpec;
    private transient DSTU4145Params dstuParams;

    public BCDSTU4145PublicKey(BCDSTU4145PublicKey bCDSTU4145PublicKey) {
        this.ecPublicKey = bCDSTU4145PublicKey.ecPublicKey;
        this.ecSpec = bCDSTU4145PublicKey.ecSpec;
        this.withCompression = bCDSTU4145PublicKey.withCompression;
        this.dstuParams = bCDSTU4145PublicKey.dstuParams;
    }

    public BCDSTU4145PublicKey(java.security.spec.ECPublicKeySpec eCPublicKeySpec) {
        this.ecSpec = eCPublicKeySpec.getParams();
        this.ecPublicKey = new ECPublicKeyParameters(EC5Util.convertPoint((ECParameterSpec)this.ecSpec, (ECPoint)eCPublicKeySpec.getW(), (boolean)false), EC5Util.getDomainParameters(null, (ECParameterSpec)this.ecSpec));
    }

    public BCDSTU4145PublicKey(ECPublicKeySpec eCPublicKeySpec, ProviderConfiguration providerConfiguration) {
        if (eCPublicKeySpec.getParams() != null) {
            ECCurve eCCurve = eCPublicKeySpec.getParams().getCurve();
            EllipticCurve ellipticCurve = EC5Util.convertCurve((ECCurve)eCCurve, (byte[])eCPublicKeySpec.getParams().getSeed());
            this.ecPublicKey = new ECPublicKeyParameters(eCPublicKeySpec.getQ(), ECUtil.getDomainParameters((ProviderConfiguration)providerConfiguration, (macromedia.externals.org.bouncycastle_1_60_0_0.jce.spec.ECParameterSpec)eCPublicKeySpec.getParams()));
            this.ecSpec = EC5Util.convertSpec((EllipticCurve)ellipticCurve, (macromedia.externals.org.bouncycastle_1_60_0_0.jce.spec.ECParameterSpec)eCPublicKeySpec.getParams());
        } else {
            macromedia.externals.org.bouncycastle_1_60_0_0.jce.spec.ECParameterSpec eCParameterSpec = providerConfiguration.getEcImplicitlyCa();
            this.ecPublicKey = new ECPublicKeyParameters(eCParameterSpec.getCurve().createPoint(eCPublicKeySpec.getQ().getAffineXCoord().toBigInteger(), eCPublicKeySpec.getQ().getAffineYCoord().toBigInteger()), EC5Util.getDomainParameters((ProviderConfiguration)providerConfiguration, (ECParameterSpec)null));
            this.ecSpec = null;
        }
    }

    public BCDSTU4145PublicKey(String string, ECPublicKeyParameters eCPublicKeyParameters, ECParameterSpec eCParameterSpec) {
        ECDomainParameters eCDomainParameters = eCPublicKeyParameters.getParameters();
        this.algorithm = string;
        this.ecPublicKey = eCPublicKeyParameters;
        if (eCParameterSpec == null) {
            EllipticCurve ellipticCurve = EC5Util.convertCurve((ECCurve)eCDomainParameters.getCurve(), (byte[])eCDomainParameters.getSeed());
            this.ecSpec = this.createSpec(ellipticCurve, eCDomainParameters);
        } else {
            this.ecSpec = eCParameterSpec;
        }
    }

    public BCDSTU4145PublicKey(String string, ECPublicKeyParameters eCPublicKeyParameters, macromedia.externals.org.bouncycastle_1_60_0_0.jce.spec.ECParameterSpec eCParameterSpec) {
        ECDomainParameters eCDomainParameters = eCPublicKeyParameters.getParameters();
        this.algorithm = string;
        if (eCParameterSpec == null) {
            EllipticCurve ellipticCurve = EC5Util.convertCurve((ECCurve)eCDomainParameters.getCurve(), (byte[])eCDomainParameters.getSeed());
            this.ecSpec = this.createSpec(ellipticCurve, eCDomainParameters);
        } else {
            EllipticCurve ellipticCurve = EC5Util.convertCurve((ECCurve)eCParameterSpec.getCurve(), (byte[])eCParameterSpec.getSeed());
            this.ecSpec = EC5Util.convertSpec((EllipticCurve)ellipticCurve, (macromedia.externals.org.bouncycastle_1_60_0_0.jce.spec.ECParameterSpec)eCParameterSpec);
        }
        this.ecPublicKey = eCPublicKeyParameters;
    }

    public BCDSTU4145PublicKey(String string, ECPublicKeyParameters eCPublicKeyParameters) {
        this.algorithm = string;
        this.ecPublicKey = eCPublicKeyParameters;
        this.ecSpec = null;
    }

    private ECParameterSpec createSpec(EllipticCurve ellipticCurve, ECDomainParameters eCDomainParameters) {
        return new ECParameterSpec(ellipticCurve, EC5Util.convertPoint((macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECPoint)eCDomainParameters.getG()), eCDomainParameters.getN(), eCDomainParameters.getH().intValue());
    }

    BCDSTU4145PublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        this.populateFromPubKeyInfo(subjectPublicKeyInfo);
    }

    private void reverseBytes(byte[] byArray) {
        for (int i2 = 0; i2 < byArray.length / 2; ++i2) {
            byte by2 = byArray[i2];
            byArray[i2] = byArray[byArray.length - 1 - i2];
            byArray[byArray.length - 1 - i2] = by2;
        }
    }

    private void populateFromPubKeyInfo(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        Object object;
        ASN1ObjectIdentifier aSN1ObjectIdentifier;
        ASN1OctetString aSN1OctetString;
        DERBitString dERBitString = subjectPublicKeyInfo.getPublicKeyData();
        this.algorithm = "DSTU4145";
        try {
            aSN1OctetString = (ASN1OctetString)ASN1Primitive.fromByteArray((byte[])dERBitString.getBytes());
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("error recovering public key");
        }
        byte[] byArray = aSN1OctetString.getOctets();
        if (subjectPublicKeyInfo.getAlgorithm().getAlgorithm().equals((Object)UAObjectIdentifiers.dstu4145le)) {
            this.reverseBytes(byArray);
        }
        this.dstuParams = DSTU4145Params.getInstance((Object)((ASN1Sequence)subjectPublicKeyInfo.getAlgorithm().getParameters()));
        ECNamedCurveParameterSpec eCNamedCurveParameterSpec = null;
        if (this.dstuParams.isNamedCurve()) {
            aSN1ObjectIdentifier = this.dstuParams.getNamedCurve();
            object = DSTU4145NamedCurves.getByOID((ASN1ObjectIdentifier)aSN1ObjectIdentifier);
            eCNamedCurveParameterSpec = new ECNamedCurveParameterSpec(aSN1ObjectIdentifier.getId(), object.getCurve(), object.getG(), object.getN(), object.getH(), object.getSeed());
        } else {
            aSN1ObjectIdentifier = this.dstuParams.getECBinary();
            object = aSN1ObjectIdentifier.getB();
            if (subjectPublicKeyInfo.getAlgorithm().getAlgorithm().equals((Object)UAObjectIdentifiers.dstu4145le)) {
                this.reverseBytes((byte[])object);
            }
            DSTU4145BinaryField dSTU4145BinaryField = aSN1ObjectIdentifier.getField();
            ECCurve.F2m f2m = new ECCurve.F2m(dSTU4145BinaryField.getM(), dSTU4145BinaryField.getK1(), dSTU4145BinaryField.getK2(), dSTU4145BinaryField.getK3(), aSN1ObjectIdentifier.getA(), new BigInteger(1, (byte[])object));
            byte[] byArray2 = aSN1ObjectIdentifier.getG();
            if (subjectPublicKeyInfo.getAlgorithm().getAlgorithm().equals((Object)UAObjectIdentifiers.dstu4145le)) {
                this.reverseBytes(byArray2);
            }
            eCNamedCurveParameterSpec = new macromedia.externals.org.bouncycastle_1_60_0_0.jce.spec.ECParameterSpec((ECCurve)f2m, DSTU4145PointEncoder.decodePoint((ECCurve)f2m, (byte[])byArray2), aSN1ObjectIdentifier.getN());
        }
        aSN1ObjectIdentifier = eCNamedCurveParameterSpec.getCurve();
        object = EC5Util.convertCurve((ECCurve)aSN1ObjectIdentifier, (byte[])eCNamedCurveParameterSpec.getSeed());
        this.ecSpec = this.dstuParams.isNamedCurve() ? new ECNamedCurveSpec(this.dstuParams.getNamedCurve().getId(), (EllipticCurve)object, EC5Util.convertPoint((macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECPoint)eCNamedCurveParameterSpec.getG()), eCNamedCurveParameterSpec.getN(), eCNamedCurveParameterSpec.getH()) : new ECParameterSpec((EllipticCurve)object, EC5Util.convertPoint((macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECPoint)eCNamedCurveParameterSpec.getG()), eCNamedCurveParameterSpec.getN(), eCNamedCurveParameterSpec.getH().intValue());
        this.ecPublicKey = new ECPublicKeyParameters(DSTU4145PointEncoder.decodePoint((ECCurve)aSN1ObjectIdentifier, (byte[])byArray), EC5Util.getDomainParameters(null, (ECParameterSpec)this.ecSpec));
    }

    public byte[] getSbox() {
        if (null != this.dstuParams) {
            return this.dstuParams.getDKE();
        }
        return DSTU4145Params.getDefaultDKE();
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        SubjectPublicKeyInfo subjectPublicKeyInfo;
        Object object;
        DSTU4145Params dSTU4145Params;
        if (this.dstuParams != null) {
            dSTU4145Params = this.dstuParams;
        } else if (this.ecSpec instanceof ECNamedCurveSpec) {
            dSTU4145Params = new DSTU4145Params(new ASN1ObjectIdentifier(((ECNamedCurveSpec)this.ecSpec).getName()));
        } else {
            object = EC5Util.convertCurve((EllipticCurve)this.ecSpec.getCurve());
            X9ECParameters x9ECParameters = new X9ECParameters((ECCurve)object, EC5Util.convertPoint((ECCurve)object, (ECPoint)this.ecSpec.getGenerator(), (boolean)this.withCompression), this.ecSpec.getOrder(), BigInteger.valueOf(this.ecSpec.getCofactor()), this.ecSpec.getCurve().getSeed());
            dSTU4145Params = new X962Parameters(x9ECParameters);
        }
        object = DSTU4145PointEncoder.encodePoint((macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECPoint)this.ecPublicKey.getQ());
        try {
            subjectPublicKeyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(UAObjectIdentifiers.dstu4145be, (ASN1Encodable)dSTU4145Params), (ASN1Encodable)new DEROctetString(object));
        }
        catch (IOException iOException) {
            return null;
        }
        return KeyUtil.getEncodedSubjectPublicKeyInfo((SubjectPublicKeyInfo)subjectPublicKeyInfo);
    }

    @Override
    public ECParameterSpec getParams() {
        return this.ecSpec;
    }

    public macromedia.externals.org.bouncycastle_1_60_0_0.jce.spec.ECParameterSpec getParameters() {
        if (this.ecSpec == null) {
            return null;
        }
        return EC5Util.convertSpec((ECParameterSpec)this.ecSpec, (boolean)this.withCompression);
    }

    @Override
    public ECPoint getW() {
        return EC5Util.convertPoint((macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECPoint)this.ecPublicKey.getQ());
    }

    public macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECPoint getQ() {
        macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECPoint eCPoint = this.ecPublicKey.getQ();
        if (this.ecSpec == null) {
            return eCPoint.getDetachedPoint();
        }
        return eCPoint;
    }

    ECPublicKeyParameters engineGetKeyParameters() {
        return this.ecPublicKey;
    }

    macromedia.externals.org.bouncycastle_1_60_0_0.jce.spec.ECParameterSpec engineGetSpec() {
        if (this.ecSpec != null) {
            return EC5Util.convertSpec((ECParameterSpec)this.ecSpec, (boolean)this.withCompression);
        }
        return BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa();
    }

    public String toString() {
        return ECUtil.publicKeyToString((String)this.algorithm, (macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECPoint)this.ecPublicKey.getQ(), (macromedia.externals.org.bouncycastle_1_60_0_0.jce.spec.ECParameterSpec)this.engineGetSpec());
    }

    public void setPointFormat(String string) {
        this.withCompression = !"UNCOMPRESSED".equalsIgnoreCase(string);
    }

    public boolean equals(Object object) {
        if (!(object instanceof BCDSTU4145PublicKey)) {
            return false;
        }
        BCDSTU4145PublicKey bCDSTU4145PublicKey = (BCDSTU4145PublicKey)object;
        return this.ecPublicKey.getQ().equals(bCDSTU4145PublicKey.ecPublicKey.getQ()) && this.engineGetSpec().equals((Object)bCDSTU4145PublicKey.engineGetSpec());
    }

    public int hashCode() {
        return this.ecPublicKey.getQ().hashCode() ^ this.engineGetSpec().hashCode();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.populateFromPubKeyInfo(SubjectPublicKeyInfo.getInstance((Object)ASN1Primitive.fromByteArray((byte[])byArray)));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }
}

