/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.asymmetric.dsa;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.util.Hashtable;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.CryptoServicesRegistrar;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.Digest;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.KeyGenerationParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.digests.SHA256Digest;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.generators.DSAKeyPairGenerator;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.generators.DSAParametersGenerator;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.DSAKeyGenerationParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.DSAParameterGenerationParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.DSAParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.DSAPrivateKeyParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.DSAPublicKeyParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.asymmetric.dsa.BCDSAPrivateKey;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.asymmetric.dsa.BCDSAPublicKey;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.asymmetric.util.PrimeCertaintyCalculator;
import macromedia.externals.org.bouncycastle_1_60_0_0.jce.provider.BouncyCastleProvider;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Integers;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Properties;

public class KeyPairGeneratorSpi
extends KeyPairGenerator {
    private static Hashtable params = new Hashtable();
    private static Object lock = new Object();
    DSAKeyGenerationParameters param;
    DSAKeyPairGenerator engine = new DSAKeyPairGenerator();
    int strength = 2048;
    SecureRandom random = CryptoServicesRegistrar.getSecureRandom();
    boolean initialised = false;

    public KeyPairGeneratorSpi() {
        super("DSA");
    }

    @Override
    public void initialize(int n2, SecureRandom secureRandom) {
        if (n2 < 512 || n2 > 4096 || n2 < 1024 && n2 % 64 != 0 || n2 >= 1024 && n2 % 1024 != 0) {
            throw new InvalidParameterException("strength must be from 512 - 4096 and a multiple of 1024 above 1024");
        }
        DSAParameterSpec dSAParameterSpec = BouncyCastleProvider.CONFIGURATION.getDSADefaultParameters(n2);
        if (dSAParameterSpec != null) {
            this.param = new DSAKeyGenerationParameters(secureRandom, new DSAParameters(dSAParameterSpec.getP(), dSAParameterSpec.getQ(), dSAParameterSpec.getG()));
            this.engine.init((KeyGenerationParameters)this.param);
            this.initialised = true;
        } else {
            this.strength = n2;
            this.random = secureRandom;
            this.initialised = false;
        }
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof DSAParameterSpec)) {
            throw new InvalidAlgorithmParameterException("parameter object not a DSAParameterSpec");
        }
        DSAParameterSpec dSAParameterSpec = (DSAParameterSpec)algorithmParameterSpec;
        this.param = new DSAKeyGenerationParameters(secureRandom, new DSAParameters(dSAParameterSpec.getP(), dSAParameterSpec.getQ(), dSAParameterSpec.getG()));
        this.engine.init((KeyGenerationParameters)this.param);
        this.initialised = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyPair generateKeyPair() {
        DSAPrivateKeyParameters dSAPrivateKeyParameters;
        Object object;
        Integer n2;
        if (!this.initialised) {
            n2 = Integers.valueOf((int)this.strength);
            if (params.containsKey(n2)) {
                this.param = (DSAKeyGenerationParameters)params.get(n2);
            } else {
                object = lock;
                synchronized (object) {
                    if (params.containsKey(n2)) {
                        this.param = (DSAKeyGenerationParameters)params.get(n2);
                    } else {
                        int n3 = PrimeCertaintyCalculator.getDefaultCertainty((int)this.strength);
                        if (this.strength == 1024) {
                            dSAPrivateKeyParameters = new DSAParametersGenerator();
                            if (Properties.isOverrideSet((String)"macromedia.externals.org.bouncycastle_1_60_0_0.dsa.FIPS186-2for1024bits")) {
                                dSAPrivateKeyParameters.init(this.strength, n3, this.random);
                            } else {
                                DSAParameterGenerationParameters dSAParameterGenerationParameters = new DSAParameterGenerationParameters(1024, 160, n3, this.random);
                                dSAPrivateKeyParameters.init(dSAParameterGenerationParameters);
                            }
                        } else if (this.strength > 1024) {
                            DSAParameterGenerationParameters dSAParameterGenerationParameters = new DSAParameterGenerationParameters(this.strength, 256, n3, this.random);
                            dSAPrivateKeyParameters = new DSAParametersGenerator((Digest)new SHA256Digest());
                            dSAPrivateKeyParameters.init(dSAParameterGenerationParameters);
                        } else {
                            dSAPrivateKeyParameters = new DSAParametersGenerator();
                            dSAPrivateKeyParameters.init(this.strength, n3, this.random);
                        }
                        this.param = new DSAKeyGenerationParameters(this.random, dSAPrivateKeyParameters.generateParameters());
                        params.put(n2, this.param);
                    }
                }
            }
            this.engine.init((KeyGenerationParameters)this.param);
            this.initialised = true;
        }
        n2 = this.engine.generateKeyPair();
        object = (DSAPublicKeyParameters)n2.getPublic();
        dSAPrivateKeyParameters = (DSAPrivateKeyParameters)n2.getPrivate();
        return new KeyPair((PublicKey)new BCDSAPublicKey(object), (PrivateKey)new BCDSAPrivateKey(dSAPrivateKeyParameters));
    }
}

