/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.asymmetric.dh;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Hashtable;
import javax.crypto.spec.DHParameterSpec;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.CryptoServicesRegistrar;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.KeyGenerationParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.generators.DHBasicKeyPairGenerator;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.generators.DHParametersGenerator;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.DHKeyGenerationParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.DHParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.DHPrivateKeyParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.DHPublicKeyParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.asymmetric.dh.BCDHPrivateKey;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.asymmetric.dh.BCDHPublicKey;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.asymmetric.util.PrimeCertaintyCalculator;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.spec.DHDomainParameterSpec;
import macromedia.externals.org.bouncycastle_1_60_0_0.jce.provider.BouncyCastleProvider;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Integers;

public class KeyPairGeneratorSpi
extends KeyPairGenerator {
    private static Hashtable params = new Hashtable();
    private static Object lock = new Object();
    DHKeyGenerationParameters param;
    DHBasicKeyPairGenerator engine = new DHBasicKeyPairGenerator();
    int strength = 2048;
    SecureRandom random = CryptoServicesRegistrar.getSecureRandom();
    boolean initialised = false;

    public KeyPairGeneratorSpi() {
        super("DH");
    }

    @Override
    public void initialize(int n2, SecureRandom secureRandom) {
        this.strength = n2;
        this.random = secureRandom;
        this.initialised = false;
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof DHParameterSpec)) {
            throw new InvalidAlgorithmParameterException("parameter object not a DHParameterSpec");
        }
        DHParameterSpec dHParameterSpec = (DHParameterSpec)algorithmParameterSpec;
        try {
            this.param = this.convertParams(secureRandom, dHParameterSpec);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidAlgorithmParameterException(illegalArgumentException.getMessage(), illegalArgumentException);
        }
        this.engine.init((KeyGenerationParameters)this.param);
        this.initialised = true;
    }

    private DHKeyGenerationParameters convertParams(SecureRandom secureRandom, DHParameterSpec dHParameterSpec) {
        if (dHParameterSpec instanceof DHDomainParameterSpec) {
            return new DHKeyGenerationParameters(secureRandom, ((DHDomainParameterSpec)dHParameterSpec).getDomainParameters());
        }
        return new DHKeyGenerationParameters(secureRandom, new DHParameters(dHParameterSpec.getP(), dHParameterSpec.getG(), null, dHParameterSpec.getL()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyPair generateKeyPair() {
        Object object;
        Object object2;
        Integer n2;
        if (!this.initialised) {
            n2 = Integers.valueOf((int)this.strength);
            if (params.containsKey(n2)) {
                this.param = (DHKeyGenerationParameters)params.get(n2);
            } else {
                object2 = BouncyCastleProvider.CONFIGURATION.getDHDefaultParameters(this.strength);
                if (object2 != null) {
                    this.param = this.convertParams(this.random, (DHParameterSpec)object2);
                } else {
                    object = lock;
                    synchronized (object) {
                        if (params.containsKey(n2)) {
                            this.param = (DHKeyGenerationParameters)params.get(n2);
                        } else {
                            DHParametersGenerator dHParametersGenerator = new DHParametersGenerator();
                            dHParametersGenerator.init(this.strength, PrimeCertaintyCalculator.getDefaultCertainty((int)this.strength), this.random);
                            this.param = new DHKeyGenerationParameters(this.random, dHParametersGenerator.generateParameters());
                            params.put(n2, this.param);
                        }
                    }
                }
            }
            this.engine.init((KeyGenerationParameters)this.param);
            this.initialised = true;
        }
        n2 = this.engine.generateKeyPair();
        object2 = (DHPublicKeyParameters)n2.getPublic();
        object = (DHPrivateKeyParameters)n2.getPrivate();
        return new KeyPair((PublicKey)new BCDHPublicKey(object2), (PrivateKey)new BCDHPrivateKey(object));
    }
}

