/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.i18n;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TimeZone;
import macromedia.externals.org.bouncycastle_1_60_0_0.i18n.LocalizedMessage;
import macromedia.externals.org.bouncycastle_1_60_0_0.i18n.MissingEntryException;
import macromedia.externals.org.bouncycastle_1_60_0_0.i18n.filter.Filter;

public class LocalizedMessage {
    protected final String id;
    protected final String resource;
    public static final String DEFAULT_ENCODING = "ISO-8859-1";
    protected String encoding = "ISO-8859-1";
    protected FilteredArguments arguments;
    protected FilteredArguments extraArgs = null;
    protected Filter filter = null;
    protected ClassLoader loader = null;

    public LocalizedMessage(String string, String string2) throws NullPointerException {
        if (string == null || string2 == null) {
            throw new NullPointerException();
        }
        this.id = string2;
        this.resource = string;
        this.arguments = new FilteredArguments(this);
    }

    public LocalizedMessage(String string, String string2, String string3) throws NullPointerException, UnsupportedEncodingException {
        if (string == null || string2 == null) {
            throw new NullPointerException();
        }
        this.id = string2;
        this.resource = string;
        this.arguments = new FilteredArguments(this);
        if (!Charset.isSupported(string3)) {
            throw new UnsupportedEncodingException("The encoding \"" + string3 + "\" is not supported.");
        }
        this.encoding = string3;
    }

    public LocalizedMessage(String string, String string2, Object[] objectArray) throws NullPointerException {
        if (string == null || string2 == null || objectArray == null) {
            throw new NullPointerException();
        }
        this.id = string2;
        this.resource = string;
        this.arguments = new FilteredArguments(this, objectArray);
    }

    public LocalizedMessage(String string, String string2, String string3, Object[] objectArray) throws NullPointerException, UnsupportedEncodingException {
        if (string == null || string2 == null || objectArray == null) {
            throw new NullPointerException();
        }
        this.id = string2;
        this.resource = string;
        this.arguments = new FilteredArguments(this, objectArray);
        if (!Charset.isSupported(string3)) {
            throw new UnsupportedEncodingException("The encoding \"" + string3 + "\" is not supported.");
        }
        this.encoding = string3;
    }

    public String getEntry(String string, Locale locale, TimeZone timeZone) throws MissingEntryException {
        String string2 = this.id;
        if (string != null) {
            string2 = string2 + "." + string;
        }
        try {
            ResourceBundle resourceBundle = this.loader == null ? ResourceBundle.getBundle(this.resource, locale) : ResourceBundle.getBundle(this.resource, locale, this.loader);
            String string3 = resourceBundle.getString(string2);
            if (!this.encoding.equals(DEFAULT_ENCODING)) {
                string3 = new String(string3.getBytes(DEFAULT_ENCODING), this.encoding);
            }
            if (!this.arguments.isEmpty()) {
                string3 = this.formatWithTimeZone(string3, this.arguments.getFilteredArgs(locale), locale, timeZone);
            }
            string3 = this.addExtraArgs(string3, locale);
            return string3;
        }
        catch (MissingResourceException missingResourceException) {
            throw new MissingEntryException("Can't find entry " + string2 + " in resource file " + this.resource + ".", this.resource, string2, locale, this.loader != null ? this.loader : this.getClassLoader());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    protected String formatWithTimeZone(String string, Object[] objectArray, Locale locale, TimeZone timeZone) {
        MessageFormat messageFormat = new MessageFormat(" ");
        messageFormat.setLocale(locale);
        messageFormat.applyPattern(string);
        if (!timeZone.equals(TimeZone.getDefault())) {
            Format[] formatArray = messageFormat.getFormats();
            for (int i2 = 0; i2 < formatArray.length; ++i2) {
                if (!(formatArray[i2] instanceof DateFormat)) continue;
                DateFormat dateFormat = (DateFormat)formatArray[i2];
                dateFormat.setTimeZone(timeZone);
                messageFormat.setFormat(i2, dateFormat);
            }
        }
        return messageFormat.format(objectArray);
    }

    protected String addExtraArgs(String string, Locale locale) {
        if (this.extraArgs != null) {
            StringBuffer stringBuffer = new StringBuffer(string);
            Object[] objectArray = this.extraArgs.getFilteredArgs(locale);
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                stringBuffer.append(objectArray[i2]);
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public void setFilter(Filter filter) {
        this.arguments.setFilter(filter);
        if (this.extraArgs != null) {
            this.extraArgs.setFilter(filter);
        }
        this.filter = filter;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.loader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public String getId() {
        return this.id;
    }

    public String getResource() {
        return this.resource;
    }

    public Object[] getArguments() {
        return this.arguments.getArguments();
    }

    public void setExtraArgument(Object object) {
        this.setExtraArguments(new Object[]{object});
    }

    public void setExtraArguments(Object[] objectArray) {
        if (objectArray != null) {
            this.extraArgs = new FilteredArguments(this, objectArray);
            this.extraArgs.setFilter(this.filter);
        } else {
            this.extraArgs = null;
        }
    }

    public Object[] getExtraArgs() {
        return this.extraArgs == null ? null : this.extraArgs.getArguments();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Resource: \"").append(this.resource);
        stringBuffer.append("\" Id: \"").append(this.id).append("\"");
        stringBuffer.append(" Arguments: ").append(this.arguments.getArguments().length).append(" normal");
        if (this.extraArgs != null && this.extraArgs.getArguments().length > 0) {
            stringBuffer.append(", ").append(this.extraArgs.getArguments().length).append(" extra");
        }
        stringBuffer.append(" Encoding: ").append(this.encoding);
        stringBuffer.append(" ClassLoader: ").append(this.loader);
        return stringBuffer.toString();
    }
}

