/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.crypto.util;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Encodable;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1InputStream;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Integer;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1ObjectIdentifier;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Primitive;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.oiw.ElGamalParameter;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.oiw.OIWObjectIdentifiers;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.pkcs.DHParameter;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.pkcs.PKCSObjectIdentifiers;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.pkcs.PrivateKeyInfo;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.pkcs.RSAPrivateKey;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.sec.ECPrivateKey;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.AlgorithmIdentifier;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.DSAParameter;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x9.ECNamedCurveTable;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x9.X962Parameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x9.X9ECParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x9.X9ObjectIdentifiers;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.ec.CustomNamedCurves;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.AsymmetricKeyParameter;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.DHParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.DHPrivateKeyParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.DSAParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.DSAPrivateKeyParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ECDomainParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ECNamedDomainParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ECPrivateKeyParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ElGamalParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ElGamalPrivateKeyParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.RSAPrivateCrtKeyParameters;

/*
 * Exception performing whole class analysis ignored.
 */
public class PrivateKeyFactory {
    public static AsymmetricKeyParameter createKey(byte[] byArray) throws IOException {
        return PrivateKeyFactory.createKey((PrivateKeyInfo)PrivateKeyInfo.getInstance((Object)ASN1Primitive.fromByteArray((byte[])byArray)));
    }

    public static AsymmetricKeyParameter createKey(InputStream inputStream) throws IOException {
        return PrivateKeyFactory.createKey((PrivateKeyInfo)PrivateKeyInfo.getInstance((Object)new ASN1InputStream(inputStream).readObject()));
    }

    public static AsymmetricKeyParameter createKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        AlgorithmIdentifier algorithmIdentifier = privateKeyInfo.getPrivateKeyAlgorithm();
        if (algorithmIdentifier.getAlgorithm().equals((Object)PKCSObjectIdentifiers.rsaEncryption)) {
            RSAPrivateKey rSAPrivateKey = RSAPrivateKey.getInstance((Object)privateKeyInfo.parsePrivateKey());
            return new RSAPrivateCrtKeyParameters(rSAPrivateKey.getModulus(), rSAPrivateKey.getPublicExponent(), rSAPrivateKey.getPrivateExponent(), rSAPrivateKey.getPrime1(), rSAPrivateKey.getPrime2(), rSAPrivateKey.getExponent1(), rSAPrivateKey.getExponent2(), rSAPrivateKey.getCoefficient());
        }
        if (algorithmIdentifier.getAlgorithm().equals((Object)PKCSObjectIdentifiers.dhKeyAgreement)) {
            DHParameter dHParameter = DHParameter.getInstance((Object)algorithmIdentifier.getParameters());
            ASN1Integer aSN1Integer = (ASN1Integer)privateKeyInfo.parsePrivateKey();
            BigInteger bigInteger = dHParameter.getL();
            int n2 = bigInteger == null ? 0 : bigInteger.intValue();
            DHParameters dHParameters = new DHParameters(dHParameter.getP(), dHParameter.getG(), null, n2);
            return new DHPrivateKeyParameters(aSN1Integer.getValue(), dHParameters);
        }
        if (algorithmIdentifier.getAlgorithm().equals((Object)OIWObjectIdentifiers.elGamalAlgorithm)) {
            ElGamalParameter elGamalParameter = ElGamalParameter.getInstance((Object)algorithmIdentifier.getParameters());
            ASN1Integer aSN1Integer = (ASN1Integer)privateKeyInfo.parsePrivateKey();
            return new ElGamalPrivateKeyParameters(aSN1Integer.getValue(), new ElGamalParameters(elGamalParameter.getP(), elGamalParameter.getG()));
        }
        if (algorithmIdentifier.getAlgorithm().equals((Object)X9ObjectIdentifiers.id_dsa)) {
            ASN1Integer aSN1Integer = (ASN1Integer)privateKeyInfo.parsePrivateKey();
            ASN1Encodable aSN1Encodable = algorithmIdentifier.getParameters();
            DSAParameters dSAParameters = null;
            if (aSN1Encodable != null) {
                DSAParameter dSAParameter = DSAParameter.getInstance((Object)aSN1Encodable.toASN1Primitive());
                dSAParameters = new DSAParameters(dSAParameter.getP(), dSAParameter.getQ(), dSAParameter.getG());
            }
            return new DSAPrivateKeyParameters(aSN1Integer.getValue(), dSAParameters);
        }
        if (algorithmIdentifier.getAlgorithm().equals((Object)X9ObjectIdentifiers.id_ecPublicKey)) {
            ECDomainParameters eCDomainParameters;
            ASN1ObjectIdentifier aSN1ObjectIdentifier;
            X962Parameters x962Parameters = new X962Parameters((ASN1Primitive)algorithmIdentifier.getParameters());
            if (x962Parameters.isNamedCurve()) {
                aSN1ObjectIdentifier = (ASN1ObjectIdentifier)x962Parameters.getParameters();
                X9ECParameters x9ECParameters = CustomNamedCurves.getByOID((ASN1ObjectIdentifier)aSN1ObjectIdentifier);
                if (x9ECParameters == null) {
                    x9ECParameters = ECNamedCurveTable.getByOID((ASN1ObjectIdentifier)aSN1ObjectIdentifier);
                }
                eCDomainParameters = new ECNamedDomainParameters(aSN1ObjectIdentifier, x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH(), x9ECParameters.getSeed());
            } else {
                X9ECParameters x9ECParameters = X9ECParameters.getInstance((Object)x962Parameters.getParameters());
                eCDomainParameters = new ECDomainParameters(x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH(), x9ECParameters.getSeed());
            }
            aSN1ObjectIdentifier = ECPrivateKey.getInstance((Object)privateKeyInfo.parsePrivateKey());
            BigInteger bigInteger = aSN1ObjectIdentifier.getKey();
            return new ECPrivateKeyParameters(bigInteger, eCDomainParameters);
        }
        throw new RuntimeException("algorithm identifier in key not recognised");
    }
}

