/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsContext;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsFatalAlert;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsUtils;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Strings;

public class URLAndHash {
    protected String url;
    protected byte[] sha1Hash;

    public URLAndHash(String string, byte[] byArray) {
        if (string == null || string.length() < 1 || string.length() >= 65536) {
            throw new IllegalArgumentException("'url' must have length from 1 to (2^16 - 1)");
        }
        if (byArray != null && byArray.length != 20) {
            throw new IllegalArgumentException("'sha1Hash' must have length == 20, if present");
        }
        this.url = string;
        this.sha1Hash = byArray;
    }

    public String getURL() {
        return this.url;
    }

    public byte[] getSHA1Hash() {
        return this.sha1Hash;
    }

    public void encode(OutputStream outputStream) throws IOException {
        byte[] byArray = Strings.toByteArray((String)this.url);
        TlsUtils.writeOpaque16((byte[])byArray, (OutputStream)outputStream);
        if (this.sha1Hash == null) {
            TlsUtils.writeUint8((int)0, (OutputStream)outputStream);
        } else {
            TlsUtils.writeUint8((int)1, (OutputStream)outputStream);
            outputStream.write(this.sha1Hash);
        }
    }

    public static URLAndHash parse(TlsContext tlsContext, InputStream inputStream) throws IOException {
        byte[] byArray = TlsUtils.readOpaque16((InputStream)inputStream);
        if (byArray.length < 1) {
            throw new TlsFatalAlert(47);
        }
        String string = Strings.fromByteArray((byte[])byArray);
        byte[] byArray2 = null;
        short s2 = TlsUtils.readUint8((InputStream)inputStream);
        switch (s2) {
            case 0: {
                if (!TlsUtils.isTLSv12((TlsContext)tlsContext)) break;
                throw new TlsFatalAlert(47);
            }
            case 1: {
                byArray2 = TlsUtils.readFully((int)20, (InputStream)inputStream);
                break;
            }
            default: {
                throw new TlsFatalAlert(47);
            }
        }
        return new URLAndHash(string, byArray2);
    }
}

