/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls;

import java.io.IOException;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.CipherParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.Digest;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.StreamCipher;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.KeyParameter;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ParametersWithIV;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsCipher;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsContext;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsFatalAlert;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsMac;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsUtils;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Arrays;

public class TlsStreamCipher
implements TlsCipher {
    protected TlsContext context;
    protected StreamCipher encryptCipher;
    protected StreamCipher decryptCipher;
    protected TlsMac writeMac;
    protected TlsMac readMac;
    protected boolean usesNonce;

    public TlsStreamCipher(TlsContext tlsContext, StreamCipher streamCipher, StreamCipher streamCipher2, Digest digest, Digest digest2, int n2, boolean bl2) throws IOException {
        KeyParameter keyParameter;
        KeyParameter keyParameter2;
        boolean bl3 = tlsContext.isServer();
        this.context = tlsContext;
        this.usesNonce = bl2;
        this.encryptCipher = streamCipher;
        this.decryptCipher = streamCipher2;
        int n3 = 2 * n2 + digest.getDigestSize() + digest2.getDigestSize();
        byte[] byArray = TlsUtils.calculateKeyBlock((TlsContext)tlsContext, (int)n3);
        int n4 = 0;
        TlsMac tlsMac = new TlsMac(tlsContext, digest, byArray, n4, digest.getDigestSize());
        TlsMac tlsMac2 = new TlsMac(tlsContext, digest2, byArray, n4 += digest.getDigestSize(), digest2.getDigestSize());
        KeyParameter keyParameter3 = new KeyParameter(byArray, n4 += digest2.getDigestSize(), n2);
        KeyParameter keyParameter4 = new KeyParameter(byArray, n4 += n2, n2);
        if ((n4 += n2) != n3) {
            throw new TlsFatalAlert(80);
        }
        if (bl3) {
            this.writeMac = tlsMac2;
            this.readMac = tlsMac;
            this.encryptCipher = streamCipher2;
            this.decryptCipher = streamCipher;
            keyParameter2 = keyParameter4;
            keyParameter = keyParameter3;
        } else {
            this.writeMac = tlsMac;
            this.readMac = tlsMac2;
            this.encryptCipher = streamCipher;
            this.decryptCipher = streamCipher2;
            keyParameter2 = keyParameter3;
            keyParameter = keyParameter4;
        }
        if (bl2) {
            byte[] byArray2 = new byte[8];
            keyParameter2 = new ParametersWithIV((CipherParameters)keyParameter2, byArray2);
            keyParameter = new ParametersWithIV((CipherParameters)keyParameter, byArray2);
        }
        this.encryptCipher.init(true, (CipherParameters)keyParameter2);
        this.decryptCipher.init(false, (CipherParameters)keyParameter);
    }

    public int getPlaintextLimit(int n2) {
        return n2 - this.writeMac.getSize();
    }

    public byte[] encodePlaintext(long l2, short s2, byte[] byArray, int n2, int n3) {
        if (this.usesNonce) {
            this.updateIV(this.encryptCipher, true, l2);
        }
        byte[] byArray2 = new byte[n3 + this.writeMac.getSize()];
        this.encryptCipher.processBytes(byArray, n2, n3, byArray2, 0);
        byte[] byArray3 = this.writeMac.calculateMac(l2, s2, byArray, n2, n3);
        this.encryptCipher.processBytes(byArray3, 0, byArray3.length, byArray2, n3);
        return byArray2;
    }

    public byte[] decodeCiphertext(long l2, short s2, byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        if (this.usesNonce) {
            this.updateIV(this.decryptCipher, false, l2);
        }
        if (n3 < (n4 = this.readMac.getSize())) {
            throw new TlsFatalAlert(50);
        }
        int n5 = n3 - n4;
        byte[] byArray2 = new byte[n3];
        this.decryptCipher.processBytes(byArray, n2, n3, byArray2, 0);
        this.checkMAC(l2, s2, byArray2, n5, n3, byArray2, 0, n5);
        return Arrays.copyOfRange((byte[])byArray2, (int)0, (int)n5);
    }

    protected void checkMAC(long l2, short s2, byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5) throws IOException {
        byte[] byArray3;
        byte[] byArray4 = Arrays.copyOfRange((byte[])byArray, (int)n2, (int)n3);
        if (!Arrays.constantTimeAreEqual((byte[])byArray4, (byte[])(byArray3 = this.readMac.calculateMac(l2, s2, byArray2, n4, n5)))) {
            throw new TlsFatalAlert(20);
        }
    }

    protected void updateIV(StreamCipher streamCipher, boolean bl2, long l2) {
        byte[] byArray = new byte[8];
        TlsUtils.writeUint64((long)l2, (byte[])byArray, (int)0);
        streamCipher.init(bl2, (CipherParameters)new ParametersWithIV(null, byArray));
    }
}

