/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls;

import java.io.IOException;
import java.io.OutputStream;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.AsymmetricBlockCipher;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.CipherParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.InvalidCipherTextException;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.encodings.PKCS1Encoding;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.engines.RSABlindedEngine;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ParametersWithRandom;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.RSAKeyParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.ProtocolVersion;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsContext;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsFatalAlert;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsUtils;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Arrays;

public class TlsRSAUtils {
    public static byte[] generateEncryptedPreMasterSecret(TlsContext tlsContext, RSAKeyParameters rSAKeyParameters, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[48];
        tlsContext.getSecureRandom().nextBytes(byArray);
        TlsUtils.writeVersion((ProtocolVersion)tlsContext.getClientVersion(), (byte[])byArray, (int)0);
        PKCS1Encoding pKCS1Encoding = new PKCS1Encoding((AsymmetricBlockCipher)new RSABlindedEngine());
        pKCS1Encoding.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)rSAKeyParameters, tlsContext.getSecureRandom()));
        try {
            byte[] byArray2 = pKCS1Encoding.processBlock(byArray, 0, byArray.length);
            if (TlsUtils.isSSL((TlsContext)tlsContext)) {
                outputStream.write(byArray2);
            } else {
                TlsUtils.writeOpaque16((byte[])byArray2, (OutputStream)outputStream);
            }
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new TlsFatalAlert(80, (Throwable)invalidCipherTextException);
        }
        return byArray;
    }

    public static byte[] safeDecryptPreMasterSecret(TlsContext tlsContext, RSAKeyParameters rSAKeyParameters, byte[] byArray) {
        ProtocolVersion protocolVersion = tlsContext.getClientVersion();
        boolean bl2 = false;
        byte[] byArray2 = new byte[48];
        tlsContext.getSecureRandom().nextBytes(byArray2);
        byte[] byArray3 = Arrays.clone((byte[])byArray2);
        try {
            PKCS1Encoding pKCS1Encoding = new PKCS1Encoding((AsymmetricBlockCipher)new RSABlindedEngine(), byArray2);
            pKCS1Encoding.init(false, (CipherParameters)new ParametersWithRandom((CipherParameters)rSAKeyParameters, tlsContext.getSecureRandom()));
            byArray3 = pKCS1Encoding.processBlock(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl2 || !protocolVersion.isEqualOrEarlierVersionOf(ProtocolVersion.TLSv10)) {
            int n2 = protocolVersion.getMajorVersion() ^ byArray3[0] & 0xFF | protocolVersion.getMinorVersion() ^ byArray3[1] & 0xFF;
            n2 |= n2 >> 1;
            n2 |= n2 >> 2;
            n2 |= n2 >> 4;
            int n3 = ~((n2 & 1) - 1);
            for (int i2 = 0; i2 < 48; ++i2) {
                byArray3[i2] = (byte)(byArray3[i2] & ~n3 | byArray2[i2] & n3);
            }
        }
        return byArray3;
    }
}

