/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls;

import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.CipherParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.Digest;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.Mac;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.digests.LongDigest;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.macs.HMac;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.KeyParameter;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.ProtocolVersion;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.SSL3Mac;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsContext;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsUtils;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Arrays;

public class TlsMac {
    protected TlsContext context;
    protected byte[] secret;
    protected Mac mac;
    protected int digestBlockSize;
    protected int digestOverhead;
    protected int macLength;

    public TlsMac(TlsContext tlsContext, Digest digest, byte[] byArray, int n2, int n3) {
        this.context = tlsContext;
        KeyParameter keyParameter = new KeyParameter(byArray, n2, n3);
        this.secret = Arrays.clone((byte[])keyParameter.getKey());
        if (digest instanceof LongDigest) {
            this.digestBlockSize = 128;
            this.digestOverhead = 16;
        } else {
            this.digestBlockSize = 64;
            this.digestOverhead = 8;
        }
        if (TlsUtils.isSSL((TlsContext)tlsContext)) {
            this.mac = new SSL3Mac(digest);
            if (digest.getDigestSize() == 20) {
                this.digestOverhead = 4;
            }
        } else {
            this.mac = new HMac(digest);
        }
        this.mac.init((CipherParameters)keyParameter);
        this.macLength = this.mac.getMacSize();
        if (tlsContext.getSecurityParameters().truncatedHMac) {
            this.macLength = Math.min(this.macLength, 10);
        }
    }

    public byte[] getMACSecret() {
        return this.secret;
    }

    public int getSize() {
        return this.macLength;
    }

    public byte[] calculateMac(long l2, short s2, byte[] byArray, int n2, int n3) {
        ProtocolVersion protocolVersion = this.context.getServerVersion();
        boolean bl2 = protocolVersion.isSSL();
        byte[] byArray2 = new byte[bl2 ? 11 : 13];
        TlsUtils.writeUint64((long)l2, (byte[])byArray2, (int)0);
        TlsUtils.writeUint8((short)s2, (byte[])byArray2, (int)8);
        if (!bl2) {
            TlsUtils.writeVersion((ProtocolVersion)protocolVersion, (byte[])byArray2, (int)9);
        }
        TlsUtils.writeUint16((int)n3, (byte[])byArray2, (int)(byArray2.length - 2));
        this.mac.update(byArray2, 0, byArray2.length);
        this.mac.update(byArray, n2, n3);
        byte[] byArray3 = new byte[this.mac.getMacSize()];
        this.mac.doFinal(byArray3, 0);
        return this.truncate(byArray3);
    }

    public byte[] calculateMacConstantTime(long l2, short s2, byte[] byArray, int n2, int n3, int n4, byte[] byArray2) {
        byte[] byArray3 = this.calculateMac(l2, s2, byArray, n2, n3);
        int n5 = TlsUtils.isSSL((TlsContext)this.context) ? 11 : 13;
        int n6 = this.getDigestBlockCount(n5 + n4) - this.getDigestBlockCount(n5 + n3);
        while (--n6 >= 0) {
            this.mac.update(byArray2, 0, this.digestBlockSize);
        }
        this.mac.update(byArray2[0]);
        this.mac.reset();
        return byArray3;
    }

    protected int getDigestBlockCount(int n2) {
        return (n2 + this.digestOverhead) / this.digestBlockSize;
    }

    protected byte[] truncate(byte[] byArray) {
        if (byArray.length <= this.macLength) {
            return byArray;
        }
        return Arrays.copyOf((byte[])byArray, (int)this.macLength);
    }
}

