/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.Vector;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.Digest;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.Signer;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ECDomainParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ECPublicKeyParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.CertificateRequest;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.DigestInputBuffer;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.DigitallySigned;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.SecurityParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.SignatureAndHashAlgorithm;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.SignerInputBuffer;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsContext;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsCredentials;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsECCUtils;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsECDHKeyExchange;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsFatalAlert;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsSigner;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsSignerCredentials;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsUtils;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.io.TeeInputStream;

public class TlsECDHEKeyExchange
extends TlsECDHKeyExchange {
    protected TlsSignerCredentials serverCredentials = null;

    public TlsECDHEKeyExchange(int n2, Vector vector, int[] nArray, short[] sArray, short[] sArray2) {
        super(n2, vector, nArray, sArray, sArray2);
    }

    public void processServerCredentials(TlsCredentials tlsCredentials) throws IOException {
        if (!(tlsCredentials instanceof TlsSignerCredentials)) {
            throw new TlsFatalAlert(80);
        }
        this.processServerCertificate(tlsCredentials.getCertificate());
        this.serverCredentials = (TlsSignerCredentials)tlsCredentials;
    }

    public byte[] generateServerKeyExchange() throws IOException {
        DigestInputBuffer digestInputBuffer = new DigestInputBuffer();
        this.ecAgreePrivateKey = TlsECCUtils.generateEphemeralServerKeyExchange((SecureRandom)this.context.getSecureRandom(), (int[])this.namedCurves, (short[])this.clientECPointFormats, (OutputStream)digestInputBuffer);
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = TlsUtils.getSignatureAndHashAlgorithm((TlsContext)this.context, (TlsSignerCredentials)this.serverCredentials);
        Digest digest = TlsUtils.createHash((SignatureAndHashAlgorithm)signatureAndHashAlgorithm);
        SecurityParameters securityParameters = this.context.getSecurityParameters();
        digest.update(securityParameters.clientRandom, 0, securityParameters.clientRandom.length);
        digest.update(securityParameters.serverRandom, 0, securityParameters.serverRandom.length);
        digestInputBuffer.updateDigest(digest);
        byte[] byArray = new byte[digest.getDigestSize()];
        digest.doFinal(byArray, 0);
        byte[] byArray2 = this.serverCredentials.generateCertificateSignature(byArray);
        DigitallySigned digitallySigned = new DigitallySigned(signatureAndHashAlgorithm, byArray2);
        digitallySigned.encode((OutputStream)digestInputBuffer);
        return digestInputBuffer.toByteArray();
    }

    public void processServerKeyExchange(InputStream inputStream) throws IOException {
        SecurityParameters securityParameters = this.context.getSecurityParameters();
        SignerInputBuffer signerInputBuffer = new SignerInputBuffer();
        TeeInputStream teeInputStream = new TeeInputStream(inputStream, (OutputStream)signerInputBuffer);
        ECDomainParameters eCDomainParameters = TlsECCUtils.readECParameters((int[])this.namedCurves, (short[])this.clientECPointFormats, (InputStream)teeInputStream);
        byte[] byArray = TlsUtils.readOpaque8((InputStream)teeInputStream);
        DigitallySigned digitallySigned = this.parseSignature(inputStream);
        Signer signer = this.initVerifyer(this.tlsSigner, digitallySigned.getAlgorithm(), securityParameters);
        signerInputBuffer.updateSigner(signer);
        if (!signer.verifySignature(digitallySigned.getSignature())) {
            throw new TlsFatalAlert(51);
        }
        this.ecAgreePublicKey = TlsECCUtils.validateECPublicKey((ECPublicKeyParameters)TlsECCUtils.deserializeECPublicKey((short[])this.clientECPointFormats, (ECDomainParameters)eCDomainParameters, (byte[])byArray));
    }

    public void validateCertificateRequest(CertificateRequest certificateRequest) throws IOException {
        short[] sArray = certificateRequest.getCertificateTypes();
        block3: for (int i2 = 0; i2 < sArray.length; ++i2) {
            switch (sArray[i2]) {
                case 1: 
                case 2: 
                case 64: {
                    continue block3;
                }
                default: {
                    throw new TlsFatalAlert(47);
                }
            }
        }
    }

    public void processClientCredentials(TlsCredentials tlsCredentials) throws IOException {
        if (!(tlsCredentials instanceof TlsSignerCredentials)) {
            throw new TlsFatalAlert(80);
        }
    }

    protected Signer initVerifyer(TlsSigner tlsSigner, SignatureAndHashAlgorithm signatureAndHashAlgorithm, SecurityParameters securityParameters) {
        Signer signer = tlsSigner.createVerifyer(signatureAndHashAlgorithm, this.serverPublicKey);
        signer.update(securityParameters.clientRandom, 0, securityParameters.clientRandom.length);
        signer.update(securityParameters.serverRandom, 0, securityParameters.serverRandom.length);
        return signer;
    }
}

