/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.SecureRandom;
import java.util.Hashtable;
import java.util.Vector;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.prng.RandomGenerator;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.AbstractTlsContext;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.Certificate;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.CertificateRequest;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.CertificateStatus;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.CipherSuite;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.DigitallySigned;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.NewSessionTicket;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.ProtocolVersion;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.SecurityParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.SessionParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.SignatureAndHashAlgorithm;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsAuthentication;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsClient;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsClientContext;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsClientContextImpl;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsContext;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsCredentials;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsExtensionsUtils;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsFatalAlert;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsHandshakeHash;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsKeyExchange;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsPeer;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsProtocol;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsSession;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsSessionImpl;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsSignerCredentials;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsUtils;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Arrays;

/*
 * Exception performing whole class analysis ignored.
 */
public class TlsClientProtocol
extends TlsProtocol {
    protected TlsClient tlsClient = null;
    TlsClientContextImpl tlsClientContext = null;
    protected byte[] selectedSessionID = null;
    protected TlsKeyExchange keyExchange = null;
    protected TlsAuthentication authentication = null;
    protected CertificateStatus certificateStatus = null;
    protected CertificateRequest certificateRequest = null;

    public TlsClientProtocol(InputStream inputStream, OutputStream outputStream, SecureRandom secureRandom) {
        super(inputStream, outputStream, secureRandom);
    }

    public TlsClientProtocol(SecureRandom secureRandom) {
        super(secureRandom);
    }

    public void connect(TlsClient tlsClient) throws IOException {
        SessionParameters sessionParameters;
        if (tlsClient == null) {
            throw new IllegalArgumentException("'tlsClient' cannot be null");
        }
        if (this.tlsClient != null) {
            throw new IllegalStateException("'connect' can only be called once");
        }
        this.tlsClient = tlsClient;
        this.securityParameters = new SecurityParameters();
        this.securityParameters.entity = 1;
        this.tlsClientContext = new TlsClientContextImpl(this.secureRandom, this.securityParameters);
        this.securityParameters.clientRandom = TlsClientProtocol.createRandomBlock((boolean)tlsClient.shouldUseGMTUnixTime(), (RandomGenerator)this.tlsClientContext.getNonceRandomGenerator());
        this.tlsClient.init((TlsClientContext)this.tlsClientContext);
        this.recordStream.init((TlsContext)this.tlsClientContext);
        TlsSession tlsSession = tlsClient.getSessionToResume();
        if (tlsSession != null && tlsSession.isResumable() && (sessionParameters = tlsSession.exportSessionParameters()) != null) {
            this.tlsSession = tlsSession;
            this.sessionParameters = sessionParameters;
        }
        this.sendClientHelloMessage();
        this.connection_state = 1;
        this.blockForHandshake();
    }

    protected void cleanupHandshake() {
        super.cleanupHandshake();
        this.selectedSessionID = null;
        this.keyExchange = null;
        this.authentication = null;
        this.certificateStatus = null;
        this.certificateRequest = null;
    }

    protected TlsContext getContext() {
        return this.tlsClientContext;
    }

    AbstractTlsContext getContextAdmin() {
        return this.tlsClientContext;
    }

    protected TlsPeer getPeer() {
        return this.tlsClient;
    }

    protected void handleHandshakeMessage(short s2, ByteArrayInputStream byteArrayInputStream) throws IOException {
        if (this.resumedSession) {
            if (s2 != 20 || this.connection_state != 2) {
                throw new TlsFatalAlert(10);
            }
            this.processFinishedMessage(byteArrayInputStream);
            this.connection_state = (short)15;
            this.sendChangeCipherSpecMessage();
            this.sendFinishedMessage();
            this.connection_state = (short)13;
            this.completeHandshake();
            return;
        }
        block0 : switch (s2) {
            case 11: {
                switch (this.connection_state) {
                    case 2: {
                        this.handleSupplementalData(null);
                    }
                    case 3: {
                        this.peerCertificate = Certificate.parse((InputStream)byteArrayInputStream);
                        TlsClientProtocol.assertEmpty((ByteArrayInputStream)byteArrayInputStream);
                        if (this.peerCertificate == null || this.peerCertificate.isEmpty()) {
                            this.allowCertificateStatus = false;
                        }
                        this.keyExchange.processServerCertificate(this.peerCertificate);
                        this.authentication = this.tlsClient.getAuthentication();
                        this.authentication.notifyServerCertificate(this.peerCertificate);
                        break;
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
                this.connection_state = (short)4;
                break;
            }
            case 22: {
                switch (this.connection_state) {
                    case 4: {
                        if (!this.allowCertificateStatus) {
                            throw new TlsFatalAlert(10);
                        }
                        this.certificateStatus = CertificateStatus.parse((InputStream)byteArrayInputStream);
                        TlsClientProtocol.assertEmpty((ByteArrayInputStream)byteArrayInputStream);
                        this.connection_state = (short)5;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 20: {
                switch (this.connection_state) {
                    case 13: {
                        if (this.expectSessionTicket) {
                            throw new TlsFatalAlert(10);
                        }
                    }
                    case 14: {
                        this.processFinishedMessage(byteArrayInputStream);
                        this.connection_state = (short)15;
                        this.completeHandshake();
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 2: {
                switch (this.connection_state) {
                    case 1: {
                        this.receiveServerHelloMessage(byteArrayInputStream);
                        this.connection_state = (short)2;
                        this.recordStream.notifyHelloComplete();
                        this.applyMaxFragmentLengthExtension();
                        if (this.resumedSession) {
                            this.securityParameters.masterSecret = Arrays.clone((byte[])this.sessionParameters.getMasterSecret());
                            this.recordStream.setPendingConnectionState(this.getPeer().getCompression(), this.getPeer().getCipher());
                            break block0;
                        }
                        this.invalidateSession();
                        if (this.selectedSessionID.length <= 0) break block0;
                        this.tlsSession = new TlsSessionImpl(this.selectedSessionID, null);
                        break block0;
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
            }
            case 23: {
                switch (this.connection_state) {
                    case 2: {
                        this.handleSupplementalData(TlsClientProtocol.readSupplementalDataMessage((ByteArrayInputStream)byteArrayInputStream));
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 14: {
                switch (this.connection_state) {
                    case 2: {
                        this.handleSupplementalData(null);
                    }
                    case 3: {
                        this.keyExchange.skipServerCredentials();
                        this.authentication = null;
                    }
                    case 4: 
                    case 5: {
                        this.keyExchange.skipServerKeyExchange();
                    }
                    case 6: 
                    case 7: {
                        TlsClientProtocol.assertEmpty((ByteArrayInputStream)byteArrayInputStream);
                        this.connection_state = (short)8;
                        this.recordStream.getHandshakeHash().sealHashAlgorithms();
                        Vector vector = this.tlsClient.getClientSupplementalData();
                        if (vector != null) {
                            this.sendSupplementalDataMessage(vector);
                        }
                        this.connection_state = (short)9;
                        TlsCredentials tlsCredentials = null;
                        if (this.certificateRequest == null) {
                            this.keyExchange.skipClientCredentials();
                        } else {
                            tlsCredentials = this.authentication.getClientCredentials(this.certificateRequest);
                            if (tlsCredentials == null) {
                                this.keyExchange.skipClientCredentials();
                                this.sendCertificateMessage(Certificate.EMPTY_CHAIN);
                            } else {
                                this.keyExchange.processClientCredentials(tlsCredentials);
                                this.sendCertificateMessage(tlsCredentials.getCertificate());
                            }
                        }
                        this.connection_state = (short)10;
                        this.sendClientKeyExchangeMessage();
                        this.connection_state = (short)11;
                        if (TlsUtils.isSSL((TlsContext)this.getContext())) {
                            TlsClientProtocol.establishMasterSecret((TlsContext)this.getContext(), (TlsKeyExchange)this.keyExchange);
                        }
                        TlsHandshakeHash tlsHandshakeHash = this.recordStream.prepareToFinish();
                        this.securityParameters.sessionHash = TlsClientProtocol.getCurrentPRFHash((TlsContext)this.getContext(), (TlsHandshakeHash)tlsHandshakeHash, null);
                        if (!TlsUtils.isSSL((TlsContext)this.getContext())) {
                            TlsClientProtocol.establishMasterSecret((TlsContext)this.getContext(), (TlsKeyExchange)this.keyExchange);
                        }
                        this.recordStream.setPendingConnectionState(this.getPeer().getCompression(), this.getPeer().getCipher());
                        if (tlsCredentials != null && tlsCredentials instanceof TlsSignerCredentials) {
                            TlsSignerCredentials tlsSignerCredentials = (TlsSignerCredentials)tlsCredentials;
                            SignatureAndHashAlgorithm signatureAndHashAlgorithm = TlsUtils.getSignatureAndHashAlgorithm((TlsContext)this.getContext(), (TlsSignerCredentials)tlsSignerCredentials);
                            byte[] byArray = signatureAndHashAlgorithm == null ? this.securityParameters.getSessionHash() : tlsHandshakeHash.getFinalHash(signatureAndHashAlgorithm.getHash());
                            byte[] byArray2 = tlsSignerCredentials.generateCertificateSignature(byArray);
                            DigitallySigned digitallySigned = new DigitallySigned(signatureAndHashAlgorithm, byArray2);
                            this.sendCertificateVerifyMessage(digitallySigned);
                            this.connection_state = (short)12;
                        }
                        this.sendChangeCipherSpecMessage();
                        this.sendFinishedMessage();
                        break;
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
                this.connection_state = (short)13;
                break;
            }
            case 12: {
                switch (this.connection_state) {
                    case 2: {
                        this.handleSupplementalData(null);
                    }
                    case 3: {
                        this.keyExchange.skipServerCredentials();
                        this.authentication = null;
                    }
                    case 4: 
                    case 5: {
                        this.keyExchange.processServerKeyExchange((InputStream)byteArrayInputStream);
                        TlsClientProtocol.assertEmpty((ByteArrayInputStream)byteArrayInputStream);
                        break;
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
                this.connection_state = (short)6;
                break;
            }
            case 13: {
                switch (this.connection_state) {
                    case 4: 
                    case 5: {
                        this.keyExchange.skipServerKeyExchange();
                    }
                    case 6: {
                        if (this.authentication == null) {
                            throw new TlsFatalAlert(40);
                        }
                        this.certificateRequest = CertificateRequest.parse((TlsContext)this.getContext(), (InputStream)byteArrayInputStream);
                        TlsClientProtocol.assertEmpty((ByteArrayInputStream)byteArrayInputStream);
                        this.keyExchange.validateCertificateRequest(this.certificateRequest);
                        TlsUtils.trackHashAlgorithms((TlsHandshakeHash)this.recordStream.getHandshakeHash(), (Vector)this.certificateRequest.getSupportedSignatureAlgorithms());
                        break;
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
                this.connection_state = (short)7;
                break;
            }
            case 4: {
                switch (this.connection_state) {
                    case 13: {
                        if (!this.expectSessionTicket) {
                            throw new TlsFatalAlert(10);
                        }
                        this.invalidateSession();
                        this.receiveNewSessionTicketMessage(byteArrayInputStream);
                        break;
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
                this.connection_state = (short)14;
                break;
            }
            case 0: {
                TlsClientProtocol.assertEmpty((ByteArrayInputStream)byteArrayInputStream);
                if (this.connection_state != 16) break;
                this.refuseRenegotiation();
                break;
            }
            default: {
                throw new TlsFatalAlert(10);
            }
        }
    }

    protected void handleSupplementalData(Vector vector) throws IOException {
        this.tlsClient.processServerSupplementalData(vector);
        this.connection_state = (short)3;
        this.keyExchange = this.tlsClient.getKeyExchange();
        this.keyExchange.init(this.getContext());
    }

    protected void receiveNewSessionTicketMessage(ByteArrayInputStream byteArrayInputStream) throws IOException {
        NewSessionTicket newSessionTicket = NewSessionTicket.parse((InputStream)byteArrayInputStream);
        TlsClientProtocol.assertEmpty((ByteArrayInputStream)byteArrayInputStream);
        this.tlsClient.notifyNewSessionTicket(newSessionTicket);
    }

    protected void receiveServerHelloMessage(ByteArrayInputStream byteArrayInputStream) throws IOException {
        Serializable serializable;
        Object object;
        ProtocolVersion protocolVersion = TlsUtils.readVersion((InputStream)byteArrayInputStream);
        if (protocolVersion.isDTLS()) {
            throw new TlsFatalAlert(47);
        }
        if (!protocolVersion.equals(this.recordStream.getReadVersion())) {
            throw new TlsFatalAlert(47);
        }
        ProtocolVersion protocolVersion2 = this.getContext().getClientVersion();
        if (!protocolVersion.isEqualOrEarlierVersionOf(protocolVersion2)) {
            throw new TlsFatalAlert(47);
        }
        this.recordStream.setWriteVersion(protocolVersion);
        this.getContextAdmin().setServerVersion(protocolVersion);
        this.tlsClient.notifyServerVersion(protocolVersion);
        this.securityParameters.serverRandom = TlsUtils.readFully((int)32, (InputStream)byteArrayInputStream);
        this.selectedSessionID = TlsUtils.readOpaque8((InputStream)byteArrayInputStream);
        if (this.selectedSessionID.length > 32) {
            throw new TlsFatalAlert(47);
        }
        this.tlsClient.notifySessionID(this.selectedSessionID);
        this.resumedSession = this.selectedSessionID.length > 0 && this.tlsSession != null && Arrays.areEqual((byte[])this.selectedSessionID, (byte[])this.tlsSession.getSessionID());
        int n2 = TlsUtils.readUint16((InputStream)byteArrayInputStream);
        if (!Arrays.contains((int[])this.offeredCipherSuites, (int)n2) || n2 == 0 || CipherSuite.isSCSV((int)n2) || !TlsUtils.isValidCipherSuiteForVersion((int)n2, (ProtocolVersion)this.getContext().getServerVersion())) {
            throw new TlsFatalAlert(47);
        }
        this.tlsClient.notifySelectedCipherSuite(n2);
        short s2 = TlsUtils.readUint8((InputStream)byteArrayInputStream);
        if (!Arrays.contains((short[])this.offeredCompressionMethods, (short)s2)) {
            throw new TlsFatalAlert(47);
        }
        this.tlsClient.notifySelectedCompressionMethod(s2);
        this.serverExtensions = TlsClientProtocol.readExtensions((ByteArrayInputStream)byteArrayInputStream);
        if (this.serverExtensions != null) {
            object = this.serverExtensions.keys();
            while (object.hasMoreElements()) {
                serializable = (Integer)object.nextElement();
                if (serializable.equals(EXT_RenegotiationInfo)) continue;
                if (null == TlsUtils.getExtensionData((Hashtable)this.clientExtensions, (Integer)serializable)) {
                    throw new TlsFatalAlert(110);
                }
                if (!this.resumedSession) continue;
            }
        }
        if ((object = (Object)TlsUtils.getExtensionData((Hashtable)this.serverExtensions, (Integer)EXT_RenegotiationInfo)) != null) {
            this.secure_renegotiation = true;
            if (!Arrays.constantTimeAreEqual((byte[])object, (byte[])TlsClientProtocol.createRenegotiationInfo((byte[])TlsUtils.EMPTY_BYTES))) {
                throw new TlsFatalAlert(40);
            }
        }
        this.tlsClient.notifySecureRenegotiation(this.secure_renegotiation);
        object = this.clientExtensions;
        serializable = this.serverExtensions;
        if (this.resumedSession) {
            if (n2 != this.sessionParameters.getCipherSuite() || s2 != this.sessionParameters.getCompressionAlgorithm()) {
                throw new TlsFatalAlert(47);
            }
            object = null;
            serializable = this.sessionParameters.readServerExtensions();
        }
        this.securityParameters.cipherSuite = n2;
        this.securityParameters.compressionAlgorithm = s2;
        if (serializable != null) {
            boolean bl2 = TlsExtensionsUtils.hasEncryptThenMACExtension((Hashtable)serializable);
            if (bl2 && !TlsUtils.isBlockCipherSuite((int)n2)) {
                throw new TlsFatalAlert(47);
            }
            this.securityParameters.encryptThenMAC = bl2;
            this.securityParameters.extendedMasterSecret = TlsExtensionsUtils.hasExtendedMasterSecretExtension((Hashtable)serializable);
            this.securityParameters.maxFragmentLength = this.processMaxFragmentLengthExtension((Hashtable)object, (Hashtable)serializable, (short)47);
            this.securityParameters.truncatedHMac = TlsExtensionsUtils.hasTruncatedHMacExtension((Hashtable)serializable);
            this.allowCertificateStatus = !this.resumedSession && TlsUtils.hasExpectedEmptyExtensionData((Hashtable)serializable, (Integer)TlsExtensionsUtils.EXT_status_request, (short)47);
            boolean bl3 = this.expectSessionTicket = !this.resumedSession && TlsUtils.hasExpectedEmptyExtensionData((Hashtable)serializable, (Integer)TlsProtocol.EXT_SessionTicket, (short)47);
        }
        if (object != null) {
            this.tlsClient.processServerExtensions((Hashtable)serializable);
        }
        this.securityParameters.prfAlgorithm = TlsClientProtocol.getPRFAlgorithm((TlsContext)this.getContext(), (int)this.securityParameters.getCipherSuite());
        this.securityParameters.verifyDataLength = 12;
    }

    protected void sendCertificateVerifyMessage(DigitallySigned digitallySigned) throws IOException {
        TlsProtocol.HandshakeMessage handshakeMessage = new TlsProtocol.HandshakeMessage((TlsProtocol)this, 15);
        digitallySigned.encode((OutputStream)handshakeMessage);
        handshakeMessage.writeToRecordStream();
    }

    protected void sendClientHelloMessage() throws IOException {
        boolean bl2;
        this.recordStream.setWriteVersion(this.tlsClient.getClientHelloRecordLayerVersion());
        ProtocolVersion protocolVersion = this.tlsClient.getClientVersion();
        if (protocolVersion.isDTLS()) {
            throw new TlsFatalAlert(80);
        }
        this.getContextAdmin().setClientVersion(protocolVersion);
        byte[] byArray = TlsUtils.EMPTY_BYTES;
        if (this.tlsSession != null && ((byArray = this.tlsSession.getSessionID()) == null || byArray.length > 32)) {
            byArray = TlsUtils.EMPTY_BYTES;
        }
        boolean bl3 = this.tlsClient.isFallback();
        this.offeredCipherSuites = this.tlsClient.getCipherSuites();
        this.offeredCompressionMethods = this.tlsClient.getCompressionMethods();
        if (!(byArray.length <= 0 || this.sessionParameters == null || Arrays.contains((int[])this.offeredCipherSuites, (int)this.sessionParameters.getCipherSuite()) && Arrays.contains((short[])this.offeredCompressionMethods, (short)this.sessionParameters.getCompressionAlgorithm()))) {
            byArray = TlsUtils.EMPTY_BYTES;
        }
        this.clientExtensions = this.tlsClient.getClientExtensions();
        TlsProtocol.HandshakeMessage handshakeMessage = new TlsProtocol.HandshakeMessage((TlsProtocol)this, 1);
        TlsUtils.writeVersion((ProtocolVersion)protocolVersion, (OutputStream)handshakeMessage);
        handshakeMessage.write(this.securityParameters.getClientRandom());
        TlsUtils.writeOpaque8((byte[])byArray, (OutputStream)handshakeMessage);
        byte[] byArray2 = TlsUtils.getExtensionData((Hashtable)this.clientExtensions, (Integer)EXT_RenegotiationInfo);
        boolean bl4 = null == byArray2;
        boolean bl5 = bl2 = !Arrays.contains((int[])this.offeredCipherSuites, (int)255);
        if (bl4 && bl2) {
            this.offeredCipherSuites = Arrays.append((int[])this.offeredCipherSuites, (int)255);
        }
        if (bl3 && !Arrays.contains((int[])this.offeredCipherSuites, (int)22016)) {
            this.offeredCipherSuites = Arrays.append((int[])this.offeredCipherSuites, (int)22016);
        }
        TlsUtils.writeUint16ArrayWithUint16Length((int[])this.offeredCipherSuites, (OutputStream)handshakeMessage);
        TlsUtils.writeUint8ArrayWithUint8Length((short[])this.offeredCompressionMethods, (OutputStream)handshakeMessage);
        if (this.clientExtensions != null) {
            TlsClientProtocol.writeExtensions((OutputStream)handshakeMessage, (Hashtable)this.clientExtensions);
        }
        handshakeMessage.writeToRecordStream();
    }

    protected void sendClientKeyExchangeMessage() throws IOException {
        TlsProtocol.HandshakeMessage handshakeMessage = new TlsProtocol.HandshakeMessage((TlsProtocol)this, 16);
        this.keyExchange.generateClientKeyExchange((OutputStream)handshakeMessage);
        handshakeMessage.writeToRecordStream();
    }
}

