/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls;

import java.io.IOException;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.CipherParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.modes.AEADBlockCipher;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.AEADParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.KeyParameter;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.ProtocolVersion;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsCipher;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsContext;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsFatalAlert;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsUtils;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Arrays;

public class TlsAEADCipher
implements TlsCipher {
    public static final int NONCE_RFC5288 = 1;
    static final int NONCE_DRAFT_CHACHA20_POLY1305 = 2;
    protected TlsContext context;
    protected int macSize;
    protected int record_iv_length;
    protected AEADBlockCipher encryptCipher;
    protected AEADBlockCipher decryptCipher;
    protected byte[] encryptImplicitNonce;
    protected byte[] decryptImplicitNonce;
    protected int nonceMode;

    public TlsAEADCipher(TlsContext tlsContext, AEADBlockCipher aEADBlockCipher, AEADBlockCipher aEADBlockCipher2, int n2, int n3) throws IOException {
        this(tlsContext, aEADBlockCipher, aEADBlockCipher2, n2, n3, 1);
    }

    TlsAEADCipher(TlsContext tlsContext, AEADBlockCipher aEADBlockCipher, AEADBlockCipher aEADBlockCipher2, int n2, int n3, int n4) throws IOException {
        KeyParameter keyParameter;
        KeyParameter keyParameter2;
        int n5;
        if (!TlsUtils.isTLSv12((TlsContext)tlsContext)) {
            throw new TlsFatalAlert(80);
        }
        this.nonceMode = n4;
        switch (n4) {
            case 1: {
                n5 = 4;
                this.record_iv_length = 8;
                break;
            }
            case 2: {
                n5 = 12;
                this.record_iv_length = 0;
                break;
            }
            default: {
                throw new TlsFatalAlert(80);
            }
        }
        this.context = tlsContext;
        this.macSize = n3;
        int n6 = 2 * n2 + 2 * n5;
        byte[] byArray = TlsUtils.calculateKeyBlock((TlsContext)tlsContext, (int)n6);
        int n7 = 0;
        KeyParameter keyParameter3 = new KeyParameter(byArray, n7, n2);
        KeyParameter keyParameter4 = new KeyParameter(byArray, n7 += n2, n2);
        byte[] byArray2 = Arrays.copyOfRange((byte[])byArray, (int)(n7 += n2), (int)(n7 + n5));
        byte[] byArray3 = Arrays.copyOfRange((byte[])byArray, (int)(n7 += n5), (int)(n7 + n5));
        if ((n7 += n5) != n6) {
            throw new TlsFatalAlert(80);
        }
        if (tlsContext.isServer()) {
            this.encryptCipher = aEADBlockCipher2;
            this.decryptCipher = aEADBlockCipher;
            this.encryptImplicitNonce = byArray3;
            this.decryptImplicitNonce = byArray2;
            keyParameter2 = keyParameter4;
            keyParameter = keyParameter3;
        } else {
            this.encryptCipher = aEADBlockCipher;
            this.decryptCipher = aEADBlockCipher2;
            this.encryptImplicitNonce = byArray2;
            this.decryptImplicitNonce = byArray3;
            keyParameter2 = keyParameter3;
            keyParameter = keyParameter4;
        }
        byte[] byArray4 = new byte[n5 + this.record_iv_length];
        this.encryptCipher.init(true, (CipherParameters)new AEADParameters(keyParameter2, 8 * n3, byArray4));
        this.decryptCipher.init(false, (CipherParameters)new AEADParameters(keyParameter, 8 * n3, byArray4));
    }

    public int getPlaintextLimit(int n2) {
        return n2 - this.macSize - this.record_iv_length;
    }

    public byte[] encodePlaintext(long l2, short s2, byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        byte[] byArray2 = new byte[this.encryptImplicitNonce.length + this.record_iv_length];
        switch (this.nonceMode) {
            case 1: {
                System.arraycopy(this.encryptImplicitNonce, 0, byArray2, 0, this.encryptImplicitNonce.length);
                TlsUtils.writeUint64((long)l2, (byte[])byArray2, (int)this.encryptImplicitNonce.length);
                break;
            }
            case 2: {
                TlsUtils.writeUint64((long)l2, (byte[])byArray2, (int)(byArray2.length - 8));
                for (n4 = 0; n4 < this.encryptImplicitNonce.length; ++n4) {
                    int n5 = n4;
                    byArray2[n5] = (byte)(byArray2[n5] ^ this.encryptImplicitNonce[n4]);
                }
                break;
            }
            default: {
                throw new TlsFatalAlert(80);
            }
        }
        n4 = n2;
        int n6 = n3;
        int n7 = this.encryptCipher.getOutputSize(n6);
        byte[] byArray3 = new byte[this.record_iv_length + n7];
        if (this.record_iv_length != 0) {
            System.arraycopy(byArray2, byArray2.length - this.record_iv_length, byArray3, 0, this.record_iv_length);
        }
        int n8 = this.record_iv_length;
        byte[] byArray4 = this.getAdditionalData(l2, s2, n6);
        AEADParameters aEADParameters = new AEADParameters(null, 8 * this.macSize, byArray2, byArray4);
        try {
            this.encryptCipher.init(true, (CipherParameters)aEADParameters);
            n8 += this.encryptCipher.processBytes(byArray, n4, n6, byArray3, n8);
            n8 += this.encryptCipher.doFinal(byArray3, n8);
        }
        catch (Exception exception) {
            throw new TlsFatalAlert(80, (Throwable)exception);
        }
        if (n8 != byArray3.length) {
            throw new TlsFatalAlert(80);
        }
        return byArray3;
    }

    public byte[] decodeCiphertext(long l2, short s2, byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        if (this.getPlaintextLimit(n3) < 0) {
            throw new TlsFatalAlert(50);
        }
        byte[] byArray2 = new byte[this.decryptImplicitNonce.length + this.record_iv_length];
        switch (this.nonceMode) {
            case 1: {
                System.arraycopy(this.decryptImplicitNonce, 0, byArray2, 0, this.decryptImplicitNonce.length);
                System.arraycopy(byArray, n2, byArray2, byArray2.length - this.record_iv_length, this.record_iv_length);
                break;
            }
            case 2: {
                TlsUtils.writeUint64((long)l2, (byte[])byArray2, (int)(byArray2.length - 8));
                for (n4 = 0; n4 < this.decryptImplicitNonce.length; ++n4) {
                    int n5 = n4;
                    byArray2[n5] = (byte)(byArray2[n5] ^ this.decryptImplicitNonce[n4]);
                }
                break;
            }
            default: {
                throw new TlsFatalAlert(80);
            }
        }
        n4 = n2 + this.record_iv_length;
        int n6 = n3 - this.record_iv_length;
        int n7 = this.decryptCipher.getOutputSize(n6);
        byte[] byArray3 = new byte[n7];
        int n8 = 0;
        byte[] byArray4 = this.getAdditionalData(l2, s2, n7);
        AEADParameters aEADParameters = new AEADParameters(null, 8 * this.macSize, byArray2, byArray4);
        try {
            this.decryptCipher.init(false, (CipherParameters)aEADParameters);
            n8 += this.decryptCipher.processBytes(byArray, n4, n6, byArray3, n8);
            n8 += this.decryptCipher.doFinal(byArray3, n8);
        }
        catch (Exception exception) {
            throw new TlsFatalAlert(20, (Throwable)exception);
        }
        if (n8 != byArray3.length) {
            throw new TlsFatalAlert(80);
        }
        return byArray3;
    }

    protected byte[] getAdditionalData(long l2, short s2, int n2) throws IOException {
        byte[] byArray = new byte[13];
        TlsUtils.writeUint64((long)l2, (byte[])byArray, (int)0);
        TlsUtils.writeUint8((short)s2, (byte[])byArray, (int)8);
        TlsUtils.writeVersion((ProtocolVersion)this.context.getServerVersion(), (byte[])byArray, (int)9);
        TlsUtils.writeUint16((int)n2, (byte[])byArray, (int)11);
        return byArray;
    }
}

