/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsSRPUtils;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsUtils;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Arrays;

public class ServerSRPParams {
    protected BigInteger N;
    protected BigInteger g;
    protected BigInteger B;
    protected byte[] s;

    public ServerSRPParams(BigInteger bigInteger, BigInteger bigInteger2, byte[] byArray, BigInteger bigInteger3) {
        this.N = bigInteger;
        this.g = bigInteger2;
        this.s = Arrays.clone((byte[])byArray);
        this.B = bigInteger3;
    }

    public BigInteger getB() {
        return this.B;
    }

    public BigInteger getG() {
        return this.g;
    }

    public BigInteger getN() {
        return this.N;
    }

    public byte[] getS() {
        return this.s;
    }

    public void encode(OutputStream outputStream) throws IOException {
        TlsSRPUtils.writeSRPParameter((BigInteger)this.N, (OutputStream)outputStream);
        TlsSRPUtils.writeSRPParameter((BigInteger)this.g, (OutputStream)outputStream);
        TlsUtils.writeOpaque8((byte[])this.s, (OutputStream)outputStream);
        TlsSRPUtils.writeSRPParameter((BigInteger)this.B, (OutputStream)outputStream);
    }

    public static ServerSRPParams parse(InputStream inputStream) throws IOException {
        BigInteger bigInteger = TlsSRPUtils.readSRPParameter((InputStream)inputStream);
        BigInteger bigInteger2 = TlsSRPUtils.readSRPParameter((InputStream)inputStream);
        byte[] byArray = TlsUtils.readOpaque8((InputStream)inputStream);
        BigInteger bigInteger3 = TlsSRPUtils.readSRPParameter((InputStream)inputStream);
        return new ServerSRPParams(bigInteger, bigInteger2, byArray, bigInteger3);
    }
}

