/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.DHParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.DHPublicKeyParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsDHUtils;

public class ServerDHParams {
    protected DHPublicKeyParameters publicKey;

    public ServerDHParams(DHPublicKeyParameters dHPublicKeyParameters) {
        if (dHPublicKeyParameters == null) {
            throw new IllegalArgumentException("'publicKey' cannot be null");
        }
        this.publicKey = dHPublicKeyParameters;
    }

    public DHPublicKeyParameters getPublicKey() {
        return this.publicKey;
    }

    public void encode(OutputStream outputStream) throws IOException {
        DHParameters dHParameters = this.publicKey.getParameters();
        BigInteger bigInteger = this.publicKey.getY();
        TlsDHUtils.writeDHParameter((BigInteger)dHParameters.getP(), (OutputStream)outputStream);
        TlsDHUtils.writeDHParameter((BigInteger)dHParameters.getG(), (OutputStream)outputStream);
        TlsDHUtils.writeDHParameter((BigInteger)bigInteger, (OutputStream)outputStream);
    }

    public static ServerDHParams parse(InputStream inputStream) throws IOException {
        BigInteger bigInteger = TlsDHUtils.readDHParameter((InputStream)inputStream);
        BigInteger bigInteger2 = TlsDHUtils.readDHParameter((InputStream)inputStream);
        BigInteger bigInteger3 = TlsDHUtils.readDHParameter((InputStream)inputStream);
        return new ServerDHParams(TlsDHUtils.validateDHPublicKey((DHPublicKeyParameters)new DHPublicKeyParameters(bigInteger3, new DHParameters(bigInteger, bigInteger2))));
    }
}

