/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls;

import java.io.IOException;
import java.util.Hashtable;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.AbstractTlsServer;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.DefaultTlsCipherFactory;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsCipherFactory;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsCredentials;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsFatalAlert;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsKeyExchange;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsSRPIdentityManager;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsSRPKeyExchange;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsSRPLoginParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsSRPUtils;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsSignerCredentials;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsUtils;

public class SRPTlsServer
extends AbstractTlsServer {
    protected TlsSRPIdentityManager srpIdentityManager;
    protected byte[] srpIdentity = null;
    protected TlsSRPLoginParameters loginParameters = null;

    public SRPTlsServer(TlsSRPIdentityManager tlsSRPIdentityManager) {
        this((TlsCipherFactory)new DefaultTlsCipherFactory(), tlsSRPIdentityManager);
    }

    public SRPTlsServer(TlsCipherFactory tlsCipherFactory, TlsSRPIdentityManager tlsSRPIdentityManager) {
        super(tlsCipherFactory);
        this.srpIdentityManager = tlsSRPIdentityManager;
    }

    protected TlsSignerCredentials getDSASignerCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected TlsSignerCredentials getRSASignerCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected int[] getCipherSuites() {
        return new int[]{49186, 49183, 49185, 49182, 49184, 49181};
    }

    public void processClientExtensions(Hashtable hashtable) throws IOException {
        super.processClientExtensions(hashtable);
        this.srpIdentity = TlsSRPUtils.getSRPExtension((Hashtable)hashtable);
    }

    public int getSelectedCipherSuite() throws IOException {
        int n2 = super.getSelectedCipherSuite();
        if (TlsSRPUtils.isSRPCipherSuite((int)n2)) {
            if (this.srpIdentity != null) {
                this.loginParameters = this.srpIdentityManager.getLoginParameters(this.srpIdentity);
            }
            if (this.loginParameters == null) {
                throw new TlsFatalAlert(115);
            }
        }
        return n2;
    }

    public TlsCredentials getCredentials() throws IOException {
        int n2 = TlsUtils.getKeyExchangeAlgorithm((int)this.selectedCipherSuite);
        switch (n2) {
            case 21: {
                return null;
            }
            case 22: {
                return this.getDSASignerCredentials();
            }
            case 23: {
                return this.getRSASignerCredentials();
            }
        }
        throw new TlsFatalAlert(80);
    }

    public TlsKeyExchange getKeyExchange() throws IOException {
        int n2 = TlsUtils.getKeyExchangeAlgorithm((int)this.selectedCipherSuite);
        switch (n2) {
            case 21: 
            case 22: 
            case 23: {
                return this.createSRPKeyExchange(n2);
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected TlsKeyExchange createSRPKeyExchange(int n2) {
        return new TlsSRPKeyExchange(n2, this.supportedSignatureAlgorithms, this.srpIdentity, this.loginParameters);
    }
}

