/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls;

import java.io.IOException;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.agreement.DHStandardGroups;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.DHParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.AbstractTlsServer;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.DefaultTlsCipherFactory;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsCipherFactory;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsCredentials;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsEncryptionCredentials;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsFatalAlert;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsKeyExchange;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsPSKIdentityManager;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsPSKKeyExchange;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsUtils;

public class PSKTlsServer
extends AbstractTlsServer {
    protected TlsPSKIdentityManager pskIdentityManager;

    public PSKTlsServer(TlsPSKIdentityManager tlsPSKIdentityManager) {
        this((TlsCipherFactory)new DefaultTlsCipherFactory(), tlsPSKIdentityManager);
    }

    public PSKTlsServer(TlsCipherFactory tlsCipherFactory, TlsPSKIdentityManager tlsPSKIdentityManager) {
        super(tlsCipherFactory);
        this.pskIdentityManager = tlsPSKIdentityManager;
    }

    protected TlsEncryptionCredentials getRSAEncryptionCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected DHParameters getDHParameters() {
        return DHStandardGroups.rfc7919_ffdhe2048;
    }

    protected int[] getCipherSuites() {
        return new int[]{49207, 49205, 178, 144};
    }

    public TlsCredentials getCredentials() throws IOException {
        int n2 = TlsUtils.getKeyExchangeAlgorithm((int)this.selectedCipherSuite);
        switch (n2) {
            case 13: 
            case 14: 
            case 24: {
                return null;
            }
            case 15: {
                return this.getRSAEncryptionCredentials();
            }
        }
        throw new TlsFatalAlert(80);
    }

    public TlsKeyExchange getKeyExchange() throws IOException {
        int n2 = TlsUtils.getKeyExchangeAlgorithm((int)this.selectedCipherSuite);
        switch (n2) {
            case 13: 
            case 14: 
            case 15: 
            case 24: {
                return this.createPSKKeyExchange(n2);
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected TlsKeyExchange createPSKKeyExchange(int n2) {
        return new TlsPSKKeyExchange(n2, this.supportedSignatureAlgorithms, null, this.pskIdentityManager, this.getDHParameters(), this.namedCurves, this.clientECPointFormats, this.serverECPointFormats);
    }
}

