/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.HeartbeatMessage;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.HeartbeatMessageType;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsContext;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsFatalAlert;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsUtils;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.io.Streams;

public class HeartbeatMessage {
    protected short type;
    protected byte[] payload;
    protected int paddingLength;

    public HeartbeatMessage(short s2, byte[] byArray, int n2) {
        if (!HeartbeatMessageType.isValid((short)s2)) {
            throw new IllegalArgumentException("'type' is not a valid HeartbeatMessageType value");
        }
        if (byArray == null || byArray.length >= 65536) {
            throw new IllegalArgumentException("'payload' must have length < 2^16");
        }
        if (n2 < 16) {
            throw new IllegalArgumentException("'paddingLength' must be at least 16");
        }
        this.type = s2;
        this.payload = byArray;
        this.paddingLength = n2;
    }

    public void encode(TlsContext tlsContext, OutputStream outputStream) throws IOException {
        TlsUtils.writeUint8((short)this.type, (OutputStream)outputStream);
        TlsUtils.checkUint16((int)this.payload.length);
        TlsUtils.writeUint16((int)this.payload.length, (OutputStream)outputStream);
        outputStream.write(this.payload);
        byte[] byArray = new byte[this.paddingLength];
        tlsContext.getNonceRandomGenerator().nextBytes(byArray);
        outputStream.write(byArray);
    }

    public static HeartbeatMessage parse(InputStream inputStream) throws IOException {
        short s2 = TlsUtils.readUint8((InputStream)inputStream);
        if (!HeartbeatMessageType.isValid((short)s2)) {
            throw new TlsFatalAlert(47);
        }
        int n2 = TlsUtils.readUint16((InputStream)inputStream);
        PayloadBuffer payloadBuffer = new PayloadBuffer();
        Streams.pipeAll((InputStream)inputStream, (OutputStream)payloadBuffer);
        byte[] byArray = payloadBuffer.toTruncatedByteArray(n2);
        if (byArray == null) {
            return null;
        }
        int n3 = payloadBuffer.size() - byArray.length;
        return new HeartbeatMessage(s2, byArray, n3);
    }
}

