/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.SignatureAndHashAlgorithm;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsContext;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsUtils;

public class DigitallySigned {
    protected SignatureAndHashAlgorithm algorithm;
    protected byte[] signature;

    public DigitallySigned(SignatureAndHashAlgorithm signatureAndHashAlgorithm, byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("'signature' cannot be null");
        }
        this.algorithm = signatureAndHashAlgorithm;
        this.signature = byArray;
    }

    public SignatureAndHashAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (this.algorithm != null) {
            this.algorithm.encode(outputStream);
        }
        TlsUtils.writeOpaque16((byte[])this.signature, (OutputStream)outputStream);
    }

    public static DigitallySigned parse(TlsContext tlsContext, InputStream inputStream) throws IOException {
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = null;
        if (TlsUtils.isTLSv12((TlsContext)tlsContext)) {
            signatureAndHashAlgorithm = SignatureAndHashAlgorithm.parse((InputStream)inputStream);
        }
        byte[] byArray = TlsUtils.readOpaque16((InputStream)inputStream);
        return new DigitallySigned(signatureAndHashAlgorithm, byArray);
    }
}

