/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.Hashtable;
import java.util.Vector;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.SubjectPublicKeyInfo;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.AsymmetricKeyParameter;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.prng.RandomGenerator;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.Certificate;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.CertificateRequest;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.CertificateStatus;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.CipherSuite;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.DTLSProtocol;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.DTLSRecordLayer;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.DTLSReliableHandshake;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.DTLSServerProtocol;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.DTLSTransport;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.DatagramTransport;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.DigitallySigned;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.NewSessionTicket;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.ProtocolVersion;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.SecurityParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.SignatureAndHashAlgorithm;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsContext;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsExtensionsUtils;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsFatalAlert;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsHandshakeHash;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsKeyExchange;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsPeer;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsProtocol;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsServer;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsServerContext;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsServerContextImpl;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsSigner;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsUtils;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.util.PublicKeyFactory;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Arrays;

/*
 * Exception performing whole class analysis ignored.
 */
public class DTLSServerProtocol
extends DTLSProtocol {
    protected boolean verifyRequests = true;

    public DTLSServerProtocol(SecureRandom secureRandom) {
        super(secureRandom);
    }

    public boolean getVerifyRequests() {
        return this.verifyRequests;
    }

    public void setVerifyRequests(boolean bl2) {
        this.verifyRequests = bl2;
    }

    public DTLSTransport accept(TlsServer tlsServer, DatagramTransport datagramTransport) throws IOException {
        if (tlsServer == null) {
            throw new IllegalArgumentException("'server' cannot be null");
        }
        if (datagramTransport == null) {
            throw new IllegalArgumentException("'transport' cannot be null");
        }
        SecurityParameters securityParameters = new SecurityParameters();
        securityParameters.entity = 0;
        ServerHandshakeState serverHandshakeState = new ServerHandshakeState();
        serverHandshakeState.server = tlsServer;
        serverHandshakeState.serverContext = new TlsServerContextImpl(this.secureRandom, securityParameters);
        securityParameters.serverRandom = TlsProtocol.createRandomBlock((boolean)tlsServer.shouldUseGMTUnixTime(), (RandomGenerator)serverHandshakeState.serverContext.getNonceRandomGenerator());
        tlsServer.init((TlsServerContext)serverHandshakeState.serverContext);
        DTLSRecordLayer dTLSRecordLayer = new DTLSRecordLayer(datagramTransport, (TlsContext)serverHandshakeState.serverContext, (TlsPeer)tlsServer, 22);
        try {
            DTLSTransport dTLSTransport = this.serverHandshake(serverHandshakeState, dTLSRecordLayer);
            return dTLSTransport;
        }
        catch (TlsFatalAlert tlsFatalAlert) {
            this.abortServerHandshake(serverHandshakeState, dTLSRecordLayer, tlsFatalAlert.getAlertDescription());
            throw tlsFatalAlert;
        }
        catch (IOException iOException) {
            this.abortServerHandshake(serverHandshakeState, dTLSRecordLayer, (short)80);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.abortServerHandshake(serverHandshakeState, dTLSRecordLayer, (short)80);
            throw new TlsFatalAlert(80, (Throwable)runtimeException);
        }
        finally {
            securityParameters.clear();
        }
    }

    protected void abortServerHandshake(ServerHandshakeState serverHandshakeState, DTLSRecordLayer dTLSRecordLayer, short s2) {
        dTLSRecordLayer.fail(s2);
        this.invalidateSession(serverHandshakeState);
    }

    protected DTLSTransport serverHandshake(ServerHandshakeState serverHandshakeState, DTLSRecordLayer dTLSRecordLayer) throws IOException {
        Object object;
        byte[] byArray;
        Object object2;
        Object object3;
        SecurityParameters securityParameters = serverHandshakeState.serverContext.getSecurityParameters();
        DTLSReliableHandshake dTLSReliableHandshake = new DTLSReliableHandshake((TlsContext)serverHandshakeState.serverContext, dTLSRecordLayer);
        DTLSReliableHandshake.Message message = dTLSReliableHandshake.receiveMessage();
        if (message.getType() != 1) {
            throw new TlsFatalAlert(10);
        }
        this.processClientHello(serverHandshakeState, message.getBody());
        Object object4 = this.generateServerHello(serverHandshakeState);
        DTLSServerProtocol.applyMaxFragmentLengthExtension((DTLSRecordLayer)dTLSRecordLayer, (short)securityParameters.maxFragmentLength);
        Object object5 = serverHandshakeState.serverContext.getServerVersion();
        dTLSRecordLayer.setReadVersion(object5);
        dTLSRecordLayer.setWriteVersion(object5);
        dTLSReliableHandshake.sendMessage((short)2, object4);
        dTLSReliableHandshake.notifyHelloComplete();
        object4 = serverHandshakeState.server.getServerSupplementalData();
        if (object4 != null) {
            object5 = DTLSServerProtocol.generateSupplementalData((Vector)object4);
            dTLSReliableHandshake.sendMessage((short)23, (byte[])object5);
        }
        serverHandshakeState.keyExchange = serverHandshakeState.server.getKeyExchange();
        serverHandshakeState.keyExchange.init((TlsContext)serverHandshakeState.serverContext);
        serverHandshakeState.serverCredentials = serverHandshakeState.server.getCredentials();
        object5 = null;
        if (serverHandshakeState.serverCredentials == null) {
            serverHandshakeState.keyExchange.skipServerCredentials();
        } else {
            serverHandshakeState.keyExchange.processServerCredentials(serverHandshakeState.serverCredentials);
            object5 = serverHandshakeState.serverCredentials.getCertificate();
            object3 = DTLSServerProtocol.generateCertificate((Certificate)object5);
            dTLSReliableHandshake.sendMessage((short)11, object3);
        }
        if (object5 == null || object5.isEmpty()) {
            serverHandshakeState.allowCertificateStatus = false;
        }
        if (serverHandshakeState.allowCertificateStatus && (object3 = (Object)serverHandshakeState.server.getCertificateStatus()) != null) {
            object2 = this.generateCertificateStatus(serverHandshakeState, (CertificateStatus)object3);
            dTLSReliableHandshake.sendMessage((short)22, object2);
        }
        if ((object3 = serverHandshakeState.keyExchange.generateServerKeyExchange()) != null) {
            dTLSReliableHandshake.sendMessage((short)12, object3);
        }
        if (serverHandshakeState.serverCredentials != null) {
            serverHandshakeState.certificateRequest = serverHandshakeState.server.getCertificateRequest();
            if (serverHandshakeState.certificateRequest != null) {
                if (TlsUtils.isTLSv12((TlsContext)serverHandshakeState.serverContext) != (serverHandshakeState.certificateRequest.getSupportedSignatureAlgorithms() != null)) {
                    throw new TlsFatalAlert(80);
                }
                serverHandshakeState.keyExchange.validateCertificateRequest(serverHandshakeState.certificateRequest);
                object2 = this.generateCertificateRequest(serverHandshakeState, serverHandshakeState.certificateRequest);
                dTLSReliableHandshake.sendMessage((short)13, object2);
                TlsUtils.trackHashAlgorithms((TlsHandshakeHash)dTLSReliableHandshake.getHandshakeHash(), (Vector)serverHandshakeState.certificateRequest.getSupportedSignatureAlgorithms());
            }
        }
        dTLSReliableHandshake.sendMessage((short)14, TlsUtils.EMPTY_BYTES);
        dTLSReliableHandshake.getHandshakeHash().sealHashAlgorithms();
        message = dTLSReliableHandshake.receiveMessage();
        if (message.getType() == 23) {
            this.processClientSupplementalData(serverHandshakeState, message.getBody());
            message = dTLSReliableHandshake.receiveMessage();
        } else {
            serverHandshakeState.server.processClientSupplementalData(null);
        }
        if (serverHandshakeState.certificateRequest == null) {
            serverHandshakeState.keyExchange.skipClientCredentials();
        } else if (message.getType() == 11) {
            this.processClientCertificate(serverHandshakeState, message.getBody());
            message = dTLSReliableHandshake.receiveMessage();
        } else {
            if (TlsUtils.isTLSv12((TlsContext)serverHandshakeState.serverContext)) {
                throw new TlsFatalAlert(10);
            }
            this.notifyClientCertificate(serverHandshakeState, Certificate.EMPTY_CHAIN);
        }
        if (message.getType() != 16) {
            throw new TlsFatalAlert(10);
        }
        this.processClientKeyExchange(serverHandshakeState, message.getBody());
        object2 = dTLSReliableHandshake.prepareToFinish();
        securityParameters.sessionHash = TlsProtocol.getCurrentPRFHash((TlsContext)serverHandshakeState.serverContext, (TlsHandshakeHash)object2, null);
        TlsProtocol.establishMasterSecret((TlsContext)serverHandshakeState.serverContext, (TlsKeyExchange)serverHandshakeState.keyExchange);
        dTLSRecordLayer.initPendingEpoch(serverHandshakeState.server.getCipher());
        if (this.expectCertificateVerifyMessage(serverHandshakeState)) {
            byArray = dTLSReliableHandshake.receiveMessageBody((short)15);
            this.processCertificateVerify(serverHandshakeState, byArray, (TlsHandshakeHash)object2);
        }
        byArray = TlsUtils.calculateVerifyData((TlsContext)serverHandshakeState.serverContext, (String)"client finished", (byte[])TlsProtocol.getCurrentPRFHash((TlsContext)serverHandshakeState.serverContext, (TlsHandshakeHash)dTLSReliableHandshake.getHandshakeHash(), null));
        this.processFinished(dTLSReliableHandshake.receiveMessageBody((short)20), byArray);
        if (serverHandshakeState.expectSessionTicket) {
            object = serverHandshakeState.server.getNewSessionTicket();
            byte[] byArray2 = this.generateNewSessionTicket(serverHandshakeState, object);
            dTLSReliableHandshake.sendMessage((short)4, byArray2);
        }
        object = TlsUtils.calculateVerifyData((TlsContext)serverHandshakeState.serverContext, (String)"server finished", (byte[])TlsProtocol.getCurrentPRFHash((TlsContext)serverHandshakeState.serverContext, (TlsHandshakeHash)dTLSReliableHandshake.getHandshakeHash(), null));
        dTLSReliableHandshake.sendMessage((short)20, (byte[])object);
        dTLSReliableHandshake.finish();
        serverHandshakeState.server.notifyHandshakeComplete();
        return new DTLSTransport(dTLSRecordLayer);
    }

    protected byte[] generateCertificateRequest(ServerHandshakeState serverHandshakeState, CertificateRequest certificateRequest) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        certificateRequest.encode((OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected byte[] generateCertificateStatus(ServerHandshakeState serverHandshakeState, CertificateStatus certificateStatus) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        certificateStatus.encode((OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected byte[] generateNewSessionTicket(ServerHandshakeState serverHandshakeState, NewSessionTicket newSessionTicket) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        newSessionTicket.encode((OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected byte[] generateServerHello(ServerHandshakeState serverHandshakeState) throws IOException {
        SecurityParameters securityParameters = serverHandshakeState.serverContext.getSecurityParameters();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ProtocolVersion protocolVersion = serverHandshakeState.server.getServerVersion();
        if (!protocolVersion.isEqualOrEarlierVersionOf(serverHandshakeState.serverContext.getClientVersion())) {
            throw new TlsFatalAlert(80);
        }
        serverHandshakeState.serverContext.setServerVersion(protocolVersion);
        TlsUtils.writeVersion((ProtocolVersion)serverHandshakeState.serverContext.getServerVersion(), (OutputStream)byteArrayOutputStream);
        byteArrayOutputStream.write(securityParameters.getServerRandom());
        TlsUtils.writeOpaque8((byte[])TlsUtils.EMPTY_BYTES, (OutputStream)byteArrayOutputStream);
        int n2 = serverHandshakeState.server.getSelectedCipherSuite();
        if (!Arrays.contains((int[])serverHandshakeState.offeredCipherSuites, (int)n2) || n2 == 0 || CipherSuite.isSCSV((int)n2) || !TlsUtils.isValidCipherSuiteForVersion((int)n2, (ProtocolVersion)serverHandshakeState.serverContext.getServerVersion())) {
            throw new TlsFatalAlert(80);
        }
        DTLSServerProtocol.validateSelectedCipherSuite((int)n2, (short)80);
        securityParameters.cipherSuite = n2;
        short s2 = serverHandshakeState.server.getSelectedCompressionMethod();
        if (!Arrays.contains((short[])serverHandshakeState.offeredCompressionMethods, (short)s2)) {
            throw new TlsFatalAlert(80);
        }
        securityParameters.compressionAlgorithm = s2;
        TlsUtils.writeUint16((int)n2, (OutputStream)byteArrayOutputStream);
        TlsUtils.writeUint8((short)s2, (OutputStream)byteArrayOutputStream);
        serverHandshakeState.serverExtensions = serverHandshakeState.server.getServerExtensions();
        if (serverHandshakeState.secure_renegotiation) {
            boolean bl2;
            byte[] byArray = TlsUtils.getExtensionData((Hashtable)serverHandshakeState.serverExtensions, (Integer)TlsProtocol.EXT_RenegotiationInfo);
            boolean bl3 = bl2 = null == byArray;
            if (bl2) {
                serverHandshakeState.serverExtensions = TlsExtensionsUtils.ensureExtensionsInitialised((Hashtable)serverHandshakeState.serverExtensions);
                serverHandshakeState.serverExtensions.put(TlsProtocol.EXT_RenegotiationInfo, TlsProtocol.createRenegotiationInfo((byte[])TlsUtils.EMPTY_BYTES));
            }
        }
        if (securityParameters.extendedMasterSecret) {
            serverHandshakeState.serverExtensions = TlsExtensionsUtils.ensureExtensionsInitialised((Hashtable)serverHandshakeState.serverExtensions);
            TlsExtensionsUtils.addExtendedMasterSecretExtension((Hashtable)serverHandshakeState.serverExtensions);
        }
        if (serverHandshakeState.serverExtensions != null) {
            securityParameters.encryptThenMAC = TlsExtensionsUtils.hasEncryptThenMACExtension((Hashtable)serverHandshakeState.serverExtensions);
            securityParameters.maxFragmentLength = DTLSServerProtocol.evaluateMaxFragmentLengthExtension((boolean)serverHandshakeState.resumedSession, (Hashtable)serverHandshakeState.clientExtensions, (Hashtable)serverHandshakeState.serverExtensions, (short)80);
            securityParameters.truncatedHMac = TlsExtensionsUtils.hasTruncatedHMacExtension((Hashtable)serverHandshakeState.serverExtensions);
            serverHandshakeState.allowCertificateStatus = !serverHandshakeState.resumedSession && TlsUtils.hasExpectedEmptyExtensionData((Hashtable)serverHandshakeState.serverExtensions, (Integer)TlsExtensionsUtils.EXT_status_request, (short)80);
            serverHandshakeState.expectSessionTicket = !serverHandshakeState.resumedSession && TlsUtils.hasExpectedEmptyExtensionData((Hashtable)serverHandshakeState.serverExtensions, (Integer)TlsProtocol.EXT_SessionTicket, (short)80);
            TlsProtocol.writeExtensions((OutputStream)byteArrayOutputStream, (Hashtable)serverHandshakeState.serverExtensions);
        }
        securityParameters.prfAlgorithm = TlsProtocol.getPRFAlgorithm((TlsContext)serverHandshakeState.serverContext, (int)securityParameters.getCipherSuite());
        securityParameters.verifyDataLength = 12;
        return byteArrayOutputStream.toByteArray();
    }

    protected void invalidateSession(ServerHandshakeState serverHandshakeState) {
        if (serverHandshakeState.sessionParameters != null) {
            serverHandshakeState.sessionParameters.clear();
            serverHandshakeState.sessionParameters = null;
        }
        if (serverHandshakeState.tlsSession != null) {
            serverHandshakeState.tlsSession.invalidate();
            serverHandshakeState.tlsSession = null;
        }
    }

    protected void notifyClientCertificate(ServerHandshakeState serverHandshakeState, Certificate certificate) throws IOException {
        if (serverHandshakeState.certificateRequest == null) {
            throw new IllegalStateException();
        }
        if (serverHandshakeState.clientCertificate != null) {
            throw new TlsFatalAlert(10);
        }
        serverHandshakeState.clientCertificate = certificate;
        if (certificate.isEmpty()) {
            serverHandshakeState.keyExchange.skipClientCredentials();
        } else {
            serverHandshakeState.clientCertificateType = TlsUtils.getClientCertificateType((Certificate)certificate, (Certificate)serverHandshakeState.serverCredentials.getCertificate());
            serverHandshakeState.keyExchange.processClientCertificate(certificate);
        }
        serverHandshakeState.server.notifyClientCertificate(certificate);
    }

    protected void processClientCertificate(ServerHandshakeState serverHandshakeState, byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Certificate certificate = Certificate.parse((InputStream)byteArrayInputStream);
        TlsProtocol.assertEmpty((ByteArrayInputStream)byteArrayInputStream);
        this.notifyClientCertificate(serverHandshakeState, certificate);
    }

    protected void processCertificateVerify(ServerHandshakeState serverHandshakeState, byte[] byArray, TlsHandshakeHash tlsHandshakeHash) throws IOException {
        if (serverHandshakeState.certificateRequest == null) {
            throw new IllegalStateException();
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        TlsServerContextImpl tlsServerContextImpl = serverHandshakeState.serverContext;
        DigitallySigned digitallySigned = DigitallySigned.parse((TlsContext)tlsServerContextImpl, (InputStream)byteArrayInputStream);
        TlsProtocol.assertEmpty((ByteArrayInputStream)byteArrayInputStream);
        try {
            byte[] byArray2;
            SignatureAndHashAlgorithm signatureAndHashAlgorithm = digitallySigned.getAlgorithm();
            if (TlsUtils.isTLSv12((TlsContext)tlsServerContextImpl)) {
                TlsUtils.verifySupportedSignatureAlgorithm((Vector)serverHandshakeState.certificateRequest.getSupportedSignatureAlgorithms(), (SignatureAndHashAlgorithm)signatureAndHashAlgorithm);
                byArray2 = tlsHandshakeHash.getFinalHash(signatureAndHashAlgorithm.getHash());
            } else {
                byArray2 = tlsServerContextImpl.getSecurityParameters().getSessionHash();
            }
            macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.Certificate certificate = serverHandshakeState.clientCertificate.getCertificateAt(0);
            SubjectPublicKeyInfo subjectPublicKeyInfo = certificate.getSubjectPublicKeyInfo();
            AsymmetricKeyParameter asymmetricKeyParameter = PublicKeyFactory.createKey((SubjectPublicKeyInfo)subjectPublicKeyInfo);
            TlsSigner tlsSigner = TlsUtils.createTlsSigner((short)serverHandshakeState.clientCertificateType);
            tlsSigner.init((TlsContext)tlsServerContextImpl);
            if (!tlsSigner.verifyRawSignature(signatureAndHashAlgorithm, digitallySigned.getSignature(), asymmetricKeyParameter, byArray2)) {
                throw new TlsFatalAlert(51);
            }
        }
        catch (TlsFatalAlert tlsFatalAlert) {
            throw tlsFatalAlert;
        }
        catch (Exception exception) {
            throw new TlsFatalAlert(51, (Throwable)exception);
        }
    }

    protected void processClientHello(ServerHandshakeState serverHandshakeState, byte[] byArray) throws IOException {
        byte[] byArray2;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ProtocolVersion protocolVersion = TlsUtils.readVersion((InputStream)byteArrayInputStream);
        if (!protocolVersion.isDTLS()) {
            throw new TlsFatalAlert(47);
        }
        byte[] byArray3 = TlsUtils.readFully((int)32, (InputStream)byteArrayInputStream);
        byte[] byArray4 = TlsUtils.readOpaque8((InputStream)byteArrayInputStream);
        if (byArray4.length > 32) {
            throw new TlsFatalAlert(47);
        }
        byte[] byArray5 = TlsUtils.readOpaque8((InputStream)byteArrayInputStream);
        int n2 = TlsUtils.readUint16((InputStream)byteArrayInputStream);
        if (n2 < 2 || (n2 & 1) != 0) {
            throw new TlsFatalAlert(50);
        }
        serverHandshakeState.offeredCipherSuites = TlsUtils.readUint16Array((int)(n2 / 2), (InputStream)byteArrayInputStream);
        short s2 = TlsUtils.readUint8((InputStream)byteArrayInputStream);
        if (s2 < 1) {
            throw new TlsFatalAlert(47);
        }
        serverHandshakeState.offeredCompressionMethods = TlsUtils.readUint8Array((int)s2, (InputStream)byteArrayInputStream);
        serverHandshakeState.clientExtensions = TlsProtocol.readExtensions((ByteArrayInputStream)byteArrayInputStream);
        TlsServerContextImpl tlsServerContextImpl = serverHandshakeState.serverContext;
        SecurityParameters securityParameters = tlsServerContextImpl.getSecurityParameters();
        securityParameters.extendedMasterSecret = TlsExtensionsUtils.hasExtendedMasterSecretExtension((Hashtable)serverHandshakeState.clientExtensions);
        tlsServerContextImpl.setClientVersion(protocolVersion);
        serverHandshakeState.server.notifyClientVersion(protocolVersion);
        serverHandshakeState.server.notifyFallback(Arrays.contains((int[])serverHandshakeState.offeredCipherSuites, (int)22016));
        securityParameters.clientRandom = byArray3;
        serverHandshakeState.server.notifyOfferedCipherSuites(serverHandshakeState.offeredCipherSuites);
        serverHandshakeState.server.notifyOfferedCompressionMethods(serverHandshakeState.offeredCompressionMethods);
        if (Arrays.contains((int[])serverHandshakeState.offeredCipherSuites, (int)255)) {
            serverHandshakeState.secure_renegotiation = true;
        }
        if ((byArray2 = TlsUtils.getExtensionData((Hashtable)serverHandshakeState.clientExtensions, (Integer)TlsProtocol.EXT_RenegotiationInfo)) != null) {
            serverHandshakeState.secure_renegotiation = true;
            if (!Arrays.constantTimeAreEqual((byte[])byArray2, (byte[])TlsProtocol.createRenegotiationInfo((byte[])TlsUtils.EMPTY_BYTES))) {
                throw new TlsFatalAlert(40);
            }
        }
        serverHandshakeState.server.notifySecureRenegotiation(serverHandshakeState.secure_renegotiation);
        if (serverHandshakeState.clientExtensions != null) {
            TlsExtensionsUtils.getPaddingExtension((Hashtable)serverHandshakeState.clientExtensions);
            serverHandshakeState.server.processClientExtensions(serverHandshakeState.clientExtensions);
        }
    }

    protected void processClientKeyExchange(ServerHandshakeState serverHandshakeState, byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        serverHandshakeState.keyExchange.processClientKeyExchange((InputStream)byteArrayInputStream);
        TlsProtocol.assertEmpty((ByteArrayInputStream)byteArrayInputStream);
    }

    protected void processClientSupplementalData(ServerHandshakeState serverHandshakeState, byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Vector vector = TlsProtocol.readSupplementalDataMessage((ByteArrayInputStream)byteArrayInputStream);
        serverHandshakeState.server.processClientSupplementalData(vector);
    }

    protected boolean expectCertificateVerifyMessage(ServerHandshakeState serverHandshakeState) {
        return serverHandshakeState.clientCertificateType >= 0 && TlsUtils.hasSigningCapability((short)serverHandshakeState.clientCertificateType);
    }
}

