/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.SecureRandom;
import java.util.Hashtable;
import java.util.Vector;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.prng.RandomGenerator;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.Certificate;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.CertificateRequest;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.CertificateStatus;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.CipherSuite;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.DTLSClientProtocol;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.DTLSProtocol;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.DTLSRecordLayer;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.DTLSReliableHandshake;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.DTLSTransport;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.DatagramTransport;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.DigitallySigned;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.NewSessionTicket;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.ProtocolVersion;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.SecurityParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.SessionParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsClient;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsClientContext;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsClientContextImpl;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsContext;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsExtensionsUtils;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsFatalAlert;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsHandshakeHash;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsKeyExchange;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsPeer;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsProtocol;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsSession;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsSessionImpl;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsSignerCredentials;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsUtils;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Arrays;

/*
 * Exception performing whole class analysis ignored.
 */
public class DTLSClientProtocol
extends DTLSProtocol {
    public DTLSClientProtocol(SecureRandom secureRandom) {
        super(secureRandom);
    }

    public DTLSTransport connect(TlsClient tlsClient, DatagramTransport datagramTransport) throws IOException {
        SessionParameters sessionParameters;
        if (tlsClient == null) {
            throw new IllegalArgumentException("'client' cannot be null");
        }
        if (datagramTransport == null) {
            throw new IllegalArgumentException("'transport' cannot be null");
        }
        SecurityParameters securityParameters = new SecurityParameters();
        securityParameters.entity = 1;
        ClientHandshakeState clientHandshakeState = new ClientHandshakeState();
        clientHandshakeState.client = tlsClient;
        clientHandshakeState.clientContext = new TlsClientContextImpl(this.secureRandom, securityParameters);
        securityParameters.clientRandom = TlsProtocol.createRandomBlock((boolean)tlsClient.shouldUseGMTUnixTime(), (RandomGenerator)clientHandshakeState.clientContext.getNonceRandomGenerator());
        tlsClient.init((TlsClientContext)clientHandshakeState.clientContext);
        DTLSRecordLayer dTLSRecordLayer = new DTLSRecordLayer(datagramTransport, (TlsContext)clientHandshakeState.clientContext, (TlsPeer)tlsClient, 22);
        TlsSession tlsSession = clientHandshakeState.client.getSessionToResume();
        if (tlsSession != null && tlsSession.isResumable() && (sessionParameters = tlsSession.exportSessionParameters()) != null) {
            clientHandshakeState.tlsSession = tlsSession;
            clientHandshakeState.sessionParameters = sessionParameters;
        }
        try {
            sessionParameters = this.clientHandshake(clientHandshakeState, dTLSRecordLayer);
            return sessionParameters;
        }
        catch (TlsFatalAlert tlsFatalAlert) {
            this.abortClientHandshake(clientHandshakeState, dTLSRecordLayer, tlsFatalAlert.getAlertDescription());
            throw tlsFatalAlert;
        }
        catch (IOException iOException) {
            this.abortClientHandshake(clientHandshakeState, dTLSRecordLayer, (short)80);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.abortClientHandshake(clientHandshakeState, dTLSRecordLayer, (short)80);
            throw new TlsFatalAlert(80, (Throwable)runtimeException);
        }
        finally {
            securityParameters.clear();
        }
    }

    protected void abortClientHandshake(ClientHandshakeState clientHandshakeState, DTLSRecordLayer dTLSRecordLayer, short s2) {
        dTLSRecordLayer.fail(s2);
        this.invalidateSession(clientHandshakeState);
    }

    protected DTLSTransport clientHandshake(ClientHandshakeState clientHandshakeState, DTLSRecordLayer dTLSRecordLayer) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        SecurityParameters securityParameters = clientHandshakeState.clientContext.getSecurityParameters();
        DTLSReliableHandshake dTLSReliableHandshake = new DTLSReliableHandshake((TlsContext)clientHandshakeState.clientContext, dTLSRecordLayer);
        byte[] byArray = this.generateClientHello(clientHandshakeState, clientHandshakeState.client);
        dTLSRecordLayer.setWriteVersion(ProtocolVersion.DTLSv10);
        dTLSReliableHandshake.sendMessage((short)1, byArray);
        DTLSReliableHandshake.Message message = dTLSReliableHandshake.receiveMessage();
        while (message.getType() == 3) {
            object6 = dTLSRecordLayer.getReadVersion();
            if (!object6.isEqualOrEarlierVersionOf(object5 = clientHandshakeState.clientContext.getClientVersion())) {
                throw new TlsFatalAlert(47);
            }
            dTLSRecordLayer.setReadVersion(null);
            object4 = this.processHelloVerifyRequest(clientHandshakeState, message.getBody());
            object3 = DTLSClientProtocol.patchClientHelloWithCookie((byte[])byArray, (byte[])object4);
            dTLSReliableHandshake.resetHandshakeMessagesDigest();
            dTLSReliableHandshake.sendMessage((short)1, object3);
            message = dTLSReliableHandshake.receiveMessage();
        }
        if (message.getType() != 2) {
            throw new TlsFatalAlert(10);
        }
        object6 = dTLSRecordLayer.getReadVersion();
        this.reportServerVersion(clientHandshakeState, object6);
        dTLSRecordLayer.setWriteVersion(object6);
        this.processServerHello(clientHandshakeState, message.getBody());
        dTLSReliableHandshake.notifyHelloComplete();
        DTLSClientProtocol.applyMaxFragmentLengthExtension((DTLSRecordLayer)dTLSRecordLayer, (short)securityParameters.maxFragmentLength);
        if (clientHandshakeState.resumedSession) {
            securityParameters.masterSecret = Arrays.clone((byte[])clientHandshakeState.sessionParameters.getMasterSecret());
            dTLSRecordLayer.initPendingEpoch(clientHandshakeState.client.getCipher());
            object6 = TlsUtils.calculateVerifyData((TlsContext)clientHandshakeState.clientContext, (String)"server finished", (byte[])TlsProtocol.getCurrentPRFHash((TlsContext)clientHandshakeState.clientContext, (TlsHandshakeHash)dTLSReliableHandshake.getHandshakeHash(), null));
            this.processFinished(dTLSReliableHandshake.receiveMessageBody((short)20), (byte[])object6);
            object5 = TlsUtils.calculateVerifyData((TlsContext)clientHandshakeState.clientContext, (String)"client finished", (byte[])TlsProtocol.getCurrentPRFHash((TlsContext)clientHandshakeState.clientContext, (TlsHandshakeHash)dTLSReliableHandshake.getHandshakeHash(), null));
            dTLSReliableHandshake.sendMessage((short)20, (byte[])object5);
            dTLSReliableHandshake.finish();
            clientHandshakeState.clientContext.setResumableSession(clientHandshakeState.tlsSession);
            clientHandshakeState.client.notifyHandshakeComplete();
            return new DTLSTransport(dTLSRecordLayer);
        }
        this.invalidateSession(clientHandshakeState);
        if (clientHandshakeState.selectedSessionID.length > 0) {
            clientHandshakeState.tlsSession = new TlsSessionImpl(clientHandshakeState.selectedSessionID, null);
        }
        if ((message = dTLSReliableHandshake.receiveMessage()).getType() == 23) {
            this.processServerSupplementalData(clientHandshakeState, message.getBody());
            message = dTLSReliableHandshake.receiveMessage();
        } else {
            clientHandshakeState.client.processServerSupplementalData(null);
        }
        clientHandshakeState.keyExchange = clientHandshakeState.client.getKeyExchange();
        clientHandshakeState.keyExchange.init((TlsContext)clientHandshakeState.clientContext);
        object6 = null;
        if (message.getType() == 11) {
            object6 = this.processServerCertificate(clientHandshakeState, message.getBody());
            message = dTLSReliableHandshake.receiveMessage();
        } else {
            clientHandshakeState.keyExchange.skipServerCredentials();
        }
        if (object6 == null || object6.isEmpty()) {
            clientHandshakeState.allowCertificateStatus = false;
        }
        if (message.getType() == 22) {
            this.processCertificateStatus(clientHandshakeState, message.getBody());
            message = dTLSReliableHandshake.receiveMessage();
        }
        if (message.getType() == 12) {
            this.processServerKeyExchange(clientHandshakeState, message.getBody());
            message = dTLSReliableHandshake.receiveMessage();
        } else {
            clientHandshakeState.keyExchange.skipServerKeyExchange();
        }
        if (message.getType() == 13) {
            this.processCertificateRequest(clientHandshakeState, message.getBody());
            TlsUtils.trackHashAlgorithms((TlsHandshakeHash)dTLSReliableHandshake.getHandshakeHash(), (Vector)clientHandshakeState.certificateRequest.getSupportedSignatureAlgorithms());
            message = dTLSReliableHandshake.receiveMessage();
        }
        if (message.getType() == 14) {
            if (message.getBody().length != 0) {
                throw new TlsFatalAlert(50);
            }
        } else {
            throw new TlsFatalAlert(10);
        }
        dTLSReliableHandshake.getHandshakeHash().sealHashAlgorithms();
        object5 = clientHandshakeState.client.getClientSupplementalData();
        if (object5 != null) {
            object4 = DTLSClientProtocol.generateSupplementalData((Vector)object5);
            dTLSReliableHandshake.sendMessage((short)23, object4);
        }
        if (clientHandshakeState.certificateRequest != null) {
            clientHandshakeState.clientCredentials = clientHandshakeState.authentication.getClientCredentials(clientHandshakeState.certificateRequest);
            object4 = null;
            if (clientHandshakeState.clientCredentials != null) {
                object4 = clientHandshakeState.clientCredentials.getCertificate();
            }
            if (object4 == null) {
                object4 = Certificate.EMPTY_CHAIN;
            }
            object3 = DTLSClientProtocol.generateCertificate((Certificate)object4);
            dTLSReliableHandshake.sendMessage((short)11, object3);
        }
        if (clientHandshakeState.clientCredentials != null) {
            clientHandshakeState.keyExchange.processClientCredentials(clientHandshakeState.clientCredentials);
        } else {
            clientHandshakeState.keyExchange.skipClientCredentials();
        }
        object4 = this.generateClientKeyExchange(clientHandshakeState);
        dTLSReliableHandshake.sendMessage((short)16, object4);
        object3 = dTLSReliableHandshake.prepareToFinish();
        securityParameters.sessionHash = TlsProtocol.getCurrentPRFHash((TlsContext)clientHandshakeState.clientContext, (TlsHandshakeHash)object3, null);
        TlsProtocol.establishMasterSecret((TlsContext)clientHandshakeState.clientContext, (TlsKeyExchange)clientHandshakeState.keyExchange);
        dTLSRecordLayer.initPendingEpoch(clientHandshakeState.client.getCipher());
        if (clientHandshakeState.clientCredentials != null && clientHandshakeState.clientCredentials instanceof TlsSignerCredentials) {
            object2 = (TlsSignerCredentials)clientHandshakeState.clientCredentials;
            object = TlsUtils.getSignatureAndHashAlgorithm((TlsContext)clientHandshakeState.clientContext, (TlsSignerCredentials)object2);
            byte[] byArray2 = object == null ? securityParameters.getSessionHash() : object3.getFinalHash(object.getHash());
            byte[] byArray3 = object2.generateCertificateSignature(byArray2);
            DigitallySigned digitallySigned = new DigitallySigned(object, byArray3);
            byte[] byArray4 = this.generateCertificateVerify(clientHandshakeState, digitallySigned);
            dTLSReliableHandshake.sendMessage((short)15, byArray4);
        }
        object2 = TlsUtils.calculateVerifyData((TlsContext)clientHandshakeState.clientContext, (String)"client finished", (byte[])TlsProtocol.getCurrentPRFHash((TlsContext)clientHandshakeState.clientContext, (TlsHandshakeHash)dTLSReliableHandshake.getHandshakeHash(), null));
        dTLSReliableHandshake.sendMessage((short)20, (byte[])object2);
        if (clientHandshakeState.expectSessionTicket) {
            message = dTLSReliableHandshake.receiveMessage();
            if (message.getType() == 4) {
                this.processNewSessionTicket(clientHandshakeState, message.getBody());
            } else {
                throw new TlsFatalAlert(10);
            }
        }
        object = TlsUtils.calculateVerifyData((TlsContext)clientHandshakeState.clientContext, (String)"server finished", (byte[])TlsProtocol.getCurrentPRFHash((TlsContext)clientHandshakeState.clientContext, (TlsHandshakeHash)dTLSReliableHandshake.getHandshakeHash(), null));
        this.processFinished(dTLSReliableHandshake.receiveMessageBody((short)20), (byte[])object);
        dTLSReliableHandshake.finish();
        if (clientHandshakeState.tlsSession != null) {
            clientHandshakeState.sessionParameters = new SessionParameters.Builder().setCipherSuite(securityParameters.getCipherSuite()).setCompressionAlgorithm(securityParameters.getCompressionAlgorithm()).setMasterSecret(securityParameters.getMasterSecret()).setPeerCertificate((Certificate)object6).setPSKIdentity(securityParameters.getPSKIdentity()).setSRPIdentity(securityParameters.getSRPIdentity()).setServerExtensions(clientHandshakeState.serverExtensions).build();
            clientHandshakeState.tlsSession = TlsUtils.importSession((byte[])clientHandshakeState.tlsSession.getSessionID(), (SessionParameters)clientHandshakeState.sessionParameters);
            clientHandshakeState.clientContext.setResumableSession(clientHandshakeState.tlsSession);
        }
        clientHandshakeState.client.notifyHandshakeComplete();
        return new DTLSTransport(dTLSRecordLayer);
    }

    protected byte[] generateCertificateVerify(ClientHandshakeState clientHandshakeState, DigitallySigned digitallySigned) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        digitallySigned.encode((OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected byte[] generateClientHello(ClientHandshakeState clientHandshakeState, TlsClient tlsClient) throws IOException {
        boolean bl2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ProtocolVersion protocolVersion = tlsClient.getClientVersion();
        if (!protocolVersion.isDTLS()) {
            throw new TlsFatalAlert(80);
        }
        TlsClientContextImpl tlsClientContextImpl = clientHandshakeState.clientContext;
        tlsClientContextImpl.setClientVersion(protocolVersion);
        TlsUtils.writeVersion((ProtocolVersion)protocolVersion, (OutputStream)byteArrayOutputStream);
        SecurityParameters securityParameters = tlsClientContextImpl.getSecurityParameters();
        byteArrayOutputStream.write(securityParameters.getClientRandom());
        byte[] byArray = TlsUtils.EMPTY_BYTES;
        if (clientHandshakeState.tlsSession != null && ((byArray = clientHandshakeState.tlsSession.getSessionID()) == null || byArray.length > 32)) {
            byArray = TlsUtils.EMPTY_BYTES;
        }
        TlsUtils.writeOpaque8((byte[])byArray, (OutputStream)byteArrayOutputStream);
        TlsUtils.writeOpaque8((byte[])TlsUtils.EMPTY_BYTES, (OutputStream)byteArrayOutputStream);
        boolean bl3 = tlsClient.isFallback();
        clientHandshakeState.offeredCipherSuites = tlsClient.getCipherSuites();
        clientHandshakeState.clientExtensions = tlsClient.getClientExtensions();
        byte[] byArray2 = TlsUtils.getExtensionData((Hashtable)clientHandshakeState.clientExtensions, (Integer)TlsProtocol.EXT_RenegotiationInfo);
        boolean bl4 = null == byArray2;
        boolean bl5 = bl2 = !Arrays.contains((int[])clientHandshakeState.offeredCipherSuites, (int)255);
        if (bl4 && bl2) {
            clientHandshakeState.offeredCipherSuites = Arrays.append((int[])clientHandshakeState.offeredCipherSuites, (int)255);
        }
        if (bl3 && !Arrays.contains((int[])clientHandshakeState.offeredCipherSuites, (int)22016)) {
            clientHandshakeState.offeredCipherSuites = Arrays.append((int[])clientHandshakeState.offeredCipherSuites, (int)22016);
        }
        TlsUtils.writeUint16ArrayWithUint16Length((int[])clientHandshakeState.offeredCipherSuites, (OutputStream)byteArrayOutputStream);
        clientHandshakeState.offeredCompressionMethods = new short[]{0};
        TlsUtils.writeUint8ArrayWithUint8Length((short[])clientHandshakeState.offeredCompressionMethods, (OutputStream)byteArrayOutputStream);
        if (clientHandshakeState.clientExtensions != null) {
            TlsProtocol.writeExtensions((OutputStream)byteArrayOutputStream, (Hashtable)clientHandshakeState.clientExtensions);
        }
        return byteArrayOutputStream.toByteArray();
    }

    protected byte[] generateClientKeyExchange(ClientHandshakeState clientHandshakeState) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        clientHandshakeState.keyExchange.generateClientKeyExchange((OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected void invalidateSession(ClientHandshakeState clientHandshakeState) {
        if (clientHandshakeState.sessionParameters != null) {
            clientHandshakeState.sessionParameters.clear();
            clientHandshakeState.sessionParameters = null;
        }
        if (clientHandshakeState.tlsSession != null) {
            clientHandshakeState.tlsSession.invalidate();
            clientHandshakeState.tlsSession = null;
        }
    }

    protected void processCertificateRequest(ClientHandshakeState clientHandshakeState, byte[] byArray) throws IOException {
        if (clientHandshakeState.authentication == null) {
            throw new TlsFatalAlert(40);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        clientHandshakeState.certificateRequest = CertificateRequest.parse((TlsContext)clientHandshakeState.clientContext, (InputStream)byteArrayInputStream);
        TlsProtocol.assertEmpty((ByteArrayInputStream)byteArrayInputStream);
        clientHandshakeState.keyExchange.validateCertificateRequest(clientHandshakeState.certificateRequest);
    }

    protected void processCertificateStatus(ClientHandshakeState clientHandshakeState, byte[] byArray) throws IOException {
        if (!clientHandshakeState.allowCertificateStatus) {
            throw new TlsFatalAlert(10);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        clientHandshakeState.certificateStatus = CertificateStatus.parse((InputStream)byteArrayInputStream);
        TlsProtocol.assertEmpty((ByteArrayInputStream)byteArrayInputStream);
    }

    protected byte[] processHelloVerifyRequest(ClientHandshakeState clientHandshakeState, byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ProtocolVersion protocolVersion = TlsUtils.readVersion((InputStream)byteArrayInputStream);
        byte[] byArray2 = TlsUtils.readOpaque8((InputStream)byteArrayInputStream);
        TlsProtocol.assertEmpty((ByteArrayInputStream)byteArrayInputStream);
        if (!protocolVersion.isEqualOrEarlierVersionOf(clientHandshakeState.clientContext.getClientVersion())) {
            throw new TlsFatalAlert(47);
        }
        if (!ProtocolVersion.DTLSv12.isEqualOrEarlierVersionOf(protocolVersion) && byArray2.length > 32) {
            throw new TlsFatalAlert(47);
        }
        return byArray2;
    }

    protected void processNewSessionTicket(ClientHandshakeState clientHandshakeState, byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        NewSessionTicket newSessionTicket = NewSessionTicket.parse((InputStream)byteArrayInputStream);
        TlsProtocol.assertEmpty((ByteArrayInputStream)byteArrayInputStream);
        clientHandshakeState.client.notifyNewSessionTicket(newSessionTicket);
    }

    protected Certificate processServerCertificate(ClientHandshakeState clientHandshakeState, byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Certificate certificate = Certificate.parse((InputStream)byteArrayInputStream);
        TlsProtocol.assertEmpty((ByteArrayInputStream)byteArrayInputStream);
        clientHandshakeState.keyExchange.processServerCertificate(certificate);
        clientHandshakeState.authentication = clientHandshakeState.client.getAuthentication();
        clientHandshakeState.authentication.notifyServerCertificate(certificate);
        return certificate;
    }

    protected void processServerHello(ClientHandshakeState clientHandshakeState, byte[] byArray) throws IOException {
        Serializable serializable;
        Object object;
        SecurityParameters securityParameters = clientHandshakeState.clientContext.getSecurityParameters();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ProtocolVersion protocolVersion = TlsUtils.readVersion((InputStream)byteArrayInputStream);
        this.reportServerVersion(clientHandshakeState, protocolVersion);
        securityParameters.serverRandom = TlsUtils.readFully((int)32, (InputStream)byteArrayInputStream);
        clientHandshakeState.selectedSessionID = TlsUtils.readOpaque8((InputStream)byteArrayInputStream);
        if (clientHandshakeState.selectedSessionID.length > 32) {
            throw new TlsFatalAlert(47);
        }
        clientHandshakeState.client.notifySessionID(clientHandshakeState.selectedSessionID);
        clientHandshakeState.resumedSession = clientHandshakeState.selectedSessionID.length > 0 && clientHandshakeState.tlsSession != null && Arrays.areEqual((byte[])clientHandshakeState.selectedSessionID, (byte[])clientHandshakeState.tlsSession.getSessionID());
        int n2 = TlsUtils.readUint16((InputStream)byteArrayInputStream);
        if (!Arrays.contains((int[])clientHandshakeState.offeredCipherSuites, (int)n2) || n2 == 0 || CipherSuite.isSCSV((int)n2) || !TlsUtils.isValidCipherSuiteForVersion((int)n2, (ProtocolVersion)clientHandshakeState.clientContext.getServerVersion())) {
            throw new TlsFatalAlert(47);
        }
        DTLSClientProtocol.validateSelectedCipherSuite((int)n2, (short)47);
        clientHandshakeState.client.notifySelectedCipherSuite(n2);
        short s2 = TlsUtils.readUint8((InputStream)byteArrayInputStream);
        if (!Arrays.contains((short[])clientHandshakeState.offeredCompressionMethods, (short)s2)) {
            throw new TlsFatalAlert(47);
        }
        clientHandshakeState.client.notifySelectedCompressionMethod(s2);
        clientHandshakeState.serverExtensions = TlsProtocol.readExtensions((ByteArrayInputStream)byteArrayInputStream);
        if (clientHandshakeState.serverExtensions != null) {
            object = clientHandshakeState.serverExtensions.keys();
            while (object.hasMoreElements()) {
                serializable = (Integer)object.nextElement();
                if (serializable.equals(TlsProtocol.EXT_RenegotiationInfo)) continue;
                if (null == TlsUtils.getExtensionData((Hashtable)clientHandshakeState.clientExtensions, (Integer)serializable)) {
                    throw new TlsFatalAlert(110);
                }
                if (!clientHandshakeState.resumedSession) continue;
            }
        }
        if ((object = (Object)TlsUtils.getExtensionData((Hashtable)clientHandshakeState.serverExtensions, (Integer)TlsProtocol.EXT_RenegotiationInfo)) != null) {
            clientHandshakeState.secure_renegotiation = true;
            if (!Arrays.constantTimeAreEqual((byte[])object, (byte[])TlsProtocol.createRenegotiationInfo((byte[])TlsUtils.EMPTY_BYTES))) {
                throw new TlsFatalAlert(40);
            }
        }
        clientHandshakeState.client.notifySecureRenegotiation(clientHandshakeState.secure_renegotiation);
        object = clientHandshakeState.clientExtensions;
        serializable = clientHandshakeState.serverExtensions;
        if (clientHandshakeState.resumedSession) {
            if (n2 != clientHandshakeState.sessionParameters.getCipherSuite() || s2 != clientHandshakeState.sessionParameters.getCompressionAlgorithm()) {
                throw new TlsFatalAlert(47);
            }
            object = null;
            serializable = clientHandshakeState.sessionParameters.readServerExtensions();
        }
        securityParameters.cipherSuite = n2;
        securityParameters.compressionAlgorithm = s2;
        if (serializable != null) {
            boolean bl2 = TlsExtensionsUtils.hasEncryptThenMACExtension((Hashtable)serializable);
            if (bl2 && !TlsUtils.isBlockCipherSuite((int)securityParameters.getCipherSuite())) {
                throw new TlsFatalAlert(47);
            }
            securityParameters.encryptThenMAC = bl2;
            securityParameters.extendedMasterSecret = TlsExtensionsUtils.hasExtendedMasterSecretExtension((Hashtable)serializable);
            securityParameters.maxFragmentLength = DTLSClientProtocol.evaluateMaxFragmentLengthExtension((boolean)clientHandshakeState.resumedSession, (Hashtable)object, (Hashtable)serializable, (short)47);
            securityParameters.truncatedHMac = TlsExtensionsUtils.hasTruncatedHMacExtension((Hashtable)serializable);
            clientHandshakeState.allowCertificateStatus = !clientHandshakeState.resumedSession && TlsUtils.hasExpectedEmptyExtensionData((Hashtable)serializable, (Integer)TlsExtensionsUtils.EXT_status_request, (short)47);
            boolean bl3 = clientHandshakeState.expectSessionTicket = !clientHandshakeState.resumedSession && TlsUtils.hasExpectedEmptyExtensionData((Hashtable)serializable, (Integer)TlsProtocol.EXT_SessionTicket, (short)47);
        }
        if (object != null) {
            clientHandshakeState.client.processServerExtensions((Hashtable)serializable);
        }
        securityParameters.prfAlgorithm = TlsProtocol.getPRFAlgorithm((TlsContext)clientHandshakeState.clientContext, (int)securityParameters.getCipherSuite());
        securityParameters.verifyDataLength = 12;
    }

    protected void processServerKeyExchange(ClientHandshakeState clientHandshakeState, byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        clientHandshakeState.keyExchange.processServerKeyExchange((InputStream)byteArrayInputStream);
        TlsProtocol.assertEmpty((ByteArrayInputStream)byteArrayInputStream);
    }

    protected void processServerSupplementalData(ClientHandshakeState clientHandshakeState, byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Vector vector = TlsProtocol.readSupplementalDataMessage((ByteArrayInputStream)byteArrayInputStream);
        clientHandshakeState.client.processServerSupplementalData(vector);
    }

    protected void reportServerVersion(ClientHandshakeState clientHandshakeState, ProtocolVersion protocolVersion) throws IOException {
        TlsClientContextImpl tlsClientContextImpl = clientHandshakeState.clientContext;
        ProtocolVersion protocolVersion2 = tlsClientContextImpl.getServerVersion();
        if (null == protocolVersion2) {
            tlsClientContextImpl.setServerVersion(protocolVersion);
            clientHandshakeState.client.notifyServerVersion(protocolVersion);
        } else if (!protocolVersion2.equals(protocolVersion)) {
            throw new TlsFatalAlert(47);
        }
    }

    protected static byte[] patchClientHelloWithCookie(byte[] byArray, byte[] byArray2) throws IOException {
        int n2 = 34;
        short s2 = TlsUtils.readUint8((byte[])byArray, (int)n2);
        int n3 = n2 + 1 + s2;
        int n4 = n3 + 1;
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, n3);
        TlsUtils.checkUint8((int)byArray2.length);
        TlsUtils.writeUint8((int)byArray2.length, (byte[])byArray3, (int)n3);
        System.arraycopy(byArray2, 0, byArray3, n4, byArray2.length);
        System.arraycopy(byArray, n4, byArray3, n4 + byArray2.length, byArray.length - n4);
        return byArray3;
    }
}

