/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Primitive;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsUtils;

public class Certificate {
    public static final Certificate EMPTY_CHAIN = new Certificate(new macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.Certificate[0]);
    protected macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.Certificate[] certificateList;

    public Certificate(macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.Certificate[] certificateArray) {
        if (certificateArray == null) {
            throw new IllegalArgumentException("'certificateList' cannot be null");
        }
        this.certificateList = certificateArray;
    }

    public macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.Certificate[] getCertificateList() {
        return this.cloneCertificateList();
    }

    public macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.Certificate getCertificateAt(int n2) {
        return this.certificateList[n2];
    }

    public int getLength() {
        return this.certificateList.length;
    }

    public boolean isEmpty() {
        return this.certificateList.length == 0;
    }

    public void encode(OutputStream outputStream) throws IOException {
        byte[] byArray;
        int n2;
        Vector<byte[]> vector = new Vector<byte[]>(this.certificateList.length);
        int n3 = 0;
        for (n2 = 0; n2 < this.certificateList.length; ++n2) {
            byArray = this.certificateList[n2].getEncoded("DER");
            vector.addElement(byArray);
            n3 += byArray.length + 3;
        }
        TlsUtils.checkUint24((int)n3);
        TlsUtils.writeUint24((int)n3, (OutputStream)outputStream);
        for (n2 = 0; n2 < vector.size(); ++n2) {
            byArray = (byte[])vector.elementAt(n2);
            TlsUtils.writeOpaque24((byte[])byArray, (OutputStream)outputStream);
        }
    }

    public static Certificate parse(InputStream inputStream) throws IOException {
        Object[] objectArray;
        int n2 = TlsUtils.readUint24((InputStream)inputStream);
        if (n2 == 0) {
            return EMPTY_CHAIN;
        }
        byte[] byArray = TlsUtils.readFully((int)n2, (InputStream)inputStream);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Vector<macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.Certificate> vector = new Vector<macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.Certificate>();
        while (byteArrayInputStream.available() > 0) {
            objectArray = TlsUtils.readOpaque24((InputStream)byteArrayInputStream);
            ASN1Primitive aSN1Primitive = TlsUtils.readASN1Object((byte[])objectArray);
            vector.addElement(macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.Certificate.getInstance((Object)aSN1Primitive));
        }
        objectArray = new macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.Certificate[vector.size()];
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            objectArray[i2] = (byte)((macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.Certificate)vector.elementAt(i2));
        }
        return new Certificate((macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.Certificate[])objectArray);
    }

    protected macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.Certificate[] cloneCertificateList() {
        macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.Certificate[] certificateArray = new macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.Certificate[this.certificateList.length];
        System.arraycopy(this.certificateList, 0, certificateArray, 0, certificateArray.length);
        return certificateArray;
    }
}

