/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls;

import java.security.SecureRandom;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.Digest;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.prng.DigestRandomGenerator;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.prng.RandomGenerator;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.ProtocolVersion;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.SecurityParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsContext;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsSession;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsUtils;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Times;

/*
 * Exception performing whole class analysis ignored.
 */
abstract class AbstractTlsContext
implements TlsContext {
    private static long counter = Times.nanoTime();
    private RandomGenerator nonceRandom;
    private SecureRandom secureRandom;
    private SecurityParameters securityParameters;
    private ProtocolVersion clientVersion = null;
    private ProtocolVersion serverVersion = null;
    private TlsSession session = null;
    private Object userObject = null;

    private static synchronized long nextCounterValue() {
        return ++counter;
    }

    AbstractTlsContext(SecureRandom secureRandom, SecurityParameters securityParameters) {
        Digest digest = TlsUtils.createHash((short)4);
        byte[] byArray = new byte[digest.getDigestSize()];
        secureRandom.nextBytes(byArray);
        this.nonceRandom = new DigestRandomGenerator(digest);
        this.nonceRandom.addSeedMaterial(AbstractTlsContext.nextCounterValue());
        this.nonceRandom.addSeedMaterial(Times.nanoTime());
        this.nonceRandom.addSeedMaterial(byArray);
        this.secureRandom = secureRandom;
        this.securityParameters = securityParameters;
    }

    public RandomGenerator getNonceRandomGenerator() {
        return this.nonceRandom;
    }

    public SecureRandom getSecureRandom() {
        return this.secureRandom;
    }

    public SecurityParameters getSecurityParameters() {
        return this.securityParameters;
    }

    public ProtocolVersion getClientVersion() {
        return this.clientVersion;
    }

    void setClientVersion(ProtocolVersion protocolVersion) {
        this.clientVersion = protocolVersion;
    }

    public ProtocolVersion getServerVersion() {
        return this.serverVersion;
    }

    void setServerVersion(ProtocolVersion protocolVersion) {
        this.serverVersion = protocolVersion;
    }

    public TlsSession getResumableSession() {
        return this.session;
    }

    void setResumableSession(TlsSession tlsSession) {
        this.session = tlsSession;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object object) {
        this.userObject = object;
    }

    public byte[] exportKeyingMaterial(String string, byte[] byArray, int n2) {
        if (byArray != null && !TlsUtils.isValidUint16((int)byArray.length)) {
            throw new IllegalArgumentException("'context_value' must have length less than 2^16 (or be null)");
        }
        SecurityParameters securityParameters = this.getSecurityParameters();
        byte[] byArray2 = securityParameters.getClientRandom();
        byte[] byArray3 = securityParameters.getServerRandom();
        int n3 = byArray2.length + byArray3.length;
        if (byArray != null) {
            n3 += 2 + byArray.length;
        }
        byte[] byArray4 = new byte[n3];
        int n4 = 0;
        System.arraycopy(byArray2, 0, byArray4, n4, byArray2.length);
        System.arraycopy(byArray3, 0, byArray4, n4 += byArray2.length, byArray3.length);
        n4 += byArray3.length;
        if (byArray != null) {
            TlsUtils.writeUint16((int)byArray.length, (byte[])byArray4, (int)n4);
            System.arraycopy(byArray, 0, byArray4, n4 += 2, byArray.length);
            n4 += byArray.length;
        }
        if (n4 != n3) {
            throw new IllegalStateException("error in calculation of seed for export");
        }
        return TlsUtils.PRF((TlsContext)this, (byte[])securityParameters.getMasterSecret(), (String)string, (byte[])byArray4, (int)n2);
    }
}

